/*
 * Decompiled with CFR 0.152.
 */
package com.estebes.usefulcrops.crops;

import com.estebes.usefulcrops.crops.Crops;
import cpw.mods.fml.common.registry.GameRegistry;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import net.minecraft.item.ItemStack;

public class CropProperties {
    private Crops.CropInfo cropInfo;

    public CropProperties(Crops.CropInfo cropInfo) {
        this.cropInfo = cropInfo;
    }

    public String getCropName() {
        return this.cropInfo.getCropName();
    }

    public String getCropDiscoveredBy() {
        return this.cropInfo.getCropDiscoveredBy();
    }

    public String[] getCropAttributes() {
        ArrayList<String> cropAttributes = new ArrayList<String>();
        Pattern pattern = Pattern.compile("([a-zA-Z]+)");
        Matcher matcher = pattern.matcher(this.cropInfo.getCropAttributes());
        while (matcher.find()) {
            if (matcher.group(1) == null || cropAttributes.size() > 3) continue;
            cropAttributes.add(matcher.group(1));
        }
        return cropAttributes.toArray(new String[cropAttributes.size()]);
    }

    public int getCropTier() {
        return this.cropInfo.getCropTier();
    }

    public int[] getCropGrowthDuration() {
        return null;
    }

    public BufferedImage getCropIcon() {
        BufferedImage background = null;
        BufferedImage foreground = null;
        try {
            background = ImageIO.read(this.getClass().getResource("/assets/usefulcrops/textures/blocks/" + this.cropInfo.getCropType().toString().toLowerCase() + "_bg.png"));
            foreground = ImageIO.read(this.getClass().getResource("/assets/usefulcrops/textures/blocks/" + this.cropInfo.getCropType().toString().toLowerCase() + "_fg.png"));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        BufferedImage aux = new BufferedImage(foreground.getWidth(), foreground.getHeight(), 2);
        Graphics2D aux_g = aux.createGraphics();
        Color fgCropColor = Color.decode(this.cropInfo.getCropColor());
        aux_g.drawImage(foreground, null, 0, 0);
        aux_g.setColor(fgCropColor);
        aux_g.setComposite(AlphaComposite.getInstance(10, 0.5f));
        aux_g.fillRect(0, 0, foreground.getWidth(), foreground.getHeight());
        BufferedImage finalImage = new BufferedImage(background.getWidth(), background.getHeight(), 2);
        Graphics2D final_g = finalImage.createGraphics();
        final_g.drawImage((Image)background, 0, 0, null);
        final_g.drawImage((Image)aux, 0, 0, null);
        aux_g.dispose();
        final_g.dispose();
        return finalImage;
    }

    public ItemStack getCropDrop() {
        String modID = "";
        String itemID = "";
        int metaData = 0;
        Pattern pattern = Pattern.compile("([^:]+)([:])([^@]+)([@])?(\\d+)?");
        Matcher matcher = pattern.matcher(this.cropInfo.getCropDrops().getCropDrop());
        if (matcher.matches()) {
            if (matcher.group(1) != null) {
                modID = matcher.group(1);
            }
            if (matcher.group(3) != null) {
                itemID = matcher.group(3);
            }
            if (matcher.group(5) != null) {
                metaData = Integer.valueOf(matcher.group(5));
            }
        }
        if (GameRegistry.findItem((String)modID, (String)itemID) != null) {
            return new ItemStack(GameRegistry.findItem((String)modID, (String)itemID), 1, metaData);
        }
        return null;
    }

    public float getCropDropChance() {
        return this.cropInfo.getCropDrops().getCropDropChance();
    }
}

