/*
 * Decompiled with CFR 0.152.
 */
package com.estebes.usefulcrops.util;

import com.google.common.base.Strings;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public final class SpriteHelper {
    public static IIcon registerCustomSprite(IIconRegister iconRegistry, BufferedImage bufferedImage, final String spriteName, int spriteDimensions) throws IOException {
        TextureAtlasSprite sprite = null;
        if (iconRegistry == null || bufferedImage == null || Strings.isNullOrEmpty((String)spriteName)) {
            return null;
        }
        if (iconRegistry instanceof TextureMap) {
            TextureMap textureMap = (TextureMap)iconRegistry;
            sprite = textureMap.getTextureExtry(spriteName);
            if (sprite != null) {
                return sprite;
            }
            final int[] rgb = bufferedImage.getRGB(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), new int[bufferedImage.getWidth() * bufferedImage.getHeight()], 0, spriteDimensions);
            sprite = new TextureAtlasSprite(spriteName){
                private final List<int[][]> framesTextureData;
                {
                    super(x0);
                    this.framesTextureData = (List)ObfuscationReflectionHelper.getPrivateValue(TextureAtlasSprite.class, (Object)((Object)this), (String[])new String[]{"a", "field_110976_a", "framesTextureData"});
                }

                public boolean load(IResourceManager resourceManager, ResourceLocation resourceLocation) {
                    this.framesTextureData.clear();
                    int[][] mipmapLevels = new int[Minecraft.func_71410_x().field_71474_y.field_151442_I + 1][];
                    if (mipmapLevels.length <= 0) {
                        FMLLog.severe((String)"Couldn't generate mipmap levels for sprite \"%s\"?", (Object[])new Object[]{spriteName});
                        return true;
                    }
                    for (int i = 0; i < mipmapLevels.length; ++i) {
                        mipmapLevels[i] = rgb;
                    }
                    this.framesTextureData.add(mipmapLevels);
                    return false;
                }

                public void func_147963_d(int mipmapLevel) {
                    try {
                        this.framesTextureData.clear();
                        if (rgb != null && rgb.length > 1) {
                            int[][] mipmapData = this.prepareAnisotropicFiltering(new int[mipmapLevel + 1][], this.func_94211_a(), this.func_94216_b());
                            if (mipmapData == null | (mipmapData != null && mipmapData.length <= 0)) {
                                FMLLog.severe((String)"Couldn't generate mipmaps for sprite \"%s\"! Couldn't invoke method \"prepareAnisotropicFiltering\"?", (Object[])new Object[]{this.func_94215_i()});
                                return;
                            }
                            for (int i = 0; i < mipmapData.length; ++i) {
                                mipmapData[i] = rgb;
                            }
                            this.framesTextureData.add(mipmapData);
                        } else {
                            FMLLog.severe((String)"Couldn't get the RGB array for sprite \"%s\"!", (Object[])new Object[]{this.func_94215_i()});
                        }
                        return;
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    FMLLog.severe((String)"Failed to generate mipmaps for sprite \"%s\"!", (Object[])new Object[]{spriteName});
                }

                public boolean hasCustomLoader(IResourceManager resourceManager, ResourceLocation resourceLocation) {
                    return true;
                }

                private int[][] prepareAnisotropicFiltering(int[][] par1, int par2, int par3) throws IllegalAccessException, InvocationTargetException {
                    String[] methodNames = new String[]{"a", "func_147960_a", "prepareAnisotropicFiltering"};
                    int[][] var1 = null;
                    for (Method searchingMethod : TextureAtlasSprite.class.getDeclaredMethods()) {
                        boolean isAccessible = searchingMethod.isAccessible();
                        if (!isAccessible) {
                            searchingMethod.setAccessible(true);
                        }
                        for (String methodName : methodNames) {
                            if (!searchingMethod.getName().equals(methodName)) continue;
                            var1 = (int[][])searchingMethod.invoke((Object)this, new Object[]{par1, par2, par3});
                            break;
                        }
                        searchingMethod.setAccessible(isAccessible);
                    }
                    return var1;
                }
            };
            sprite.func_110966_b(bufferedImage.getWidth());
            sprite.func_110969_c(bufferedImage.getHeight());
            textureMap.setTextureEntry(spriteName, sprite);
        }
        return sprite;
    }
}

