/*
 * Decompiled with CFR 0.152.
 */
package com.estebes.usefulcrops.crops;

import com.estebes.usefulcrops.crops.Crops;
import com.estebes.usefulcrops.util.Util;
import cpw.mods.fml.common.registry.GameRegistry;
import java.awt.Color;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;

public class CropProperties {
    private Crops.CropInfo cropInfo;

    public CropProperties(Crops.CropInfo cropInfo) {
        this.cropInfo = cropInfo;
    }

    public String getCropName() {
        return this.cropInfo.getCropName();
    }

    public String getCropDiscoveredBy() {
        return this.cropInfo.getCropDiscoveredBy();
    }

    public String[] getCropAttributes() {
        ArrayList<String> cropAttributes = new ArrayList<String>();
        Pattern pattern = Pattern.compile("([a-zA-Z]+)");
        Matcher matcher = pattern.matcher(this.cropInfo.getCropAttributes());
        while (matcher.find()) {
            if (matcher.group(1) == null || cropAttributes.size() > 3) continue;
            cropAttributes.add(matcher.group(1));
        }
        return cropAttributes.toArray(new String[cropAttributes.size()]);
    }

    public int getCropTier() {
        return this.cropInfo.getCropTier();
    }

    public int[] getCropGrowthDuration() {
        ArrayList<Integer> cropGrowthDuration = new ArrayList<Integer>();
        Pattern pattern = Pattern.compile("(\\d+)");
        Matcher matcher = pattern.matcher(this.cropInfo.getCropGrowthDuration());
        while (matcher.find()) {
            if (matcher.group(1) == null) continue;
            cropGrowthDuration.add(Integer.valueOf(matcher.group(1)));
        }
        return Util.getIntArray(cropGrowthDuration);
    }

    public Color getCropColor() {
        return Color.decode(this.cropInfo.getCropColor());
    }

    public ItemStack getCropDrop() {
        String modID = "";
        String itemID = "";
        int metaData = 0;
        Pattern pattern = Pattern.compile("([^:]+)([:])([^@]+)([@])?(\\d+)?");
        Matcher matcher = pattern.matcher(this.cropInfo.getCropDrops().getCropDrop());
        if (matcher.matches()) {
            if (matcher.group(1) != null) {
                modID = matcher.group(1);
            }
            if (matcher.group(3) != null) {
                itemID = matcher.group(3);
            }
            if (matcher.group(5) != null) {
                metaData = Integer.valueOf(matcher.group(5));
            }
        }
        if (GameRegistry.findItem((String)modID, (String)itemID) != null) {
            return new ItemStack(GameRegistry.findItem((String)modID, (String)itemID), 1, metaData);
        }
        return null;
    }

    public float getCropDropChance() {
        return this.cropInfo.getCropDrops().getCropDropChance();
    }

    public ItemStack getCropSpecialDrop() {
        String modID = "";
        String itemID = "";
        int metaData = 0;
        Pattern pattern = Pattern.compile("([^:]+)([:])([^@]+)([@])?(\\d+)?");
        Matcher matcher = pattern.matcher(this.cropInfo.getCropDrops().getCropSpecialDrop());
        if (matcher.matches()) {
            if (matcher.group(1) != null) {
                modID = matcher.group(1);
            }
            if (matcher.group(3) != null) {
                itemID = matcher.group(3);
            }
            if (matcher.group(5) != null) {
                metaData = Integer.valueOf(matcher.group(5));
            }
        }
        if (GameRegistry.findItem((String)modID, (String)itemID) != null) {
            return new ItemStack(GameRegistry.findItem((String)modID, (String)itemID), 1, metaData);
        }
        return null;
    }

    public float getCropSpecialDropChance() {
        return this.cropInfo.getCropDrops().getCropSpecialDropChance() > 0.5f ? 0.5f : this.cropInfo.getCropDrops().getCropSpecialDropChance();
    }

    public PotionEffect getCropDebuffs() {
        String potionName = "";
        Pattern pattern = Pattern.compile("([^@]+)([@])?(\\d+)?");
        Matcher matcher = pattern.matcher(this.cropInfo.getCropPoison());
        if (matcher.matches() && matcher.group(1) != null) {
            potionName = matcher.group(1);
        }
        for (int potion = 0; potion < Potion.field_76425_a.length; ++potion) {
            if (Potion.field_76425_a[potion] == null || !Potion.field_76425_a[potion].func_76393_a().equals(potionName)) continue;
            System.out.println(Potion.field_76425_a[potion].func_76396_c());
            return new PotionEffect(Potion.field_76425_a[potion].func_76396_c(), 64, 50);
        }
        return null;
    }

    public String getCropType() {
        return this.cropInfo.getCropType().toString().toLowerCase();
    }
}

