/*
 * Decompiled with CFR 0.152.
 */
package com.estebes.usefulcrops.crops;

import com.estebes.usefulcrops.UsefulCrops;
import com.estebes.usefulcrops.crops.CropProperties;
import com.estebes.usefulcrops.crops.Crops;
import com.estebes.usefulcrops.crops.croptypes.CropFlowerType1;
import com.estebes.usefulcrops.crops.croptypes.CropMushroomType1;
import com.estebes.usefulcrops.crops.croptypes.CropPlantType1;
import com.google.protobuf.Message;
import com.google.protobuf.TextFormat;
import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import java.io.InputStream;
import java.io.InputStreamReader;

public class CropParser {
    public static Crops.CropsList.Builder cropList = Crops.CropsList.newBuilder();

    public static void init() {
        for (Crops.CropInfo cropInfo : cropList.getCropInfoList()) {
            switch (cropInfo.getCropType()) {
                case CROP_PLANT_1: {
                    Crops.instance.registerCrop((CropCard)new CropPlantType1(new CropProperties(cropInfo)));
                    break;
                }
                case CROP_FLOWER_1: {
                    Crops.instance.registerCrop((CropCard)new CropFlowerType1(new CropProperties(cropInfo)));
                    break;
                }
                case CROP_MUSHROOM_1: {
                    Crops.instance.registerCrop((CropCard)new CropMushroomType1(new CropProperties(cropInfo)));
                }
            }
        }
    }

    static {
        try {
            InputStream inputStream = UsefulCrops.class.getResourceAsStream("/assets/usefulcrops/config/crops.cfg");
            InputStreamReader reader = new InputStreamReader(inputStream);
            TextFormat.merge(reader, (Message.Builder)cropList);
            inputStream.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

