/*
 * Decompiled with CFR 0.152.
 */
package com.estebes.usefulcrops.crops;

import com.estebes.usefulcrops.crops.CropProperties;
import com.estebes.usefulcrops.util.XorShiftRandom;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.crops.CropCard;
import ic2.api.crops.ICropTile;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;

public class CropCommon
extends CropCard {
    protected CropProperties cropProperties;

    public CropCommon(CropProperties cropProperties) {
        this.cropProperties = cropProperties;
    }

    public String owner() {
        return "UsefulCrops";
    }

    public String displayName() {
        return this.cropProperties.getCropName();
    }

    public String discoveredBy() {
        return this.cropProperties.getCropDiscoveredBy();
    }

    public String name() {
        return this.cropProperties.getCropName().toLowerCase();
    }

    public String[] attributes() {
        return this.cropProperties.getCropAttributes();
    }

    public int tier() {
        return this.cropProperties.getCropTier();
    }

    public int maxSize() {
        return 0;
    }

    public int getrootslength(ICropTile crop) {
        return 3;
    }

    public boolean canGrow(ICropTile crop) {
        return crop.getSize() < this.maxSize();
    }

    public int getOptimalHavestSize(ICropTile crop) {
        return 0;
    }

    public boolean canBeHarvested(ICropTile crop) {
        return false;
    }

    public byte getSizeAfterHarvest(ICropTile crop) {
        return 0;
    }

    public int growthDuration(ICropTile crop) {
        return 500;
    }

    public ItemStack getGain(ICropTile crop) {
        XorShiftRandom specialDropRandom = new XorShiftRandom(100);
        if (this.cropProperties.getCropSpecialDrop() != null && this.cropProperties.getCropSpecialDropChance() * 100.0f > (float)specialDropRandom.nextInt()) {
            return this.cropProperties.getCropSpecialDrop();
        }
        return this.cropProperties.getCropDrop();
    }

    public float dropGainChance() {
        return this.cropProperties.getCropDropChance();
    }

    public int stat(int n) {
        switch (n) {
            case 0: {
                return 2;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 0;
            }
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerSprites(IIconRegister iconRegister) {
    }

    public boolean onEntityCollision(ICropTile crop, Entity entity) {
        if (entity instanceof EntityLivingBase) {
            if (this.cropProperties.getCropDebuffs() != null && crop.getSize() >= 2) {
                ((EntityLivingBase)entity).func_70690_d(this.cropProperties.getCropDebuffs());
            }
            return ((EntityLivingBase)entity).func_70051_ag();
        }
        return false;
    }
}

