/*
 * Decompiled with CFR 0.152.
 */
package com.estebes.usefulcrops.crops.cropspecial;

import com.estebes.usefulcrops.crops.CropProperties;
import com.estebes.usefulcrops.reference.Reference;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.crops.CropCard;
import ic2.api.crops.ICropTile;
import ic2.api.energy.tile.IEnergySink;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class CropSpecialEnet
extends CropCard {
    private CropProperties cropProperties;

    public String owner() {
        return "UsefulCrops";
    }

    public String displayName() {
        return "E-net Crop";
    }

    public String discoveredBy() {
        return "Player";
    }

    public String name() {
        return "e-net crop";
    }

    public String[] attributes() {
        return null;
    }

    public int tier() {
        return 15;
    }

    public int maxSize() {
        return 4;
    }

    public int getrootslength(ICropTile crop) {
        return 3;
    }

    public boolean canGrow(ICropTile crop) {
        return crop.getSize() < this.maxSize();
    }

    public int getOptimalHavestSize(ICropTile crop) {
        return 4;
    }

    public boolean canBeHarvested(ICropTile crop) {
        return false;
    }

    public byte getSizeAfterHarvest(ICropTile crop) {
        return 2;
    }

    public int growthDuration(ICropTile crop) {
        return crop.getSize() == 3 ? 2000 : 800;
    }

    public ItemStack getGain(ICropTile crop) {
        return null;
    }

    public float dropGainChance() {
        return 0.0f;
    }

    public int stat(int n) {
        switch (n) {
            case 0: {
                return 2;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 0;
            }
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerSprites(IIconRegister iconRegister) {
        this.textures = new IIcon[this.maxSize()];
        for (int size = 1; size <= this.maxSize() - 1; ++size) {
            this.textures[size - 1] = iconRegister.func_94245_a(Reference.LOWERCASE_MOD_ID + ":" + "CropPlantType1_" + size);
        }
    }

    public void tick(ICropTile crop) {
        TileEntity teCrop = (TileEntity)crop;
        TileEntity teAux = teCrop.func_145831_w().func_147438_o(teCrop.field_145851_c, teCrop.field_145848_d + 1, teCrop.field_145849_e);
        if (teAux != null && teAux instanceof IEnergySink) {
            ((IEnergySink)teAux).injectEnergy(ForgeDirection.DOWN, 256.0, 1.0);
        }
    }
}

