//***************************
// KRTweak - Thaumcraft
//  created by Nono
//
// Changelog:
//   v0.3: 
//     - Refreshed thaumonomicon entries for basic research so they properly show the GT recipes
//     - Wrought Iron transmutation no longer marked as secondary research
//     - Moved certain Thaumonomicon research icons around
//     - Added Steel -> Damascus Steel transmutation research
//     - Hungry chest now slightly more expensive to craft
//     - Advanced Metallurgy now requires Damascus Steel transmutation
//     - Tweaked costs of more TC recipes 
//     - Mundane belt no longer craftable
//     - Mundane belt removed from most recipes other than that for Runic Shielding
//     - Clay transmutation disabled
//     - Removed a debugging transmutation that was allowing infinite nether quartz
//     - Massively revamped the crafting of Golem Animation cores
//     - All cores are now an infusion recipe using an HV robot arm and an appropriate integrated circuit
//     - Fishing animation core removed
//     - Blank animation core now has multiple assembler recipes
//     - Golem animation cores may be "copied" in assembler as long as you have one copy, but consumes a lot of EU
//     - Golem animation cores may be formatted to a blank animation core in a magnetizer
//   v0.2: 
//     - Barrier of entry lowered to MV (120 EU/t)
//     - Advanced metallurgic transmutations are now properly set to primary research
//     - Bone Bow research now properly requires Infusion 
//     - Added Assembling Machine recipe for Table
//     - Added Assembling Machine recipe for Arcane Stone
//     - Normalized some EU costs to prevent undesirable Insufficient Energy errors
//     - Tweaked transmutation costs to make more sense as well as removing a possible exploit
//     - Runic Shielding tech tree has been smoothed out
//     - Doubled both cost and yield for gunpowder manufacture recipe
//     - Excavation focus now an infusion recipe
//     - Equal Trade focus now an infusion recipe
//     - Primal focus now an infusion recipe
//     - Minor lore changes for consistency
//     - Elemental tool infusion recipes have Thaumium and Titanium swapped for consistency
//     - Elemental tools now require salis mundus in lieu of greatwood log 
//     - Voidmetal armor and tools are now infusion recipes requiring diamond equivalents (Already 
//       implemented, but was not documented in v0.1 changelog)
//   v0.1: 
//     - Initial release
//     - Thaumium ingots now require a balanced shard to craft
//     - Thaumometer initially requires HV Assembling Machine
//     - Scribing tools now requires Assembling Machine, but are also refilled more efficiently
//     - Iron Wand Cap requires HV Precision Laser Engraver
//     - Iron Wand assembled in HV Assembling Machine with Sealed Wood Stick
//     - Charcoal transmutation removed
//     - Gunpowder now under Alchemical manufacture and consumes saltpeter instead of being a duplication
//     - Significantly increased the barrier of entry for golem automation
//     - Warp has been added/increased for a large number of researches
//     - Added many additional transmutation and alchemical recipes that can be unlocked, including 
//       ways to obtain non-generating Railcraft decorative blocks
//     - Tallow candle now requires significant time to manufacture, done so via Assembling Machine
//     - Enchanted fabric has an alternate Assembling Machine recipe requiring molten Thaumium
//     - Enchanted fabric is woven into clothes more efficiently in Assembling Machine
//     - Deconstruction table can be made in Assembling Machine with molten gold and thaumometer
//     - Arcane Keys created more efficiently in Forming Press
//     - Essentia Jars created more efficiently in Assembling Machine
//     - Fill Essentia Jars with lava in Fluid Canning Machine to transform them into Void Jars
//     - Empty Void Jars in Fluid Canning Machine to get regular Essentia Jars back
//     - Brain in a jar can be uncanned in the Canning Machine
//     - Additional useful Alchemical Duplication recipes introduced
//     - Goggles of Revealing now requires Thaumium (and therefore the Thaumium research) instead of Gold
//     - Phials are now more expensive to craft in a worktable, Assembling Machine needed for old efficiency
//     - Arcane lamp now crafted from a floodlight
//     - Added Assembling Machine recipes for certain basic Thaumcraft blocks
//     - Basic infusion tools now take an appropriate titanium tool head instead of a diamond
//     - Bone bow is now an unstable infusion recipe that takes a long titanium rod
//     - Boots of the Traveller infuses from Hover Boots
//     - Thaumostatic Harness now infused from IC2 Jetpack
//     - Thaumostatic Girdle now requires infusion and consumes two boost engines from GraviSuite
//     - Wand caps now have a linear progression
//     - Silverwood wand core now requires all intermediate wand cores researched
//     - Voidmetal recipe now yields 1 nugget instead of 1 ingot
//     - Voidmetal caps now require 5 ingots instead of 5 nuggets
//     - Staff cores now only require Greatwood wand core research, to improve their location in the tech tree
//     - Sceptre research now requires Thaumium Wand Cap and Silverwood Staff Core
//     - Most affected Thaumonomicon entries have been updated
//     - Thaumonomicon research locations moved around for improved aesthetics 
//     - Arcane Bore more expensive to craft, to bring it in line with other auto-mining methods
//     - Mirrors now more expensive to craft, to bring them in line with other forms of item transport
//     - Wand of Equal Trade now an Eldritch tab research
//     - Added appropriate aspects to certain Railcraft and Twilight Forest items
//     - Runic shielding components (mundane accessories) are now dungeon loot only
//     - Apprentice accessories can be deinfused into mundane accessories
//     - Apprentice accessories are now craftable via new research
//     - GT crop metaitems nerfed
//       - Metallum replaced by Herba 
//       - Lucrum replaced by Terra
//     - Blast Furnace metal transmutations yield tiny pile of dust or oxidized metal instead of the nugget;
//       (Note that the Thaumonomicon will show the output as nugget in some cases - this is a problem with
//       the ModTweaker API and there is literally nothing I can do about it. The text of its Thaumonomicon
//       entry will specify the proper form of the output.)
//     - Runic shielding regen, cost, and cooldown nerfed (via separate Thaumcraft config)
//     - Taint rate of spread nerfed (via separate Thaumcraft config)
// 
//***************************

import mods.nei.NEI;
import mods.thaumcraft.Arcane;
import mods.ic2.Compressor;
import mods.gregtech.Assembler;
import mods.gregtech.PrecisionLaser;
import mods.gregtech.Polarizer;
import mods.gregtech.Lathe;
import mods.gregtech.FormingPress;
import mods.gregtech.Canner;
import mods.gregtech.FluidCanner;

//**************************
// Removing default recipes
//**************************

// Thaumometer
recipes.remove(<Thaumcraft:ItemThaumometer>);
// Firestone
recipes.remove(<Railcraft:firestone.cut>);
recipes.remove(<Railcraft:firestone.refined:4999>);
// Phial
recipes.remove(<Thaumcraft:ItemEssence>);
// Goggles
mods.thaumcraft.Arcane.removeRecipe(<Thaumcraft:ItemGoggles>);
// Hungry Chest
mods.thaumcraft.Arcane.removeRecipe(<Thaumcraft:blockChestHungry>);
// Arcane Lamp
mods.thaumcraft.Arcane.removeRecipe(<Thaumcraft:blockMetalDevice:7>);
// Scribing Tools
recipes.removeShapeless(<Thaumcraft:ItemInkwell>);
// Tallow candle
recipes.removeShaped(<Thaumcraft:blockCandle:0>);
// Enchanted Fabric
mods.thaumcraft.Arcane.removeRecipe(<Thaumcraft:ItemResource:7>);
// Bone Bow
mods.thaumcraft.Arcane.removeRecipe(<Thaumcraft:ItemBowBone>);
// Focus Pouch
mods.thaumcraft.Arcane.removeRecipe(<Thaumcraft:FocusPouch>);
// Boots of the Traveller
mods.thaumcraft.Infusion.removeRecipe(<Thaumcraft:BootsTraveller>);
// Thaumium
mods.thaumcraft.Crucible.removeRecipe(<Thaumcraft:ItemResource:2>);
// Deconstructor
mods.thaumcraft.Arcane.removeRecipe(<Thaumcraft:blockTable:14>);
// Golem Fetter
// mods.thaumcraft.Arcane.removeRecipe(<Thaumcraft:blockCosmeticSolid:9>);
// Arcane Bore
mods.thaumcraft.Arcane.removeRecipe(<Thaumcraft:blockWoodenDevice:4>);
mods.thaumcraft.Infusion.removeRecipe(<Thaumcraft:blockWoodenDevice:5>);
// Mirrors
mods.thaumcraft.Infusion.removeRecipe(<Thaumcraft:blockMirror:0>);
mods.thaumcraft.Infusion.removeRecipe(<Thaumcraft:blockMirror:6>);
mods.thaumcraft.Infusion.removeRecipe(<Thaumcraft:HandMirror>);
// Runic Shielding
recipes.remove(<Thaumcraft:ItemBaubleBlanks:0>);
recipes.remove(<Thaumcraft:ItemBaubleBlanks:1>);
recipes.remove(<Thaumcraft:ItemBaubleBlanks:2>);
// Mirrored Glass
recipes.remove(<Thaumcraft:ItemResource:10>);

// Wand Caps
recipes.remove(<Thaumcraft:WandCap>);
mods.thaumcraft.Arcane.removeRecipe(<Thaumcraft:WandCap:1>);
mods.thaumcraft.Infusion.removeRecipe(<Thaumcraft:WandCap:2>);
mods.thaumcraft.Arcane.removeRecipe(<Thaumcraft:WandCap:3>);
mods.thaumcraft.Infusion.removeRecipe(<Thaumcraft:WandCap:4>);
mods.thaumcraft.Arcane.removeRecipe(<Thaumcraft:WandCap:5>);
mods.thaumcraft.Arcane.removeRecipe(<Thaumcraft:WandCap:6>);
mods.thaumcraft.Infusion.removeRecipe(<Thaumcraft:WandCap:7>);
mods.thaumcraft.Arcane.removeRecipe(<Thaumcraft:WandCap:8>);
// Wooden Wand
recipes.remove(<Thaumcraft:WandCasting>);
// Greatwood
mods.thaumcraft.Arcane.removeRecipe(<Thaumcraft:WandRod>);
// Silverwood
mods.thaumcraft.Infusion.removeRecipe(<Thaumcraft:WandRod:2>);
// Mid-tier
mods.thaumcraft.Infusion.removeRecipe(<Thaumcraft:WandRod:1>); // Obsidian
mods.thaumcraft.Infusion.removeRecipe(<Thaumcraft:WandRod:3>); // Ice
mods.thaumcraft.Infusion.removeRecipe(<Thaumcraft:WandRod:4>); // Quartz
mods.thaumcraft.Infusion.removeRecipe(<Thaumcraft:WandRod:5>); // Reed
mods.thaumcraft.Infusion.removeRecipe(<Thaumcraft:WandRod:6>); // Blaze
mods.thaumcraft.Infusion.removeRecipe(<Thaumcraft:WandRod:7>); // Bone
// Basic Infusion Tools
mods.thaumcraft.Infusion.removeRecipe(<Thaumcraft:ItemPickaxeElemental>);
mods.thaumcraft.Infusion.removeRecipe(<Thaumcraft:ItemAxeElemental>);
mods.thaumcraft.Infusion.removeRecipe(<Thaumcraft:ItemSwordElemental>);
mods.thaumcraft.Infusion.removeRecipe(<Thaumcraft:ItemShovelElemental>);
mods.thaumcraft.Infusion.removeRecipe(<Thaumcraft:ItemHoeElemental>);
// Thaumostatic Harness
mods.thaumcraft.Infusion.removeRecipe(<Thaumcraft:HoverHarness>);
mods.thaumcraft.Infusion.removeRecipe(<Thaumcraft:ItemGirdleHover>);

// Golems
mods.thaumcraft.Arcane.removeRecipe(<Thaumcraft:ItemGolemCore:100>);
mods.thaumcraft.Crucible.removeRecipe(<Thaumcraft:ItemGolemCore:0>);
mods.thaumcraft.Crucible.removeRecipe(<Thaumcraft:ItemGolemCore:1>);
mods.thaumcraft.Crucible.removeRecipe(<Thaumcraft:ItemGolemCore:2>);
mods.thaumcraft.Crucible.removeRecipe(<Thaumcraft:ItemGolemCore:3>);
mods.thaumcraft.Crucible.removeRecipe(<Thaumcraft:ItemGolemCore:4>);
mods.thaumcraft.Crucible.removeRecipe(<Thaumcraft:ItemGolemCore:5>);
mods.thaumcraft.Infusion.removeRecipe(<Thaumcraft:ItemGolemCore:6>);
mods.thaumcraft.Infusion.removeRecipe(<Thaumcraft:ItemGolemCore:7>);
mods.thaumcraft.Infusion.removeRecipe(<Thaumcraft:ItemGolemCore:8>);
mods.thaumcraft.Crucible.removeRecipe(<Thaumcraft:ItemGolemCore:9>);
mods.thaumcraft.Infusion.removeRecipe(<Thaumcraft:ItemGolemCore:10>);
mods.thaumcraft.Infusion.removeRecipe(<Thaumcraft:ItemGolemCore:11>);

// Voidmetal
mods.thaumcraft.Crucible.removeRecipe(<Thaumcraft:ItemResource:16>);
recipes.remove(<Thaumcraft:ItemShovelVoid>);
recipes.remove(<Thaumcraft:ItemPickVoid>);
recipes.remove(<Thaumcraft:ItemAxeVoid>);
recipes.remove(<Thaumcraft:ItemSwordVoid>);
recipes.remove(<Thaumcraft:ItemHoeVoid>);
recipes.remove(<Thaumcraft:ItemHelmetVoid>);
recipes.remove(<Thaumcraft:ItemLeggingsVoid>);
recipes.remove(<Thaumcraft:ItemChestplateVoid>);
recipes.remove(<Thaumcraft:ItemBootsVoid>);

// Fishing core
mods.thaumcraft.Research.clearPrereqs("COREFISHING");
mods.thaumcraft.Research.removeResearch("COREFISHING");
NEI.hide(<Thaumcraft:ItemGolemCore:11>);

// Equal Trade
mods.thaumcraft.Research.orphanResearch("FOCUSTRADE");
mods.thaumcraft.Research.moveResearch("FOCUSTRADE", "ELDRITCH", 4, -1);
mods.thaumcraft.Research.moveResearch("CAP_void", "ELDRITCH", 2, -4);
mods.thaumcraft.Research.addPrereq("FOCUSTRADE", "ELDRITCHMINOR", false);
mods.thaumcraft.Research.clearPages("FOCUSTRADE"); 
mods.thaumcraft.Research.addPage("FOCUSTRADE", "tc.research_page.FOCUSTRADE.1");
mods.thaumcraft.Arcane.removeRecipe(<Thaumcraft:FocusTrade>);
mods.thaumcraft.Infusion.addRecipe("FOCUSTRADE", <Thaumcraft:FocusExcavation>, [<minecraft:quartz>, <Thaumcraft:ItemShard:6>, <minecraft:quartz>, <Thaumcraft:ItemShard:6>, <minecraft:quartz>, <Thaumcraft:ItemShard:6>], "perditio 48, iter 48, permutatio 48, perfodio 48", <Thaumcraft:FocusTrade>, 7);
mods.thaumcraft.Research.addInfusionPage("FOCUSTRADE", <Thaumcraft:FocusTrade>);

mods.thaumcraft.Research.addPrereq("ROD_primal_staff", "FOCUSTRADE", false);
mods.thaumcraft.Research.moveResearch("ROD_primal_staff", "ELDRITCH", 6, 0);

mods.thaumcraft.Research.addPrereq("FOCUSPORTABLEHOLE", "FOCUSFIRE", false);
mods.thaumcraft.Research.moveResearch("FOCUSPORTABLEHOLE", "THAUMATURGY", 4, -3);

// Primal
mods.thaumcraft.Research.addPrereq("FOCUSPRIMAL", "INFUSION", true);
mods.thaumcraft.Research.clearPages("FOCUSPRIMAL"); 
mods.thaumcraft.Research.addPage("FOCUSPRIMAL", "tc.research_page.FOCUSPRIMAL.1");
mods.thaumcraft.Arcane.removeRecipe(<Thaumcraft:FocusPrimal>);
mods.thaumcraft.Infusion.addRecipe("FOCUSPRIMAL", <Thaumcraft:ItemResource:15>, [<minecraft:quartz>, <Thaumcraft:ItemShard:0>, <minecraft:quartz>, <Thaumcraft:ItemShard:1>, <minecraft:quartz>, <Thaumcraft:ItemShard:2>, <minecraft:quartz>, <Thaumcraft:ItemShard:3>, <minecraft:quartz>, <Thaumcraft:ItemShard:4>, <minecraft:quartz>, <Thaumcraft:ItemShard:5>], "praecantatio 64, aer 32, aqua 32, terra 32, ignis 32, ordo 32, perditio 32", <Thaumcraft:FocusPrimal>, 7);
mods.thaumcraft.Research.addInfusionPage("FOCUSPRIMAL", <Thaumcraft:FocusPrimal>);

// Excavation
mods.thaumcraft.Research.addPrereq("FOCUSEXCAVATION", "INFUSION", true);
mods.thaumcraft.Research.clearPages("FOCUSEXCAVATION"); 
mods.thaumcraft.Research.addPage("FOCUSEXCAVATION", "tc.research_page.FOCUSEXCAVATION.1");
mods.thaumcraft.Arcane.removeRecipe(<Thaumcraft:FocusExcavation>);
mods.thaumcraft.Infusion.addRecipe("FOCUSEXCAVATION", <gregtech:gt.metaitem.01:24500>, [<minecraft:quartz>, <Thaumcraft:ItemShard:3>, <minecraft:quartz>, <Thaumcraft:ItemShard:5>, <minecraft:quartz>, <Thaumcraft:ItemShard:4>], "ordo 25, perditio 25, perfodio 10, terra 10", <Thaumcraft:FocusExcavation>, 3);
mods.thaumcraft.Research.addInfusionPage("FOCUSEXCAVATION", <Thaumcraft:FocusExcavation>);


// Transmutations
mods.thaumcraft.Crucible.removeRecipe(<minecraft:coal:1>); // Charcoal
mods.thaumcraft.Research.orphanResearch("GT_WOOD_TO_CHARCOAL");
mods.thaumcraft.Research.removeResearch("GT_WOOD_TO_CHARCOAL");
mods.thaumcraft.Research.addPrereq("GT_IRON_TO_STEEL", "ALUMENTUM", false);
mods.thaumcraft.Research.moveResearch("GT_FILL_WATER_BUCKET", "ALCHEMY", 4, 1);
mods.thaumcraft.Crucible.removeRecipe(<minecraft:gunpowder>); // Gunpowder
mods.thaumcraft.Crucible.removeRecipe(<minecraft:clay_ball>); // Clay
mods.thaumcraft.Crucible.removeRecipe(<gregtech:gt.metaitem.01:9019>); // Aluminium
mods.thaumcraft.Crucible.removeRecipe(<gregtech:gt.metaitem.01:9305>); // Steel

// Instability: 1 = Negligible, 3 = Minor, 5 = Moderate, 7 = High, 9 = Very High, 10+ = Dangerous

//*************************
// Adding Warp to Research
//*************************

mods.thaumcraft.Warp.addToResearch("TRANSGOLD", 2);
mods.thaumcraft.Warp.addToResearch("GT_ADVANCEDMETALLURGY", 3);
mods.thaumcraft.Warp.addToResearch("RUNICARMOR", 5);
mods.thaumcraft.Warp.addToResearch("INFERNALFURNACE", 4);
mods.thaumcraft.Warp.addToResearch("BONEBOW", 1);
mods.thaumcraft.Warp.addToResearch("MIRROR", 3);


// GT Advanced Metallurgy Lore

mods.thaumcraft.Research.setSpikey("GT_ADVANCEDMETALLURGY", true);
mods.thaumcraft.Research.setRound("GT_ADVANCEDMETALLURGY", true);
mods.thaumcraft.Research.clearPages("GT_ADVANCEDMETALLURGY"); 
mods.thaumcraft.Research.addPage("GT_ADVANCEDMETALLURGY", "kirara.research_page.GT_ADVANCEDMETALLURGY.1");
game.setLocalization("en_US", "kirara.research_page.GT_ADVANCEDMETALLURGY.1", "Through utilizing the knowledge you have obtained when discovering all the basic metals, you have gained significant insight towards the creation of far more advanced metals using raw essentia.<BR>Despite the malevolent derision from your fellow peers, you are certain that this transgression into the realms of forbidden metallurgy will have no foreseeable consequences.");


//******************************
// Adding tweaked GT/TC Recipes
//******************************

// IC2 crop aspects
mods.thaumcraft.Aspects.remove(<gregtech:gt.metaitem.02:32500>, "metallum 1"); // Plumbilia
mods.thaumcraft.Aspects.remove(<gregtech:gt.metaitem.02:32530>, "metallum 1"); // Coppon
mods.thaumcraft.Aspects.remove(<gregtech:gt.metaitem.02:32540>, "metallum 1"); // Tine
mods.thaumcraft.Aspects.remove(<gregtech:gt.metaitem.02:32501>, "metallum 1"); // Argentia
mods.thaumcraft.Aspects.remove(<gregtech:gt.metaitem.02:32504>, "metallum 1"); // Aurelia
mods.thaumcraft.Aspects.remove(<gregtech:gt.metaitem.02:32503>, "metallum 2"); // Ferru
mods.thaumcraft.Aspects.add(<gregtech:gt.metaitem.02:32500>, "herba 1"); // Plumbilia
mods.thaumcraft.Aspects.add(<gregtech:gt.metaitem.02:32530>, "herba 1"); // Coppon
mods.thaumcraft.Aspects.add(<gregtech:gt.metaitem.02:32540>, "herba 1"); // Tine
mods.thaumcraft.Aspects.add(<gregtech:gt.metaitem.02:32501>, "herba 1"); // Argentia
mods.thaumcraft.Aspects.add(<gregtech:gt.metaitem.02:32504>, "herba 1"); // Aurelia
mods.thaumcraft.Aspects.add(<gregtech:gt.metaitem.02:32503>, "herba 2"); // Ferru
mods.thaumcraft.Aspects.remove(<gregtech:gt.metaitem.02:32501>, "lucrum 1"); // Argentia
mods.thaumcraft.Aspects.remove(<gregtech:gt.metaitem.02:32504>, "lucrum 1"); // Aurelia
mods.thaumcraft.Aspects.remove(<gregtech:gt.metaitem.02:32511>, "lucrum 1"); // Bobsyeruncleranks
mods.thaumcraft.Aspects.add(<gregtech:gt.metaitem.02:32501>, "terra 1"); // Argentia
mods.thaumcraft.Aspects.add(<gregtech:gt.metaitem.02:32504>, "terra 1"); // Aurelia
mods.thaumcraft.Aspects.add(<gregtech:gt.metaitem.02:32511>, "terra 1"); // Bobsyeruncleranks

// RC item aspects
mods.thaumcraft.Aspects.set(<Railcraft:fluid.steam.bottle>, "ignis 1, aqua 1");
mods.thaumcraft.Aspects.set(<Railcraft:fluid.creosote.bottle>, "ignis 1, potentia 1");

// TF item aspects
mods.thaumcraft.Aspects.set(<TwilightForest:item.oreMagnet>, "magneto 8, metallum 2, lucrum 2");
mods.thaumcraft.Aspects.set(<TwilightForest:tile.TFFirefly>, "lux 1, volatus 4");
mods.thaumcraft.Aspects.set(<TwilightForest:tile.TFMoonworm>, "lux 2, bestia 1");
mods.thaumcraft.Aspects.set(<TwilightForest:tile.TFFireflyJar>, "lux 1, volatus 4, vacuos 1");
mods.thaumcraft.Aspects.set(<TwilightForest:tile.TFCicada>, "sensus 1, volatus 4");
mods.thaumcraft.Aspects.set(<TwilightForest:tile.TFPlant:4>, "aer 1, herba 1");
mods.thaumcraft.Aspects.set(<TwilightForest:tile.TFPlant:8>, "aer 1, herba 1");
mods.thaumcraft.Aspects.set(<TwilightForest:tile.TFPlant:9>, "terra 1, lux 1, herba 1");
mods.thaumcraft.Aspects.set(<TwilightForest:item.torchberries>, "lux 2, herba 1, praecantatio 1");
mods.thaumcraft.Aspects.set(<TwilightForest:item.charmOfLife1>, "sano 6, praecantatio 4");
mods.thaumcraft.Aspects.set(<TwilightForest:item.charmOfLife2>, "sano 24, praecantatio 16, nebrisum 2");
mods.thaumcraft.Aspects.set(<TwilightForest:item.charmOfKeeping1>, "iter 3, praecantatio 2");
mods.thaumcraft.Aspects.set(<TwilightForest:item.charmOfKeeping2>, "iter 12, praecantatio 8");
mods.thaumcraft.Aspects.set(<TwilightForest:item.charmOfKeeping3>, "iter 48, praecantatio 32, nebrisum 2");

// Decorative
Compressor.addRecipe(<Thaumcraft:blockCosmeticSolid:4>, <Thaumcraft:ItemResource:2> * 9);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:blockCandle>, <Thaumcraft:ItemResource:4> * 4, <minecraft:string>, <liquid:water> * 125, 51200, 1);
mods.thaumcraft.Research.clearPages("TALLOW"); 
mods.thaumcraft.Research.addPage("TALLOW", "kirara.research_page.TALLOW.1");
game.setLocalization("en_US", "kirara.research_page.TALLOW.1", "By processing and heating flesh in a crucible, you can create a mystical tallow suited for many arcane uses.<BR>This tallow can be used with string and water to craft candles in an \u00A75Assembling Machine\u00A70. It is also possible to craft different colored candles by combining a candle with a dye in a workbench, thankfully in a much less time-consuming manner.");
mods.thaumcraft.Research.addCruciblePage("TALLOW", <Thaumcraft:ItemResource:4>);
mods.gregtech.Lathe.addRecipe([<Thaumcraft:blockStoneDevice:1>, <gregtech:gt.metaitem.01:1299>], <Thaumcraft:blockCosmeticSolid:6>, 2400, 8);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:blockTable:0>, <Thaumcraft:blockMagicalLog:0>, <Thaumcraft:blockTable:0> * 0, <liquid:glue> * 100, 180, 24); 
mods.gregtech.Assembler.addRecipe(<Thaumcraft:blockCosmeticSolid:6>, <minecraft:stone>, <Thaumcraft:blockCosmeticSolid:6> * 0, <liquid:molten.thaumium> * 16, 120, 24); 
mods.gregtech.Assembler.addRecipe(<Thaumcraft:blockCosmeticSolid:2>, <Thaumcraft:blockCosmeticSolid:7>, <Thaumcraft:blockCosmeticSolid:2> * 0, <liquid:molten.thaumium> * 144, 800, 24); 
mods.gregtech.Assembler.addRecipe(<Thaumcraft:blockCosmeticSolid:3>, <Thaumcraft:blockCosmeticSolid:7>, <Thaumcraft:blockCosmeticSolid:7> * 0, <liquid:molten.thaumium> * 144, 800, 24); 
mods.gregtech.Polarizer.addRecipe(<Thaumcraft:ItemBaubleBlanks:1>, <Thaumcraft:ItemBaubleBlanks:3>, 2400, 24);
mods.gregtech.Polarizer.addRecipe(<Thaumcraft:ItemBaubleBlanks:1>, <Thaumcraft:ItemBaubleBlanks:4>, 2400, 24);
mods.gregtech.Polarizer.addRecipe(<Thaumcraft:ItemBaubleBlanks:1>, <Thaumcraft:ItemBaubleBlanks:5>, 2400, 24);
mods.gregtech.Polarizer.addRecipe(<Thaumcraft:ItemBaubleBlanks:1>, <Thaumcraft:ItemBaubleBlanks:6>, 2400, 24);
mods.gregtech.Polarizer.addRecipe(<Thaumcraft:ItemBaubleBlanks:1>, <Thaumcraft:ItemBaubleBlanks:7>, 2400, 24);
mods.gregtech.Polarizer.addRecipe(<Thaumcraft:ItemBaubleBlanks:1>, <Thaumcraft:ItemBaubleBlanks:8>, 2400, 24);

// Arcane keys
mods.gregtech.FormingPress.addRecipe(<Thaumcraft:ArcaneDoorKey:0>, <gregtech:gt.metaitem.01:23032>, <Thaumcraft:ArcaneDoorKey:0> * 0, 40, 16);
mods.gregtech.FormingPress.addRecipe(<Thaumcraft:ArcaneDoorKey:1>, <gregtech:gt.metaitem.01:23086>, <Thaumcraft:ArcaneDoorKey:1> * 0, 40, 16);

// Arcane Lamp
mods.thaumcraft.Arcane.addShaped("ARCANELAMP", <Thaumcraft:blockMetalDevice:7> * 2, "ignis 12, aer 12, aqua 6, perditio 6", [[null, <minecraft:daylight_detector>, null], 
                                                                                                                           [<gregtech:gt.metaitem.01:24514>, <GregsLighting:floodlight>, <gregtech:gt.metaitem.01:24514>],
																														   [null, <Thaumcraft:ItemResource:1>, null]]);


// Phials
mods.thaumcraft.Arcane.addShapeless("PHIAL", <Thaumcraft:ItemEssence>, "ordo 2", [<minecraft:clay_ball>, <minecraft:glass_bottle>]);
mods.thaumcraft.Research.clearPages("PHIAL"); 
mods.thaumcraft.Research.addPage("PHIAL", "kirara.research_page.PHIAL.1");
game.setLocalization("en_US", "kirara.research_page.PHIAL.1", "Glass phials are capable of holding all manner of liquids and substances, but their most important use to a thaumaturge is their ability to hold Essentia.<BR>While they can be created in the arcane workbench from molding clay and regular glass bottles, Phials are manufactured much more efficiently with an \u00A75Assembling Machine\u00A70.");
mods.thaumcraft.Research.addArcanePage("PHIAL", <Thaumcraft:ItemEssence>);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemEssence> * 8, <gregtech:gt.metaitem.01:28880> * 8, <minecraft:clay_ball>, <liquid:molten.glass> * 144, 80, 2);

// Warded Jars
mods.gregtech.Assembler.addRecipe(<Thaumcraft:blockJar:0> * 2, <gregtech:gt.metaitem.01:2809>, <Thaumcraft:blockJar:0> * 0, <liquid:molten.glass> * 576, 480, 2);
mods.gregtech.FluidCanner.addRecipe(<Thaumcraft:blockJar:3>, <Thaumcraft:blockJar:0>, null, <liquid:lava> * 1000);
mods.gregtech.FluidCanner.addRecipe(<Thaumcraft:blockJar:0>, <Thaumcraft:blockJar:3>, <liquid:lava> * 1000, null);

// Brain in a Jar
mods.gregtech.Canner.addRecipe([<Thaumcraft:blockJar:0>, <Thaumcraft:ItemZombieBrain>], <Thaumcraft:blockJar:1>, null, 40, 2);

// Mirrored Glass
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemResource:10>, <minecraft:glass_pane>, <Thaumcraft:ItemNugget:5>, <liquid:molten.aluminium> * 72, 80, 2);
// mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemBaubleBlanks:2>, <minecraft:leather> * 3, <minecraft:gold_ingot>, <liquid:glue> * 100, 80, 2);

// Removing recipe display for uncraftables
mods.thaumcraft.Research.clearPages("BASICARTIFACE"); 
mods.thaumcraft.Research.addPage("BASICARTIFACE", "tc.research_page.BASICARTIFACE.1");
mods.thaumcraft.Research.addArcanePage("BASICARTIFACE", <Thaumcraft:ItemResource:15>);

// Thaumometer: 6 gold rod + blue glass pane, Assembling Machine
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemThaumometer>, <gregtech:gt.metaitem.01:23086> * 6, <minecraft:stained_glass_pane:11>, <liquid:glue> * 100, 400, 480);
mods.thaumcraft.Arcane.addShaped("RESEARCH", <Thaumcraft:ItemThaumometer>, "ordo 1, perditio 1, terra 1, aqua 1, ignis 1, aer 1", [[<ore:shardAir>, <ore:shardFire>, <ore:shardWater>], 
                                                                                                                                   [<ore:ingotGold>, <ore:paneGlass>, <ore:ingotGold>],
																																   [<ore:shardEarth>, <ore:shardOrder>, <ore:shardEntropy>]]);
mods.thaumcraft.Research.clearPages("THAUMOMETER"); 
mods.thaumcraft.Research.addPage("THAUMOMETER", "tc.research_page.THAUMOMETER.1");
mods.thaumcraft.Research.addArcanePage("THAUMOMETER", <Thaumcraft:ItemThaumometer>);

// Goggles of Revealing
mods.thaumcraft.Research.addPrereq("GOGGLES", "THAUMIUM", true);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemGoggles:0>, <Thaumcraft:ItemThaumometer> * 2, <Thaumcraft:ItemGoggles:*> * 0, <liquid:molten.thaumium> * 288, 800, 480);
mods.thaumcraft.Arcane.addShaped("GOGGLES", <Thaumcraft:ItemGoggles>, "ordo 25, perditio 25, terra 25, aqua 25, ignis 25, aer 25", [[<minecraft:leather>, <ore:ingotThaumium>, <minecraft:leather>], 
                                                                                                                                   [<minecraft:leather>, null, <minecraft:leather>],
																																   [<Thaumcraft:ItemThaumometer>, <ore:ingotThaumium>, <Thaumcraft:ItemThaumometer>]]);

// Focus Pouch
mods.thaumcraft.Research.addPrereq("FOCUSPOUCH", "THAUMIUM", true);
mods.thaumcraft.Arcane.addShaped("FOCUSPOUCH", <Thaumcraft:FocusPouch>, "ordo 10, perditio 10, terra 10, aqua 10, ignis 10, aer 10", [[<minecraft:leather>, <ore:ingotThaumium>, <minecraft:leather>], 
                                                                                                                                      [<minecraft:leather>, <ore:craftingChest>, <minecraft:leather>],
																																      [<minecraft:leather>, <minecraft:leather>, <minecraft:leather>]]);

// Hungry Chest
mods.thaumcraft.Arcane.addShaped("HUNGRYCHEST", <Thaumcraft:blockChestHungry>, "aer 36, perditio 12, ordo 12", [[<Thaumcraft:blockMagicalLog:0>, <ore:ingotThaumium>, <Thaumcraft:blockMagicalLog:0>], 
                                                                                                                [<Thaumcraft:blockMagicalLog:0>, <ore:craftingChest>, <Thaumcraft:blockMagicalLog:0>],
                                                                                                                [<Thaumcraft:blockMagicalLog:0>, <Thaumcraft:blockMagicalLog:0>, <Thaumcraft:blockMagicalLog:0>]]);

// Enchanted Fabric

mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemResource:7>, <minecraft:string> * 8, <Thaumcraft:ItemResource:7> * 0, <liquid:molten.thaumium> * 144, 40, 8);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemChestplateRobe>, <Thaumcraft:ItemResource:7> * 4, <Thaumcraft:ItemChestplateRobe:*> * 0, <liquid:molten.thaumium> * 144, 3600, 8);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemLeggingsRobe>, <Thaumcraft:ItemResource:7> * 3, <Thaumcraft:ItemLeggingsRobe:*> * 0, <liquid:molten.thaumium> * 144, 3600, 8);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemBootsRobe>, <Thaumcraft:ItemResource:7> * 2, <Thaumcraft:ItemBootsRobe:*> * 0, <liquid:molten.thaumium> * 144, 3600, 8);
mods.thaumcraft.Arcane.addShaped("ENCHFABRIC", <Thaumcraft:ItemResource:7>, "ordo 10, perditio 10, terra 10, aqua 10, ignis 10, aer 10", [[null, <minecraft:string>, null], 
                                                                                                                                          [<minecraft:string>, <ore:blockWool>, <minecraft:string>],
																										       						      [null, <minecraft:string>, null]]);

// Bone Bow
mods.thaumcraft.Research.clearPages("BONEBOW"); 
mods.thaumcraft.Research.addPage("BONEBOW", "tc.research_page.BONEBOW.1");
mods.thaumcraft.Infusion.addRecipe("BONEBOW", <gregtech:gt.metaitem.02:22028>, [<minecraft:bone>, <Thaumcraft:ItemShard:5>, <minecraft:string>, <Thaumcraft:ItemShard:5>, <minecraft:bone>, <Thaumcraft:ItemShard:5>, <minecraft:string>, <Thaumcraft:ItemShard:5>], "perditio 48, aer 24, telum 48, exanimis 24", <Thaumcraft:ItemBowBone>, 6);
mods.thaumcraft.Research.addInfusionPage("BONEBOW", <Thaumcraft:ItemBowBone>);
mods.thaumcraft.Research.addPrereq("BONEBOW", "INFUSION", true);

// Boots of the Traveller
mods.thaumcraft.Infusion.addRecipe("BOOTSTRAVELLER", <OpenComputers:hoverBoots>, [<Thaumcraft:ItemResource:7>, <OpenComputers:item:99>, <Thaumcraft:ItemResource:7>, <OpenComputers:item:49>], "iter 96, volatus 96", <Thaumcraft:BootsTraveller>, 1);

// Thaumium
mods.thaumcraft.Crucible.addRecipe("THAUMIUM", <Thaumcraft:ItemResource:2>, <Thaumcraft:ItemShard:6>, "metallum 8, praecantatio 4");
mods.thaumcraft.Research.clearPages("THAUMIUM"); 
mods.thaumcraft.Research.addPage("THAUMIUM", "tc.research_page.THAUMIUM.1");
mods.thaumcraft.Research.addCruciblePage("THAUMIUM", <Thaumcraft:ItemResource:2>);
mods.thaumcraft.Research.addCraftingPage("THAUMIUM", <Thaumcraft:ItemAxeThaumium>);
mods.thaumcraft.Research.addCraftingPage("THAUMIUM", <Thaumcraft:ItemSwordThaumium>);
mods.thaumcraft.Research.addCraftingPage("THAUMIUM", <Thaumcraft:ItemPickThaumium>);
mods.thaumcraft.Research.addCraftingPage("THAUMIUM", <Thaumcraft:ItemShovelThaumium>);
mods.thaumcraft.Research.addCraftingPage("THAUMIUM", <Thaumcraft:ItemHoeThaumium>);
mods.thaumcraft.Research.addCraftingPage("THAUMIUM", <Thaumcraft:ItemHelmetThaumium>);
mods.thaumcraft.Research.addCraftingPage("THAUMIUM", <Thaumcraft:ItemChestplateThaumium>);
mods.thaumcraft.Research.addCraftingPage("THAUMIUM", <Thaumcraft:ItemLeggingsThaumium>);
mods.thaumcraft.Research.addCraftingPage("THAUMIUM", <Thaumcraft:ItemBootsThaumium>);

// Basic Infusion Tools
mods.thaumcraft.Infusion.addRecipe("ELEMENTALPICK", <gregtech:gt.metaitem.01:23028>, [<Thaumcraft:ItemShard:1>, <Thaumcraft:ItemShard:1>, <gregtech:gt.metaitem.02:1330>, <Thaumcraft:ItemResource:14>], "ignis 64, perfodio 64, sensus 64", <Thaumcraft:ItemPickaxeElemental>, 5);
mods.thaumcraft.Infusion.addRecipe("ELEMENTALAXE", <gregtech:gt.metaitem.01:23028>, [<Thaumcraft:ItemShard:2>, <Thaumcraft:ItemShard:2>, <gregtech:gt.metaitem.02:3330>, <Thaumcraft:ItemResource:14>], "aqua 128, arbor 64", <Thaumcraft:ItemAxeElemental>, 5);
mods.thaumcraft.Infusion.addRecipe("ELEMENTALSWORD", <gregtech:gt.metaitem.01:23028>, [<Thaumcraft:ItemShard:0>, <Thaumcraft:ItemShard:0>, <gregtech:gt.metaitem.02:330>, <Thaumcraft:ItemResource:14>], "aer 64, motus 64, potentia 64", <Thaumcraft:ItemSwordElemental>, 5);
mods.thaumcraft.Infusion.addRecipe("ELEMENTALSHOVEL", <gregtech:gt.metaitem.01:23028>, [<Thaumcraft:ItemShard:3>, <Thaumcraft:ItemShard:3>, <gregtech:gt.metaitem.02:2330>, <Thaumcraft:ItemResource:14>], "fabrico 64, terra 128", <Thaumcraft:ItemShovelElemental>, 5);
mods.thaumcraft.Infusion.addRecipe("ELEMENTALHOE", <gregtech:gt.metaitem.01:23028>, [<Thaumcraft:ItemShard:4>, <Thaumcraft:ItemShard:5>, <gregtech:gt.metaitem.02:4330>, <Thaumcraft:ItemResource:14>], "herba 64, meto 64, terra 64", <Thaumcraft:ItemHoeElemental>, 5);

// Arcane Bore
mods.thaumcraft.Infusion.addRecipe("ARCANEBORE", <Thaumcraft:FocusExcavation>, [<minecraft:diamond_axe>, <Thaumcraft:ItemShard:0>, <Thaumcraft:ItemShard:1>, <minecraft:diamond_pickaxe>, <Thaumcraft:ItemShard:2>, <Thaumcraft:ItemShard:3>, <minecraft:diamond_shovel>, <Thaumcraft:ItemShard:4>, <Thaumcraft:ItemShard:5>], "machina 64, motus 32, perfodio 64, potentia 32, vacuos 32", <Thaumcraft:blockWoodenDevice:5>, 7);
mods.thaumcraft.Infusion.addRecipe("ARCANEBORE", <gregtech:gt.metaitem.01:32722>, [<minecraft:chest>, <TwilightForest:item.oreMagnet>, <minecraft:chest>, <TwilightForest:item.oreMagnet>, <minecraft:chest>, <TwilightForest:item.oreMagnet>, <minecraft:chest>, <TwilightForest:item.oreMagnet>], "machina 64, magneto 64, motus 64, iter 64", <Thaumcraft:blockWoodenDevice:4>, 7);
mods.thaumcraft.Research.clearPages("ARCANEBORE"); 
mods.thaumcraft.Research.addPage("ARCANEBORE", "tc.research_page.ARCANEBORE.1");
mods.thaumcraft.Research.addInfusionPage("ARCANEBORE", <Thaumcraft:blockWoodenDevice:5>);
mods.thaumcraft.Research.addPage("ARCANEBORE", "tc.research_page.ARCANEBORE.2");
mods.thaumcraft.Research.addInfusionPage("ARCANEBORE", <Thaumcraft:blockWoodenDevice:4>);
mods.thaumcraft.Research.addPage("ARCANEBORE", "tc.research_page.ARCANEBORE.3");

// Mirrors
mods.thaumcraft.Infusion.addRecipe("MIRROR", <Thaumcraft:ItemResource:10>, [<minecraft:gold_ingot>, <minecraft:ender_chest>, <minecraft:gold_ingot>, <minecraft:ender_pearl>], "iter 32, permutatio 32, tenebrae 32", <Thaumcraft:blockMirror:0>, 3);
mods.thaumcraft.Infusion.addRecipe("MIRRORHAND", <Thaumcraft:blockMirror:0>, [<gregtech:gt.metaitem.01:23305>, <minecraft:compass>, <minecraft:map>, <minecraft:ender_pearl>], "iter 64, instrumentum 64", <Thaumcraft:HandMirror>, 6);
mods.thaumcraft.Infusion.addRecipe("MIRRORESSENTIA", <Thaumcraft:ItemResource:10>, [<minecraft:iron_ingot>, <minecraft:ender_pearl>, <minecraft:iron_ingot>, <Thaumcraft:blockJar>], "iter 16, permutatio 16, tenebrae 16", <Thaumcraft:blockMirror:6>, 3);

// Thaumostatic Harness
mods.thaumcraft.Infusion.addRecipe("HOVERHARNESS", <IC2:itemArmorJetpackElectric:*>, [<Thaumcraft:ItemChestplateRobe>, <Thaumcraft:ItemShard:0>, <Thaumcraft:blockTube:1>, <Thaumcraft:ItemShard:0>, <minecraft:chest>, <Thaumcraft:ItemShard:0>, <Thaumcraft:blockTube:0>, <Thaumcraft:ItemShard:0>], "iter 64, machina 128, potentia 128, volatus 256", <Thaumcraft:HoverHarness>, 7);
mods.thaumcraft.Infusion.addRecipe("HOVERGIRDLE", <Thaumcraft:ItemBaubleBlanks:2>, [<Thaumcraft:ItemShard:0>, <minecraft:feather>, <GraviSuite:itemSimpleItem:6>, <minecraft:gold_ingot>, <Thaumcraft:ItemShard:3>, <minecraft:feather>, <GraviSuite:itemSimpleItem:6>, <minecraft:gold_ingot>], "aer 128, iter 64, potentia 128, volatus 64", <Thaumcraft:ItemGirdleHover>, 9);

// Duplicating Recipes
mods.thaumcraft.Research.clearPages("ALCHEMICALDUPLICATION"); 
mods.thaumcraft.Research.addPage("ALCHEMICALDUPLICATION", "tc.research_page.ALCHEMICALDUPLICATION.1");
mods.thaumcraft.Research.addCruciblePage("ALCHEMICALDUPLICATION", <minecraft:slime_ball>);
// mods.thaumcraft.Research.addCruciblePage("ALCHEMICALDUPLICATION", <minecraft:clay_ball>);
mods.thaumcraft.Research.addCruciblePage("ALCHEMICALDUPLICATION", <minecraft:dye:0>);
mods.thaumcraft.Crucible.addRecipe("ALCHEMICALDUPLICATION", <minecraft:dye:2> * 2, <minecraft:dye:2>, "aqua 1, herba 4");
mods.thaumcraft.Research.addCruciblePage("ALCHEMICALDUPLICATION", <minecraft:dye:2>);
// mods.thaumcraft.Crucible.addRecipe("ALCHEMICALDUPLICATION", <minecraft:dye:4> * 2, <minecraft:dye:4>, "lucrum 2, sensus 2");
// mods.thaumcraft.Research.addCruciblePage("ALCHEMICALDUPLICATION", <minecraft:dye:4>);
// mods.thaumcraft.Crucible.addRecipe("ALCHEMICALDUPLICATION", <minecraft:quartz> * 2, <minecraft:quartz>, "vitreus 2, potentia 2");
// mods.thaumcraft.Research.addCruciblePage("ALCHEMICALDUPLICATION", <minecraft:quartz>);

// Gunpowder
mods.thaumcraft.Crucible.addRecipe("ALCHEMICALMANUFACTURE", <minecraft:gunpowder> * 2, <gregtech:gt.metaitem.01:2836>, "potentia 4, ignis 4, perditio 2");
mods.thaumcraft.Research.addCruciblePage("ALCHEMICALMANUFACTURE", <minecraft:gunpowder>);

// Scribing Tools
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemInkwell>, <Thaumcraft:ItemEssence>, <minecraft:feather>, <liquid:squidink> * 144, 80, 8);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemInkwell>, <Thaumcraft:ItemEssence>, <TwilightForest:item.tfFeather>, <liquid:squidink> * 144, 80, 8);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemInkwell:0>, <Thaumcraft:ItemInkwell:*>, <minecraft:feather>, <liquid:squidink> * 144, 20, 2);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemInkwell:0>, <Thaumcraft:ItemInkwell:*>, <TwilightForest:item.tfFeather>, <liquid:squidink> * 144, 20, 2);

mods.thaumcraft.Research.clearPages("RESEARCH"); 
mods.thaumcraft.Research.addPage("RESEARCH", "tc.research_page.RESEARCH.1");
mods.thaumcraft.Research.addPage("RESEARCH", "tc.research_page.RESEARCH.2");
mods.thaumcraft.Research.addArcanePage("RESEARCH", <Thaumcraft:ItemThaumometer>);
mods.thaumcraft.Research.addPage("RESEARCH", "tc.research_page.RESEARCH.3");
mods.thaumcraft.Research.addPage("RESEARCH", "tc.research_page.RESEARCH.4");
mods.thaumcraft.Research.addPage("RESEARCH", "kirara.research_page.RESEARCH.1");
game.setLocalization("en_US", "kirara.research_page.RESEARCH.1", "Research notes must be carefully written using a set of \u00A75Scribing Tools\u00A70 that may not be manufactured without advanced technological processes.<BR>You first need to construct and power an \u00A75Assembling Machine\u00A70, place into its input a \u00A75Glass Phial\u00A70 and \u00A75Feather\u00A70, and provide the contraption with a supply of liquid \u00A75Squid Ink\u00A70. A set of \u00A75Scribing Tools\u00A70 will be produced after a short time. <BR>Repeating the above recipe with a set of emptied \u00A75Scribing Tools\u00A70 instead of the \u00A75Glass Phial\u00A70 will instead refill the \u00A75Scribing Tools\u00A70, but only consuming one-fourth the quantity of liquid ink.");
mods.thaumcraft.Research.addPage("RESEARCH", "tc.research_page.RESEARCH.5");
mods.thaumcraft.Research.addPage("RESEARCH", "tc.research_page.RESEARCH.6");
mods.thaumcraft.Research.addPage("RESEARCH", "tc.research_page.RESEARCH.7");
mods.thaumcraft.Research.addPage("RESEARCH", "tc.research_page.RESEARCH.8");
mods.thaumcraft.Research.addPage("RESEARCH", "tc.research_page.RESEARCH.9");
mods.thaumcraft.Research.addPage("RESEARCH", "tc.research_page.RESEARCH.10");
mods.thaumcraft.Research.addPage("RESEARCH", "tc.research_page.RESEARCH.11");
mods.thaumcraft.Research.addPage("RESEARCH", "tc.research_page.RESEARCH.12");

// Golem gating
mods.thaumcraft.Arcane.addShapeless("COREGATHER", <Thaumcraft:ItemGolemCore:100>, "ordo 275", [<chisel:redstone_block:13>, <Thaumcraft:ItemResource:1>]);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemGolemCore:100>, <chisel:redstone_block:13>, <gregtech:gt.metaitem.01:32700> * 16, <liquid:molten.thaumium> * 1152, 2400000, 1);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemGolemCore:100>, <chisel:redstone_block:13>, <IC2:itemPartCircuit> * 8, <liquid:molten.thaumium> * 576, 640000, 8);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemGolemCore:100>, <chisel:redstone_block:13>, <IC2:itemPartCircuitAdv> * 4, <liquid:molten.thaumium> * 288, 160000, 60);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemGolemCore:100>, <chisel:redstone_block:13>, <gregtech:gt.metaitem.01:32705> * 2, <liquid:molten.thaumium> * 144, 40000, 480);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemGolemCore:100>, <chisel:redstone_block:13>, <gregtech:gt.metaitem.01:32706> * 2, <liquid:molten.thaumium> * 144, 6000, 1920);

// Golem Animation Core Infusion Recipes
mods.thaumcraft.Infusion.addRecipe("COREFILL", <Thaumcraft:ItemGolemCore:100>, [<gregtech:gt.metaitem.01:32652>, <gregtech:gt.integrated_circuit:1>], "fames 16, iter 16, vacuos 32, motus 32", <Thaumcraft:ItemGolemCore:0>, 5);
mods.thaumcraft.Infusion.addRecipe("COREEMPTY", <Thaumcraft:ItemGolemCore:100>, [<gregtech:gt.metaitem.01:32652>, <gregtech:gt.integrated_circuit:2>], "lucrum 16, iter 16, vacuos 32, motus 32", <Thaumcraft:ItemGolemCore:1>, 5);
mods.thaumcraft.Infusion.addRecipe("COREGATHER", <Thaumcraft:ItemGolemCore:100>, [<gregtech:gt.metaitem.01:32652>, <gregtech:gt.integrated_circuit:3>], "lucrum 16, iter 16, magneto 32, motus 32", <Thaumcraft:ItemGolemCore:2>, 5);
mods.thaumcraft.Infusion.addRecipe("COREHARVEST", <Thaumcraft:ItemGolemCore:100>, [<gregtech:gt.metaitem.01:32652>, <gregtech:gt.integrated_circuit:4>], "messis 16, iter 16, meto 32, motus 32", <Thaumcraft:ItemGolemCore:3>, 5);
mods.thaumcraft.Infusion.addRecipe("COREGUARD", <Thaumcraft:ItemGolemCore:100>, [<gregtech:gt.metaitem.01:32652>, <gregtech:gt.integrated_circuit:5>], "vinculum 16, iter 16, telum 32, motus 32", <Thaumcraft:ItemGolemCore:4>, 5);
mods.thaumcraft.Infusion.addRecipe("CORELIQUID", <Thaumcraft:ItemGolemCore:100>, [<gregtech:gt.metaitem.01:32652>, <gregtech:gt.integrated_circuit:6>], "aqua 16, iter 16, vacuos 32, motus 32", <Thaumcraft:ItemGolemCore:5>, 5);
mods.thaumcraft.Infusion.addRecipe("COREALCHEMY", <Thaumcraft:ItemGolemCore:100>, [<gregtech:gt.metaitem.01:32652>, <gregtech:gt.integrated_circuit:7>], "aqua 16, iter 16, praecantatio 32, motus 32", <Thaumcraft:ItemGolemCore:6>, 5);
mods.thaumcraft.Infusion.addRecipe("CORELUMBER", <Thaumcraft:ItemGolemCore:100>, [<gregtech:gt.metaitem.01:32652>, <gregtech:gt.integrated_circuit:8>], "instrumentum 16, iter 16, meto 32, motus 32", <Thaumcraft:ItemGolemCore:7>, 5);
mods.thaumcraft.Infusion.addRecipe("COREUSE", <Thaumcraft:ItemGolemCore:100>, [<gregtech:gt.metaitem.01:32652>, <gregtech:gt.integrated_circuit:9>], "machina 16, iter 16, humanus 32, motus 32", <Thaumcraft:ItemGolemCore:8>, 5);
mods.thaumcraft.Infusion.addRecipe("COREBUTCHER", <Thaumcraft:ItemGolemCore:100>, [<gregtech:gt.metaitem.01:32652>, <gregtech:gt.integrated_circuit:10>], "bestia 16, iter 16, corpus 32, motus 32", <Thaumcraft:ItemGolemCore:9>, 5);
mods.thaumcraft.Infusion.addRecipe("CORESORTING", <Thaumcraft:ItemGolemCore:100>, [<gregtech:gt.metaitem.01:32652>, <gregtech:gt.integrated_circuit:11>], "cognitio 16, iter 16, permutatio 32, motus 32", <Thaumcraft:ItemGolemCore:10>, 5);
// mods.thaumcraft.Infusion.addRecipe("COREFISHING", <Thaumcraft:ItemGolemCore:100>, [<gregtech:gt.metaitem.01:32652>, <gregtech:gt.integrated_circuit:12>], "aqua 16, iter 16, lucrum 32, motus 32", <Thaumcraft:ItemGolemCore:11>, 5);

// Golem Animation Core Thaumonomicon Entries
mods.thaumcraft.Research.clearPages("COREFILL"); 
mods.thaumcraft.Research.addPage("COREFILL", "tc.research_page.COREFILL.1");
mods.thaumcraft.Research.addInfusionPage("COREFILL", <Thaumcraft:ItemGolemCore:0>);

mods.thaumcraft.Research.clearPages("COREEMPTY"); 
mods.thaumcraft.Research.addPage("COREEMPTY", "tc.research_page.COREEMPTY.1");
mods.thaumcraft.Research.addInfusionPage("COREEMPTY", <Thaumcraft:ItemGolemCore:1>);

mods.thaumcraft.Research.clearPages("COREGATHER"); 
mods.thaumcraft.Research.addPage("COREGATHER", "tc.research_page.COREGATHER.1");
mods.thaumcraft.Research.addInfusionPage("COREGATHER", <Thaumcraft:ItemGolemCore:2>);
mods.thaumcraft.Research.addPage("COREGATHER", "kirara.research_page.GT_COREGATHER.1");
game.setLocalization("en_US", "kirara.research_page.GT_COREGATHER.1", "Simply right-click on a freshly placed golem with a core to attach it to the golem.<BR>The precision required for the basic animation core means the thaumaturge must channel a very large amount of ordo vis into a block of redstone circuit in a very short amount of time - perhaps more than what your wand can currently handle.<BR>Maybe an alternative manufacturing method using precise assembly machinery could adequately substitute...");
mods.thaumcraft.Research.addArcanePage("COREGATHER", <Thaumcraft:ItemGolemCore:100>);

mods.thaumcraft.Research.clearPages("COREHARVEST"); 
mods.thaumcraft.Research.addPage("COREHARVEST", "tc.research_page.COREHARVEST.1");
mods.thaumcraft.Research.addInfusionPage("COREHARVEST", <Thaumcraft:ItemGolemCore:3>);
mods.thaumcraft.Research.addPage("COREHARVEST", "tc.research_page.COREHARVEST.2");

mods.thaumcraft.Research.clearPages("COREGUARD"); 
mods.thaumcraft.Research.addPage("COREGUARD", "tc.research_page.COREGUARD.1");
mods.thaumcraft.Research.addInfusionPage("COREGUARD", <Thaumcraft:ItemGolemCore:4>);
mods.thaumcraft.Research.addPage("COREGUARD", "tc.research_page.COREGUARD.2");

mods.thaumcraft.Research.clearPages("CORELIQUID"); 
mods.thaumcraft.Research.addPage("CORELIQUID", "tc.research_page.CORELIQUID.1");
mods.thaumcraft.Research.addInfusionPage("CORELIQUID", <Thaumcraft:ItemGolemCore:5>);
mods.thaumcraft.Research.addPage("CORELIQUID", "tc.research_page.CORELIQUID.2");

mods.thaumcraft.Research.clearPages("COREALCHEMY"); 
mods.thaumcraft.Research.addPage("COREALCHEMY", "tc.research_page.COREALCHEMY.1");
mods.thaumcraft.Research.addInfusionPage("COREALCHEMY", <Thaumcraft:ItemGolemCore:6>);
mods.thaumcraft.Research.addPage("COREALCHEMY", "tc.research_page.COREALCHEMY.2");

mods.thaumcraft.Research.clearPages("CORELUMBER"); 
mods.thaumcraft.Research.addPage("CORELUMBER", "tc.research_page.CORELUMBER.1");
mods.thaumcraft.Research.addInfusionPage("CORELUMBER", <Thaumcraft:ItemGolemCore:7>);

mods.thaumcraft.Research.clearPages("COREUSE"); 
mods.thaumcraft.Research.addPage("COREUSE", "tc.research_page.COREUSE.1");
mods.thaumcraft.Research.addPage("COREUSE", "tc.research_page.COREUSE.2");
mods.thaumcraft.Research.addInfusionPage("COREUSE", <Thaumcraft:ItemGolemCore:8>);
mods.thaumcraft.Research.addPage("COREUSE", "tc.research_page.COREUSE.3");

mods.thaumcraft.Research.clearPages("COREBUTCHER"); 
mods.thaumcraft.Research.addPage("COREBUTCHER", "tc.research_page.COREBUTCHER.1");
mods.thaumcraft.Research.addInfusionPage("COREBUTCHER", <Thaumcraft:ItemGolemCore:8>);

mods.thaumcraft.Research.clearPages("CORESORTING"); 
mods.thaumcraft.Research.addPage("CORESORTING", "tc.research_page.CORESORTING.1");
mods.thaumcraft.Research.addInfusionPage("CORESORTING", <Thaumcraft:ItemGolemCore:8>);

// Golem Animation Core Formatting
mods.gregtech.Polarizer.addRecipe(<Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:0>, 20, 120);
mods.gregtech.Polarizer.addRecipe(<Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:1>, 20, 120);
mods.gregtech.Polarizer.addRecipe(<Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:2>, 20, 120);
mods.gregtech.Polarizer.addRecipe(<Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:3>, 20, 120);
mods.gregtech.Polarizer.addRecipe(<Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:4>, 20, 120);
mods.gregtech.Polarizer.addRecipe(<Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:5>, 20, 120);
mods.gregtech.Polarizer.addRecipe(<Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:6>, 20, 120);
mods.gregtech.Polarizer.addRecipe(<Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:7>, 20, 120);
mods.gregtech.Polarizer.addRecipe(<Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:8>, 20, 120);
mods.gregtech.Polarizer.addRecipe(<Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:9>, 20, 120);
mods.gregtech.Polarizer.addRecipe(<Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:10>, 20, 120);
// mods.gregtech.Polarizer.addRecipe(<Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:11>, 20, 120);

// Golem Animation Core Copying
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemGolemCore:0>, <Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:0> * 0, <liquid:molten.solderingalloy> * 144, 28800, 480);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemGolemCore:0>, <Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:0> * 0, <liquid:molten.tin> * 288, 28800, 480);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemGolemCore:0>, <Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:0> * 0, <liquid:molten.lead> * 576, 28800, 480);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemGolemCore:1>, <Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:1> * 0, <liquid:molten.solderingalloy> * 144, 28800, 480);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemGolemCore:1>, <Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:1> * 0, <liquid:molten.tin> * 288, 28800, 480);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemGolemCore:1>, <Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:1> * 0, <liquid:molten.lead> * 576, 28800, 480);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemGolemCore:2>, <Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:2> * 0, <liquid:molten.solderingalloy> * 144, 28800, 480);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemGolemCore:2>, <Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:2> * 0, <liquid:molten.tin> * 288, 28800, 480);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemGolemCore:2>, <Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:2> * 0, <liquid:molten.lead> * 576, 28800, 480);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemGolemCore:3>, <Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:3> * 0, <liquid:molten.solderingalloy> * 144, 28800, 480);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemGolemCore:3>, <Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:3> * 0, <liquid:molten.tin> * 288, 28800, 480);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemGolemCore:3>, <Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:3> * 0, <liquid:molten.lead> * 576, 28800, 480);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemGolemCore:4>, <Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:4> * 0, <liquid:molten.solderingalloy> * 144, 28800, 480);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemGolemCore:4>, <Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:4> * 0, <liquid:molten.tin> * 288, 28800, 480);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemGolemCore:4>, <Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:4> * 0, <liquid:molten.lead> * 576, 28800, 480);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemGolemCore:5>, <Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:5> * 0, <liquid:molten.solderingalloy> * 144, 28800, 480);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemGolemCore:5>, <Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:5> * 0, <liquid:molten.tin> * 288, 28800, 480);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemGolemCore:5>, <Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:5> * 0, <liquid:molten.lead> * 576, 28800, 480);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemGolemCore:6>, <Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:6> * 0, <liquid:molten.solderingalloy> * 144, 28800, 480);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemGolemCore:6>, <Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:6> * 0, <liquid:molten.tin> * 288, 28800, 480);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemGolemCore:6>, <Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:6> * 0, <liquid:molten.lead> * 576, 28800, 480);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemGolemCore:7>, <Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:7> * 0, <liquid:molten.solderingalloy> * 144, 28800, 480);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemGolemCore:7>, <Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:7> * 0, <liquid:molten.tin> * 288, 28800, 480);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemGolemCore:7>, <Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:7> * 0, <liquid:molten.lead> * 576, 28800, 480);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemGolemCore:8>, <Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:8> * 0, <liquid:molten.solderingalloy> * 144, 28800, 480);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemGolemCore:8>, <Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:8> * 0, <liquid:molten.tin> * 288, 28800, 480);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemGolemCore:8>, <Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:8> * 0, <liquid:molten.lead> * 576, 28800, 480);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemGolemCore:9>, <Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:9> * 0, <liquid:molten.solderingalloy> * 144, 28800, 480);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemGolemCore:9>, <Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:9> * 0, <liquid:molten.tin> * 288, 28800, 480);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemGolemCore:9>, <Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:9> * 0, <liquid:molten.lead> * 576, 28800, 480);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemGolemCore:10>, <Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:10> * 0, <liquid:molten.solderingalloy> * 144, 28800, 480);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemGolemCore:10>, <Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:10> * 0, <liquid:molten.tin> * 288, 28800, 480);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemGolemCore:10>, <Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:10> * 0, <liquid:molten.lead> * 576, 28800, 480);
// mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemGolemCore:11>, <Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:11> * 0, <liquid:molten.solderingalloy> * 144, 40, 480);
// mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemGolemCore:11>, <Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:11> * 0, <liquid:molten.tin> * 288, 40, 480);
// mods.gregtech.Assembler.addRecipe(<Thaumcraft:ItemGolemCore:11>, <Thaumcraft:ItemGolemCore:100>, <Thaumcraft:ItemGolemCore:11> * 0, <liquid:molten.lead> * 576, 40, 480);


// Deconstructor
mods.thaumcraft.Arcane.addShaped("DECONSTRUCTOR", <Thaumcraft:blockTable:14>, "perditio 25, ordo 25", [[null, <Thaumcraft:ItemThaumometer>, null], 
                                                                                                    [<minecraft:golden_axe>, <Thaumcraft:blockTable>, <minecraft:golden_pickaxe>]]);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:blockTable:14>, <Thaumcraft:ItemThaumometer>, <Thaumcraft:blockTable:14> * 0, <liquid:molten.gold> * 1440, 9600, 2);

// Iron Wand Cap: Laser engraver
mods.gregtech.PrecisionLaser.addRecipe(<Thaumcraft:WandCap> * 2, <gregtech:gt.metaitem.01:24544> * 0, <minecraft:iron_block>, 4800, 120);
mods.gregtech.PrecisionLaser.addRecipe(<Thaumcraft:WandCap> * 2, <gregtech:gt.metaitem.01:24506> * 0, <minecraft:iron_block>, 40, 120);
mods.thaumcraft.Arcane.addShaped("BASICTHAUMATURGY", <Thaumcraft:WandCap> * 2, "ordo 10, perditio 10", [[<ore:plateIron>, <ore:plateIron>, <ore:plateIron>], 
                                                                                                         [<ore:plateIron>, null, <ore:plateIron>]]);

// Iron Capped Wooden Wand: Assembler with sealed wood stick
mods.gregtech.Assembler.addRecipe(<Thaumcraft:WandCasting>, <Thaumcraft:WandCap> * 2, <gregtech:gt.metaitem.01:23889> * 1, <liquid:glue> * 100, 360, 120);

// Copper Wand Cap
mods.gregtech.Assembler.addRecipe(<Thaumcraft:WandCap:3> * 2, <IC2:blockMetal>, <Thaumcraft:WandCap:3> * 0, <liquid:molten.thaumium> * 144, 4800, 120);
mods.thaumcraft.Arcane.addShaped("CAP_copper", <Thaumcraft:WandCap:3> * 2, "ordo 20, ignis 20, aer 20", [[<ore:plateCopper>, <ore:plateCopper>, <ore:plateCopper>], 
                                                                                                         [<ore:plateCopper>, null, <ore:plateCopper>]]);

// Gold Wand Cap
mods.gregtech.Assembler.addRecipe(<Thaumcraft:WandCap:1> * 2, <minecraft:gold_block>, <Thaumcraft:WandCap:1> * 0, <liquid:molten.thaumium> * 144, 4800, 120);
mods.thaumcraft.Arcane.addShaped("CAP_gold", <Thaumcraft:WandCap:1> * 2, "ordo 25, perditio 25, terra 20, aqua 20, ignis 20, aer 20", [[<ore:plateGold>, <ore:plateGold>, <ore:plateGold>], 
                                                                                                                                       [<ore:plateGold>, null, <ore:plateGold>]]);

// Silver Wand Cap
mods.gregtech.Assembler.addRecipe(<Thaumcraft:WandCap:5> * 2, <gregtech:gt.blockmetal6:10>, <Thaumcraft:WandCap:5> * 0, <liquid:molten.thaumium> * 144, 4800, 120);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:WandCap:5> * 2, <gregtech:gt.blockmetal6:10>, <Thaumcraft:WandCap:4> * 0, <liquid:molten.thaumium> * 144, 360, 120);
mods.thaumcraft.Arcane.addShaped("CAP_silver", <Thaumcraft:WandCap:5> * 2, "ordo 50, perditio 50, terra 50, aqua 50, ignis 50, aer 50", [[<ore:plateSilver>, <ore:plateSilver>, <ore:plateSilver>], 
                                                                                                                                         [<ore:plateSilver>, null, <ore:plateSilver>]]);
mods.thaumcraft.Infusion.addRecipe("CAP_silver", <Thaumcraft:WandCap:5>, [<Thaumcraft:ItemResource:14>, <Thaumcraft:ItemResource:14>], "auram 8, potentia 32", <Thaumcraft:WandCap:4>, 4);
mods.gregtech.Polarizer.addRecipe(<Thaumcraft:WandCap:4>, <Thaumcraft:WandCap:5>, 64000, 1);

// Thaumium Wand Cap
mods.gregtech.Assembler.addRecipe(<Thaumcraft:WandCap:6> * 2, <gregtech:gt.blockmetal7:4>, <Thaumcraft:WandCap:6> * 0, <liquid:molten.thaumium> * 144, 4800, 120);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:WandCap:6> * 2, <gregtech:gt.blockmetal7:4>, <Thaumcraft:WandCap:2> * 0, <liquid:molten.thaumium> * 144, 360, 120);
mods.thaumcraft.Arcane.addShaped("CAP_thaumium", <Thaumcraft:WandCap:6> * 2, "ordo 100, perditio 100, terra 105, aqua 105, ignis 105, aer 105", [[<ore:plateThaumium>, <ore:plateThaumium>, <ore:plateThaumium>], 
                                                                                                                                                 [<ore:plateThaumium>, null, <ore:plateThaumium>]]);
mods.thaumcraft.Infusion.addRecipe("CAP_thaumium", <Thaumcraft:WandCap:6>, [<Thaumcraft:ItemResource:14>, <Thaumcraft:ItemResource:14>, <Thaumcraft:ItemResource:14>, <Thaumcraft:ItemResource:14>], "auram 18, potentia 128", <Thaumcraft:WandCap:2>, 5);
mods.gregtech.Polarizer.addRecipe(<Thaumcraft:WandCap:2>, <Thaumcraft:WandCap:6>, 192000, 1);

// Voidmetal Wand Cap
mods.gregtech.Assembler.addRecipe(<Thaumcraft:WandCap:8> * 2, <Thaumcraft:ItemResource:16> * 8, <Thaumcraft:WandCap:8> * 0, <liquid:molten.thaumium> * 144, 4800, 3840);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:WandCap:8> * 2, <Thaumcraft:ItemResource:16> * 8, <Thaumcraft:WandCap:7> * 0, <liquid:molten.thaumium> * 144, 360, 3840);
mods.thaumcraft.Arcane.addShaped("CAP_void", <Thaumcraft:WandCap:8> * 2, "perditio 200, ordo 200, ignis 200, terra 200, aqua 200, aer 220", [[<ore:ingotVoid>, <ore:ingotVoid>, <ore:ingotVoid>], 
                                                                                                                                             [<ore:ingotVoid>, null, <ore:ingotVoid>]]);
mods.thaumcraft.Infusion.addRecipe("CAP_void", <Thaumcraft:WandCap:8>, [<Thaumcraft:ItemResource:14>, <Thaumcraft:ItemResource:14>, <Thaumcraft:ItemResource:14>, <Thaumcraft:ItemResource:14>, <Thaumcraft:ItemResource:14>, <Thaumcraft:ItemResource:14>, <Thaumcraft:ItemResource:14>, <Thaumcraft:ItemResource:14>], "alienis 144, auram 144, potentia 144, vacuos 144", <Thaumcraft:WandCap:7>, 9);
mods.gregtech.Polarizer.addRecipe(<Thaumcraft:WandCap:7>, <Thaumcraft:WandCap:8>, 768000, 1);

// Greatwood Rod
mods.thaumcraft.Arcane.addShaped("ROD_greatwood", <Thaumcraft:WandRod>, "perditio 25, terra 25", [[null, <Thaumcraft:blockMagicalLog>], 
                                                                                                  [<Thaumcraft:blockMagicalLog>, null]]);
mods.thaumcraft.Infusion.addRecipe("ROD_greatwood", <minecraft:stick>, [<Thaumcraft:ItemShard:6>, <Thaumcraft:blockMagicalLog>], "perditio 4, terra 4", <Thaumcraft:WandRod>, 1);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:WandRod>, <Thaumcraft:blockMagicalLog> * 2, <Thaumcraft:WandRod> * 0, 360, 120);

// Obsidian Rod
mods.thaumcraft.Infusion.addRecipe("ROD_obsidian", <minecraft:obsidian>, [<Thaumcraft:ItemShard:6>, <Thaumcraft:ItemShard:3>], "praecantatio 48, tenebrae 48, terra 96", <Thaumcraft:WandRod:1>, 2);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:WandRod:1>, <minecraft:obsidian>, <Thaumcraft:WandRod:1> * 0, 360, 120);

// Icy Rod
mods.thaumcraft.Infusion.addRecipe("ROD_ice", <minecraft:ice>, [<Thaumcraft:ItemShard:6>, <Thaumcraft:ItemShard:2>], "aqua 96, gelum 48, praecantatio 48", <Thaumcraft:WandRod:3>, 2);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:WandRod:3>, <minecraft:ice>, <Thaumcraft:WandRod:3> * 0, 360, 120);

// Quartz Rod
mods.thaumcraft.Infusion.addRecipe("ROD_quartz", <minecraft:quartz_block>, [<Thaumcraft:ItemShard:6>, <Thaumcraft:ItemShard:4>], "ordo 96, praecantatio 48, vitreus 48", <Thaumcraft:WandRod:4>, 2);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:WandRod:4>, <minecraft:quartz_block>, <Thaumcraft:WandRod:4> * 0, 360, 120);

// Reed Rod
mods.thaumcraft.Infusion.addRecipe("ROD_reed", <minecraft:reeds>, [<Thaumcraft:ItemShard:6>, <Thaumcraft:ItemShard>], "aer 96, motus 48, praecantatio 48", <Thaumcraft:WandRod:5>, 2);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:WandRod:5>, <minecraft:reeds>, <Thaumcraft:WandRod:5> * 0, 360, 120);

// Blazing Rod
mods.thaumcraft.Infusion.addRecipe("ROD_blaze", <minecraft:blaze_rod>, [<Thaumcraft:ItemShard:6>, <Thaumcraft:ItemShard:1>], "bestia 48, ignis 96, praecantatio 48", <Thaumcraft:WandRod:6>, 2);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:WandRod:6>, <minecraft:blaze_rod>, <Thaumcraft:WandRod:6> * 0, 360, 120);

// Bone Rod
mods.thaumcraft.Infusion.addRecipe("ROD_bone", <minecraft:bone>, [<Thaumcraft:ItemShard:6>, <Thaumcraft:ItemShard:5>], "exanimis 48, perditio 96, praecantatio 48", <Thaumcraft:WandRod:7>, 2);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:WandRod:7>, <minecraft:bone>, <Thaumcraft:WandRod:7> * 0, 360, 120);

// Silverwood Rod
mods.thaumcraft.Infusion.addRecipe("ROD_silverwood", <Thaumcraft:blockMagicalLog:1>, [<Thaumcraft:ItemShard:6>, <Thaumcraft:ItemShard>, <Thaumcraft:ItemShard:1>, <Thaumcraft:ItemShard:2>, <Thaumcraft:ItemShard:3>, <Thaumcraft:ItemShard:4>, <Thaumcraft:ItemShard:5>], "aer 64, aqua 64, ignis 64, ordo 64, perditio 64, praecantatio 64, terra 64", <Thaumcraft:WandRod:2>, 5);
mods.gregtech.Assembler.addRecipe(<Thaumcraft:WandRod:2>, <Thaumcraft:blockMagicalLog:1> * 2, <Thaumcraft:WandRod:2> * 0, 360, 120);

// Sceptre
mods.thaumcraft.Research.clearPrereqs("CAP_gold");
mods.thaumcraft.Research.clearPrereqs("CAP_silver");
mods.thaumcraft.Research.clearPrereqs("CAP_thaumium");
mods.thaumcraft.Research.clearPrereqs("ROD_silverwood");
mods.thaumcraft.Research.clearPrereqs("ROD_greatwood_staff");
mods.thaumcraft.Research.clearPrereqs("SCEPTRE");
mods.thaumcraft.Research.addPrereq("SCEPTRE", "CAP_thaumium", false);
mods.thaumcraft.Research.moveResearch("CAP_copper", "THAUMATURGY", 2, 1);
mods.thaumcraft.Research.addPrereq("CAP_gold", "CAP_copper", false);
mods.thaumcraft.Research.setConcealed("CAP_gold", true);
mods.thaumcraft.Research.moveResearch("CAP_gold", "THAUMATURGY", 4, 2);
mods.thaumcraft.Research.addPrereq("CAP_silver", "CAP_gold", false);
mods.thaumcraft.Research.addPrereq("CAP_silver", "INFUSION", true);
mods.thaumcraft.Research.addPrereq("CAP_silver", "ROD_greatwood", true);
mods.thaumcraft.Research.moveResearch("CAP_silver", "THAUMATURGY", 4, 4);
mods.thaumcraft.Research.addPrereq("CAP_thaumium", "CAP_silver", false);
mods.thaumcraft.Research.addPrereq("CAP_thaumium", "THAUMIUM", true);
mods.thaumcraft.Research.addPrereq("CAP_thaumium", "ROD_silverwood", true);
mods.thaumcraft.Research.addPrereq("ROD_silverwood", "ROD_greatwood", false);
mods.thaumcraft.Research.addPrereq("ROD_silverwood_staff", "ROD_silverwood", false);
mods.thaumcraft.Research.addPrereq("ROD_silverwood", "ROD_obsidian", true);
mods.thaumcraft.Research.addPrereq("ROD_silverwood", "ROD_ice", true);
mods.thaumcraft.Research.addPrereq("ROD_silverwood", "ROD_blaze", true);
mods.thaumcraft.Research.addPrereq("ROD_silverwood", "ROD_quartz", true);
mods.thaumcraft.Research.addPrereq("ROD_silverwood", "ROD_reed", true);
mods.thaumcraft.Research.addPrereq("ROD_silverwood", "ROD_bone", true);
mods.thaumcraft.Research.setConcealed("ROD_silverwood", true);
mods.thaumcraft.Research.moveResearch("ROD_silverwood", "THAUMATURGY", -3, 4);
mods.thaumcraft.Research.moveResearch("ROD_quartz_staff", "THAUMATURGY", -5, 6);
mods.thaumcraft.Research.moveResearch("ROD_silverwood_staff", "THAUMATURGY", -2, 5);
mods.thaumcraft.Research.addPrereq("ROD_greatwood_staff", "ROD_greatwood", false);
mods.thaumcraft.Research.moveResearch("ROD_greatwood_staff", "THAUMATURGY", -2, 2);
mods.thaumcraft.Research.setConcealed("ROD_greatwood_staff", true);
mods.thaumcraft.Research.setConcealed("CAP_thaumium", true);
mods.thaumcraft.Research.moveResearch("CAP_thaumium", "THAUMATURGY", 2, 5);
mods.thaumcraft.Research.addPrereq("SCEPTRE", "CAP_thaumium", false);
mods.thaumcraft.Research.addPrereq("SCEPTRE", "ROD_silverwood_staff", false);
mods.thaumcraft.Research.moveResearch("SCEPTRE", "THAUMATURGY", 0, 4);

// Move Runic Shielding
mods.thaumcraft.Research.clearPrereqs("RUNICARMOR");
mods.thaumcraft.Research.addPrereq("RUNICARMOR", "INFUSION", true);
mods.thaumcraft.Research.moveResearch("RUNICAUGMENTATION", "ARTIFICE", 9, 7);
mods.thaumcraft.Research.moveResearch("RUNICARMOR", "ARTIFICE", 9, 4);
mods.thaumcraft.Research.moveResearch("RUNICEMERGENCY", "ARTIFICE", 10, 5);
mods.thaumcraft.Research.moveResearch("RUNICCHARGED", "ARTIFICE", 8, 3);
mods.thaumcraft.Research.moveResearch("RUNICHEALING", "ARTIFICE", 10, 3);
mods.thaumcraft.Research.moveResearch("RUNICKINETIC", "ARTIFICE", 8, 5);

// Mundane Accessories
mods.thaumcraft.Research.addResearch("GT_APPRENTICE_ARTIFICING", "ARTIFICE", "praecantatio 3, instrumentum 3", 3, 4, 3, <Thaumcraft:ItemBaubleBlanks:1>);
game.setLocalization("en_US", "tc.research_name.GT_APPRENTICE_ARTIFICING", "Apprentice Artificing");
game.setLocalization("en_US", "tc.research_text.GT_APPRENTICE_ARTIFICING", "Controlling ancient artifacts");
mods.thaumcraft.Research.addPage("GT_APPRENTICE_ARTIFICING", "kirara.research_page.GT_APPRENTICE_ARTIFICING.1");
game.setLocalization("en_US", "kirara.research_page.GT_APPRENTICE_ARTIFICING.1", "Many ancient artifacts lurk within the unexplored corners of the world, some of which are imbued with particular thaumic energy that constantly leak into the surrounding environment.<BR>You have learned that channeling ordo vis to such artifacts when they're encased in enchanted fabric can force their energies to lay dormant, but an inert ring is of little use to you... for now.");
mods.thaumcraft.Research.addPrereq("GT_APPRENTICE_ARTIFICING", "ENCHFABRIC", false);
mods.thaumcraft.Arcane.addShapeless("GT_APPRENTICE_ARTIFICING", <Thaumcraft:ItemBaubleBlanks:1>, "ordo 4", [<Thaumcraft:ItemBaubleBlanks:3>, <Thaumcraft:ItemResource:7>]);
mods.thaumcraft.Arcane.addShapeless("GT_APPRENTICE_ARTIFICING", <Thaumcraft:ItemBaubleBlanks:1>, "ordo 4", [<Thaumcraft:ItemBaubleBlanks:4>, <Thaumcraft:ItemResource:7>]);
mods.thaumcraft.Arcane.addShapeless("GT_APPRENTICE_ARTIFICING", <Thaumcraft:ItemBaubleBlanks:1>, "ordo 4", [<Thaumcraft:ItemBaubleBlanks:5>, <Thaumcraft:ItemResource:7>]);
mods.thaumcraft.Arcane.addShapeless("GT_APPRENTICE_ARTIFICING", <Thaumcraft:ItemBaubleBlanks:1>, "ordo 4", [<Thaumcraft:ItemBaubleBlanks:6>, <Thaumcraft:ItemResource:7>]);
mods.thaumcraft.Arcane.addShapeless("GT_APPRENTICE_ARTIFICING", <Thaumcraft:ItemBaubleBlanks:1>, "ordo 4", [<Thaumcraft:ItemBaubleBlanks:7>, <Thaumcraft:ItemResource:7>]);
mods.thaumcraft.Arcane.addShapeless("GT_APPRENTICE_ARTIFICING", <Thaumcraft:ItemBaubleBlanks:1>, "ordo 4", [<Thaumcraft:ItemBaubleBlanks:8>, <Thaumcraft:ItemResource:7>]);
mods.thaumcraft.Research.addArcanePage("GT_APPRENTICE_ARTIFICING", <Thaumcraft:ItemBaubleBlanks:1>);
mods.thaumcraft.Research.setConcealed("GT_APPRENTICE_ARTIFICING", true);

mods.thaumcraft.Research.addPrereq("RUNICARMOR", "GT_APPRENTICE_ARTIFICING", false);

// Apprentice Ring of Aer
mods.thaumcraft.Research.addResearch("GT_APPRENTICE_AER", "ARTIFICE", "praecantatio 3, instrumentum 1, aer 1", 2, 3, 2, <Thaumcraft:ItemBaubleBlanks:3>);
game.setLocalization("en_US", "tc.research_name.GT_APPRENTICE_AER", "Apprentice Ring of Aer");
game.setLocalization("en_US", "tc.research_text.GT_APPRENTICE_AER", "Imbuing an inert ring with the essence of air");
mods.thaumcraft.Research.addPage("GT_APPRENTICE_AER", "kirara.research_page.GT_APPRENTICE_AER.1");
game.setLocalization("en_US", "kirara.research_page.GT_APPRENTICE_AER.1", "By infusing an inert ring with aer, you have created a trinket that reduces your aer vis consumption by a small amount.");
mods.thaumcraft.Research.addPrereq("GT_APPRENTICE_AER", "GT_APPRENTICE_ARTIFICING", false);
mods.thaumcraft.Research.addPrereq("GT_APPRENTICE_AER", "INFUSION", true);
mods.thaumcraft.Infusion.addRecipe("GT_APPRENTICE_AER", <Thaumcraft:ItemBaubleBlanks:1>, [<Thaumcraft:ItemShard:0>, <minecraft:feather>], "aer 8, praecantatio 4", <Thaumcraft:ItemBaubleBlanks:3>, 0);
mods.thaumcraft.Research.addInfusionPage("GT_APPRENTICE_AER", <Thaumcraft:ItemBaubleBlanks:3>);
mods.thaumcraft.Research.setSecondary("GT_APPRENTICE_AER", true);
mods.thaumcraft.Research.setConcealed("GT_APPRENTICE_AER", true);

// Apprentice Ring of Terra
mods.thaumcraft.Research.addResearch("GT_APPRENTICE_TERRA", "ARTIFICE", "praecantatio 3, instrumentum 1, terra 1", 3, 2, 2, <Thaumcraft:ItemBaubleBlanks:4>);
game.setLocalization("en_US", "tc.research_name.GT_APPRENTICE_TERRA", "Apprentice Ring of Terra");
game.setLocalization("en_US", "tc.research_text.GT_APPRENTICE_TERRA", "Imbuing an inert ring with the essence of earth");
mods.thaumcraft.Research.addPage("GT_APPRENTICE_TERRA", "kirara.research_page.GT_APPRENTICE_TERRA.1");
game.setLocalization("en_US", "kirara.research_page.GT_APPRENTICE_TERRA.1", "By infusing an inert ring with terra, you have created a trinket that reduces your terra vis consumption by a small amount.");
mods.thaumcraft.Research.addPrereq("GT_APPRENTICE_TERRA", "GT_APPRENTICE_ARTIFICING", false);
mods.thaumcraft.Research.addPrereq("GT_APPRENTICE_TERRA", "INFUSION", true);
mods.thaumcraft.Infusion.addRecipe("GT_APPRENTICE_TERRA", <Thaumcraft:ItemBaubleBlanks:1>, [<Thaumcraft:ItemShard:3>, <minecraft:dirt>], "terra 8, praecantatio 4", <Thaumcraft:ItemBaubleBlanks:4>, 0);
mods.thaumcraft.Research.addInfusionPage("GT_APPRENTICE_TERRA", <Thaumcraft:ItemBaubleBlanks:4>);
mods.thaumcraft.Research.setSecondary("GT_APPRENTICE_TERRA", true);
mods.thaumcraft.Research.setConcealed("GT_APPRENTICE_TERRA", true);

// Apprentice Ring of Ignis
mods.thaumcraft.Research.addResearch("GT_APPRENTICE_IGNIS", "ARTIFICE", "praecantatio 3, instrumentum 1, ignis 1", 4, 3, 2, <Thaumcraft:ItemBaubleBlanks:5>);
game.setLocalization("en_US", "tc.research_name.GT_APPRENTICE_IGNIS", "Apprentice Ring of Ignis");
game.setLocalization("en_US", "tc.research_text.GT_APPRENTICE_IGNIS", "Imbuing an inert ring with the essence of fire");
mods.thaumcraft.Research.addPage("GT_APPRENTICE_IGNIS", "kirara.research_page.GT_APPRENTICE_IGNIS.1");
game.setLocalization("en_US", "kirara.research_page.GT_APPRENTICE_IGNIS.1", "By infusing an inert ring with ignis, you have created a trinket that reduces your ignis vis consumption by a small amount.");
mods.thaumcraft.Research.addPrereq("GT_APPRENTICE_IGNIS", "GT_APPRENTICE_ARTIFICING", false);
mods.thaumcraft.Research.addPrereq("GT_APPRENTICE_IGNIS", "INFUSION", true);
mods.thaumcraft.Infusion.addRecipe("GT_APPRENTICE_IGNIS", <Thaumcraft:ItemBaubleBlanks:1>, [<Thaumcraft:ItemShard:1>, <minecraft:torch>], "ignis 8, praecantatio 4", <Thaumcraft:ItemBaubleBlanks:5>, 0);
mods.thaumcraft.Research.addInfusionPage("GT_APPRENTICE_IGNIS", <Thaumcraft:ItemBaubleBlanks:5>);
mods.thaumcraft.Research.setSecondary("GT_APPRENTICE_IGNIS", true);
mods.thaumcraft.Research.setConcealed("GT_APPRENTICE_IGNIS", true);

// Apprentice Ring of Aqua
mods.thaumcraft.Research.addResearch("GT_APPRENTICE_AQUA", "ARTIFICE", "praecantatio 3, instrumentum 1, aqua 1", 2, 5, 2, <Thaumcraft:ItemBaubleBlanks:6>);
game.setLocalization("en_US", "tc.research_name.GT_APPRENTICE_AQUA", "Apprentice Ring of Aqua");
game.setLocalization("en_US", "tc.research_text.GT_APPRENTICE_AQUA", "Imbuing an inert ring with the essence of water");
mods.thaumcraft.Research.addPage("GT_APPRENTICE_AQUA", "kirara.research_page.GT_APPRENTICE_AQUA.1");
game.setLocalization("en_US", "kirara.research_page.GT_APPRENTICE_AQUA.1", "By infusing an inert ring with aqua, you have created a trinket that reduces your aqua vis consumption by a small amount.");
mods.thaumcraft.Research.addPrereq("GT_APPRENTICE_AQUA", "GT_APPRENTICE_ARTIFICING", false);
mods.thaumcraft.Research.addPrereq("GT_APPRENTICE_AQUA", "INFUSION", true);
mods.thaumcraft.Infusion.addRecipe("GT_APPRENTICE_AQUA", <Thaumcraft:ItemBaubleBlanks:1>, [<Thaumcraft:ItemShard:2>, <minecraft:potion>], "aqua 8, praecantatio 4", <Thaumcraft:ItemBaubleBlanks:6>, 0);
mods.thaumcraft.Research.addInfusionPage("GT_APPRENTICE_AQUA", <Thaumcraft:ItemBaubleBlanks:6>);
mods.thaumcraft.Research.setSecondary("GT_APPRENTICE_AQUA", true);
mods.thaumcraft.Research.setConcealed("GT_APPRENTICE_AQUA", true);

// Apprentice Ring of Ordo
mods.thaumcraft.Research.addResearch("GT_APPRENTICE_ORDO", "ARTIFICE", "praecantatio 3, instrumentum 1, ordo 1", 3, 6, 2, <Thaumcraft:ItemBaubleBlanks:7>);
game.setLocalization("en_US", "tc.research_name.GT_APPRENTICE_ORDO", "Apprentice Ring of Ordo");
game.setLocalization("en_US", "tc.research_text.GT_APPRENTICE_ORDO", "Imbuing an inert ring with the essence of order");
mods.thaumcraft.Research.addPage("GT_APPRENTICE_ORDO", "kirara.research_page.GT_APPRENTICE_ORDO.1");
game.setLocalization("en_US", "kirara.research_page.GT_APPRENTICE_ORDO.1", "By infusing an inert ring with ordo, you have created a trinket that reduces your ordo vis consumption by a small amount.");
mods.thaumcraft.Research.addPrereq("GT_APPRENTICE_ORDO", "GT_APPRENTICE_ARTIFICING", false);
mods.thaumcraft.Research.addPrereq("GT_APPRENTICE_ORDO", "INFUSION", true);
mods.thaumcraft.Infusion.addRecipe("GT_APPRENTICE_ORDO", <Thaumcraft:ItemBaubleBlanks:1>, [<Thaumcraft:ItemShard:4>, <minecraft:sandstone:2>], "ordo 8, praecantatio 4", <Thaumcraft:ItemBaubleBlanks:7>, 0);
mods.thaumcraft.Research.addInfusionPage("GT_APPRENTICE_ORDO", <Thaumcraft:ItemBaubleBlanks:7>);
mods.thaumcraft.Research.setSecondary("GT_APPRENTICE_ORDO", true);
mods.thaumcraft.Research.setConcealed("GT_APPRENTICE_ORDO", true);

// Apprentice Ring of Perditio
mods.thaumcraft.Research.addResearch("GT_APPRENTICE_PERDITIO", "ARTIFICE", "praecantatio 3, instrumentum 1, perditio 1", 4, 5, 2, <Thaumcraft:ItemBaubleBlanks:8>);
game.setLocalization("en_US", "tc.research_name.GT_APPRENTICE_PERDITIO", "Apprentice Ring of Perditio");
game.setLocalization("en_US", "tc.research_text.GT_APPRENTICE_PERDITIO", "Imbuing an inert ring with the essence of entropy");
mods.thaumcraft.Research.addPage("GT_APPRENTICE_PERDITIO", "kirara.research_page.GT_APPRENTICE_PERDITIO.1");
game.setLocalization("en_US", "kirara.research_page.GT_APPRENTICE_PERDITIO.1", "By infusing an inert ring with perditio, you have created a trinket that reduces your perditio vis consumption by a small amount.");
mods.thaumcraft.Research.addPrereq("GT_APPRENTICE_PERDITIO", "GT_APPRENTICE_ARTIFICING", false);
mods.thaumcraft.Research.addPrereq("GT_APPRENTICE_PERDITIO", "INFUSION", true);
mods.thaumcraft.Infusion.addRecipe("GT_APPRENTICE_PERDITIO", <Thaumcraft:ItemBaubleBlanks:1>, [<Thaumcraft:ItemShard:5>, <minecraft:cobblestone>], "perditio 8, praecantatio 4", <Thaumcraft:ItemBaubleBlanks:8>, 0);
mods.thaumcraft.Research.addInfusionPage("GT_APPRENTICE_PERDITIO", <Thaumcraft:ItemBaubleBlanks:8>);
mods.thaumcraft.Research.setSecondary("GT_APPRENTICE_PERDITIO", true);
mods.thaumcraft.Research.setConcealed("GT_APPRENTICE_PERDITIO", true);

// Runic Shielding tweaks
mods.thaumcraft.Research.addPrereq("RUNICAUGMENTATION", "RUNICEMERGENCY", true);
mods.thaumcraft.Research.addPrereq("RUNICAUGMENTATION", "RUNICCHARGED", true);
mods.thaumcraft.Research.addPrereq("RUNICAUGMENTATION", "RUNICHEALING", true);
mods.thaumcraft.Research.addPrereq("RUNICAUGMENTATION", "RUNICKINETIC", true);

mods.thaumcraft.Research.addPrereq("RUNICCHARGED", "GT_APPRENTICE_IGNIS", true);
mods.thaumcraft.Research.addPrereq("RUNICHEALING", "GT_APPRENTICE_AQUA", true);
mods.thaumcraft.Research.addPrereq("RUNICKINETIC", "GT_APPRENTICE_AER", true);
mods.thaumcraft.Research.addPrereq("RUNICEMERGENCY", "GT_APPRENTICE_TERRA", true);

mods.thaumcraft.Infusion.removeRecipe(<Thaumcraft:ItemRingRunic:1>);
mods.thaumcraft.Infusion.addRecipe("RUNICARMOR", <Thaumcraft:ItemBaubleBlanks:1>, [<chisel:voidstoneRunic:8>, <Thaumcraft:ItemResource:15>, <Thaumcraft:ItemResource:6>, <chisel:voidstoneRunic:1>, <Thaumcraft:ItemResource:7>, <Thaumcraft:ItemResource:1>], "potentia 32, praecantatio 32, tutamen 16, auram 5", <Thaumcraft:ItemRingRunic:1>, 6);
mods.thaumcraft.Infusion.removeRecipe(<Thaumcraft:ItemAmuletRunic:0>);
mods.thaumcraft.Infusion.addRecipe("RUNICARMOR", <Thaumcraft:ItemBaubleBlanks:0>, [<chisel:voidstoneRunic:8>, <Thaumcraft:ItemResource:15>, <Thaumcraft:ItemResource:6>, <chisel:voidstoneRunic:2>, <Thaumcraft:ItemResource:7>, <Thaumcraft:ItemResource:1>], "potentia 48, praecantatio 48, tutamen 24, auram 8", <Thaumcraft:ItemAmuletRunic:0>, 6);
mods.thaumcraft.Infusion.removeRecipe(<Thaumcraft:ItemGirdleRunic:0>);
mods.thaumcraft.Infusion.addRecipe("RUNICARMOR", <Thaumcraft:ItemBaubleBlanks:2>, [<chisel:voidstoneRunic:8>, <Thaumcraft:ItemResource:15>, <Thaumcraft:ItemResource:6>, <chisel:voidstoneRunic:12>, <Thaumcraft:ItemResource:7>, <Thaumcraft:ItemResource:1>], "potentia 64, praecantatio 64, tutamen 32, auram 10", <Thaumcraft:ItemGirdleRunic:0>, 6);

mods.thaumcraft.Infusion.removeRecipe(<Thaumcraft:ItemRingRunic:2>);
mods.thaumcraft.Infusion.addRecipe("RUNICCHARGED", <Thaumcraft:ItemRingRunic:1>, [<Thaumcraft:ItemShard:6>, <Thaumcraft:ItemShard:1>, <Thaumcraft:ItemShard:1>, <Thaumcraft:ItemBaubleBlanks:5>, <Thaumcraft:ItemShard:1>, <Thaumcraft:ItemShard:1>], "potentia 64, praecantatio 32, tutamen 32, auram 4", <Thaumcraft:ItemRingRunic:2>, 8);
mods.thaumcraft.Infusion.removeRecipe(<Thaumcraft:ItemRingRunic:3>);
mods.thaumcraft.Infusion.addRecipe("RUNICHEALING", <Thaumcraft:ItemRingRunic:1>, [<Thaumcraft:ItemShard:6>, <Thaumcraft:ItemShard:2>, <Thaumcraft:ItemShard:2>, <Thaumcraft:ItemBaubleBlanks:6>, <Thaumcraft:ItemShard:2>, <Thaumcraft:ItemShard:2>], "aqua 64, praecantatio 32, sano 64, auram 4", <Thaumcraft:ItemRingRunic:3>, 8);
mods.thaumcraft.Infusion.removeRecipe(<Thaumcraft:ItemAmuletRunic:1>);
mods.thaumcraft.Infusion.addRecipe("RUNICEMERGENCY", <Thaumcraft:ItemAmuletRunic:0>, [<Thaumcraft:ItemShard:6>, <Thaumcraft:ItemShard:3>, <Thaumcraft:ItemShard:3>, <Thaumcraft:ItemBaubleBlanks:4>, <Thaumcraft:ItemShard:3>, <Thaumcraft:ItemShard:3>], "vacuos 64, praecantatio 32, tutamen 32, terra 32, auram 7", <Thaumcraft:ItemAmuletRunic:1>, 8);
mods.thaumcraft.Infusion.removeRecipe(<Thaumcraft:ItemGirdleRunic:1>);
mods.thaumcraft.Infusion.addRecipe("RUNICKINETIC", <Thaumcraft:ItemGirdleRunic:0>, [<Thaumcraft:ItemShard:6>, <Thaumcraft:ItemShard:0>, <Thaumcraft:ItemShard:0>, <Thaumcraft:ItemBaubleBlanks:3>, <Thaumcraft:ItemShard:0>, <Thaumcraft:ItemShard:0>], "aer 64, praecantatio 64, tutamen 32, auram 9", <Thaumcraft:ItemGirdleRunic:1>, 8);

// Lava
mods.thaumcraft.Research.addResearch("GT_FILL_LAVA_BUCKET", "ALCHEMY", "ignis 8, tenebrae 4, terra 6, permutatio 4", 6, 3, 4, <minecraft:lava_bucket>);
game.setLocalization("en_US", "tc.research_name.GT_FILL_LAVA_BUCKET", "Lava Transmutation");
game.setLocalization("en_US", "tc.research_text.GT_FILL_LAVA_BUCKET", "[GT] Filling buckets with lava");
mods.thaumcraft.Research.addPage("GT_FILL_LAVA_BUCKET", "kirara.research_page.GT_FILL_LAVA_BUCKET.1");
game.setLocalization("en_US", "kirara.research_page.GT_FILL_LAVA_BUCKET.1", "After refining the method through which you used a bucket as a vehicle to transform aqua essentia into water, you have discovered a way of filling a bucket with various energetic essentia in order to get lava.");
mods.thaumcraft.Research.addPrereq("GT_FILL_LAVA_BUCKET", "GT_FILL_WATER_BUCKET", false);
mods.thaumcraft.Research.addPrereq("GT_FILL_LAVA_BUCKET", "NITOR", true);
mods.thaumcraft.Crucible.addRecipe("GT_FILL_LAVA_BUCKET", <minecraft:lava_bucket>, <minecraft:bucket>, "ignis 8, potentia 8, lux 2, perditio 4, terra 4, metallum 1");
mods.thaumcraft.Research.addCruciblePage("GT_FILL_LAVA_BUCKET", <minecraft:lava_bucket>);
mods.thaumcraft.Research.setConcealed("GT_FILL_LAVA_BUCKET", true);

// Firestone
mods.thaumcraft.Research.addResearch("GT_FIRESTONE", "ALCHEMY", "ignis 8, perditio 4, potentia 6, permutatio 4", 8, 3, 6, <Railcraft:firestone.raw>);
game.setLocalization("en_US", "tc.research_name.GT_FIRESTONE", "Firestone");
game.setLocalization("en_US", "tc.research_text.GT_FIRESTONE", "[GT] Harnessing the power of concentrated flame");
mods.thaumcraft.Research.addPage("GT_FIRESTONE", "kirara.research_page.GT_FIRESTONE.1");
game.setLocalization("en_US", "kirara.research_page.GT_FIRESTONE.1", "As transmuting of even red-hot lava has not satisfied your quest for power, you have devised a method of concentrating vast amounts of raw primal ignis essentia into a vessel no larger than a single piece of quartz.<BR>The firestone is an extremely potent fuel source, and until its powers are culled, will indiscriminately set surrounding blocks on fire.");
mods.thaumcraft.Research.addPrereq("GT_FIRESTONE", "GT_FILL_LAVA_BUCKET", false);
mods.thaumcraft.Research.addPrereq("GT_FIRESTONE", "INFUSION", true);
mods.thaumcraft.Infusion.addRecipe("GT_FIRESTONE", <minecraft:quartz>, [<minecraft:lava_bucket>, <minecraft:lava_bucket>, <minecraft:lava_bucket>, <minecraft:lava_bucket>], "ignis 32, terra 32, potentia 32, praecantatio 32, fames 32, vacuos 32, lux 32, lucrum 32, permutatio 32, instrumentum 32", <Railcraft:firestone.raw>, 10);
mods.thaumcraft.Research.addInfusionPage("GT_FIRESTONE", <Railcraft:firestone.raw>);
mods.thaumcraft.Infusion.addRecipe("GT_FIRESTONE", <Railcraft:firestone.raw>, [<minecraft:diamond>, <gregtech:gt.blockgem2:6>, <minecraft:diamond>, <gregtech:gt.blockgem2:6>, <minecraft:diamond>, <gregtech:gt.blockgem2:6>, <minecraft:diamond>, <gregtech:gt.blockgem2:6>], "vitreus 64, praecantatio 64, gelum 64", <Railcraft:firestone.cut>, 5);
mods.thaumcraft.Research.addInfusionPage("GT_FIRESTONE", <Railcraft:firestone.cut>);
mods.thaumcraft.Infusion.addRecipe("GT_FIRESTONE", <Railcraft:firestone.cut>, [<chisel:redstone_block:12>, <chisel:redstone_block:12>, <chisel:redstone_block:12>, <chisel:redstone_block:12>], "vinculum 64", <Railcraft:firestone.refined:4998>, 7);
mods.thaumcraft.Research.addInfusionPage("GT_FIRESTONE", <Railcraft:firestone.refined:4998>);
mods.thaumcraft.Infusion.addRecipe("GT_FIRESTONE", <Railcraft:firestone.refined:*>, [<gregtech:gt.blockgem1:14>, <gregtech:gt.blockgem1:14>, <gregtech:gt.blockgem1:14>, <gregtech:gt.blockgem1:14>], "ignis 2048, potentia 2048", <Railcraft:firestone.refined:0>, 3);
mods.thaumcraft.Research.addInfusionPage("GT_FIRESTONE", <Railcraft:firestone.refined:0>);
mods.thaumcraft.Infusion.addRecipe("GT_FIRESTONE", <Railcraft:firestone.cracked:*>, [<gregtech:gt.blockgem1:14>, <gregtech:gt.blockgem1:14>, <gregtech:gt.blockgem1:14>, <gregtech:gt.blockgem1:14>], "ignis 32, praecantatio 64, vitreus 32", <Railcraft:firestone.refined:4999>, 3);
mods.thaumcraft.Research.addInfusionPage("GT_FIRESTONE", <Railcraft:firestone.refined:4999>);
mods.thaumcraft.Research.setConcealed("GT_FIRESTONE", true);
mods.thaumcraft.Warp.addToResearch("GT_FIRESTONE", 1);

// Basic Wand Craft Thaumonomicon Entry
mods.thaumcraft.Research.clearPages("BASICTHAUMATURGY"); 
mods.thaumcraft.Research.addPage("BASICTHAUMATURGY", "tc.research_page.BASICTHAUMATURGY.1");
mods.thaumcraft.Research.addPage("BASICTHAUMATURGY", "kirara.research_page.BASICTHAUMATURGY.1");
game.setLocalization("en_US", "kirara.research_page.BASICTHAUMATURGY.1", "Holding shift will display exact numbers held by the wand and any possible discounts you have to performing magical tasks.<BR>Wands are always constructed by the combination of a rod and two end-caps. As you progress with your studies, you are sure you will discover different materials that you can use to craft rods and caps to make powerful wands. All wands require the \u00A75Arcane Workbench\u00A70 and will cost vis to bind them together.<BR>As the basic wand is constructed from mundane wood and iron, both of which are not particularly attuned to magic, it is possible to construct your first wand in an \u00A75Assembling Machine\u00A70 with the iron caps, a sealed wood stick, and some glue.");

// Move GT Crystallization Research
mods.thaumcraft.Research.moveResearch("GT_CRYSTALLISATION", "ALCHEMY", -11, -2);

// Quarried Stone
mods.thaumcraft.Research.addResearch("RC_QUARRIED_STONE", "ALCHEMY", "ordo 2, permutatio 1, terra 2", -7, -3, 2, <Railcraft:cube:7>);
game.setLocalization("en_US", "tc.research_name.RC_QUARRIED_STONE", "Quarried Stone");
game.setLocalization("en_US", "tc.research_text.RC_QUARRIED_STONE", "[RC] Stone to marble in one simple step");
mods.thaumcraft.Research.addPage("RC_QUARRIED_STONE", "kirara.research_page.RC_QUARRIED_STONE.1");
game.setLocalization("en_US", "kirara.research_page.RC_QUARRIED_STONE.1", "You have found a way to imbue simple stone with lux essentia to transform its exterior appearance.<BR>The resulting product has a very unique refined look and feel to it; perhaps the addition of other essentia types may yield something completely different...");
mods.thaumcraft.Research.addPrereq("RC_QUARRIED_STONE", "ALCHEMICALMANUFACTURE", false);
mods.thaumcraft.Crucible.addRecipe("RC_QUARRIED_STONE", <Railcraft:cube:7>, <minecraft:stone>, "lux 2");
mods.thaumcraft.Research.addCruciblePage("RC_QUARRIED_STONE", <Railcraft:cube:7>);
mods.thaumcraft.Research.setConcealed("RC_QUARRIED_STONE", true);

// Abyssal Stone
mods.thaumcraft.Research.addResearch("RC_ABYSSAL_STONE", "ALCHEMY", "ordo 2, permutatio 1, terra 2", -9, -3, 2, <Railcraft:cube:6>);
game.setLocalization("en_US", "tc.research_name.RC_ABYSSAL_STONE", "Abyssal Stone");
game.setLocalization("en_US", "tc.research_text.RC_ABYSSAL_STONE", "[RC] Stone to darker marble(?) in one simple step");
mods.thaumcraft.Research.addPage("RC_ABYSSAL_STONE", "kirara.research_page.RC_ABYSSAL_STONE.1");
game.setLocalization("en_US", "kirara.research_page.RC_ABYSSAL_STONE.1", "By imbuing stone with tenebrae essentia, you have produced an equivalent material that is aesthetically similar to quarried stone, but far darker in appearance.<BR>You are sure that the faint screams you seem to hear from the tenebrous block are just your imagination.");
mods.thaumcraft.Research.addPrereq("RC_ABYSSAL_STONE", "RC_QUARRIED_STONE", false);
mods.thaumcraft.Crucible.addRecipe("RC_ABYSSAL_STONE", <Railcraft:cube:6>, <minecraft:stone>, "tenebrae 2");
mods.thaumcraft.Research.addCruciblePage("RC_ABYSSAL_STONE", <Railcraft:cube:6>);
mods.thaumcraft.Research.setConcealed("RC_ABYSSAL_STONE", true);
mods.thaumcraft.Warp.addToResearch("RC_ABYSSAL_STONE", 1);

// Peat
mods.thaumcraft.Research.addResearch("GT_MATURE_PEAT", "ALCHEMY", "ignis 3, aqua 1, permutatio 1, potentia 3", -7, -1, 3, <Forestry:peat>);
game.setLocalization("en_US", "tc.research_name.GT_MATURE_PEAT", "Alchemical Peat Formation");
game.setLocalization("en_US", "tc.research_text.GT_MATURE_PEAT", "[GT] Technomagical peat manufacture");
mods.thaumcraft.Research.addPage("GT_MATURE_PEAT", "kirara.research_page.GT_MATURE_PEAT.1");
game.setLocalization("en_US", "kirara.research_page.GT_MATURE_PEAT.1", "Waiting for peat to mature tried your patience like no other task. Now, you have found a way to instantly turn bog earth into precious, mature peat fuel inside a crucible.<BR>The careful addition of Ignis, Aqua, and Terra essentia completes the process instantaneously, though the rushed alchemical manufacture of peat in this fashion will not return usable blocks of dirt.");
mods.thaumcraft.Research.addPrereq("GT_MATURE_PEAT", "GT_FILL_WATER_BUCKET", true);
mods.thaumcraft.Research.addPrereq("GT_MATURE_PEAT", "ALCHEMICALMANUFACTURE", false);
mods.thaumcraft.Crucible.addRecipe("GT_MATURE_PEAT", <Forestry:peat>, <Forestry:soil:1>, "ignis 2, aqua 2, terra 1");
mods.thaumcraft.Research.addCruciblePage("GT_MATURE_PEAT", <Forestry:peat>);
mods.thaumcraft.Research.setConcealed("GT_MATURE_PEAT", true);

// Bituminous peat
mods.thaumcraft.Research.addResearch("GT_BITUMINOUS_PEAT", "ALCHEMY", "ignis 6, perditio 3, permutatio 3, terra 3, potentia 6", -9, -1, 6, <Forestry:bituminousPeat>);
game.setLocalization("en_US", "tc.research_name.GT_BITUMINOUS_PEAT", "Alchemical Peat Refining");
game.setLocalization("en_US", "tc.research_text.GT_BITUMINOUS_PEAT", "[GT] Alchemically treated peat");
mods.thaumcraft.Research.addPage("GT_BITUMINOUS_PEAT", "kirara.research_page.GT_BITUMINOUS_PEAT.1");
game.setLocalization("en_US", "kirara.research_page.GT_BITUMINOUS_PEAT.1", "Regular peat is not a great source of energy, but you have found that the addition of biomass in the form of Herba essentia can vastly improve its effectiveness.<BR>Additional energy input in the form of Ignis and Potentia essentia is of course required, but the gains from refining the peat block into a rich, bituminous form far outweighs the initial cost.");
mods.thaumcraft.Research.addPrereq("GT_BITUMINOUS_PEAT", "GT_MATURE_PEAT", false);
mods.thaumcraft.Crucible.addRecipe("GT_BITUMINOUS_PEAT", <Forestry:bituminousPeat>, <Forestry:peat>, "herba 8, ignis 2, potentia 1");
mods.thaumcraft.Research.addCruciblePage("GT_BITUMINOUS_PEAT", <Forestry:bituminousPeat>);
mods.thaumcraft.Research.setConcealed("GT_BITUMINOUS_PEAT", true);

// Coal coke
mods.thaumcraft.Research.moveResearch("ETHEREALBLOOM", "ALCHEMY", -2, -4); 
mods.thaumcraft.Research.addResearch("GT_COAL_COKE", "ALCHEMY", "ignis 5, permutatio 5, terra 2, potentia 5", -3, -2, 5, <Railcraft:fuel.coke>);
game.setLocalization("en_US", "tc.research_name.GT_COAL_COKE", "Refining Coal");
game.setLocalization("en_US", "tc.research_text.GT_COAL_COKE", "[GT] Alchemically refining coal");
mods.thaumcraft.Research.addPage("GT_COAL_COKE", "kirara.research_page.GT_COAL_COKE.1");
game.setLocalization("en_US", "kirara.research_page.GT_COAL_COKE.1", "Regular coal often contains many impurities that prevent proper combustion, and thus efficient usage of its potential energy. By infusing raw coal with a large quantity of ignis and perditio essentia, that impurity can be driven off and coaxed out of the coal mass.<BR>What you are left with is a grey, porous material that burns far better than raw coal, much akin to the coal coke produced via industrial processes in special ovens. Unfortunately, unlike those industrial processes, the thaumaturgical refining of coal will not produce any byproduct.");
mods.thaumcraft.Research.addPrereq("GT_COAL_COKE", "ALCHEMICALMANUFACTURE", false);
mods.thaumcraft.Crucible.addRecipe("GT_COAL_COKE", <Railcraft:fuel.coke>, <minecraft:coal>, "ignis 4, perditio 2, potentia 2");
mods.thaumcraft.Research.addCruciblePage("GT_COAL_COKE", <Railcraft:fuel.coke>);
mods.thaumcraft.Research.setConcealed("GT_COAL_COKE", true);

// Wrought Iron
mods.thaumcraft.Research.addResearch("GT_TRANSIRONWROUGHT", "ALCHEMY", "metallum 3, permutatio 3, ordo 1", 4, 5, 3, <gregtech:gt.metaitem.01:9304>);
game.setLocalization("en_US", "tc.research_name.GT_TRANSIRONWROUGHT", "Wrought Iron Transmutation");
game.setLocalization("en_US", "tc.research_text.GT_TRANSIRONWROUGHT", "[GT] Transforming iron to wrought iron");
mods.thaumcraft.Research.addPage("GT_TRANSIRONWROUGHT", "kirara.research_page.GT_TRANSIRONWROUGHT.1");
game.setLocalization("en_US", "kirara.research_page.GT_TRANSIRONWROUGHT.1", "You have discovered a way of making iron harder by thoroughly heating its components.<BR>This method can be used to create a material called wrought iron, which is used in many non-Thaumaturgic applications.");
mods.thaumcraft.Research.addPrereq("GT_TRANSIRONWROUGHT", "ALUMENTUM", false);
mods.thaumcraft.Research.addPrereq("GT_TRANSIRONWROUGHT", "TRANSGOLD", false);
mods.thaumcraft.Crucible.addRecipe("GT_TRANSIRONWROUGHT", <gregtech:gt.metaitem.01:9304>, <ore:nuggetIron>, "ignis 1");
mods.thaumcraft.Research.addCruciblePage("GT_TRANSIRONWROUGHT", <gregtech:gt.metaitem.01:9304>);
mods.thaumcraft.Research.setConcealed("GT_TRANSIRONWROUGHT", true);

// Thaumium
mods.thaumcraft.Research.addResearch("GT_TRANSTHAUMIUM", "ALCHEMY", "metallum 3, permutatio 3, praecantatio 1", 6, 5, 3, <Thaumcraft:ItemNugget:6>);
game.setLocalization("en_US", "tc.research_name.GT_TRANSTHAUMIUM", "Thaumium Transmutation");
game.setLocalization("en_US", "tc.research_text.GT_TRANSTHAUMIUM", "[GT] Transforming iron to thaumium");
mods.thaumcraft.Research.addPage("GT_TRANSTHAUMIUM", "kirara.research_page.GT_TRANSTHAUMIUM.1");
game.setLocalization("en_US", "kirara.research_page.GT_TRANSTHAUMIUM.1", "As it is quite expensive to expend valuable balanced shards to produce thaumium, you have devised an alternative method of manufacturing the magical metal.<BR>By exposing iron to praecantatio essentia in the same fashion that you used ignis to manufacture wrought iron, you have effectively created a method to manufacture thaumium without the use of valuable crystal shards.");
mods.thaumcraft.Research.addPrereq("GT_TRANSTHAUMIUM", "GT_TRANSIRONWROUGHT", false);
mods.thaumcraft.Crucible.addRecipe("GT_TRANSTHAUMIUM", <Thaumcraft:ItemNugget:6>, <ore:nuggetIron>, "praecantatio 1");
mods.thaumcraft.Research.addCruciblePage("GT_TRANSTHAUMIUM", <Thaumcraft:ItemNugget:6>);
mods.thaumcraft.Research.setConcealed("GT_TRANSTHAUMIUM", true);
mods.thaumcraft.Research.setSecondary("GT_TRANSTHAUMIUM", true);

// Steel
mods.thaumcraft.Research.moveResearch("GT_IRON_TO_STEEL", "ALCHEMY", 6, 7); 
mods.thaumcraft.Research.clearPages("GT_IRON_TO_STEEL"); 
mods.thaumcraft.Research.addPage("GT_IRON_TO_STEEL", "kirara.research_page.GT_IRON_TO_STEEL.1");
game.setLocalization("en_US", "kirara.research_page.GT_IRON_TO_STEEL.1", "You have discovered a way of making wrought iron even harder by breaking down and reordering its components.<BR>This method can be used to create a material called steel, which is used in many non-Thaumaturgic applications. Unfortunately, this process leaves the material in dust form, requiring further processing via non-Thaumaturgical means.");
mods.thaumcraft.Crucible.addRecipe("GT_IRON_TO_STEEL", <gregtech:gt.metaitem.01:9305>, <gregtech:gt.metaitem.01:9304>, "ordo 1");
mods.thaumcraft.Research.addCruciblePage("GT_IRON_TO_STEEL", <gregtech:gt.metaitem.01:9305>);
mods.thaumcraft.Crucible.removeRecipe(<gregtech:gt.metaitem.01:9305>);

mods.thaumcraft.Crucible.addRecipe("GT_IRON_TO_STEEL", <gregtech:gt.metaitem.01:305>, <gregtech:gt.metaitem.01:9304>, "ordo 1");
mods.thaumcraft.Research.clearPrereqs("GT_IRON_TO_STEEL"); 
mods.thaumcraft.Research.addPrereq("GT_IRON_TO_STEEL", "GT_TRANSIRONWROUGHT", false); 
mods.thaumcraft.Warp.addToResearch("GT_IRON_TO_STEEL", 3);

// Damascus Steel
mods.thaumcraft.Research.addResearch("GT_TRANSSTEELDAMASCUS", "ALCHEMY", "metallum 3, permutatio 3, vitreus 1, perditio 1", 13, 9, 6, <gregtech:gt.metaitem.01:9335>);
game.setLocalization("en_US", "tc.research_name.GT_TRANSSTEELDAMASCUS", "Damascus Steel Transformation");
game.setLocalization("en_US", "tc.research_text.GT_TRANSSTEELDAMASCUS", "[GT] Refining steel even further");
mods.thaumcraft.Research.addPage("GT_TRANSSTEELDAMASCUS", "kirara.research_page.GT_TRANSSTEELDAMASCUS.1");
game.setLocalization("en_US", "kirara.research_page.GT_TRANSSTEELDAMASCUS.1", "You have discovered a way of making steel even harder by breaking down and crystallizing its components on an atomic level.<BR>This method can be used to refine an amazingly durable variant of steel resembling that of the legendary Damascus Steel normally only found in ancient ruins. Unfortunately, this process leaves the material in dust form, requiring further processing via non-Thaumaturgical means.");
mods.thaumcraft.Research.addPrereq("GT_TRANSSTEELDAMASCUS", "GT_IRON_TO_STEEL", false);
mods.thaumcraft.Crucible.addRecipe("GT_TRANSSTEELDAMASCUS", <gregtech:gt.metaitem.01:9335>, <ore:nuggetSteel>, "vitreus 1, ordo 1, machina 1");
mods.thaumcraft.Research.addCruciblePage("GT_TRANSSTEELDAMASCUS", <gregtech:gt.metaitem.01:9335>);
mods.thaumcraft.Crucible.removeRecipe(<gregtech:gt.metaitem.01:9335>);

mods.thaumcraft.Crucible.addRecipe("GT_TRANSSTEELDAMASCUS", <gregtech:gt.metaitem.01:335>, <ore:nuggetSteel>, "vitreus 1, ordo 1, machina 1");
mods.thaumcraft.Research.setConcealed("GT_TRANSSTEELDAMASCUS", true);

// Advanced Metallurgy
mods.thaumcraft.Research.clearPrereqs("GT_ADVANCEDMETALLURGY");
mods.thaumcraft.Research.addPrereq("GT_ADVANCEDMETALLURGY", "GT_TRANSELECTRUM", false);
mods.thaumcraft.Research.addPrereq("GT_ADVANCEDMETALLURGY", "GT_TRANSBRASS", false);
mods.thaumcraft.Research.addPrereq("GT_ADVANCEDMETALLURGY", "GT_TRANSBATTERYALLOY", false);
mods.thaumcraft.Research.addPrereq("GT_ADVANCEDMETALLURGY", "GT_TRANSSOLDERINGALLOY", false);
mods.thaumcraft.Research.addPrereq("GT_ADVANCEDMETALLURGY", "GT_TRANSINVAR", false);
mods.thaumcraft.Research.addPrereq("GT_ADVANCEDMETALLURGY", "GT_TRANSCUPRONICKEL", false);
mods.thaumcraft.Research.addPrereq("GT_ADVANCEDMETALLURGY", "GT_TRANSBISMUTH", false);
mods.thaumcraft.Research.addPrereq("GT_ADVANCEDMETALLURGY", "GT_TRANSSTEELDAMASCUS", false);


// Platinum
mods.thaumcraft.Research.addResearch("GT_TRANSPLATINUM", "ALCHEMY", "metallum 5, nebrisum 3, permutatio 3, ordo 3, lucrum 3", 19, 15, 7, <gregtech:gt.metaitem.01:9085>);
game.setLocalization("en_US", "tc.research_name.GT_TRANSPLATINUM", "Platinum Transmutation");
game.setLocalization("en_US", "tc.research_text.GT_TRANSPLATINUM", "[GT] Transformation of metals to Platinum");

mods.thaumcraft.Research.clearPages("GT_TRANSPLATINUM"); 
mods.thaumcraft.Research.addPage("GT_TRANSPLATINUM", "kirara.research_page.GT_TRANSPLATINUM.1");
game.setLocalization("en_US", "kirara.research_page.GT_TRANSPLATINUM.1", "You have discovered a way to multiply Platinum by steeping Platinum nuggets in metallum harvested from other metals.<BR>This transmutation is quite costly, requiring a whole ingot of platinum's worth in nebrisum to create a mere nugget of the same metal. Perhaps if you could discover an alternative source for this essentia...");
mods.thaumcraft.Crucible.addRecipe("GT_TRANSPLATINUM", <gregtech:gt.metaitem.01:9085> * 2, <gregtech:gt.metaitem.01:9085>, "ignis 2, nebrisum 1, lucrum 2, metallum 1");
mods.thaumcraft.Research.addCruciblePage("GT_TRANSPLATINUM", <gregtech:gt.metaitem.01:9085>);
// mods.thaumcraft.Crucible.removeRecipe(<gregtech:gt.metaitem.01:9085>);

// mods.thaumcraft.Crucible.addRecipe("GT_TRANSPLATINUM", <gregtech:gt.metaitem.01:85> * 2, <gregtech:gt.metaitem.01:9085>, "ignis 2, nebrisum 1, lucrum 2, metallum 1");
mods.thaumcraft.Research.addPrereq("GT_TRANSPLATINUM", "GT_ADVANCEDMETALLURGY", false); 
mods.thaumcraft.Research.addPrereq("GT_TRANSPLATINUM", "GT_TRANSALUMINIUM", true); 
mods.thaumcraft.Research.setConcealed("GT_TRANSPLATINUM", true);
// mods.thaumcraft.Research.setSecondary("GT_TRANSPLATINUM", true);
mods.thaumcraft.Warp.addToResearch("GT_TRANSPLATINUM", 1);

// Iridium
mods.thaumcraft.Research.addResearch("GT_TRANSIRIDIUM", "ALCHEMY", "metallum 5, machina 3, permutatio 3, tutamen 3, electrum 3", 21, 15, 7, <gregtech:gt.metaitem.01:9084>);
game.setLocalization("en_US", "tc.research_name.GT_TRANSIRIDIUM", "Iridium Transmutation");
game.setLocalization("en_US", "tc.research_text.GT_TRANSIRIDIUM", "[GT] Transformation of metals to Iridium");

mods.thaumcraft.Research.clearPages("GT_TRANSIRIDIUM"); 
mods.thaumcraft.Research.addPage("GT_TRANSIRIDIUM", "kirara.research_page.GT_TRANSIRIDIUM.1");
game.setLocalization("en_US", "kirara.research_page.GT_TRANSIRIDIUM.1", "You have discovered a way to multiply Iridium by steeping Iridium nuggets in metallum harvested from other metals.<BR>This transmutation is quite costly, requiring a whole ingot of platinum's worth in nebrisum to create a mere nugget of iridium. Perhaps if you could discover an alternative source for this essentia...");
mods.thaumcraft.Crucible.addRecipe("GT_TRANSIRIDIUM", <gregtech:gt.metaitem.01:9084> * 2, <gregtech:gt.metaitem.01:9084>, "ignis 2, nebrisum 1, metallum 1, machina 1, electrum 1, potentia 1");
mods.thaumcraft.Research.addCruciblePage("GT_TRANSIRIDIUM", <gregtech:gt.metaitem.01:9084>);
mods.thaumcraft.Research.addPrereq("GT_TRANSIRIDIUM", "GT_TRANSPLATINUM", false); 
mods.thaumcraft.Research.setConcealed("GT_TRANSIRIDIUM", true);
// mods.thaumcraft.Research.setSecondary("GT_TRANSIRIDIUM", true);
mods.thaumcraft.Warp.addToResearch("GT_TRANSIRIDIUM", 4);

// Titanium
mods.thaumcraft.Research.addResearch("GT_TRANSTITANIUM", "ALCHEMY", "metallum 5, tutamen 3, permutatio 3, ordo 3, instrumentum 3", 19, 16, 7, <gregtech:gt.metaitem.01:9028>);
game.setLocalization("en_US", "tc.research_name.GT_TRANSTITANIUM", "Titanium Transmutation");
game.setLocalization("en_US", "tc.research_text.GT_TRANSTITANIUM", "[GT] Transformation of metals to Titanium");

mods.thaumcraft.Research.clearPages("GT_TRANSTITANIUM"); 
mods.thaumcraft.Research.addPage("GT_TRANSTITANIUM", "kirara.research_page.GT_TRANSTITANIUM.1");
game.setLocalization("en_US", "kirara.research_page.GT_TRANSTITANIUM.1", "You have discovered a way to multiply Titanium by steeping Titanium nuggets in metallum harvested from other metals.<BR>Unfortunately, this process leaves the material in an oxidized form, requiring further processing via non-Thaumaturgical means.");
mods.thaumcraft.Crucible.addRecipe("GT_TRANSTITANIUM", <gregtech:gt.metaitem.01:375> * 2, <gregtech:gt.metaitem.01:9028>, "ignis 1, metallum 1, tutamen 1, aer 1, machina 1");
mods.thaumcraft.Research.addCruciblePage("GT_TRANSTITANIUM", <gregtech:gt.metaitem.01:375>);
mods.thaumcraft.Research.addPrereq("GT_TRANSTITANIUM", "GT_ADVANCEDMETALLURGY", false); 
mods.thaumcraft.Research.addPrereq("GT_TRANSTITANIUM", "GT_TRANSPLATINUM", true); 
mods.thaumcraft.Research.setConcealed("GT_TRANSTITANIUM", true);
// mods.thaumcraft.Research.setSecondary("GT_TRANSTITANIUM", true);
mods.thaumcraft.Warp.addToResearch("GT_TRANSTITANIUM", 3);

// Tungsten
mods.thaumcraft.Research.addResearch("GT_TRANSTUNGSTEN", "ALCHEMY", "metallum 5, tutamen 3, permutatio 3, sano 3, lux 3", 19, 17, 7, <gregtech:gt.metaitem.01:9081>);
game.setLocalization("en_US", "tc.research_name.GT_TRANSTUNGSTEN", "Tungsten Transmutation");
game.setLocalization("en_US", "tc.research_text.GT_TRANSTUNGSTEN", "[GT] Transformation of metals to Tungsten");

mods.thaumcraft.Research.clearPages("GT_TRANSTUNGSTEN"); 
mods.thaumcraft.Research.addPage("GT_TRANSTUNGSTEN", "kirara.research_page.GT_TRANSTUNGSTEN.1");
game.setLocalization("en_US", "kirara.research_page.GT_TRANSTUNGSTEN.1", "You have discovered a way to multiply Tungsten by steeping Tungsten nuggets in metallum harvested from other metals.<BR>Unfortunately, this process leaves the material in an oxidized form, requiring further processing via non-Thaumaturgical means.");
mods.thaumcraft.Crucible.addRecipe("GT_TRANSTUNGSTEN", <gregtech:gt.metaitem.01:910> * 14, <gregtech:gt.metaitem.01:9081>, "ignis 1, metallum 1, tutamen 1, sano 1, lux 1");
mods.thaumcraft.Research.addCruciblePage("GT_TRANSTUNGSTEN", <gregtech:gt.metaitem.01:910>);
mods.thaumcraft.Research.addPrereq("GT_TRANSTUNGSTEN", "GT_ADVANCEDMETALLURGY", true); 
mods.thaumcraft.Research.addPrereq("GT_TRANSTUNGSTEN", "GT_TRANSTITANIUM", false); 
mods.thaumcraft.Research.setConcealed("GT_TRANSTUNGSTEN", true);
// mods.thaumcraft.Research.setSecondary("GT_TRANSTUNGSTEN", true);
// mods.thaumcraft.Warp.addToResearch("GT_TRANSTUNGSTEN", 1);

// Uranium
mods.thaumcraft.Research.addResearch("GT_TRANSURANIUM", "ALCHEMY", "metallum 5, radio 3, permutatio 3, venenum 3, potentia 3", 21, 16, 7, <gregtech:gt.metaitem.01:9097>);
game.setLocalization("en_US", "tc.research_name.GT_TRANSURANIUM", "Uranium Transmutation");
game.setLocalization("en_US", "tc.research_text.GT_TRANSURANIUM", "[GT] Transformation of metals to Uranium");

mods.thaumcraft.Research.clearPages("GT_TRANSURANIUM"); 
mods.thaumcraft.Research.addPage("GT_TRANSURANIUM", "kirara.research_page.GT_TRANSURANIUM.1");
game.setLocalization("en_US", "kirara.research_page.GT_TRANSURANIUM.1", "You have discovered a way to multiply Uranium by steeping Uranium nuggets in a vast number of different essentia.<BR>Unfortunately, this process leaves the material in an oxidized form, requiring further processing via non-Thaumaturgical means.");
mods.thaumcraft.Crucible.addRecipe("GT_TRANSURANIUM", <gregtech:gt.metaitem.01:922> * 2, <gregtech:gt.metaitem.01:9097>, "ignis 1, potentia 1, radio 1, metallum 1, mortuus 1, venenum 1");
mods.thaumcraft.Research.addCruciblePage("GT_TRANSURANIUM", <gregtech:gt.metaitem.01:922>);
mods.thaumcraft.Research.addPrereq("GT_TRANSURANIUM", "GT_TRANSPLATINUM", false); 
mods.thaumcraft.Research.addPrereq("GT_TRANSURANIUM", "GT_TRANSTITANIUM", false); 
mods.thaumcraft.Research.addPrereq("GT_TRANSURANIUM", "GT_TRANSTUNGSTEN", false); 
mods.thaumcraft.Research.setConcealed("GT_TRANSURANIUM", true);
// mods.thaumcraft.Research.setSecondary("GT_TRANSURANIUM", true);
mods.thaumcraft.Warp.addToResearch("GT_TRANSURANIUM", 5);

// Chromium
mods.thaumcraft.Research.addResearch("GT_TRANSCHROMIUM", "ALCHEMY", "metallum 5, machina 3, permutatio 3, nebrisum 3, lucrum 3", 19, 13, 7, <gregtech:gt.metaitem.01:9030>);
game.setLocalization("en_US", "tc.research_name.GT_TRANSCHROMIUM", "Chromium Transmutation");
game.setLocalization("en_US", "tc.research_text.GT_TRANSCHROMIUM", "[GT] Transformation of metals to Chromium");

mods.thaumcraft.Research.clearPages("GT_TRANSCHROMIUM"); 
mods.thaumcraft.Research.addPage("GT_TRANSCHROMIUM", "kirara.research_page.GT_TRANSCHROMIUM.1");
game.setLocalization("en_US", "kirara.research_page.GT_TRANSCHROMIUM.1", "You have discovered a way to multiply Chromium by steeping Chromium nuggets in metallum harvested from other metals.<BR>This transmutation is quite costly, requiring an incredibly large quantity of rare essentia to produce a tiny pile of oxidized chrome dust.<BR>While not a worthwhile recipe by itself, you wonder if this discovery could lead to other, far more valuable transmutations.");
mods.thaumcraft.Crucible.addRecipe("GT_TRANSCHROMIUM", <gregtech:gt.metaitem.01:9030> * 2, <gregtech:gt.metaitem.01:9030>, "ignis 2, machina 1, nebrisum 1, lucrum 1, metallum 1");
mods.thaumcraft.Research.addCruciblePage("GT_TRANSCHROMIUM", <gregtech:gt.metaitem.01:9030>);
mods.thaumcraft.Crucible.removeRecipe(<gregtech:gt.metaitem.01:9030>);

mods.thaumcraft.Crucible.addRecipe("GT_TRANSCHROMIUM", <gregtech:gt.metaitem.01:361> * 2, <gregtech:gt.metaitem.01:9030>, "ignis 2, machina 1, nebrisum 1, lucrum 1, metallum 1");
mods.thaumcraft.Research.addPrereq("GT_TRANSCHROMIUM", "GT_TRANSALUMINIUM", true); 
mods.thaumcraft.Research.addPrereq("GT_TRANSCHROMIUM", "GT_ADVANCEDMETALLURGY", false); 
mods.thaumcraft.Research.setConcealed("GT_TRANSCHROMIUM", true);
// mods.thaumcraft.Research.setSecondary("GT_TRANSCHROMIUM", true);
// mods.thaumcraft.Warp.addToResearch("GT_TRANSCHROMIUM", 1);

// Manganese
mods.thaumcraft.Research.addResearch("GT_TRANSMANGANESE", "ALCHEMY", "metallum 5, tenebrae 3, permutatio 3, nebrisum 3, volatus 3", 19, 12, 7, <gregtech:gt.metaitem.01:9031>);
game.setLocalization("en_US", "tc.research_name.GT_TRANSMANGANESE", "Manganese Transmutation");
game.setLocalization("en_US", "tc.research_text.GT_TRANSMANGANESE", "[GT] Transformation of metals to Manganese");

mods.thaumcraft.Research.clearPages("GT_TRANSMANGANESE"); 
mods.thaumcraft.Research.addPage("GT_TRANSMANGANESE", "kirara.research_page.GT_TRANSMANGANESE.1");
game.setLocalization("en_US", "kirara.research_page.GT_TRANSMANGANESE.1", "You have discovered a way to multiply Manganese by steeping Manganese nuggets in metallum harvested from other metals.<BR>This transmutation is quite costly, requiring rare, valuable essentia to produce a single nugget of manganese.<BR>While not a worthwhile recipe by itself, you wonder if this discovery could lead to other, far more valuable transmutations.");
mods.thaumcraft.Crucible.addRecipe("GT_TRANSMANGANESE", <gregtech:gt.metaitem.01:9031> * 2, <gregtech:gt.metaitem.01:9031>, "ignis 2, tenebrae 2, vitreus 1, volatus 2, metallum 1");
mods.thaumcraft.Research.addCruciblePage("GT_TRANSMANGANESE", <gregtech:gt.metaitem.01:9031>);
// mods.thaumcraft.Crucible.removeRecipe(<gregtech:gt.metaitem.01:9031>);

// mods.thaumcraft.Crucible.addRecipe("GT_TRANSMANGANESE", <gregtech:gt.metaitem.01:31> * 2, <gregtech:gt.metaitem.01:9031>, "ignis 2, tenebrae 2, vitreus 1, volatus 2, metallum 1");
mods.thaumcraft.Research.addPrereq("GT_TRANSMANGANESE", "GT_TRANSCHROMIUM", true); 
mods.thaumcraft.Research.addPrereq("GT_TRANSMANGANESE", "GT_ADVANCEDMETALLURGY", false); 
mods.thaumcraft.Research.setConcealed("GT_TRANSMANGANESE", true);
// mods.thaumcraft.Research.setSecondary("GT_TRANSMANGANESE", true);
// mods.thaumcraft.Warp.addToResearch("GT_TRANSMANGANESE", 1);

// Stainless Steel
mods.thaumcraft.Research.addResearch("GT_TRANSSTAINLESS", "ALCHEMY", "metallum 5, permutatio 3, machina 3, ordo 3, ignis 3", 21, 12, 7, <gregtech:gt.metaitem.01:9306>);
game.setLocalization("en_US", "tc.research_name.GT_TRANSSTAINLESS", "Stainless Steel Transmutation");
game.setLocalization("en_US", "tc.research_text.GT_TRANSSTAINLESS", "[GT] Transformation of metals to stainless steel");

mods.thaumcraft.Research.clearPages("GT_TRANSSTAINLESS"); 
mods.thaumcraft.Research.addPage("GT_TRANSSTAINLESS", "kirara.research_page.GT_TRANSSTAINLESS.1");
game.setLocalization("en_US", "kirara.research_page.GT_TRANSSTAINLESS.1", "After much experimentation with refining Nickel, Invar, Chrome, and Manganese, you have discovered a way to multiply the complex stainless steel alloy by steeping its nuggets in metallum harvested from other metals.<BR>This transmutation is significantly harder to achieve, as stainless steel is a complex alloy with a large number of components. Additionally, this process leaves the material in dust form, requiring further processing via non-Thaumaturgical means.");
mods.thaumcraft.Crucible.addRecipe("GT_TRANSSTAINLESS", <gregtech:gt.metaitem.01:9306> * 2, <gregtech:gt.metaitem.01:9306>, "ignis 4, metallum 1, ordo 2, lucrum 1, machina 1, gelum 1");
mods.thaumcraft.Research.addCruciblePage("GT_TRANSSTAINLESS", <gregtech:gt.metaitem.01:9306>);
mods.thaumcraft.Crucible.removeRecipe(<gregtech:gt.metaitem.01:9306>);

mods.thaumcraft.Crucible.addRecipe("GT_TRANSSTAINLESS", <gregtech:gt.metaitem.01:306> * 2, <gregtech:gt.metaitem.01:9306>, "ignis 4, metallum 1, ordo 2, lucrum 1, machina 1, gelum 1");
mods.thaumcraft.Research.addPrereq("GT_TRANSCHROMIUM", "GT_ADVANCEDMETALLURGY", false); 
mods.thaumcraft.Research.addPrereq("GT_TRANSSTAINLESS", "GT_TRANSCHROMIUM", false); 
mods.thaumcraft.Research.addPrereq("GT_TRANSSTAINLESS", "GT_TRANSMANGANESE", false); 
mods.thaumcraft.Research.setConcealed("GT_TRANSSTAINLESS", true);
// mods.thaumcraft.Research.setSecondary("GT_TRANSSTAINLESS", true);
mods.thaumcraft.Warp.addToResearch("GT_TRANSSTAINLESS", 5);

// Voidmetal
mods.thaumcraft.Crucible.addRecipe("VOIDMETAL", <Thaumcraft:ItemNugget:7>, <Thaumcraft:ItemResource:17>, "metallum 1");
mods.thaumcraft.Infusion.addRecipe("VOIDMETAL", <minecraft:diamond_pickaxe>, [<Thaumcraft:ItemResource:14>, <Thaumcraft:ItemResource:16>, <Thaumcraft:ItemResource:14>, <Thaumcraft:ItemResource:2>], "perfodio 16, alienis 16, praecantatio 16, tenebrae 16, vacuos 16, ordo 16, perditio 16", <Thaumcraft:ItemPickVoid>, 7);
mods.thaumcraft.Infusion.addRecipe("VOIDMETAL", <minecraft:diamond_shovel>, [<Thaumcraft:ItemResource:14>, <Thaumcraft:ItemResource:16>, <Thaumcraft:ItemResource:14>, <Thaumcraft:ItemResource:2>], "instrumentum 16, alienis 16, praecantatio 16, tenebrae 16, vacuos 16, ordo 16, perditio 16", <Thaumcraft:ItemShovelVoid>, 7);
mods.thaumcraft.Infusion.addRecipe("VOIDMETAL", <minecraft:diamond_hoe>, [<Thaumcraft:ItemResource:14>, <Thaumcraft:ItemResource:16>, <Thaumcraft:ItemResource:14>, <Thaumcraft:ItemResource:2>], "meto 16, alienis 16, praecantatio 16, tenebrae 16, vacuos 16, ordo 16, perditio 16", <Thaumcraft:ItemHoeVoid>, 7);
mods.thaumcraft.Infusion.addRecipe("VOIDMETAL", <minecraft:diamond_axe>, [<Thaumcraft:ItemResource:14>, <Thaumcraft:ItemResource:16>, <Thaumcraft:ItemResource:14>, <Thaumcraft:ItemResource:2>], "arbor 16, alienis 16, praecantatio 16, tenebrae 16, vacuos 16, ordo 16, perditio 16", <Thaumcraft:ItemAxeVoid>, 7);
mods.thaumcraft.Infusion.addRecipe("VOIDMETAL", <minecraft:diamond_sword>, [<Thaumcraft:ItemResource:14>, <Thaumcraft:ItemResource:16>, <Thaumcraft:ItemResource:14>, <Thaumcraft:ItemResource:2>], "telum 16, alienis 16, praecantatio 16, tenebrae 16, vacuos 16, ordo 16, perditio 16", <Thaumcraft:ItemSwordVoid>, 7);
mods.thaumcraft.Infusion.addRecipe("VOIDMETAL", <minecraft:diamond_chestplate>, [<Thaumcraft:ItemResource:14>, <Thaumcraft:ItemResource:16>, <Thaumcraft:ItemResource:14>, <Thaumcraft:ItemResource:2>], "tutamen 16, alienis 16, praecantatio 16, tenebrae 16, vacuos 16, ordo 16, perditio 16", <Thaumcraft:ItemChestplateVoid>, 7);
mods.thaumcraft.Infusion.addRecipe("VOIDMETAL", <minecraft:diamond_leggings>, [<Thaumcraft:ItemResource:14>, <Thaumcraft:ItemResource:16>, <Thaumcraft:ItemResource:14>, <Thaumcraft:ItemResource:2>], "tutamen 16, alienis 16, praecantatio 16, tenebrae 16, vacuos 16, ordo 16, perditio 16", <Thaumcraft:ItemLeggingsVoid>, 7);
mods.thaumcraft.Infusion.addRecipe("VOIDMETAL", <minecraft:diamond_helmet>, [<Thaumcraft:ItemResource:14>, <Thaumcraft:ItemResource:16>, <Thaumcraft:ItemResource:14>, <Thaumcraft:ItemResource:2>], "tutamen 16, alienis 16, praecantatio 16, tenebrae 16, vacuos 16, ordo 16, perditio 16", <Thaumcraft:ItemHelmetVoid>, 7);
mods.thaumcraft.Infusion.addRecipe("VOIDMETAL", <minecraft:diamond_boots>, [<Thaumcraft:ItemResource:14>, <Thaumcraft:ItemResource:16>, <Thaumcraft:ItemResource:14>, <Thaumcraft:ItemResource:2>], "tutamen 16, alienis 16, praecantatio 16, tenebrae 16, vacuos 16, ordo 16, perditio 16", <Thaumcraft:ItemBootsVoid>, 7);


mods.thaumcraft.Research.clearPages("VOIDMETAL"); 
mods.thaumcraft.Research.addPage("VOIDMETAL", "tc.research_page.VOIDMETAL.1");
mods.thaumcraft.Research.addCruciblePage("VOIDMETAL", <Thaumcraft:ItemNugget:7>);
mods.thaumcraft.Research.addPage("VOIDMETAL", "tc.research_page.VOIDMETAL.2");
mods.thaumcraft.Research.addCraftingPage("VOIDMETAL", <Thaumcraft:ItemResource:16>);
mods.thaumcraft.Research.addInfusionPage("VOIDMETAL", <Thaumcraft:ItemShovelVoid>);
mods.thaumcraft.Research.addInfusionPage("VOIDMETAL", <Thaumcraft:ItemPickVoid>);
mods.thaumcraft.Research.addInfusionPage("VOIDMETAL", <Thaumcraft:ItemAxeVoid>);
mods.thaumcraft.Research.addInfusionPage("VOIDMETAL", <Thaumcraft:ItemSwordVoid>);
mods.thaumcraft.Research.addInfusionPage("VOIDMETAL", <Thaumcraft:ItemHoeVoid>);
mods.thaumcraft.Research.addInfusionPage("VOIDMETAL", <Thaumcraft:ItemHelmetVoid>);
mods.thaumcraft.Research.addInfusionPage("VOIDMETAL", <Thaumcraft:ItemChestplateVoid>);
mods.thaumcraft.Research.addInfusionPage("VOIDMETAL", <Thaumcraft:ItemLeggingsVoid>);
mods.thaumcraft.Research.addInfusionPage("VOIDMETAL", <Thaumcraft:ItemBootsVoid>);

// Transmutations
mods.thaumcraft.Crucible.addRecipe("GT_TRANSALUMINIUM", <gregtech:gt.metaitem.01:19> * 3, <gregtech:gt.metaitem.01:9019>, "ignis 1, ordo 1, volatus 1, metallum 2");

// Refresh Recipes
mods.thaumcraft.Research.refreshResearchRecipe("PLANTS");
mods.thaumcraft.Research.refreshResearchRecipe("GOGGLES");
mods.thaumcraft.Research.refreshResearchRecipe("HUNGRYCHEST");
mods.thaumcraft.Research.refreshResearchRecipe("FOCUSPOUCH");
mods.thaumcraft.Research.refreshResearchRecipe("ENCHFABRIC");
mods.thaumcraft.Research.refreshResearchRecipe("BOOTSTRAVELLER");
mods.thaumcraft.Research.refreshResearchRecipe("DECONSTRUCTOR");
mods.thaumcraft.Research.refreshResearchRecipe("ARCANELAMP");
mods.thaumcraft.Research.refreshResearchRecipe("ELEMENTALPICK");
mods.thaumcraft.Research.refreshResearchRecipe("ELEMENTALAXE");
mods.thaumcraft.Research.refreshResearchRecipe("ELEMENTALSWORD");
mods.thaumcraft.Research.refreshResearchRecipe("ELEMENTALSHOVEL");
mods.thaumcraft.Research.refreshResearchRecipe("ELEMENTALHOE");
mods.thaumcraft.Research.refreshResearchRecipe("RUNICARMOR");
mods.thaumcraft.Research.refreshResearchRecipe("RUNICEMERGENCY");
mods.thaumcraft.Research.refreshResearchRecipe("RUNICCHARGED");
mods.thaumcraft.Research.refreshResearchRecipe("RUNICHEALING");
mods.thaumcraft.Research.refreshResearchRecipe("RUNICKINETIC");
mods.thaumcraft.Research.refreshResearchRecipe("MIRROR");
mods.thaumcraft.Research.refreshResearchRecipe("MIRRORHAND");
mods.thaumcraft.Research.refreshResearchRecipe("MIRRORESSENTIA");
mods.thaumcraft.Research.refreshResearchRecipe("HOVERHARNESS");
mods.thaumcraft.Research.refreshResearchRecipe("HOVERGIRDLE");
mods.thaumcraft.Research.refreshResearchRecipe("COREGATHER");
mods.thaumcraft.Research.refreshResearchRecipe("CAP_gold");
mods.thaumcraft.Research.refreshResearchRecipe("CAP_copper");
mods.thaumcraft.Research.refreshResearchRecipe("CAP_silver");
mods.thaumcraft.Research.refreshResearchRecipe("CAP_thaumium");	
mods.thaumcraft.Research.refreshResearchRecipe("CAP_void");
mods.thaumcraft.Research.refreshResearchRecipe("ROD_greatwood");
mods.thaumcraft.Research.refreshResearchRecipe("ROD_silverwood");
mods.thaumcraft.Research.refreshResearchRecipe("ROD_obsidian");
mods.thaumcraft.Research.refreshResearchRecipe("ROD_ice");
mods.thaumcraft.Research.refreshResearchRecipe("ROD_quartz");
mods.thaumcraft.Research.refreshResearchRecipe("ROD_reed");
mods.thaumcraft.Research.refreshResearchRecipe("ROD_blaze");
mods.thaumcraft.Research.refreshResearchRecipe("ROD_bone");

