/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.tools.packulike;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.newdawn.slick.tools.packulike.Pack;
import org.newdawn.slick.tools.packulike.Sheet;
import org.newdawn.slick.tools.packulike.SheetPanel;
import org.newdawn.slick.tools.packulike.Sprite;

public class Packer
extends JFrame {
    private SheetPanel sheetPanel;
    private DefaultListModel sprites = new DefaultListModel();
    private JList list = new JList(this.sprites);
    private int twidth;
    private int theight;
    private DefaultComboBoxModel sizes = new DefaultComboBoxModel();
    private DefaultComboBoxModel sizes2 = new DefaultComboBoxModel();
    private JComboBox widths = new JComboBox(this.sizes);
    private JComboBox heights = new JComboBox(this.sizes2);
    private JSpinner border = new JSpinner(new SpinnerNumberModel(0, 0, 50, 1));
    private JFileChooser chooser = new JFileChooser(".");
    private JFileChooser saveChooser = new JFileChooser(".");
    private Pack pack = new Pack();

    public Packer() {
        super("Pack-U-Like");
        this.saveChooser.setFileFilter(new FileFilter(){

            public boolean accept(File f2) {
                if (f2.isDirectory()) {
                    return true;
                }
                return f2.getName().endsWith(".png");
            }

            public String getDescription() {
                return "PNG Images (*.png)";
            }
        });
        this.chooser.setMultiSelectionEnabled(true);
        this.chooser.setFileFilter(new FileFilter(){

            public boolean accept(File f2) {
                if (f2.isDirectory()) {
                    return true;
                }
                return f2.getName().endsWith(".png") || f2.getName().endsWith(".jpg") || f2.getName().endsWith(".gif");
            }

            public String getDescription() {
                return "Images (*.jpg, *.png, *.gif)";
            }
        });
        this.sizes.addElement(new Integer(64));
        this.sizes.addElement(new Integer(128));
        this.sizes.addElement(new Integer(256));
        this.sizes.addElement(new Integer(512));
        this.sizes.addElement(new Integer(1024));
        this.sizes.addElement(new Integer(2048));
        this.sizes2.addElement(new Integer(64));
        this.sizes2.addElement(new Integer(128));
        this.sizes2.addElement(new Integer(256));
        this.sizes2.addElement(new Integer(512));
        this.sizes2.addElement(new Integer(1024));
        this.sizes2.addElement(new Integer(2048));
        JMenuBar bar = new JMenuBar();
        JMenu file = new JMenu("File");
        bar.add(file);
        JMenuItem save = new JMenuItem("Save");
        file.add(save);
        file.addSeparator();
        JMenuItem quit = new JMenuItem("Quit");
        file.add(quit);
        save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                Packer.this.save();
            }
        });
        quit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                System.exit(0);
            }
        });
        this.setJMenuBar(bar);
        JPanel panel = new JPanel();
        panel.setLayout(null);
        this.sheetPanel = new SheetPanel(this);
        JScrollPane pane = new JScrollPane(this.sheetPanel);
        pane.setBounds(5, 5, 530, 530);
        JScrollPane listScroll = new JScrollPane(this.list);
        listScroll.setBounds(540, 5, 200, 350);
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e2) {
                Object[] values = Packer.this.list.getSelectedValues();
                ArrayList<Object> sprites = new ArrayList<Object>();
                for (int i2 = 0; i2 < values.length; ++i2) {
                    sprites.add(values[i2]);
                }
                Packer.this.list.removeListSelectionListener(this);
                Packer.this.select(sprites);
                Packer.this.list.addListSelectionListener(this);
            }
        });
        this.list.setSelectionMode(2);
        this.list.setCellRenderer(new FileListRenderer());
        panel.add(pane);
        panel.add(listScroll);
        JButton add = new JButton("Add");
        add.setFont(add.getFont().deriveFont(1));
        add.setMargin(new Insets(0, 0, 0, 0));
        add.setBounds(745, 5, 40, 30);
        panel.add(add);
        add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                int resp = Packer.this.chooser.showOpenDialog(Packer.this);
                if (resp == 0) {
                    File[] selected = Packer.this.chooser.getSelectedFiles();
                    for (int i2 = 0; i2 < selected.length; ++i2) {
                        try {
                            Packer.this.sprites.addElement(new Sprite(selected[i2]));
                            continue;
                        }
                        catch (IOException x) {
                            x.printStackTrace();
                            JOptionPane.showMessageDialog(Packer.this, "Unable to load: " + selected[i2].getName());
                        }
                    }
                }
                Packer.this.regenerate();
            }
        });
        JButton remove = new JButton("Del");
        remove.setFont(add.getFont().deriveFont(1));
        remove.setMargin(new Insets(0, 0, 0, 0));
        remove.setBounds(745, 35, 40, 30);
        panel.add(remove);
        remove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                Object[] selected = Packer.this.list.getSelectedValues();
                for (int i2 = 0; i2 < selected.length; ++i2) {
                    Packer.this.sprites.removeElement(selected[i2]);
                }
                Packer.this.regenerate();
            }
        });
        JLabel label = new JLabel("Border");
        label.setBounds(540, 375, 200, 25);
        panel.add(label);
        this.border.setBounds(540, 400, 200, 25);
        panel.add(this.border);
        this.border.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e2) {
                Packer.this.regenerate();
            }
        });
        label = new JLabel("Width");
        label.setBounds(540, 425, 200, 25);
        panel.add(label);
        this.widths.setBounds(540, 450, 200, 25);
        panel.add(this.widths);
        this.widths.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                Packer.this.twidth = (Integer)Packer.this.widths.getSelectedItem();
                Packer.this.sheetPanel.setTextureSize(Packer.this.twidth, Packer.this.theight);
                Packer.this.regenerate();
            }
        });
        label = new JLabel("Height");
        label.setBounds(540, 475, 200, 25);
        panel.add(label);
        this.heights.setBounds(540, 500, 200, 25);
        this.heights.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                Packer.this.theight = (Integer)Packer.this.heights.getSelectedItem();
                Packer.this.sheetPanel.setTextureSize(Packer.this.twidth, Packer.this.theight);
                Packer.this.regenerate();
            }
        });
        panel.add(this.heights);
        this.twidth = 512;
        this.theight = 512;
        this.sheetPanel.setTextureSize(this.twidth, this.theight);
        this.widths.setSelectedItem(new Integer(this.twidth));
        this.heights.setSelectedItem(new Integer(this.theight));
        this.setDefaultCloseOperation(2);
        this.setContentPane(panel);
        this.setSize(800, 600);
        this.setResizable(false);
        this.setVisible(true);
    }

    public Sprite getSpriteAt(int x, int y) {
        for (int i2 = 0; i2 < this.sprites.size(); ++i2) {
            if (!((Sprite)this.sprites.get(i2)).contains(x, y)) continue;
            return (Sprite)this.sprites.get(i2);
        }
        return null;
    }

    public void select(ArrayList selection) {
        this.list.clearSelection();
        int[] selected = new int[selection.size()];
        for (int i2 = 0; i2 < selection.size(); ++i2) {
            selected[i2] = this.sprites.indexOf(selection.get(i2));
        }
        this.list.setSelectedIndices(selected);
        this.sheetPanel.setSelection(selection);
    }

    private void save() {
        int resp = this.saveChooser.showSaveDialog(this);
        if (resp == 0) {
            File out = this.saveChooser.getSelectedFile();
            ArrayList list = new ArrayList();
            for (int i2 = 0; i2 < this.sprites.size(); ++i2) {
                list.add(this.sprites.elementAt(i2));
            }
            try {
                int b2 = (Integer)this.border.getValue();
                this.pack.packImages(list, this.twidth, this.theight, b2, out);
            }
            catch (IOException e2) {
                e2.printStackTrace();
                JOptionPane.showMessageDialog(this, "Failed to write output");
            }
        }
    }

    private void regenerate() {
        try {
            ArrayList list = new ArrayList();
            for (int i2 = 0; i2 < this.sprites.size(); ++i2) {
                list.add(this.sprites.elementAt(i2));
            }
            int b2 = (Integer)this.border.getValue();
            Sheet sheet = this.pack.packImages(list, this.twidth, this.theight, b2, null);
            this.sheetPanel.setImage(sheet);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public static void main(String[] argv) {
        new Packer();
    }

    private class FileListRenderer
    extends DefaultListCellRenderer {
        private FileListRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Sprite sprite = (Sprite)value;
            label.setText(sprite.getName());
            return label;
        }
    }
}

