/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.tools.peditor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.lwjgl.LWJGLException;
import org.newdawn.slick.CanvasGameContainer;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.particles.ConfigurableEmitter;
import org.newdawn.slick.particles.ParticleIO;
import org.newdawn.slick.particles.ParticleSystem;
import org.newdawn.slick.tools.peditor.ColorPanel;
import org.newdawn.slick.tools.peditor.EmissionControls;
import org.newdawn.slick.tools.peditor.EmitterList;
import org.newdawn.slick.tools.peditor.GraphEditorWindow;
import org.newdawn.slick.tools.peditor.LimitPanel;
import org.newdawn.slick.tools.peditor.ParticleGame;
import org.newdawn.slick.tools.peditor.PositionControls;
import org.newdawn.slick.tools.peditor.SettingsPanel;
import org.newdawn.slick.tools.peditor.WhiskasPanel;
import org.newdawn.slick.util.InputAdapter;
import org.newdawn.slick.util.Log;

public class ParticleEditor
extends JFrame {
    private ParticleGame game;
    private JMenuItem newSystem = new JMenuItem("New System");
    private JMenuItem load = new JMenuItem("Load System");
    private JMenuItem save = new JMenuItem("Save System");
    private JMenuItem imp = new JMenuItem("Import Emitter");
    private JMenuItem clone = new JMenuItem("Clone Emitter");
    private JMenuItem exp = new JMenuItem("Export Emitter");
    private JMenuItem hud = new JMenuItem("Toggle Overlay");
    private JMenuItem loadBackground = new JMenuItem("Load Background Image");
    private JMenuItem clearBackground = new JMenuItem("Clear Background Image");
    private JMenuItem whiskas = new JMenuItem("Show/Hide Graph Editor");
    private JMenuItem quit = new JMenuItem("Exit");
    private EmitterList emitters;
    private EmissionControls emissionControls;
    private PositionControls positionControls;
    private SettingsPanel settingsPanel;
    private ColorPanel colorPanel;
    private LimitPanel limitPanel;
    private WhiskasPanel whiskasPanel;
    private JCheckBox additive = new JCheckBox("Additive Blending");
    private JCheckBox pointsEnabled = new JCheckBox("Use Points");
    private ConfigurableEmitter selected;
    private JFileChooser chooser = new JFileChooser(new File("."));
    private JButton reset = new JButton("Reset Max");
    private JButton pause = new JButton("Play/Pause");
    private JSlider systemMove = new JSlider(-100, 100, 0);
    private JFrame graphEditorFrame;
    private FileFilter xmlFileFilter = new FileFilter(){

        public boolean accept(File f2) {
            if (f2.isDirectory()) {
                return true;
            }
            return f2.getName().endsWith(".xml");
        }

        public String getDescription() {
            return "XML Files";
        }
    };

    public ParticleEditor() throws LWJGLException, SlickException {
        super("Pedigree - Whiskas flavoured");
        this.chooser.setFileFilter(this.xmlFileFilter);
        this.emitters = new EmitterList(this);
        this.emissionControls = new EmissionControls();
        this.positionControls = new PositionControls();
        this.settingsPanel = new SettingsPanel(this.emitters);
        this.colorPanel = new ColorPanel();
        this.limitPanel = new LimitPanel(this.emitters);
        this.whiskasPanel = new WhiskasPanel(this.emitters, this.colorPanel, this.emissionControls);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        JMenu file = new JMenu("File");
        file.add(this.newSystem);
        file.addSeparator();
        file.add(this.load);
        file.add(this.save);
        file.addSeparator();
        file.add(this.imp);
        file.add(this.clone);
        file.add(this.exp);
        file.addSeparator();
        file.add(this.hud);
        file.add(this.whiskas);
        file.addSeparator();
        file.add(this.loadBackground);
        file.add(this.clearBackground);
        file.addSeparator();
        file.add(this.quit);
        this.loadBackground.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                ParticleEditor.this.loadBackground();
            }
        });
        this.clearBackground.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                ParticleEditor.this.clearBackground();
            }
        });
        this.newSystem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                ParticleEditor.this.createNewSystem();
            }
        });
        this.hud.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                ParticleEditor.this.game.setHud(!ParticleEditor.this.game.isHudOn());
            }
        });
        this.load.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                ParticleEditor.this.loadSystem();
            }
        });
        this.save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                ParticleEditor.this.saveSystem();
            }
        });
        this.clone.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                ParticleEditor.this.cloneEmitter();
            }
        });
        this.exp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                ParticleEditor.this.exportEmitter();
            }
        });
        this.imp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                ParticleEditor.this.importEmitter();
            }
        });
        this.quit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                System.exit(0);
            }
        });
        this.whiskas.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                ParticleEditor.this.graphEditorFrame.setVisible(!ParticleEditor.this.graphEditorFrame.isVisible());
            }
        });
        JMenuBar bar = new JMenuBar();
        bar.add(file);
        this.setJMenuBar(bar);
        this.game = new ParticleGame(this);
        final CanvasGameContainer container = new CanvasGameContainer(this.game);
        container.getContainer().setAlwaysRender(true);
        container.setSize(500, 600);
        JPanel controls = new JPanel();
        controls.setLayout(null);
        this.emitters.setBounds(0, 0, 300, 150);
        this.emitters.setBorder(BorderFactory.createTitledBorder("Emitters"));
        controls.add(this.emitters);
        JTabbedPane tabs = new JTabbedPane();
        tabs.setBounds(0, 150, 300, 350);
        controls.add(tabs);
        tabs.add("Settings", this.settingsPanel);
        tabs.add("Emission", this.emissionControls);
        tabs.add("Position", this.positionControls);
        tabs.add("Rendering", this.colorPanel);
        tabs.add("Limit", this.limitPanel);
        tabs.add("Whiskas", this.whiskasPanel);
        JPanel panel = new JPanel();
        panel.setLayout(null);
        container.setBounds(0, 0, 500, 600);
        controls.setBounds(500, 20, 300, 575);
        this.reset.setBounds(90, 500, 90, 25);
        controls.add(this.reset);
        this.systemMove.setBounds(180, 500, 120, 25);
        controls.add(this.systemMove);
        this.pause.setBounds(0, 500, 90, 25);
        controls.add(this.pause);
        this.additive.setBounds(500, 0, 150, 25);
        panel.add(this.additive);
        this.pointsEnabled.setBounds(650, 0, 150, 25);
        panel.add(this.pointsEnabled);
        panel.add(container);
        panel.add(controls);
        this.systemMove.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e2) {
                ParticleEditor.this.game.setSystemMove(ParticleEditor.this.systemMove.getValue(), false);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e2) {
                System.exit(0);
            }
        });
        this.additive.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                ParticleEditor.this.updateBlendMode();
            }
        });
        this.pointsEnabled.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                ParticleEditor.this.game.getSystem().setUsePoints(ParticleEditor.this.pointsEnabled.isSelected());
            }
        });
        this.reset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                ParticleEditor.this.game.resetCounts();
            }
        });
        this.pause.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                ParticleEditor.this.game.setPaused(!ParticleEditor.this.game.isPaused());
            }
        });
        ConfigurableEmitter test = new ConfigurableEmitter("Default");
        this.emitters.add(test);
        this.game.addEmitter(test);
        this.additive.setSelected(true);
        this.setContentPane(panel);
        this.setSize(800, 600);
        this.setResizable(false);
        this.setVisible(true);
        InputAdapter listener = new InputAdapter(){

            public void mousePressed(int x, int y, int button) {
                if (button != 0) {
                    ParticleEditor.this.positionControls.setPosition(0, 0);
                }
                ParticleEditor.this.systemMove.setValue(0);
                ParticleEditor.this.game.setSystemMove(0, true);
            }

            public void mouseMoved(int x, int y, int nx, int ny) {
                if (container.getContainer().getInput().isMouseButtonDown(0)) {
                    int xp = nx - 250;
                    int yp = ny - 300;
                    ParticleEditor.this.positionControls.setPosition(xp, yp);
                    ParticleEditor.this.systemMove.setValue(0);
                    ParticleEditor.this.game.setSystemMove(0, true);
                }
            }
        };
        this.game.setListener(listener);
        this.initGraphEditorWindow();
        this.emitters.setSelected(0);
        try {
            container.start();
        }
        catch (SlickException e1) {
            Log.error(e1);
        }
    }

    private void loadBackground() {
        JFileChooser chooser = new JFileChooser(".");
        chooser.setDialogTitle("Open");
        int resp = chooser.showOpenDialog(this);
        if (resp == 0) {
            this.game.setBackgroundImage(chooser.getSelectedFile());
        }
    }

    private void clearBackground() {
        this.game.setBackgroundImage(null);
    }

    private void initGraphEditorWindow() {
        GraphEditorWindow editor = new GraphEditorWindow();
        this.whiskasPanel.setEditor(editor);
        this.graphEditorFrame = new JFrame("Whiskas Gradient Editor");
        this.graphEditorFrame.getContentPane().add(editor);
        this.graphEditorFrame.setDefaultCloseOperation(1);
        this.graphEditorFrame.pack();
        this.graphEditorFrame.setSize(600, 300);
        this.graphEditorFrame.setLocation(this.getX(), this.getY() + this.getHeight());
        this.graphEditorFrame.setVisible(true);
    }

    public void setSystemMove(int move) {
        this.systemMove.setValue(move);
    }

    public void importEmitter() {
        this.chooser.setDialogTitle("Open");
        int resp = this.chooser.showOpenDialog(this);
        if (resp == 0) {
            File file = this.chooser.getSelectedFile();
            File path = file.getParentFile();
            try {
                final ConfigurableEmitter emitter = ParticleIO.loadEmitter(file);
                if (emitter.getImageName() != null) {
                    File possible = new File(path, emitter.getImageName());
                    if (possible.exists()) {
                        emitter.setImageName(possible.getAbsolutePath());
                    } else {
                        this.chooser.setDialogTitle("Locate the image: " + emitter.getImageName());
                        resp = this.chooser.showOpenDialog(this);
                        FileFilter filter = new FileFilter(){

                            public boolean accept(File f2) {
                                if (f2.isDirectory()) {
                                    return true;
                                }
                                return f2.getName().equals(emitter.getImageName());
                            }

                            public String getDescription() {
                                return emitter.getImageName();
                            }
                        };
                        this.chooser.addChoosableFileFilter(filter);
                        if (resp == 0) {
                            File image = this.chooser.getSelectedFile();
                            emitter.setImageName(image.getAbsolutePath());
                            path = image.getParentFile();
                        }
                        this.chooser.resetChoosableFileFilters();
                        this.chooser.addChoosableFileFilter(this.xmlFileFilter);
                    }
                }
                this.addEmitter(emitter);
                this.emitters.setSelected(emitter);
            }
            catch (IOException e2) {
                Log.error(e2);
                JOptionPane.showMessageDialog(this, e2.getMessage());
            }
        }
    }

    public void cloneEmitter() {
        if (this.selected == null) {
            return;
        }
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ParticleIO.saveEmitter(bout, this.selected);
            ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
            ConfigurableEmitter emitter = ParticleIO.loadEmitter(bin);
            emitter.name = emitter.name + "_clone";
            this.addEmitter(emitter);
            this.emitters.setSelected(emitter);
        }
        catch (IOException e2) {
            Log.error(e2);
            JOptionPane.showMessageDialog(this, e2.getMessage());
        }
    }

    public void exportEmitter() {
        if (this.selected == null) {
            return;
        }
        this.chooser.setDialogTitle("Save");
        int resp = this.chooser.showSaveDialog(this);
        if (resp == 0) {
            File file = this.chooser.getSelectedFile();
            if (!file.getName().endsWith(".xml")) {
                file = new File(file.getAbsolutePath() + ".xml");
            }
            try {
                ParticleIO.saveEmitter(file, this.selected);
            }
            catch (IOException e2) {
                Log.error(e2);
                JOptionPane.showMessageDialog(this, e2.getMessage());
            }
        }
    }

    public void createNewSystem() {
        this.game.clearSystem(this.additive.isSelected());
        this.pointsEnabled.setSelected(false);
        this.emitters.clear();
    }

    public void loadSystem() {
        this.chooser.setDialogTitle("Open");
        int resp = this.chooser.showOpenDialog(this);
        if (resp == 0) {
            File file = this.chooser.getSelectedFile();
            File path = file.getParentFile();
            try {
                ParticleSystem system = ParticleIO.loadConfiguredSystem(file);
                this.game.setSystem(system);
                this.emitters.clear();
                for (int i2 = 0; i2 < system.getEmitterCount(); ++i2) {
                    final ConfigurableEmitter emitter = (ConfigurableEmitter)system.getEmitter(i2);
                    if (emitter.getImageName() != null) {
                        File possible = new File(path, emitter.getImageName());
                        if (possible.exists()) {
                            emitter.setImageName(possible.getAbsolutePath());
                        } else {
                            this.chooser.setDialogTitle("Locate the image: " + emitter.getImageName());
                            FileFilter filter = new FileFilter(){

                                public boolean accept(File f2) {
                                    if (f2.isDirectory()) {
                                        return true;
                                    }
                                    return f2.getName().equals(emitter.getImageName());
                                }

                                public String getDescription() {
                                    return emitter.getImageName();
                                }
                            };
                            this.chooser.addChoosableFileFilter(filter);
                            resp = this.chooser.showOpenDialog(this);
                            if (resp == 0) {
                                File image = this.chooser.getSelectedFile();
                                emitter.setImageName(image.getAbsolutePath());
                                path = image.getParentFile();
                            }
                            this.chooser.setDialogTitle("Open");
                            this.chooser.resetChoosableFileFilters();
                            this.chooser.addChoosableFileFilter(this.xmlFileFilter);
                        }
                    }
                    this.emitters.add(emitter);
                }
                this.additive.setSelected(system.getBlendingMode() == 1);
                this.pointsEnabled.setSelected(system.usePoints());
                this.emitters.setSelected(0);
            }
            catch (IOException e2) {
                Log.error(e2);
                JOptionPane.showMessageDialog(this, e2.getMessage());
            }
        }
    }

    public void saveSystem() {
        int resp = this.chooser.showSaveDialog(this);
        if (resp == 0) {
            File file = this.chooser.getSelectedFile();
            if (!file.getName().endsWith(".xml")) {
                file = new File(file.getAbsolutePath() + ".xml");
            }
            try {
                ParticleIO.saveConfiguredSystem(file, this.game.getSystem());
            }
            catch (IOException e2) {
                Log.error(e2);
                JOptionPane.showMessageDialog(this, e2.getMessage());
            }
        }
    }

    public void addEmitter(ConfigurableEmitter emitter) {
        this.emitters.add(emitter);
        this.game.addEmitter(emitter);
    }

    public void removeEmitter(ConfigurableEmitter emitter) {
        this.emitters.remove(emitter);
        this.game.removeEmitter(emitter);
    }

    public void setCurrentEmitter(ConfigurableEmitter emitter) {
        this.selected = emitter;
        if (emitter == null) {
            this.emissionControls.setEnabled(false);
            this.settingsPanel.setEnabled(false);
            this.positionControls.setEnabled(false);
            this.colorPanel.setEnabled(false);
            this.limitPanel.setEnabled(false);
            this.whiskasPanel.setEnabled(false);
        } else {
            this.emissionControls.setEnabled(true);
            this.settingsPanel.setEnabled(true);
            this.positionControls.setEnabled(true);
            this.colorPanel.setEnabled(true);
            this.limitPanel.setEnabled(true);
            this.whiskasPanel.setEnabled(true);
            this.emissionControls.setTarget(emitter);
            this.settingsPanel.setTarget(emitter);
            this.positionControls.setTarget(emitter);
            this.settingsPanel.setTarget(emitter);
            this.colorPanel.setTarget(emitter);
            this.limitPanel.setTarget(emitter);
            this.whiskasPanel.setTarget(emitter);
        }
    }

    public void updateBlendMode() {
        if (this.additive.isSelected()) {
            this.game.getSystem().setBlendingMode(1);
        } else {
            this.game.getSystem().setBlendingMode(2);
        }
    }

    public static void main(String[] argv) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            new ParticleEditor();
        }
        catch (Exception e2) {
            Log.error(e2);
        }
    }
}

