/*
 * Decompiled with CFR 0.152.
 */
package test;

import classes.Score;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.newdawn.slick.Animation;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.Input;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.Sound;
import org.newdawn.slick.UnicodeFont;
import org.newdawn.slick.font.effects.ColorEffect;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;
import org.newdawn.slick.state.transition.FadeInTransition;
import org.newdawn.slick.state.transition.FadeOutTransition;
import org.newdawn.slick.state.transition.Transition;
import test.Test;

public class Highscores
extends BasicGameState {
    private List<Score> highscores = null;
    private Image bg0 = null;
    private Image bg1 = null;
    private Image bg2 = null;
    private Image bg3 = null;
    private Image bg4 = null;
    private Image bg5 = null;
    private Image[] background = new Image[0];
    private Image mainOption = null;
    private Image resetOption = null;
    private Animation bgfinal = null;
    private Sound button = null;
    private UnicodeFont font = null;
    private Transition inTransition = new FadeInTransition(new Color(0, 0, 0), 1000);
    private Transition outTransition = new FadeOutTransition(new Color(0, 0, 0), 1000);
    private int stateID = 4;
    private boolean insideMainMenu = false;
    private boolean insideReset = false;
    private boolean updatehs = false;
    private String fontpath = "data/fgh.ttf";
    private int xpos = 415;
    private int xpos2 = 445;
    private int[] ypos = new int[]{195, 225, 255, 285, 315, 345, 375, 405, 435, 465, 495};
    private String path = "";
    private String decodedPath = "";

    public Highscores(int stateID) {
        this.stateID = stateID;
    }

    @Override
    public int getID() {
        return this.stateID;
    }

    @Override
    public void init(GameContainer container, StateBasedGame game) throws SlickException {
        container.setMouseCursor("data/c1.png", 0, 0);
        this.bg0 = new Image("data/hs0.png");
        this.bg1 = new Image("data/hs1.png");
        this.bg2 = new Image("data/hs2.png");
        this.bg3 = new Image("data/hs3.png");
        this.bg4 = new Image("data/hs4.png");
        this.bg5 = new Image("data/hs5.png");
        this.background = new Image[]{this.bg0, this.bg1, this.bg2, this.bg3, this.bg4, this.bg5};
        this.mainOption = new Image("data/hsmm.png");
        this.resetOption = new Image("data/hsreset.png");
        this.bgfinal = new Animation(this.background, 500);
        this.button = new Sound("data/buton.wav");
        this.font = new UnicodeFont(this.fontpath, 20, true, false);
        this.font.addAsciiGlyphs();
        this.font.addGlyphs(400, 600);
        this.font.getEffects().add(new ColorEffect(java.awt.Color.WHITE));
        this.font.loadGlyphs();
        container.setShowFPS(false);
    }

    @Override
    public void enter(GameContainer container, StateBasedGame game) throws SlickException {
        this.path = Test.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        try {
            this.decodedPath = URLDecoder.decode(this.path, "UTF-8");
        }
        catch (IOException error) {
            error.printStackTrace();
        }
        File file = new File(this.decodedPath + "scores.dat");
        if (file.exists()) {
            this.highscores = this.readFile();
            Collections.sort(this.highscores);
            Collections.reverse(this.highscores);
        }
    }

    @Override
    public void render(GameContainer container, StateBasedGame game, Graphics g2) throws SlickException {
        int pos;
        this.bgfinal.draw(0.0f, 0.0f);
        if (this.insideMainMenu) {
            this.mainOption.draw(0.0f, 0.0f);
        }
        if (this.insideReset) {
            this.resetOption.draw(0.0f, 0.0f);
        }
        for (pos = 1; pos < 11; ++pos) {
            this.font.drawString(this.xpos, this.ypos[pos - 1], ("" + pos + " -").toUpperCase());
        }
        if (this.highscores != null) {
            for (pos = 0; pos < this.highscores.size(); ++pos) {
                if (pos >= 10) continue;
                this.font.drawString(this.xpos2, this.ypos[pos], this.highscores.get(pos).toString());
            }
        }
    }

    @Override
    public void update(GameContainer container, StateBasedGame game, int delta) throws SlickException {
        Input input = container.getInput();
        int mouseX = input.getMouseX();
        int mouseY = input.getMouseY();
        this.insideMainMenu = mouseX >= 110 && mouseX <= 328 && mouseY >= 237 && mouseY <= 267;
        this.insideReset = mouseX >= 158 && mouseX <= 275 && mouseY >= 315 && mouseY <= 345;
        if (this.insideMainMenu && input.isMouseButtonDown(0)) {
            this.button.play(1.0f, 0.1f);
            game.enterState(1, this.outTransition, this.inTransition);
        }
        if (this.insideReset && input.isMouseButtonDown(0)) {
            this.button.play(1.0f, 0.1f);
            try {
                File file = new File(this.decodedPath + "scores.dat");
                if (file.exists()) {
                    file.delete();
                    file.createNewFile();
                    this.writeToFile(new ArrayList());
                } else if (!file.exists()) {
                    file.createNewFile();
                    this.writeToFile(new ArrayList());
                }
            }
            catch (IOException error) {
                error.printStackTrace();
            }
            game.enterState(4, this.outTransition, this.inTransition);
        }
    }

    public List readFile() {
        ArrayList highscores = null;
        try {
            FileInputStream fstream = new FileInputStream(this.decodedPath + "scores.dat");
            ObjectInputStream objstream = new ObjectInputStream(fstream);
            highscores = (ArrayList)objstream.readObject();
            objstream.close();
        }
        catch (IOException error) {
            error.printStackTrace();
        }
        catch (ClassNotFoundException error) {
            error.printStackTrace();
        }
        return highscores;
    }

    public void writeToFile(List highscores) {
        try {
            FileOutputStream fstream = new FileOutputStream(this.decodedPath + "scores.dat");
            ObjectOutputStream objstream = new ObjectOutputStream(fstream);
            objstream.writeObject(highscores);
            objstream.close();
        }
        catch (IOException error) {
            error.printStackTrace();
        }
    }
}

