/*
 * Decompiled with CFR 0.152.
 */
package test;

import classes.Score;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import logic.Board;
import org.newdawn.slick.Animation;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.Input;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.Sound;
import org.newdawn.slick.UnicodeFont;
import org.newdawn.slick.font.effects.ColorEffect;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;
import org.newdawn.slick.state.transition.FadeInTransition;
import org.newdawn.slick.state.transition.FadeOutTransition;
import org.newdawn.slick.state.transition.Transition;
import test.Test;

public class Timed
extends BasicGameState {
    private static final int width = 8;
    private static final int height = 8;
    private List<Board> boards = new ArrayList<Board>();
    private Image bg0 = null;
    private Image bg1 = null;
    private Image bg2 = null;
    private Image bg3 = null;
    private Image bg4 = null;
    private Image bg5 = null;
    private Image red = null;
    private Image pink = null;
    private Image blue = null;
    private Image yellow = null;
    private Image white = null;
    private Image orange = null;
    private Image green = null;
    private Image poweurp = null;
    private Image frame = null;
    private Image p1 = null;
    private Image p2 = null;
    private Image p3 = null;
    private Image p4 = null;
    private Image[] background = new Image[0];
    private Image mainOption = null;
    private Image overOption = null;
    private Animation bgfinal = null;
    private Sound button = null;
    private Transition inTransition = new FadeInTransition(new Color(0, 0, 0), 1000);
    private Transition outTransition = new FadeOutTransition(new Color(0, 0, 0), 1000);
    private int stateID = 3;
    private boolean insideMainMenu = false;
    private boolean[][] select = new boolean[8][8];
    private boolean[][] chose = new boolean[8][8];
    private boolean playing;
    private boolean levelup;
    private boolean pieceselected = false;
    private int curlevel;
    private int[] levelscores = new int[]{50, 100, 150, 200, 250, 300, 350, 400, 450, 500};
    private int[] xpos = new int[]{321, 371, 421, 471, 521, 571, 621, 671};
    private int[] ypos = new int[]{116, 166, 216, 266, 316, 366, 416, 466};
    private int lvlscore;
    private int fullscore;
    private UnicodeFont font = null;
    private String fontpath = "data/fgh.ttf";
    private int x;
    private int y;
    private int playscore;
    private String name1 = "";
    private boolean gameOver = false;
    private String path = "";
    private String decodedPath = "";
    private String name = "";
    private List<Score> scores = null;
    private int timer = 0;
    private int control = 0;

    public Timed(int stateID) {
        this.stateID = stateID;
    }

    @Override
    public int getID() {
        return this.stateID;
    }

    @Override
    public void init(GameContainer container, StateBasedGame game) throws SlickException {
        container.setMouseCursor("data/c1.png", 0, 0);
        this.bg0 = new Image("data/gs0.png");
        this.bg1 = new Image("data/gs1.png");
        this.bg2 = new Image("data/gs2.png");
        this.bg3 = new Image("data/gs3.png");
        this.bg4 = new Image("data/gs4.png");
        this.bg5 = new Image("data/gs5.png");
        this.red = new Image("data/square.png");
        this.pink = new Image("data/pink.png");
        this.blue = new Image("data/blue.png");
        this.green = new Image("data/green.png");
        this.yellow = new Image("data/yellow.png");
        this.orange = new Image("data/orange.png");
        this.white = new Image("data/white.png");
        this.frame = new Image("data/frame.png");
        this.p1 = new Image("data/p1.png");
        this.p2 = new Image("data/p2.png");
        this.p3 = new Image("data/p3.png");
        this.p4 = new Image("data/p4.png");
        this.background = new Image[]{this.bg0, this.bg1, this.bg2, this.bg3, this.bg4, this.bg5};
        this.mainOption = new Image("data/main.png");
        this.overOption = new Image("data/mainover.png");
        this.bgfinal = new Animation(this.background, 500);
        this.button = new Sound("data/buton.wav");
        this.font = new UnicodeFont(this.fontpath, 40, true, false);
        this.font.addAsciiGlyphs();
        this.font.addGlyphs(400, 600);
        this.font.getEffects().add(new ColorEffect(java.awt.Color.WHITE));
        this.font.loadGlyphs();
        this.boards.clear();
        this.curlevel = 0;
        this.lvlscore = 0;
        this.fullscore = 0;
        this.playscore = 0;
        this.control = 0;
        this.isLeveling();
        for (int i2 = 0; i2 < 8; ++i2) {
            for (int j = 0; j < 8; ++j) {
                this.select[i2][j] = false;
                this.chose[i2][j] = false;
            }
        }
    }

    @Override
    public void enter(GameContainer container, StateBasedGame game) throws SlickException {
        this.boards.clear();
        this.curlevel = 0;
        this.lvlscore = 0;
        this.fullscore = 0;
        this.playscore = 0;
        this.control = 0;
        this.gameOver = false;
        this.pieceselected = false;
        this.isLeveling();
        for (int i2 = 0; i2 < 8; ++i2) {
            for (int j = 0; j < 8; ++j) {
                this.select[i2][j] = false;
                this.chose[i2][j] = false;
            }
        }
        this.path = Test.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        try {
            this.decodedPath = URLDecoder.decode(this.path, "UTF-8");
        }
        catch (IOException error) {
            error.printStackTrace();
        }
        this.name = this.readFile();
        File file = new File(this.decodedPath + "scores.dat");
        if (file.exists()) {
            this.scores = this.readFileScore();
        }
        this.timer = 30000;
    }

    @Override
    public void render(GameContainer container, StateBasedGame game, Graphics g2) throws SlickException {
        int j;
        int i2;
        this.bgfinal.draw(0.0f, 0.0f);
        this.mainOption.draw(0.0f, 0.0f);
        if (this.boards.size() > 0) {
            this.font.drawString(50.0f, 555.0f, "LVL - " + (this.curlevel + 1));
            this.font.drawString(150.0f, 175.0f, this.fullscore + "");
            for (i2 = 0; i2 < 8; ++i2) {
                for (j = 0; j < 8; ++j) {
                    if (this.boards.get(this.curlevel).getBlockAt(i2, j).getType().equalsIgnoreCase("r")) {
                        this.red.draw(this.xpos[i2], this.ypos[j]);
                    } else if (this.boards.get(this.curlevel).getBlockAt(i2, j).getType().equalsIgnoreCase("y")) {
                        this.yellow.draw(this.xpos[i2], this.ypos[j]);
                    } else if (this.boards.get(this.curlevel).getBlockAt(i2, j).getType().equalsIgnoreCase("o")) {
                        this.orange.draw(this.xpos[i2], this.ypos[j]);
                    } else if (this.boards.get(this.curlevel).getBlockAt(i2, j).getType().equalsIgnoreCase("w")) {
                        this.white.draw(this.xpos[i2], this.ypos[j]);
                    }
                    if (this.boards.get(this.curlevel).getBlockAt(i2, j).getType().equalsIgnoreCase("b")) {
                        this.blue.draw(this.xpos[i2], this.ypos[j]);
                    }
                    if (this.boards.get(this.curlevel).getBlockAt(i2, j).getType().equalsIgnoreCase("p")) {
                        this.pink.draw(this.xpos[i2], this.ypos[j]);
                        continue;
                    }
                    if (!this.boards.get(this.curlevel).getBlockAt(i2, j).getType().equalsIgnoreCase("g")) continue;
                    this.green.draw(this.xpos[i2], this.ypos[j]);
                }
            }
            for (i2 = 0; i2 < 8; ++i2) {
                for (j = 0; j < 8; ++j) {
                    if (this.boards.get(this.curlevel).getBlockAt(i2, j).getChargeType() == 1) {
                        this.p1.draw(this.xpos[i2], this.ypos[j]);
                        continue;
                    }
                    if (this.boards.get(this.curlevel).getBlockAt(i2, j).getChargeType() == 2) {
                        this.p2.draw(this.xpos[i2], this.ypos[j]);
                        continue;
                    }
                    if (this.boards.get(this.curlevel).getBlockAt(i2, j).getChargeType() == 3) {
                        this.p3.draw(this.xpos[i2], this.ypos[j]);
                        continue;
                    }
                    if (this.boards.get(this.curlevel).getBlockAt(i2, j).getChargeType() != 4) continue;
                    this.p4.draw(this.xpos[i2], this.ypos[j]);
                }
            }
        }
        if (this.insideMainMenu) {
            this.overOption.draw(0.0f, 0.0f);
        }
        for (i2 = 0; i2 < 8; ++i2) {
            for (j = 0; j < 8; ++j) {
                if (!this.chose[i2][j]) continue;
                this.frame.draw(this.xpos[i2], this.ypos[j]);
            }
        }
        this.font.drawString(150.0f, 305.0f, this.timer / 1000 + "");
    }

    @Override
    public void update(GameContainer container, StateBasedGame game, int delta) throws SlickException {
        int j;
        int i2;
        if (this.timer >= 0) {
            this.timer -= delta;
        }
        Input input = container.getInput();
        int mouseX = input.getMouseX();
        int mouseY = input.getMouseY();
        this.insideMainMenu = mouseX >= 92 && mouseX <= 277 && mouseY >= 386 && mouseY <= 414;
        if (this.insideMainMenu && input.isMouseButtonDown(0)) {
            this.button.play(1.0f, 0.1f);
            game.enterState(1, this.outTransition, this.inTransition);
        }
        for (i2 = 0; i2 < 8; ++i2) {
            for (j = 0; j < 8; ++j) {
                this.select[i2][j] = mouseX >= this.xpos[i2] && mouseX <= this.xpos[i2] + 50 && mouseY >= this.ypos[j] - 12 && mouseY <= this.ypos[j] + 38;
            }
        }
        for (i2 = 0; i2 < 8; ++i2) {
            for (j = 0; j < 8; ++j) {
                if (!this.select[i2][j] || !input.isMousePressed(0)) continue;
                if (this.pieceselected) {
                    if (!this.boards.get(this.curlevel).isPieceInsertable(i2, j, this.boards.get(this.curlevel).getBlockAt(this.x, this.y)) && (i2 == this.x && j == this.y - 1 || i2 == this.x - 1 && j == this.y || i2 == this.x + 1 && j == this.y || i2 == this.x && j == this.y + 1)) {
                        this.boards.get(this.curlevel).doSwitch(this.x, this.y, i2, j);
                        do {
                            this.playscore = this.boards.get(this.curlevel).checkForLines();
                            this.lvlscore += this.playscore;
                            this.fullscore += this.playscore;
                            this.control += this.playscore;
                            this.timer += 3000;
                        } while (this.playscore != 0);
                        if (this.control == 0) {
                            this.boards.get(this.curlevel).doSwitch(this.x, this.y, i2, j);
                        }
                        this.control = 0;
                        this.playscore = 0;
                        this.chose[this.x][this.y] = false;
                        this.pieceselected = false;
                        this.x = -1;
                        this.y = -1;
                        this.boards.get(this.curlevel).fixBoard();
                        continue;
                    }
                    if (!this.boards.get(this.curlevel).isPieceInsertable(this.x, this.y, this.boards.get(this.curlevel).getBlockAt(i2, j)) && (i2 == this.x && j == this.y - 1 || i2 == this.x - 1 && j == this.y || i2 == this.x + 1 && j == this.y || i2 == this.x && j == this.y + 1)) {
                        this.boards.get(this.curlevel).doSwitch(i2, j, this.x, this.y);
                        do {
                            this.playscore = this.boards.get(this.curlevel).checkForLines();
                            this.lvlscore += this.playscore;
                            this.fullscore += this.playscore;
                            this.control += this.playscore;
                            this.timer += 3000;
                        } while (this.playscore != 0);
                        if (this.control == 0) {
                            this.boards.get(this.curlevel).doSwitch(i2, j, this.x, this.y);
                        }
                        this.control = 0;
                        this.playscore = 0;
                        this.chose[this.x][this.y] = false;
                        this.pieceselected = false;
                        this.x = -1;
                        this.y = -1;
                        this.boards.get(this.curlevel).fixBoard();
                        continue;
                    }
                    this.chose[this.x][this.y] = false;
                    this.pieceselected = false;
                    continue;
                }
                this.chose[i2][j] = !this.chose[i2][j];
                this.x = i2;
                this.y = j;
                this.pieceselected = true;
            }
        }
        if (this.lvlscore >= this.levelscores[this.curlevel] && this.curlevel < 10) {
            this.isLeveling();
            ++this.curlevel;
        }
        if (this.timer == 0) {
            this.gameOver = true;
        }
        if (this.gameOver) {
            Score score = new Score(this.name, this.fullscore);
            if (this.scores != null) {
                this.scores.add(new Score(this.name, this.fullscore));
            } else {
                this.scores = new ArrayList<Score>();
                this.scores.add(new Score(this.name, this.fullscore));
            }
            Collections.sort(this.scores);
            Collections.reverse(this.scores);
            if (this.scores.size() > 10) {
                for (int i3 = this.scores.size(); i3 > 9; --i3) {
                    this.scores.remove(i3);
                }
            }
            this.writeToFile(this.scores);
            this.gameOver = false;
            this.scores.clear();
            game.enterState(1, this.outTransition, this.inTransition);
        }
        if (this.levelup) {
            if (this.curlevel == 0) {
                // empty if block
            }
            this.boards.add(new Board(this.curlevel + 1, 8, 8));
            this.lvlscore = 0;
            this.timer = 30000;
            this.levelup = false;
        }
        if (this.boards.get(this.curlevel).checkPlays() == 0) {
            this.gameOver = true;
        }
    }

    public void isLeveling() {
        this.levelup = true;
    }

    public void isPlaying() {
        this.playing = true;
    }

    public int getLevel() {
        return this.curlevel;
    }

    public void setLevel(int level) {
        this.curlevel = level;
    }

    public String readFile() {
        String name = "";
        try {
            FileInputStream fstream = new FileInputStream(this.decodedPath + "name.dat");
            ObjectInputStream objstream = new ObjectInputStream(fstream);
            name = objstream.readUTF();
            objstream.close();
        }
        catch (IOException error) {
            error.printStackTrace();
        }
        return name;
    }

    public List readFileScore() {
        ArrayList highscores = null;
        try {
            FileInputStream fstream = new FileInputStream(this.decodedPath + "scores.dat");
            ObjectInputStream objstream = new ObjectInputStream(fstream);
            highscores = (ArrayList)objstream.readObject();
            objstream.close();
        }
        catch (IOException error) {
            error.printStackTrace();
        }
        catch (ClassNotFoundException error) {
            error.printStackTrace();
        }
        return highscores;
    }

    public void writeToFile(List highscores) {
        try {
            FileOutputStream fstream = new FileOutputStream(this.decodedPath + "scores.dat");
            ObjectOutputStream objstream = new ObjectOutputStream(fstream);
            objstream.writeObject(highscores);
            objstream.close();
        }
        catch (IOException error) {
            error.printStackTrace();
        }
    }
}

