/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jorbis;

import com.jcraft.jorbis.Drft;

class Lpc {
    Drft fft = new Drft();
    int ln;
    int m;

    Lpc() {
    }

    static float lpc_from_data(float[] fArray, float[] fArray2, int n, int n2) {
        int n3;
        float f2;
        float[] fArray3 = new float[n2 + 1];
        int n4 = n2 + 1;
        while (n4-- != 0) {
            f2 = 0.0f;
            n3 = n4;
            while (n3 < n) {
                f2 += fArray[n3] * fArray[n3 - n4];
                ++n3;
            }
            fArray3[n4] = f2;
        }
        float f3 = fArray3[0];
        n3 = 0;
        while (n3 < n2) {
            f2 = -fArray3[n3 + 1];
            if (f3 == 0.0f) {
                int n5 = 0;
                while (n5 < n2) {
                    fArray2[n5] = 0.0f;
                    ++n5;
                }
                return 0.0f;
            }
            n4 = 0;
            while (n4 < n3) {
                f2 -= fArray2[n4] * fArray3[n3 - n4];
                ++n4;
            }
            fArray2[n3] = f2 /= f3;
            n4 = 0;
            while (n4 < n3 / 2) {
                float f4 = fArray2[n4];
                int n6 = n4;
                fArray2[n6] = fArray2[n6] + f2 * fArray2[n3 - 1 - n4];
                int n7 = n3 - 1 - n4;
                fArray2[n7] = fArray2[n7] + f2 * f4;
                ++n4;
            }
            if (n3 % 2 != 0) {
                int n8 = n4;
                fArray2[n8] = fArray2[n8] + fArray2[n4] * f2;
            }
            f3 = (float)((double)f3 * (1.0 - (double)(f2 * f2)));
            ++n3;
        }
        return f3;
    }

    float lpc_from_curve(float[] fArray, float[] fArray2) {
        int n = this.ln;
        float[] fArray3 = new float[n + n];
        float f2 = (float)(0.5 / (double)n);
        int n2 = 0;
        while (n2 < n) {
            fArray3[n2 * 2] = fArray[n2] * f2;
            fArray3[n2 * 2 + 1] = 0.0f;
            ++n2;
        }
        fArray3[n * 2 - 1] = fArray[n - 1] * f2;
        this.fft.backward(fArray3);
        n2 = 0;
        int n3 = (n *= 2) / 2;
        while (n2 < n / 2) {
            float f3 = fArray3[n2];
            fArray3[n2++] = fArray3[n3];
            fArray3[n3++] = f3;
        }
        return Lpc.lpc_from_data(fArray3, fArray2, n, this.m);
    }

    void init(int n, int n2) {
        this.ln = n;
        this.m = n2;
        this.fft.init(n * 2);
    }

    void clear() {
        this.fft.clear();
    }

    static float FAST_HYPOT(float f2, float f3) {
        return (float)Math.sqrt(f2 * f2 + f3 * f3);
    }

    void lpc_to_curve(float[] fArray, float[] fArray2, float f2) {
        int n = 0;
        while (n < this.ln * 2) {
            fArray[n] = 0.0f;
            ++n;
        }
        if (f2 == 0.0f) {
            return;
        }
        int n2 = 0;
        while (n2 < this.m) {
            fArray[n2 * 2 + 1] = fArray2[n2] / (4.0f * f2);
            fArray[n2 * 2 + 2] = -fArray2[n2] / (4.0f * f2);
            ++n2;
        }
        this.fft.backward(fArray);
        int n3 = this.ln * 2;
        float f3 = (float)(1.0 / (double)f2);
        fArray[0] = (float)(1.0 / (double)(fArray[0] * 2.0f + f3));
        int n4 = 1;
        while (n4 < this.ln) {
            float f4 = fArray[n4] + fArray[n3 - n4];
            float f5 = fArray[n4] - fArray[n3 - n4];
            float f6 = f4 + f3;
            fArray[n4] = (float)(1.0 / (double)Lpc.FAST_HYPOT(f6, f5));
            ++n4;
        }
    }
}

