/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jorbis;

class Mdct {
    private static final float cPI3_8 = 0.38268343f;
    private static final float cPI2_8 = 0.70710677f;
    private static final float cPI1_8 = 0.9238795f;
    int n;
    int log2n;
    float[] trig;
    int[] bitrev;
    float scale;
    float[] _x = new float[1024];
    float[] _w = new float[1024];

    Mdct() {
    }

    void init(int n) {
        this.bitrev = new int[n / 4];
        this.trig = new float[n + n / 4];
        int n2 = n >>> 1;
        this.log2n = (int)Math.rint(Math.log(n) / Math.log(2.0));
        this.n = n;
        int n3 = 0;
        int n4 = 1;
        int n5 = n3 + n / 2;
        int n6 = n5 + 1;
        int n7 = n5 + n / 2;
        int n8 = n7 + 1;
        int n9 = 0;
        while (n9 < n / 4) {
            this.trig[n3 + n9 * 2] = (float)Math.cos(Math.PI / (double)n * (double)(4 * n9));
            this.trig[n4 + n9 * 2] = (float)(-Math.sin(Math.PI / (double)n * (double)(4 * n9)));
            this.trig[n5 + n9 * 2] = (float)Math.cos(Math.PI / (double)(2 * n) * (double)(2 * n9 + 1));
            this.trig[n6 + n9 * 2] = (float)Math.sin(Math.PI / (double)(2 * n) * (double)(2 * n9 + 1));
            ++n9;
        }
        int n10 = 0;
        while (n10 < n / 8) {
            this.trig[n7 + n10 * 2] = (float)Math.cos(Math.PI / (double)n * (double)(4 * n10 + 2));
            this.trig[n8 + n10 * 2] = (float)(-Math.sin(Math.PI / (double)n * (double)(4 * n10 + 2)));
            ++n10;
        }
        int n11 = (1 << this.log2n - 1) - 1;
        int n12 = 1 << this.log2n - 2;
        int n13 = 0;
        while (n13 < n / 8) {
            int n14 = 0;
            int n15 = 0;
            while (n12 >>> n15 != 0) {
                if ((n12 >>> n15 & n13) != 0) {
                    n14 |= 1 << n15;
                }
                ++n15;
            }
            this.bitrev[n13 * 2] = ~n14 & n11;
            this.bitrev[n13 * 2 + 1] = n14;
            ++n13;
        }
        this.scale = 4.0f / (float)n;
    }

    void clear() {
    }

    void forward(float[] fArray, float[] fArray2) {
    }

    synchronized void backward(float[] fArray, float[] fArray2) {
        if (this._x.length < this.n / 2) {
            this._x = new float[this.n / 2];
        }
        if (this._w.length < this.n / 2) {
            this._w = new float[this.n / 2];
        }
        float[] fArray3 = this._x;
        float[] fArray4 = this._w;
        int n = this.n >>> 1;
        int n2 = this.n >>> 2;
        int n3 = this.n >>> 3;
        int n4 = 1;
        int n5 = 0;
        int n6 = n;
        int n7 = 0;
        while (n7 < n3) {
            fArray3[n5++] = -fArray[n4 + 2] * this.trig[(n6 -= 2) + 1] - fArray[n4] * this.trig[n6];
            fArray3[n5++] = fArray[n4] * this.trig[n6 + 1] - fArray[n4 + 2] * this.trig[n6];
            n4 += 4;
            ++n7;
        }
        n4 = n - 4;
        n7 = 0;
        while (n7 < n3) {
            fArray3[n5++] = fArray[n4] * this.trig[(n6 -= 2) + 1] + fArray[n4 + 2] * this.trig[n6];
            fArray3[n5++] = fArray[n4] * this.trig[n6] - fArray[n4 + 2] * this.trig[n6 + 1];
            n4 -= 4;
            ++n7;
        }
        float[] fArray5 = this.mdct_kernel(fArray3, fArray4, this.n, n, n2, n3);
        n5 = 0;
        n6 = n;
        n7 = n2;
        int n8 = n7 - 1;
        int n9 = n2 + n;
        int n10 = n9 - 1;
        int n11 = 0;
        while (n11 < n2) {
            float f2 = fArray5[n5] * this.trig[n6 + 1] - fArray5[n5 + 1] * this.trig[n6];
            float f3 = -(fArray5[n5] * this.trig[n6] + fArray5[n5 + 1] * this.trig[n6 + 1]);
            fArray2[n7] = -f2;
            fArray2[n8] = f2;
            fArray2[n9] = f3;
            fArray2[n10] = f3;
            ++n7;
            --n8;
            ++n9;
            --n10;
            n5 += 2;
            n6 += 2;
            ++n11;
        }
    }

    private float[] mdct_kernel(float[] fArray, float[] fArray2, int n, int n2, int n3, int n4) {
        float f2;
        float f3;
        float f4;
        float f5;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = n3;
        int n10 = 0;
        int n11 = n3;
        int n12 = n2;
        int n13 = 0;
        while (n13 < n3) {
            float f6 = fArray[n9] - fArray[n10];
            fArray2[n11 + n13] = fArray[n9++] + fArray[n10++];
            float f7 = fArray[n9] - fArray[n10];
            fArray2[n13++] = f6 * this.trig[n12 -= 4] + f7 * this.trig[n12 + 1];
            fArray2[n13] = f7 * this.trig[n12] - f6 * this.trig[n12 + 1];
            fArray2[n11 + n13] = fArray[n9++] + fArray[n10++];
            ++n13;
        }
        int n14 = 0;
        while (n14 < this.log2n - 3) {
            int n15 = n >>> n14 + 2;
            n8 = 1 << n14 + 3;
            n7 = n2 - 2;
            n12 = 0;
            n6 = 0;
            while (n6 < n15 >>> 2) {
                n5 = n7;
                n11 = n5 - (n15 >> 1);
                f5 = this.trig[n12];
                f4 = this.trig[n12 + 1];
                n7 -= 2;
                ++n15;
                int n16 = 0;
                while (n16 < 2 << n14) {
                    f3 = fArray2[n5] - fArray2[n11];
                    fArray[n5] = fArray2[n5] + fArray2[n11];
                    f2 = fArray2[++n5] - fArray2[++n11];
                    fArray[n5] = fArray2[n5] + fArray2[n11];
                    fArray[n11] = f2 * f5 - f3 * f4;
                    fArray[n11 - 1] = f3 * f5 + f2 * f4;
                    n5 -= n15;
                    n11 -= n15;
                    ++n16;
                }
                --n15;
                n12 += n8;
                ++n6;
            }
            float[] fArray3 = fArray2;
            fArray2 = fArray;
            fArray = fArray3;
            ++n14;
        }
        n14 = n;
        int n17 = 0;
        n8 = 0;
        n7 = n2 - 1;
        int n18 = 0;
        while (n18 < n4) {
            n6 = this.bitrev[n17++];
            n5 = this.bitrev[n17++];
            f5 = fArray2[n6] - fArray2[n5 + 1];
            f2 = fArray2[n6 - 1] + fArray2[n5];
            f4 = fArray2[n6] + fArray2[n5 + 1];
            f3 = fArray2[n6 - 1] - fArray2[n5];
            float f8 = f5 * this.trig[n14];
            float f9 = f2 * this.trig[n14++];
            float f10 = f5 * this.trig[n14];
            float f11 = f2 * this.trig[n14++];
            fArray[n8++] = (f4 + f10 + f9) * 0.5f;
            fArray[n7--] = (-f3 + f11 - f8) * 0.5f;
            fArray[n8++] = (f3 + f11 - f8) * 0.5f;
            fArray[n7--] = (f4 - f10 - f9) * 0.5f;
            ++n18;
        }
        return fArray;
    }
}

