/*
 * Decompiled with CFR 0.152.
 */
package logic;

import classes.Piece;
import java.util.Random;

public class Board {
    private String[] types = new String[]{"r", "o", "y", "g", "b", "p", "w"};
    private int width;
    private int height;
    private int level;
    private Piece[][] board = null;
    private Piece[][] boardtemp = null;
    private Piece temp = null;
    private Piece temp2 = null;
    private int score = 0;
    private int x;
    private int y;
    private int w;
    private int z;

    public Board(int level, int width, int height) {
        this.level = level;
        this.width = width;
        this.height = height;
        this.board = new Piece[this.width][this.height];
        this.createBoard();
    }

    public void createBoard() {
        int y;
        int x;
        boolean empty = true;
        for (x = 0; x < this.width; ++x) {
            for (y = 0; y < this.height; ++y) {
                this.setBlockAt(x, y, new Piece("empty", false));
            }
        }
        for (x = 0; x < this.width; ++x) {
            for (y = 0; y < this.height; ++y) {
                empty = true;
                while (empty) {
                    Piece piece = this.createPiece();
                    if (!this.isPieceInsertable(x, y, piece)) continue;
                    this.setBlockAt(x, y, piece);
                    empty = false;
                }
            }
        }
    }

    public Piece createPiece() {
        Random randomGenerator = new Random();
        int random = randomGenerator.nextInt(7);
        Piece piece = new Piece(this.types[random], false);
        return piece;
    }

    public Piece createChargedPiece(String type, int chargetype) {
        Piece piece = new Piece(type, true);
        piece.setChargeType(chargetype);
        return piece;
    }

    public void setBlockAt(int x, int y, Piece piece) {
        this.board[x][y] = piece;
    }

    public Piece getBlockAt(int x, int y) {
        return this.board[x][y];
    }

    public boolean isPieceInsertable(int x, int y, Piece piece) {
        if (x == 0 && y == 0) {
            return (!this.board[x + 1][y].getType().equalsIgnoreCase(piece.getType()) || !this.board[x + 2][y].getType().equalsIgnoreCase(piece.getType())) && (!this.board[x][y + 1].getType().equalsIgnoreCase(piece.getType()) || !this.board[x][y + 2].getType().equalsIgnoreCase(piece.getType()));
        }
        if (x == 1 && y == 1) {
            return !(this.board[x + 1][y].getType().equalsIgnoreCase(piece.getType()) && this.board[x + 2][y].getType().equalsIgnoreCase(piece.getType()) || this.board[x][y + 1].getType().equalsIgnoreCase(piece.getType()) && this.board[x][y + 2].getType().equalsIgnoreCase(piece.getType()) || this.board[x][y - 1].getType().equalsIgnoreCase(piece.getType()) && this.board[x][y + 1].getType().equalsIgnoreCase(piece.getType())) && (!this.board[x + 1][y].getType().equalsIgnoreCase(piece.getType()) || !this.board[x - 1][y].getType().equalsIgnoreCase(piece.getType()));
        }
        if (x == 0 && y == 1) {
            return !(this.board[x + 1][y].getType().equalsIgnoreCase(piece.getType()) && this.board[x + 2][y].getType().equalsIgnoreCase(piece.getType()) || this.board[x][y + 1].getType().equalsIgnoreCase(piece.getType()) && this.board[x][y + 2].getType().equalsIgnoreCase(piece.getType())) && (!this.board[x][y - 1].getType().equalsIgnoreCase(piece.getType()) || !this.board[x][y + 1].getType().equalsIgnoreCase(piece.getType()));
        }
        if (x == 1 && y == 0) {
            return !(this.board[x + 1][y].getType().equalsIgnoreCase(piece.getType()) && this.board[x + 2][y].getType().equalsIgnoreCase(piece.getType()) || this.board[x][y + 1].getType().equalsIgnoreCase(piece.getType()) && this.board[x][y + 2].getType().equalsIgnoreCase(piece.getType())) && (!this.board[x + 1][y].getType().equalsIgnoreCase(piece.getType()) || !this.board[x - 1][y].getType().equalsIgnoreCase(piece.getType()));
        }
        if (x == this.width - 1 && y == this.height - 1) {
            return (!this.board[x - 1][y].getType().equalsIgnoreCase(piece.getType()) || !this.board[x - 2][y].getType().equalsIgnoreCase(piece.getType())) && (!this.board[x][y - 1].getType().equalsIgnoreCase(piece.getType()) || !this.board[x][y - 2].getType().equalsIgnoreCase(piece.getType()));
        }
        if (x == this.width - 2 && y == this.height - 2) {
            return !(this.board[x - 1][y].getType().equalsIgnoreCase(piece.getType()) && this.board[x - 2][y].getType().equalsIgnoreCase(piece.getType()) || this.board[x][y - 1].getType().equalsIgnoreCase(piece.getType()) && this.board[x][y - 2].getType().equalsIgnoreCase(piece.getType()) || this.board[x][y - 1].getType().equalsIgnoreCase(piece.getType()) && this.board[x][y + 1].getType().equalsIgnoreCase(piece.getType())) && (!this.board[x + 1][y].getType().equalsIgnoreCase(piece.getType()) || !this.board[x - 1][y].getType().equalsIgnoreCase(piece.getType()));
        }
        if (x == this.width - 1 && y == this.height - 2) {
            return !(this.board[x - 1][y].getType().equalsIgnoreCase(piece.getType()) && this.board[x - 2][y].getType().equalsIgnoreCase(piece.getType()) || this.board[x][y - 1].getType().equalsIgnoreCase(piece.getType()) && this.board[x][y - 2].getType().equalsIgnoreCase(piece.getType())) && (!this.board[x][y - 1].getType().equalsIgnoreCase(piece.getType()) || !this.board[x][y + 1].getType().equalsIgnoreCase(piece.getType()));
        }
        if (x == this.width - 2 && y == this.height - 1) {
            return !(this.board[x - 1][y].getType().equalsIgnoreCase(piece.getType()) && this.board[x - 2][y].getType().equalsIgnoreCase(piece.getType()) || this.board[x][y - 1].getType().equalsIgnoreCase(piece.getType()) && this.board[x][y - 2].getType().equalsIgnoreCase(piece.getType())) && (!this.board[x + 1][y].getType().equalsIgnoreCase(piece.getType()) || !this.board[x - 1][y].getType().equalsIgnoreCase(piece.getType()));
        }
        if (x == 0 && y == this.height - 1) {
            return (!this.board[x + 1][y].getType().equalsIgnoreCase(piece.getType()) || !this.board[x + 2][y].getType().equalsIgnoreCase(piece.getType())) && (!this.board[x][y - 1].getType().equalsIgnoreCase(piece.getType()) || !this.board[x][y - 2].getType().equalsIgnoreCase(piece.getType()));
        }
        if (x == 1 && y == this.height - 1) {
            return !(this.board[x + 1][y].getType().equalsIgnoreCase(piece.getType()) && this.board[x + 2][y].getType().equalsIgnoreCase(piece.getType()) || this.board[x][y - 1].getType().equalsIgnoreCase(piece.getType()) && this.board[x][y - 2].getType().equalsIgnoreCase(piece.getType())) && (!this.board[x + 1][y].getType().equalsIgnoreCase(piece.getType()) || !this.board[x - 1][y].getType().equalsIgnoreCase(piece.getType()));
        }
        if (x == 0 && y == this.height - 2) {
            return !(this.board[x + 1][y].getType().equalsIgnoreCase(piece.getType()) && this.board[x + 2][y].getType().equalsIgnoreCase(piece.getType()) || this.board[x][y - 1].getType().equalsIgnoreCase(piece.getType()) && this.board[x][y - 2].getType().equalsIgnoreCase(piece.getType())) && (!this.board[x][y + 1].getType().equalsIgnoreCase(piece.getType()) || !this.board[x][y - 1].getType().equalsIgnoreCase(piece.getType()));
        }
        if (x == 1 && y == this.height - 2) {
            return !(this.board[x + 1][y].getType().equalsIgnoreCase(piece.getType()) && this.board[x + 2][y].getType().equalsIgnoreCase(piece.getType()) || this.board[x][y - 1].getType().equalsIgnoreCase(piece.getType()) && this.board[x][y - 2].getType().equalsIgnoreCase(piece.getType()) || this.board[x][y + 1].getType().equalsIgnoreCase(piece.getType()) && this.board[x][y - 1].getType().equalsIgnoreCase(piece.getType())) && (!this.board[x + 1][y].getType().equalsIgnoreCase(piece.getType()) || !this.board[x - 1][y].getType().equalsIgnoreCase(piece.getType()));
        }
        if (x == this.width - 1 && y == 0) {
            return (!this.board[x - 1][y].getType().equalsIgnoreCase(piece.getType()) || !this.board[x - 2][y].getType().equalsIgnoreCase(piece.getType())) && (!this.board[x][y + 1].getType().equalsIgnoreCase(piece.getType()) || !this.board[x][y + 2].getType().equalsIgnoreCase(piece.getType()));
        }
        if (x == this.width - 1 && y == 1) {
            return !(this.board[x - 1][y].getType().equalsIgnoreCase(piece.getType()) && this.board[x - 2][y].getType().equalsIgnoreCase(piece.getType()) || this.board[x][y + 1].getType().equalsIgnoreCase(piece.getType()) && this.board[x][y + 2].getType().equalsIgnoreCase(piece.getType())) && (!this.board[x][y + 1].getType().equalsIgnoreCase(piece.getType()) || !this.board[x][y - 1].getType().equalsIgnoreCase(piece.getType()));
        }
        if (x == this.width - 2 && y == 0) {
            return !(this.board[x - 1][y].getType().equalsIgnoreCase(piece.getType()) && this.board[x - 2][y].getType().equalsIgnoreCase(piece.getType()) || this.board[x][y + 1].getType().equalsIgnoreCase(piece.getType()) && this.board[x][y + 2].getType().equalsIgnoreCase(piece.getType())) && (!this.board[x + 1][y].getType().equalsIgnoreCase(piece.getType()) || !this.board[x - 1][y].getType().equalsIgnoreCase(piece.getType()));
        }
        if (x == this.width - 2 && y == 1) {
            return !(this.board[x - 1][y].getType().equalsIgnoreCase(piece.getType()) && this.board[x - 2][y].getType().equalsIgnoreCase(piece.getType()) || this.board[x][y + 1].getType().equalsIgnoreCase(piece.getType()) && this.board[x][y + 2].getType().equalsIgnoreCase(piece.getType()) || this.board[x][y + 1].getType().equalsIgnoreCase(piece.getType()) && this.board[x][y - 1].getType().equalsIgnoreCase(piece.getType())) && (!this.board[x + 1][y].getType().equalsIgnoreCase(piece.getType()) || !this.board[x - 1][y].getType().equalsIgnoreCase(piece.getType()));
        }
        if (x == 0) {
            return !(this.board[x + 1][y].getType().equalsIgnoreCase(piece.getType()) && this.board[x + 2][y].getType().equalsIgnoreCase(piece.getType()) || this.board[x][y + 1].getType().equalsIgnoreCase(piece.getType()) && this.board[x][y + 2].getType().equalsIgnoreCase(piece.getType()) || this.board[x][y - 1].getType().equalsIgnoreCase(piece.getType()) && this.board[x][y - 2].getType().equalsIgnoreCase(piece.getType())) && (!this.board[x][y - 1].getType().equalsIgnoreCase(piece.getType()) || !this.board[x][y + 1].getType().equalsIgnoreCase(piece.getType()));
        }
        if (x == 1) {
            return !(this.board[x + 1][y].getType().equalsIgnoreCase(piece.getType()) && this.board[x + 2][y].getType().equalsIgnoreCase(piece.getType()) || this.board[x][y + 1].getType().equalsIgnoreCase(piece.getType()) && this.board[x][y + 2].getType().equalsIgnoreCase(piece.getType()) || this.board[x][y - 1].getType().equalsIgnoreCase(piece.getType()) && this.board[x][y - 2].getType().equalsIgnoreCase(piece.getType()) || this.board[x][y - 1].getType().equalsIgnoreCase(piece.getType()) && this.board[x][y + 1].getType().equalsIgnoreCase(piece.getType())) && (!this.board[x + 1][y].getType().equalsIgnoreCase(piece.getType()) || !this.board[x - 1][y].getType().equalsIgnoreCase(piece.getType()));
        }
        if (y == 0) {
            return !(this.board[x + 1][y].getType().equalsIgnoreCase(piece.getType()) && this.board[x + 2][y].getType().equalsIgnoreCase(piece.getType()) || this.board[x - 1][y].getType().equalsIgnoreCase(piece.getType()) && this.board[x - 2][y].getType().equalsIgnoreCase(piece.getType()) || this.board[x][y + 1].getType().equalsIgnoreCase(piece.getType()) && this.board[x][y + 2].getType().equalsIgnoreCase(piece.getType())) && (!this.board[x + 1][y].getType().equalsIgnoreCase(piece.getType()) || !this.board[x - 1][y].getType().equalsIgnoreCase(piece.getType()));
        }
        if (y == 1) {
            return !(this.board[x + 1][y].getType().equalsIgnoreCase(piece.getType()) && this.board[x + 2][y].getType().equalsIgnoreCase(piece.getType()) || this.board[x - 1][y].getType().equalsIgnoreCase(piece.getType()) && this.board[x - 2][y].getType().equalsIgnoreCase(piece.getType()) || this.board[x][y + 1].getType().equalsIgnoreCase(piece.getType()) && this.board[x][y + 2].getType().equalsIgnoreCase(piece.getType()) || this.board[x + 1][y].getType().equalsIgnoreCase(piece.getType()) && this.board[x - 1][y].getType().equalsIgnoreCase(piece.getType())) && (!this.board[x][y - 1].getType().equalsIgnoreCase(piece.getType()) || !this.board[x][y + 1].getType().equalsIgnoreCase(piece.getType()));
        }
        if (x == this.width - 1) {
            return !(this.board[x - 1][y].getType().equalsIgnoreCase(piece.getType()) && this.board[x - 2][y].getType().equalsIgnoreCase(piece.getType()) || this.board[x][y - 1].getType().equalsIgnoreCase(piece.getType()) && this.board[x][y - 2].getType().equalsIgnoreCase(piece.getType()) || this.board[x][y + 1].getType().equalsIgnoreCase(piece.getType()) && this.board[x][y + 2].getType().equalsIgnoreCase(piece.getType())) && (!this.board[x][y + 1].getType().equalsIgnoreCase(piece.getType()) || !this.board[x][y - 1].getType().equalsIgnoreCase(piece.getType()));
        }
        if (x == this.width - 2) {
            return !(this.board[x - 1][y].getType().equalsIgnoreCase(piece.getType()) && this.board[x - 2][y].getType().equalsIgnoreCase(piece.getType()) || this.board[x][y - 1].getType().equalsIgnoreCase(piece.getType()) && this.board[x][y - 2].getType().equalsIgnoreCase(piece.getType()) || this.board[x][y + 1].getType().equalsIgnoreCase(piece.getType()) && this.board[x][y + 2].getType().equalsIgnoreCase(piece.getType()) || this.board[x][y + 1].getType().equalsIgnoreCase(piece.getType()) && this.board[x][y - 1].getType().equalsIgnoreCase(piece.getType())) && (!this.board[x + 1][y].getType().equalsIgnoreCase(piece.getType()) || !this.board[x - 1][y].getType().equalsIgnoreCase(piece.getType()));
        }
        if (y == this.height - 1) {
            return !(this.board[x - 1][y].getType().equalsIgnoreCase(piece.getType()) && this.board[x - 2][y].getType().equalsIgnoreCase(piece.getType()) || this.board[x + 1][y].getType().equalsIgnoreCase(piece.getType()) && this.board[x + 2][y].getType().equalsIgnoreCase(piece.getType()) || this.board[x][y - 1].getType().equalsIgnoreCase(piece.getType()) && this.board[x][y - 2].getType().equalsIgnoreCase(piece.getType())) && (!this.board[x + 1][y].getType().equalsIgnoreCase(piece.getType()) || !this.board[x - 1][y].getType().equalsIgnoreCase(piece.getType()));
        }
        if (y == this.height - 2) {
            return !(this.board[x - 1][y].getType().equalsIgnoreCase(piece.getType()) && this.board[x - 2][y].getType().equalsIgnoreCase(piece.getType()) || this.board[x + 1][y].getType().equalsIgnoreCase(piece.getType()) && this.board[x + 2][y].getType().equalsIgnoreCase(piece.getType()) || this.board[x][y - 1].getType().equalsIgnoreCase(piece.getType()) && this.board[x][y - 2].getType().equalsIgnoreCase(piece.getType()) || this.board[x + 1][y].getType().equalsIgnoreCase(piece.getType()) && this.board[x - 1][y].getType().equalsIgnoreCase(piece.getType())) && (!this.board[x][y + 1].getType().equalsIgnoreCase(piece.getType()) || !this.board[x][y - 1].getType().equalsIgnoreCase(piece.getType()));
        }
        return !(this.board[x + 1][y].getType().equalsIgnoreCase(piece.getType()) && this.board[x + 2][y].getType().equalsIgnoreCase(piece.getType()) || this.board[x][y + 1].getType().equalsIgnoreCase(piece.getType()) && this.board[x][y + 2].getType().equalsIgnoreCase(piece.getType()) || this.board[x][y - 1].getType().equalsIgnoreCase(piece.getType()) && this.board[x][y - 2].getType().equalsIgnoreCase(piece.getType()) || this.board[x - 1][y].getType().equalsIgnoreCase(piece.getType()) && this.board[x - 2][y].getType().equalsIgnoreCase(piece.getType()) || this.board[x + 1][y].getType().equalsIgnoreCase(piece.getType()) && this.board[x - 1][y].getType().equalsIgnoreCase(piece.getType())) && (!this.board[x][y + 1].getType().equalsIgnoreCase(piece.getType()) || !this.board[x][y - 1].getType().equalsIgnoreCase(piece.getType()));
    }

    public void doSwitch(int x1, int y1, int x2, int y2) {
        this.temp = this.board[x2][y2];
        this.temp2 = this.board[x1][y1];
        this.board[x2][y2] = this.board[x1][y1];
        this.board[x1][y1] = this.temp;
        this.x = x1;
        this.y = y1;
        this.w = x2;
        this.z = y2;
    }

    public int checkForLines() {
        for (int i2 = 0; i2 < 8; ++i2) {
            for (int j = 0; j < 8; ++j) {
                if (this.board[i2][j].getType().equalsIgnoreCase("empty")) continue;
                if (j + 1 < 8 && this.board[i2][j].getType().equalsIgnoreCase(this.board[i2][j + 1].getType()) && j + 2 < 8 && this.board[i2][j].getType().equalsIgnoreCase(this.board[i2][j + 2].getType())) {
                    if (j + 3 < 8 && this.board[i2][j].getType().equalsIgnoreCase(this.board[i2][j + 3].getType())) {
                        if (j + 4 < 8 && this.board[i2][j].getType().equalsIgnoreCase(this.board[i2][j + 4].getType())) {
                            if (this.board[i2][j].getChargeType() == 1 || this.board[i2][j + 1].getChargeType() == 1 || this.board[i2][j + 2].getChargeType() == 1 || this.board[i2][j + 3].getChargeType() == 1 || this.board[i2][j + 4].getChargeType() == 1) {
                                for (int r = 0; r < 8; ++r) {
                                    this.setBlockAt(i2, r, new Piece("empty", false));
                                }
                                return 40;
                            }
                            if (this.board[i2][j].getChargeType() == 3 || this.board[i2][j + 1].getChargeType() == 3 || this.board[i2][j + 2].getChargeType() == 3 || this.board[i2][j + 3].getChargeType() == 3 || this.board[i2][j + 4].getChargeType() == 3) {
                                int r;
                                for (r = 0; r < 8; ++r) {
                                    this.setBlockAt(i2, r, new Piece("empty", false));
                                }
                                for (r = 0; r < 8; ++r) {
                                    this.setBlockAt(r, j, new Piece("empty", false));
                                }
                                return 50;
                            }
                            if (this.board[i2][j].getChargeType() == 4 || this.board[i2][j + 1].getChargeType() == 4 || this.board[i2][j + 2].getChargeType() == 4 || this.board[i2][j + 3].getChargeType() == 4 || this.board[i2][j + 4].getChargeType() == 4) {
                                for (int r = 0; r < 8; ++r) {
                                    for (int t = 0; t < 8; ++t) {
                                        if (!this.board[r][t].getType().equalsIgnoreCase(this.board[i2][j].getType())) continue;
                                        this.setBlockAt(r, t, new Piece("empty", false));
                                    }
                                }
                                return 60;
                            }
                            this.setBlockAt(i2, j, new Piece("empty", false));
                            this.setBlockAt(i2, j + 1, new Piece("empty", false));
                            this.setBlockAt(i2, j + 2, new Piece("empty", false));
                            this.setBlockAt(i2, j + 3, new Piece("empty", false));
                            this.setBlockAt(i2, j + 4, new Piece("empty", false));
                            if (this.board[this.x][this.y].getType().equalsIgnoreCase("empty")) {
                                this.createCharged(this.x, this.y, this.temp.getType(), 4);
                            }
                            if (this.board[this.w][this.z].getType().equalsIgnoreCase("empty")) {
                                this.createCharged(this.w, this.z, this.temp2.getType(), 4);
                            }
                            return 20;
                        }
                        if (this.board[i2][j].getChargeType() == 1 || this.board[i2][j + 1].getChargeType() == 1 || this.board[i2][j + 2].getChargeType() == 1 || this.board[i2][j + 3].getChargeType() == 1) {
                            for (int r = 0; r < 8; ++r) {
                                this.setBlockAt(i2, r, new Piece("empty", false));
                            }
                            return 20;
                        }
                        if (this.board[i2][j].getChargeType() == 3 || this.board[i2][j + 1].getChargeType() == 3 || this.board[i2][j + 2].getChargeType() == 3 || this.board[i2][j + 3].getChargeType() == 3) {
                            int r;
                            for (r = 0; r < 8; ++r) {
                                this.setBlockAt(i2, r, new Piece("empty", false));
                            }
                            for (r = 0; r < 8; ++r) {
                                this.setBlockAt(r, j, new Piece("empty", false));
                            }
                            return 50;
                        }
                        if (this.board[i2][j].getChargeType() == 4 || this.board[i2][j + 1].getChargeType() == 4 || this.board[i2][j + 2].getChargeType() == 4 || this.board[i2][j + 3].getChargeType() == 4) {
                            for (int r = 0; r < 8; ++r) {
                                for (int t = 0; t < 8; ++t) {
                                    if (!this.board[r][t].getType().equalsIgnoreCase(this.board[i2][j].getType())) continue;
                                    this.setBlockAt(r, t, new Piece("empty", false));
                                }
                            }
                            return 60;
                        }
                        this.setBlockAt(i2, j, new Piece("empty", false));
                        this.setBlockAt(i2, j + 1, new Piece("empty", false));
                        this.setBlockAt(i2, j + 2, new Piece("empty", false));
                        this.setBlockAt(i2, j + 3, new Piece("empty", false));
                        if (this.board[this.x][this.y].getType().equalsIgnoreCase("empty")) {
                            this.createCharged(this.x, this.y, this.temp.getType(), 1);
                        }
                        if (this.board[this.w][this.z].getType().equalsIgnoreCase("empty")) {
                            this.createCharged(this.w, this.z, this.temp2.getType(), 1);
                        }
                        return 10;
                    }
                    if (this.board[i2][j].getChargeType() == 1 || this.board[i2][j + 1].getChargeType() == 1 || this.board[i2][j + 2].getChargeType() == 1) {
                        for (int r = 0; r < 8; ++r) {
                            this.setBlockAt(i2, r, new Piece("empty", false));
                        }
                        return 10;
                    }
                    if (this.board[i2][j].getChargeType() == 3 || this.board[i2][j + 1].getChargeType() == 3 || this.board[i2][j + 2].getChargeType() == 3) {
                        int r;
                        for (r = 0; r < 8; ++r) {
                            this.setBlockAt(i2, r, new Piece("empty", false));
                        }
                        for (r = 0; r < 8; ++r) {
                            this.setBlockAt(r, j, new Piece("empty", false));
                        }
                        return 50;
                    }
                    if (this.board[i2][j].getChargeType() == 4 || this.board[i2][j + 1].getChargeType() == 4 || this.board[i2][j + 2].getChargeType() == 4) {
                        for (int r = 0; r < 8; ++r) {
                            for (int t = 0; t < 8; ++t) {
                                if (!this.board[r][t].getType().equalsIgnoreCase(this.board[i2][j].getType())) continue;
                                this.setBlockAt(r, t, new Piece("empty", false));
                            }
                        }
                        return 60;
                    }
                    this.setBlockAt(i2, j, new Piece("empty", false));
                    this.setBlockAt(i2, j + 1, new Piece("empty", false));
                    this.setBlockAt(i2, j + 2, new Piece("empty", false));
                    return 5;
                }
                if (i2 + 1 >= 8 || !this.board[i2][j].getType().equalsIgnoreCase(this.board[i2 + 1][j].getType()) || i2 + 2 >= 8 || !this.board[i2][j].getType().equalsIgnoreCase(this.board[i2 + 2][j].getType())) continue;
                if (i2 + 3 < 8 && this.board[i2][j].getType().equalsIgnoreCase(this.board[i2 + 3][j].getType())) {
                    if (i2 + 4 < 8 && this.board[i2][j].getType().equalsIgnoreCase(this.board[i2 + 4][j].getType())) {
                        if (this.board[i2][j].getChargeType() == 2 || this.board[i2 + 1][j].getChargeType() == 2 || this.board[i2 + 2][j].getChargeType() == 2 || this.board[i2 + 3][j].getChargeType() == 2 || this.board[i2 + 4][j].getChargeType() == 2) {
                            for (int r = 0; r < 8; ++r) {
                                this.setBlockAt(r, j, new Piece("empty", false));
                            }
                            return 40;
                        }
                        if (this.board[i2][j].getChargeType() == 3 || this.board[i2 + 1][j].getChargeType() == 3 || this.board[i2 + 2][j].getChargeType() == 3 || this.board[i2 + 3][j].getChargeType() == 3 || this.board[i2 + 4][j].getChargeType() == 3) {
                            int r;
                            for (r = 0; r < 8; ++r) {
                                this.setBlockAt(r, j, new Piece("empty", false));
                            }
                            for (r = 0; r < 8; ++r) {
                                this.setBlockAt(i2, r, new Piece("empty", false));
                            }
                            return 50;
                        }
                        if (this.board[i2][j].getChargeType() == 4 || this.board[i2 + 1][j].getChargeType() == 4 || this.board[i2 + 2][j].getChargeType() == 4 || this.board[i2 + 3][j].getChargeType() == 4 || this.board[i2 + 4][j].getChargeType() == 4) {
                            for (int r = 0; r < 8; ++r) {
                                for (int t = 0; t < 8; ++t) {
                                    if (!this.board[r][t].getType().equalsIgnoreCase(this.board[i2][j].getType())) continue;
                                    this.setBlockAt(r, t, new Piece("empty", false));
                                }
                            }
                            return 60;
                        }
                        this.setBlockAt(i2, j, new Piece("empty", false));
                        this.setBlockAt(i2 + 1, j, new Piece("empty", false));
                        this.setBlockAt(i2 + 2, j, new Piece("empty", false));
                        this.setBlockAt(i2 + 3, j, new Piece("empty", false));
                        this.setBlockAt(i2 + 4, j, new Piece("empty", false));
                        if (this.board[this.x][this.y].getType().equalsIgnoreCase("empty")) {
                            this.createCharged(this.x, this.y, this.temp.getType(), 4);
                        }
                        if (this.board[this.w][this.z].getType().equalsIgnoreCase("empty")) {
                            this.createCharged(this.w, this.z, this.temp2.getType(), 4);
                        }
                        return 20;
                    }
                    if (this.board[i2][j].getChargeType() == 2 || this.board[i2 + 1][j].getChargeType() == 2 || this.board[i2 + 2][j].getChargeType() == 2 || this.board[i2 + 3][j].getChargeType() == 2) {
                        for (int r = 0; r < 8; ++r) {
                            this.setBlockAt(r, j, new Piece("empty", false));
                        }
                        return 20;
                    }
                    if (this.board[i2][j].getChargeType() == 3 || this.board[i2 + 1][j].getChargeType() == 3 || this.board[i2 + 2][j].getChargeType() == 3 || this.board[i2 + 3][j].getChargeType() == 3) {
                        int r;
                        for (r = 0; r < 8; ++r) {
                            this.setBlockAt(r, j, new Piece("empty", false));
                        }
                        for (r = 0; r < 8; ++r) {
                            this.setBlockAt(i2, r, new Piece("empty", false));
                        }
                        return 50;
                    }
                    if (this.board[i2][j].getChargeType() == 4 || this.board[i2 + 1][j].getChargeType() == 4 || this.board[i2 + 2][j].getChargeType() == 4 || this.board[i2 + 3][j].getChargeType() == 4) {
                        for (int r = 0; r < 8; ++r) {
                            for (int t = 0; t < 8; ++t) {
                                if (!this.board[r][t].getType().equalsIgnoreCase(this.board[i2][j].getType())) continue;
                                this.setBlockAt(r, t, new Piece("empty", false));
                            }
                        }
                        return 60;
                    }
                    this.setBlockAt(i2, j, new Piece("empty", false));
                    this.setBlockAt(i2 + 1, j, new Piece("empty", false));
                    this.setBlockAt(i2 + 2, j, new Piece("empty", false));
                    this.setBlockAt(i2 + 3, j, new Piece("empty", false));
                    if (this.board[this.x][this.y].getType().equalsIgnoreCase("empty")) {
                        this.createCharged(this.x, this.y, this.temp.getType(), 2);
                    }
                    if (this.board[this.w][this.z].getType().equalsIgnoreCase("empty")) {
                        this.createCharged(this.w, this.z, this.temp2.getType(), 2);
                    }
                    return 10;
                }
                if (this.board[i2][j].getChargeType() == 2 || this.board[i2 + 1][j].getChargeType() == 2 || this.board[i2 + 2][j].getChargeType() == 2) {
                    for (int r = 0; r < 8; ++r) {
                        this.setBlockAt(r, j, new Piece("empty", false));
                    }
                    return 10;
                }
                if (this.board[i2][j].getChargeType() == 3 || this.board[i2 + 1][j].getChargeType() == 3 || this.board[i2 + 2][j].getChargeType() == 3) {
                    int r;
                    for (r = 0; r < 8; ++r) {
                        this.setBlockAt(r, j, new Piece("empty", false));
                    }
                    for (r = 0; r < 8; ++r) {
                        this.setBlockAt(i2, r, new Piece("empty", false));
                    }
                    return 50;
                }
                if (this.board[i2][j].getChargeType() == 4 || this.board[i2 + 1][j].getChargeType() == 4 || this.board[i2 + 2][j].getChargeType() == 4) {
                    for (int r = 0; r < 8; ++r) {
                        for (int t = 0; t < 8; ++t) {
                            if (!this.board[r][t].getType().equalsIgnoreCase(this.board[i2][j].getType())) continue;
                            this.setBlockAt(r, t, new Piece("empty", false));
                        }
                    }
                    return 60;
                }
                this.setBlockAt(i2, j, new Piece("empty", false));
                this.setBlockAt(i2 + 1, j, new Piece("empty", false));
                this.setBlockAt(i2 + 2, j, new Piece("empty", false));
                return 5;
            }
        }
        this.temp = null;
        return 0;
    }

    public int checkForPlays() {
        for (int i2 = 0; i2 < 8; ++i2) {
            for (int j = 0; j < 8; ++j) {
                if (this.board[i2][j].getType().equalsIgnoreCase("empty")) continue;
                if (j + 1 < 8 && this.board[i2][j].getType().equalsIgnoreCase(this.board[i2][j + 1].getType()) && j + 2 < 8 && this.board[i2][j].getType().equalsIgnoreCase(this.board[i2][j + 2].getType())) {
                    if (j + 3 < 8 && this.board[i2][j].getType().equalsIgnoreCase(this.board[i2][j + 3].getType())) {
                        if (j + 4 < 8 && this.board[i2][j].getType().equalsIgnoreCase(this.board[i2][j + 4].getType())) {
                            return 20;
                        }
                        return 10;
                    }
                    return 5;
                }
                if (i2 + 1 >= 8 || !this.board[i2][j].getType().equalsIgnoreCase(this.board[i2 + 1][j].getType()) || i2 + 2 >= 8 || !this.board[i2][j].getType().equalsIgnoreCase(this.board[i2 + 2][j].getType())) continue;
                if (i2 + 3 < 8 && this.board[i2][j].getType().equalsIgnoreCase(this.board[i2 + 3][j].getType())) {
                    if (i2 + 4 < 8 && this.board[i2][j].getType().equalsIgnoreCase(this.board[i2 + 4][j].getType())) {
                        return 20;
                    }
                    return 10;
                }
                return 5;
            }
        }
        return 0;
    }

    public int checkPlays() {
        int plays = 0;
        for (int i2 = 0; i2 < 8; ++i2) {
            for (int j = 0; j < 8; ++j) {
                if (i2 == 0 && j == 0) {
                    this.doSwitch(i2 + 1, j, i2, j);
                    if (this.checkForPlays() != 0) {
                        this.doSwitch(i2 + 1, j, i2, j);
                        ++plays;
                    } else {
                        this.doSwitch(i2 + 1, j, i2, j);
                    }
                    this.doSwitch(i2, j + 1, i2, j);
                    if (this.checkForPlays() != 0) {
                        this.doSwitch(i2, j + 1, i2, j);
                        ++plays;
                        continue;
                    }
                    this.doSwitch(i2, j + 1, i2, j);
                    continue;
                }
                if (i2 == 7 && j == 7) {
                    this.doSwitch(i2 - 1, j, i2, j);
                    if (this.checkForPlays() != 0) {
                        this.doSwitch(i2 - 1, j, i2, j);
                        ++plays;
                    } else {
                        this.doSwitch(i2 - 1, j, i2, j);
                    }
                    this.doSwitch(i2, j - 1, i2, j);
                    if (this.checkForPlays() != 0) {
                        this.doSwitch(i2, j - 1, i2, j);
                        ++plays;
                        continue;
                    }
                    this.doSwitch(i2, j - 1, i2, j);
                    continue;
                }
                if (i2 == 0 && j == 7) {
                    this.doSwitch(i2 + 1, j, i2, j);
                    if (this.checkForPlays() != 0) {
                        this.doSwitch(i2 + 1, j, i2, j);
                        ++plays;
                    } else {
                        this.doSwitch(i2 + 1, j, i2, j);
                    }
                    this.doSwitch(i2, j - 1, i2, j);
                    if (this.checkForPlays() != 0) {
                        this.doSwitch(i2, j - 1, i2, j);
                        ++plays;
                        continue;
                    }
                    this.doSwitch(i2, j - 1, i2, j);
                    continue;
                }
                if (i2 == 7 && j == 0) {
                    this.doSwitch(i2 - 1, j, i2, j);
                    if (this.checkForPlays() != 0) {
                        this.doSwitch(i2 - 1, j, i2, j);
                        ++plays;
                    } else {
                        this.doSwitch(i2 - 1, j, i2, j);
                    }
                    this.doSwitch(i2, j + 1, i2, j);
                    if (this.checkForPlays() != 0) {
                        this.doSwitch(i2, j + 1, i2, j);
                        ++plays;
                        continue;
                    }
                    this.doSwitch(i2, j + 1, i2, j);
                    continue;
                }
                if (i2 == 0) {
                    this.doSwitch(i2 + 1, j, i2, j);
                    if (this.checkForPlays() != 0) {
                        this.doSwitch(i2 + 1, j, i2, j);
                        ++plays;
                    } else {
                        this.doSwitch(i2 + 1, j, i2, j);
                    }
                    this.doSwitch(i2, j - 1, i2, j);
                    if (this.checkForPlays() != 0) {
                        this.doSwitch(i2, j - 1, i2, j);
                        ++plays;
                    } else {
                        this.doSwitch(i2, j - 1, i2, j);
                    }
                    this.doSwitch(i2, j + 1, i2, j);
                    if (this.checkForPlays() != 0) {
                        this.doSwitch(i2, j + 1, i2, j);
                        ++plays;
                        continue;
                    }
                    this.doSwitch(i2, j + 1, i2, j);
                    continue;
                }
                if (i2 == 7) {
                    this.doSwitch(i2 - 1, j, i2, j);
                    if (this.checkForPlays() != 0) {
                        this.doSwitch(i2 - 1, j, i2, j);
                        ++plays;
                    } else {
                        this.doSwitch(i2 - 1, j, i2, j);
                    }
                    this.doSwitch(i2, j - 1, i2, j);
                    if (this.checkForPlays() != 0) {
                        this.doSwitch(i2, j - 1, i2, j);
                        ++plays;
                    } else {
                        this.doSwitch(i2, j - 1, i2, j);
                    }
                    this.doSwitch(i2, j + 1, i2, j);
                    if (this.checkForPlays() != 0) {
                        this.doSwitch(i2, j + 1, i2, j);
                        ++plays;
                        continue;
                    }
                    this.doSwitch(i2, j + 1, i2, j);
                    continue;
                }
                if (j == 0) {
                    this.doSwitch(i2 - 1, j, i2, j);
                    if (this.checkForPlays() != 0) {
                        this.doSwitch(i2 - 1, j, i2, j);
                        ++plays;
                    } else {
                        this.doSwitch(i2 - 1, j, i2, j);
                    }
                    this.doSwitch(i2 + 1, j, i2, j);
                    if (this.checkForPlays() != 0) {
                        this.doSwitch(i2 + 1, j, i2, j);
                        ++plays;
                    } else {
                        this.doSwitch(i2 + 1, j, i2, j);
                    }
                    this.doSwitch(i2, j + 1, i2, j);
                    if (this.checkForPlays() != 0) {
                        this.doSwitch(i2, j + 1, i2, j);
                        ++plays;
                        continue;
                    }
                    this.doSwitch(i2, j + 1, i2, j);
                    continue;
                }
                if (j == 7) {
                    this.doSwitch(i2 - 1, j, i2, j);
                    if (this.checkForPlays() != 0) {
                        this.doSwitch(i2 - 1, j, i2, j);
                        ++plays;
                    } else {
                        this.doSwitch(i2 - 1, j, i2, j);
                    }
                    this.doSwitch(i2 + 1, j, i2, j);
                    if (this.checkForPlays() != 0) {
                        this.doSwitch(i2 + 1, j, i2, j);
                        ++plays;
                    } else {
                        this.doSwitch(i2 + 1, j, i2, j);
                    }
                    this.doSwitch(i2, j - 1, i2, j);
                    if (this.checkForPlays() != 0) {
                        this.doSwitch(i2, j - 1, i2, j);
                        ++plays;
                        continue;
                    }
                    this.doSwitch(i2, j - 1, i2, j);
                    continue;
                }
                this.doSwitch(i2 - 1, j, i2, j);
                if (this.checkForPlays() != 0) {
                    this.doSwitch(i2 - 1, j, i2, j);
                    ++plays;
                } else {
                    this.doSwitch(i2 - 1, j, i2, j);
                }
                this.doSwitch(i2 + 1, j, i2, j);
                if (this.checkForPlays() != 0) {
                    this.doSwitch(i2 + 1, j, i2, j);
                    ++plays;
                } else {
                    this.doSwitch(i2 + 1, j, i2, j);
                }
                this.doSwitch(i2, j - 1, i2, j);
                if (this.checkForPlays() != 0) {
                    this.doSwitch(i2, j - 1, i2, j);
                    ++plays;
                } else {
                    this.doSwitch(i2, j - 1, i2, j);
                }
                this.doSwitch(i2, j + 1, i2, j);
                if (this.checkForPlays() != 0) {
                    this.doSwitch(i2, j + 1, i2, j);
                    ++plays;
                    continue;
                }
                this.doSwitch(i2, j + 1, i2, j);
            }
        }
        System.out.println(plays / 2 + "");
        return plays / 2;
    }

    public void createCharged(int xx, int yy, String type, int chargetype) {
        Piece newp;
        this.board[xx][yy] = newp = this.createChargedPiece(type, chargetype);
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int score) {
        this.score = score;
    }

    public String showScore() {
        return this.score + "";
    }

    public int getNumberOfColumns() {
        return this.width;
    }

    public int getNumberOfLines() {
        return this.height;
    }

    public void getBoard() {
        for (int i2 = 0; i2 < 8; ++i2) {
            for (int j = 0; j < 8; ++j) {
                System.out.print(this.board[i2][j].toString() + " ");
            }
            System.out.println("");
        }
    }

    public void fixBoard() {
        boolean empty = true;
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                if (this.board[x][y].getType() != "empty") continue;
                empty = true;
                while (empty) {
                    Piece piece = this.createPiece();
                    if (!this.isPieceInsertable(x, y, piece)) continue;
                    this.setBlockAt(x, y, piece);
                    empty = false;
                }
            }
        }
    }
}

