/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.tools.packulike;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class Sprite {
    private String name;
    private int x;
    private int y;
    private int width;
    private int height;
    private BufferedImage image;

    public Sprite(File file) throws IOException {
        this(file.getName(), ImageIO.read(file));
    }

    public Sprite(String name, BufferedImage image) {
        this.name = name;
        this.image = image;
        this.width = image.getWidth();
        this.height = image.getHeight();
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public String getName() {
        return this.name;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public boolean contains(int xp, int yp) {
        if (xp < this.x) {
            return false;
        }
        if (yp < this.y) {
            return false;
        }
        if (xp >= this.x + this.width) {
            return false;
        }
        return yp < this.y + this.height;
    }
}

