/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.tools.peditor;

import java.util.HashMap;
import org.newdawn.slick.particles.ConfigurableEmitter;
import org.newdawn.slick.tools.peditor.DefaultPanel;
import org.newdawn.slick.tools.peditor.InputPanelListener;
import org.newdawn.slick.tools.peditor.MinMaxPanel;
import org.newdawn.slick.tools.peditor.ValuePanel;

public abstract class ControlPanel
extends DefaultPanel
implements InputPanelListener {
    protected HashMap controlToData = new HashMap();
    protected HashMap named = new HashMap();
    protected ConfigurableEmitter emitter;
    protected int yPos;

    public ControlPanel() {
        this.setLayout(null);
    }

    protected void addValue(String name, ValuePanel valuePanel) {
        this.named.put(name, valuePanel);
        valuePanel.setBounds(0, 10 + this.yPos, 280, 63);
        valuePanel.addListener(this);
        this.add(valuePanel);
        this.yPos += 63;
    }

    protected void addMinMax(String name, MinMaxPanel minMax) {
        this.named.put(name, minMax);
        minMax.setBounds(0, 10 + this.yPos, 280, minMax.getOffset());
        minMax.addListener(this);
        this.add(minMax);
        this.yPos += minMax.getOffset();
    }

    public final void setTarget(ConfigurableEmitter emitter) {
        this.emitter = emitter;
        this.linkEmitterToFields(emitter);
    }

    protected abstract void linkEmitterToFields(ConfigurableEmitter var1);

    protected void link(ConfigurableEmitter.Range range, String name) {
        this.link(range, (MinMaxPanel)this.named.get(name));
    }

    protected void link(ConfigurableEmitter.Value value, String name) {
        this.link(value, (ValuePanel)this.named.get(name));
    }

    private void link(ConfigurableEmitter.Value value, ValuePanel panel) {
        this.controlToData.put(panel, value);
        if (value instanceof ConfigurableEmitter.SimpleValue) {
            panel.setValue((int)((ConfigurableEmitter.SimpleValue)value).getValue(0.0f));
        } else if (value instanceof ConfigurableEmitter.RandomValue) {
            panel.setValue((int)((ConfigurableEmitter.RandomValue)value).getValue());
        }
    }

    private void link(ConfigurableEmitter.Range range, MinMaxPanel panel) {
        this.controlToData.put(panel, range);
        panel.setMax((int)range.getMax());
        panel.setMin((int)range.getMin());
        panel.setEnabledValue(range.isEnabled());
    }

    public void minMaxUpdated(MinMaxPanel source) {
        if (this.emitter == null) {
            return;
        }
        ConfigurableEmitter.Range range = (ConfigurableEmitter.Range)this.controlToData.get(source);
        if (range == null) {
            throw new RuntimeException("No data set specified for the GUI source");
        }
        range.setMax(source.getMax());
        range.setMin(source.getMin());
        range.setEnabled(source.getEnabled());
    }

    public void valueUpdated(ValuePanel source) {
        if (this.emitter == null) {
            return;
        }
        ConfigurableEmitter.Value value = (ConfigurableEmitter.Value)this.controlToData.get(source);
        if (value != null) {
            if (value instanceof ConfigurableEmitter.SimpleValue) {
                ((ConfigurableEmitter.SimpleValue)value).setValue(source.getValue());
            } else if (value instanceof ConfigurableEmitter.RandomValue) {
                ((ConfigurableEmitter.RandomValue)value).setValue(source.getValue());
            }
        } else {
            throw new RuntimeException("No data set specified for the GUI source");
        }
    }
}

