/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.tools.peditor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.newdawn.slick.particles.ConfigurableEmitter;
import org.newdawn.slick.tools.peditor.ParticleEditor;

public class EmitterList
extends JPanel {
    private DefaultListModel emitters = new DefaultListModel();
    private JList list = new JList(this.emitters);
    private JButton add = new JButton("Add");
    private JButton remove = new JButton("Remove");
    private HashMap checks = new HashMap();
    private int lastSelect = -1;

    public EmitterList(final ParticleEditor editor) {
        this.setLayout(null);
        JScrollPane scroll = new JScrollPane(this.list);
        scroll.setBounds(5, 25, 285, 100);
        scroll.setBorder(BorderFactory.createEtchedBorder());
        this.add.setBounds(150, 125, 60, 20);
        this.remove.setBounds(209, 125, 80, 20);
        this.add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                editor.addEmitter(new ConfigurableEmitter("NewEmitter_" + System.currentTimeMillis()));
            }
        });
        this.remove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                ConfigurableEmitter emitter = (ConfigurableEmitter)EmitterList.this.list.getSelectedValue();
                if (emitter != null) {
                    editor.removeEmitter(emitter);
                }
            }
        });
        this.list.setCellRenderer(new Renderer());
        this.list.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e2) {
                int index = EmitterList.this.list.locationToIndex(e2.getPoint());
                if (index != -1 && EmitterList.this.list.getCellBounds(index, index).contains(e2.getPoint())) {
                    if (EmitterList.this.lastSelect == EmitterList.this.list.getSelectedIndex()) {
                        ConfigurableEmitter emitter = (ConfigurableEmitter)EmitterList.this.list.getModel().getElementAt(index);
                        JCheckBox box = (JCheckBox)EmitterList.this.checks.get(emitter);
                        emitter.setEnabled(!emitter.isEnabled());
                        box.setSelected(emitter.isEnabled());
                        EmitterList.this.repaint();
                    } else {
                        EmitterList.this.lastSelect = EmitterList.this.list.getSelectedIndex();
                    }
                }
            }
        });
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e2) {
                editor.setCurrentEmitter((ConfigurableEmitter)EmitterList.this.list.getSelectedValue());
            }
        });
        this.add(scroll);
        this.add(this.add);
        this.add(this.remove);
    }

    public void setSelected(ConfigurableEmitter emitter) {
        this.list.setSelectedValue(emitter, true);
    }

    public void setSelected(int index) {
        if (index < this.emitters.size()) {
            this.list.setSelectedIndex(index);
        }
    }

    public void update(ConfigurableEmitter emitter) {
        this.emitters.set(this.emitters.indexOf(emitter), emitter);
    }

    public void clear() {
        this.emitters.clear();
    }

    public void add(ConfigurableEmitter emitter) {
        this.emitters.addElement(emitter);
    }

    public void remove(ConfigurableEmitter emitter) {
        this.emitters.removeElement(emitter);
    }

    public class Renderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            JCheckBox box = new JCheckBox(label.getText());
            box.setBackground(label.getBackground());
            box.setSelected(((ConfigurableEmitter)value).isEnabled());
            EmitterList.this.checks.put(value, box);
            return box;
        }
    }
}

