/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.tools.packulike;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JPanel;
import org.newdawn.slick.tools.packulike.Packer;
import org.newdawn.slick.tools.packulike.Sheet;
import org.newdawn.slick.tools.packulike.Sprite;

public class SheetPanel
extends JPanel {
    private Image image;
    private TexturePaint background;
    private int width;
    private int height;
    private Sheet sheet;
    private Packer packer;
    private ArrayList selected = new ArrayList();

    public SheetPanel(Packer p) {
        this.packer = p;
        Color base = Color.gray;
        BufferedImage image = new BufferedImage(50, 50, 2);
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        g2.setColor(base);
        g2.fillRect(0, 0, image.getWidth(), image.getHeight());
        g2.setColor(base.darker());
        g2.fillRect(image.getWidth() / 2, 0, image.getWidth() / 2, image.getHeight() / 2);
        g2.fillRect(0, image.getHeight() / 2, image.getWidth() / 2, image.getHeight() / 2);
        this.background = new TexturePaint(image, new Rectangle(0, 0, image.getWidth(), image.getHeight()));
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e2) {
                Sprite sprite = SheetPanel.this.packer.getSpriteAt(e2.getX(), e2.getY());
                if (sprite != null) {
                    ArrayList<Sprite> selection = new ArrayList<Sprite>();
                    if ((e2.getModifiersEx() & 0x40) != 0) {
                        selection.addAll(SheetPanel.this.selected);
                    }
                    selection.add(sprite);
                    SheetPanel.this.packer.select(selection);
                }
            }
        });
    }

    public void setSelection(ArrayList sprites) {
        this.selected = sprites;
        this.repaint(0L);
    }

    public void setTextureSize(int width, int height) {
        this.setPreferredSize(new Dimension(width, height));
        this.setSize(new Dimension(width, height));
        this.width = width;
        this.height = height;
    }

    public void setImage(Sheet sheet) {
        this.sheet = sheet;
        this.image = sheet.getImage();
        this.repaint(0L);
    }

    public void paint(Graphics g1d) {
        Graphics2D g2 = (Graphics2D)g1d;
        g2.setPaint(this.background);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2.setColor(Color.yellow);
        g2.drawRect(0, 0, this.width, this.height);
        if (this.image != null) {
            g2.drawImage(this.image, 0, 0, null);
        }
        g2.setColor(Color.green);
        for (int i2 = 0; i2 < this.selected.size(); ++i2) {
            Sprite sprite = (Sprite)this.selected.get(i2);
            g2.drawRect(sprite.getX(), sprite.getY(), sprite.getWidth(), sprite.getHeight());
        }
    }
}

