/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.tools.peditor;

import org.newdawn.slick.particles.ConfigurableEmitter;
import org.newdawn.slick.tools.peditor.ControlPanel;
import org.newdawn.slick.tools.peditor.MinMaxPanel;
import org.newdawn.slick.tools.peditor.ValuePanel;

public class EmissionControls
extends ControlPanel {
    private MinMaxPanel initialSize;

    public EmissionControls() {
        this.setLayout(null);
        this.addMinMax("spawnInterval", new MinMaxPanel("Spawn Interval (ms)", 1, 100000, 100, 100, "The interval between the production of particles"));
        this.addMinMax("spawnCount", new MinMaxPanel("Spawn Count (# of particles)", 1, 100, 1, 1, "The number of particles created each spawn"));
        this.initialSize = new MinMaxPanel("Initial Size", 1, 100000, 1, 1, "The initial size of the produced particles");
        this.addMinMax("initialSize", this.initialSize);
        this.addMinMax("initialLife", new MinMaxPanel("Initial Life (ms)", 1, 100000, 1, 1, "The lifetime the particles will exist for in milliseconds"));
        this.addMinMax("speed", new MinMaxPanel("Particle Speed", -10000, 10000, 0, 0, "The speed at which the particles will come out of the emitter"));
        this.addValue("growth", new ValuePanel("Growth Factor", -200, 200, 0, "The amount and sign of the growth particles will undergo during their lifetime", false));
    }

    protected void linkEmitterToFields(ConfigurableEmitter emitter) {
        this.link(emitter.spawnInterval, "spawnInterval");
        this.link(emitter.spawnCount, "spawnCount");
        this.link(emitter.initialSize, "initialSize");
        this.link(emitter.initialLife, "initialLife");
        this.link(emitter.speed, "speed");
        this.link(emitter.growthFactor, "growth");
    }

    public MinMaxPanel getInitialSize() {
        return this.initialSize;
    }
}

