/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.tools.hiero;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

class Kerning {
    private Map values = Collections.EMPTY_MAP;
    private int size = -1;
    private int kerningPairCount = -1;
    private float scale;
    private long bytePosition;
    private long headOffset = -1L;
    private long kernOffset = -1L;

    Kerning() {
    }

    public void load(InputStream input, int size) throws IOException {
        this.size = size;
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null.");
        }
        this.readTableDirectory(input);
        if (this.headOffset == -1L) {
            throw new IOException("HEAD table not found.");
        }
        if (this.kernOffset == -1L) {
            this.values = Collections.EMPTY_MAP;
            return;
        }
        this.values = new HashMap(256);
        if (this.headOffset < this.kernOffset) {
            this.readHEAD(input);
            this.readKERN(input);
        } else {
            this.readKERN(input);
            this.readHEAD(input);
        }
        input.close();
        Iterator entryIter = this.values.entrySet().iterator();
        while (entryIter.hasNext()) {
            Map.Entry entry = entryIter.next();
            List valueList = (List)entry.getValue();
            ListIterator<Integer> valueIter = valueList.listIterator();
            while (valueIter.hasNext()) {
                int value = (Integer)valueIter.next();
                int glyphCode = value & 0xFFFF;
                int offset = value >> 16;
                if ((offset = Math.round((float)offset * this.scale)) == 0) {
                    valueIter.remove();
                    continue;
                }
                valueIter.set(new Integer(offset << 16 | glyphCode));
            }
            if (valueList.isEmpty()) {
                entryIter.remove();
                continue;
            }
            int[] valueArray = new int[valueList.size()];
            int i2 = 0;
            Iterator valueIter2 = valueList.iterator();
            while (valueIter2.hasNext()) {
                valueArray[i2] = (Integer)valueIter2.next();
                ++i2;
            }
            entry.setValue(valueArray);
            this.kerningPairCount += valueArray.length;
        }
    }

    public int[] getValues(int firstGlyphCode) {
        return (int[])this.values.get(new Integer(firstGlyphCode));
    }

    public int getKerning(int[] values, int otherGlyphCode) {
        int low = 0;
        int high = values.length - 1;
        while (low <= high) {
            int midIndex = low + high >>> 1;
            int value = values[midIndex];
            int foundGlyphCode = value & 0xFFFF;
            if (foundGlyphCode < otherGlyphCode) {
                low = midIndex + 1;
                continue;
            }
            if (foundGlyphCode > otherGlyphCode) {
                high = midIndex - 1;
                continue;
            }
            return value >> 16;
        }
        return 0;
    }

    public int getCount() {
        return this.kerningPairCount;
    }

    private void readTableDirectory(InputStream input) throws IOException {
        this.skip(input, 4L);
        int tableCount = this.readUnsignedShort(input);
        this.skip(input, 6L);
        byte[] tagBytes = new byte[4];
        for (int i2 = 0; i2 < tableCount; ++i2) {
            tagBytes[0] = this.readByte(input);
            tagBytes[1] = this.readByte(input);
            tagBytes[2] = this.readByte(input);
            tagBytes[3] = this.readByte(input);
            this.skip(input, 4L);
            long offset = this.readUnsignedLong(input);
            this.skip(input, 4L);
            String tag = new String(tagBytes, "ISO-8859-1");
            if (tag.equals("head")) {
                this.headOffset = offset;
                if (this.kernOffset == -1L) continue;
                break;
            }
            if (!tag.equals("kern")) continue;
            this.kernOffset = offset;
            if (this.headOffset != -1L) break;
        }
    }

    private void readHEAD(InputStream input) throws IOException {
        this.seek(input, this.headOffset + 8L + 8L + 2L);
        int unitsPerEm = this.readUnsignedShort(input);
        this.scale = (float)this.size / (float)unitsPerEm;
    }

    private void readKERN(InputStream input) throws IOException {
        this.seek(input, this.kernOffset + 2L);
        for (int subTableCount = this.readUnsignedShort(input); subTableCount > 0; --subTableCount) {
            this.skip(input, 4L);
            int tupleIndex = this.readUnsignedShort(input);
            if ((tupleIndex & 1) == 0 || (tupleIndex & 2) != 0 || (tupleIndex & 4) != 0) {
                return;
            }
            if (tupleIndex >> 8 != 0) continue;
            int kerningCount = this.readUnsignedShort(input);
            this.skip(input, 6L);
            while (kerningCount-- > 0) {
                int firstGlyphCode = this.readUnsignedShort(input);
                int secondGlyphCode = this.readUnsignedShort(input);
                short offset = this.readShort(input);
                int value = offset << 16 | secondGlyphCode;
                ArrayList<Integer> firstGlyphValues = (ArrayList<Integer>)this.values.get(new Integer(firstGlyphCode));
                if (firstGlyphValues == null) {
                    firstGlyphValues = new ArrayList<Integer>(256);
                    this.values.put(new Integer(firstGlyphCode), firstGlyphValues);
                }
                firstGlyphValues.add(new Integer(value));
            }
        }
    }

    private int readUnsignedByte(InputStream input) throws IOException {
        ++this.bytePosition;
        int b2 = input.read();
        if (b2 == -1) {
            throw new EOFException("Unexpected end of file.");
        }
        return b2;
    }

    private byte readByte(InputStream input) throws IOException {
        return (byte)this.readUnsignedByte(input);
    }

    private int readUnsignedShort(InputStream input) throws IOException {
        return (this.readUnsignedByte(input) << 8) + this.readUnsignedByte(input);
    }

    private short readShort(InputStream input) throws IOException {
        return (short)this.readUnsignedShort(input);
    }

    private long readUnsignedLong(InputStream input) throws IOException {
        long value = this.readUnsignedByte(input);
        value = (value << 8) + (long)this.readUnsignedByte(input);
        value = (value << 8) + (long)this.readUnsignedByte(input);
        value = (value << 8) + (long)this.readUnsignedByte(input);
        return value;
    }

    private void skip(InputStream input, long skip) throws IOException {
        long skipped;
        while (skip > 0L && (skipped = input.skip(skip)) > 0L) {
            this.bytePosition += skipped;
            skip -= skipped;
        }
    }

    private void seek(InputStream input, long position) throws IOException {
        this.skip(input, position - this.bytePosition);
    }
}

