/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.tools.scalar;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class ImagePanel
extends JPanel {
    private BufferedImage image;
    private TexturePaint background;

    public ImagePanel() {
        Color base = Color.gray;
        BufferedImage image = new BufferedImage(50, 50, 2);
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        g2.setColor(base);
        g2.fillRect(0, 0, image.getWidth(), image.getHeight());
        g2.setColor(base.darker());
        g2.fillRect(image.getWidth() / 2, 0, image.getWidth() / 2, image.getHeight() / 2);
        g2.fillRect(0, image.getHeight() / 2, image.getWidth() / 2, image.getHeight() / 2);
        this.background = new TexturePaint(image, new Rectangle(0, 0, image.getWidth(), image.getHeight()));
        this.setBackground(Color.black);
    }

    public void setImage(BufferedImage image) {
        this.image = image;
        this.setPreferredSize(new Dimension(image.getWidth(), image.getHeight()));
        this.setSize(new Dimension(image.getWidth(), image.getHeight()));
        this.getParent().repaint(0L);
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void paint(Graphics g1d) {
        Graphics2D g2 = (Graphics2D)g1d;
        super.paint(g2);
        g2.setPaint(this.background);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.image != null) {
            g2.drawImage((Image)this.image, 0, 0, null);
        }
    }
}

