/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.URLDecoder;
import org.newdawn.slick.Animation;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.UnicodeFont;
import org.newdawn.slick.font.effects.ColorEffect;
import org.newdawn.slick.gui.AbstractComponent;
import org.newdawn.slick.gui.ComponentListener;
import org.newdawn.slick.gui.TextField;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;
import org.newdawn.slick.state.transition.FadeInTransition;
import org.newdawn.slick.state.transition.FadeOutTransition;
import org.newdawn.slick.state.transition.Transition;
import test.Test;

public class InitScreen
extends BasicGameState
implements ComponentListener {
    private Image bg0 = null;
    private Image bg1 = null;
    private Image bg2 = null;
    private Image bg3 = null;
    private Image bg4 = null;
    private Image bg5 = null;
    private Image nameframe = null;
    private boolean sound = true;
    private Image[] background = new Image[0];
    private TextField text = null;
    private String name = "";
    private UnicodeFont font = null;
    private String fontpath = "data/fgh.ttf";
    private Transition inTransition = new FadeInTransition(new Color(0, 0, 0), 1000);
    private Transition outTransition = new FadeOutTransition(new Color(0, 0, 0), 1000);
    private Animation bgfinal = null;
    private boolean namesaved = false;
    private String path = "";
    private String decodedPath = "";
    int stateID = 0;

    public InitScreen(int stateID) {
        this.stateID = stateID;
    }

    @Override
    public int getID() {
        return this.stateID;
    }

    @Override
    public void init(GameContainer container, StateBasedGame game) throws SlickException {
        this.font = new UnicodeFont(this.fontpath, 20, true, false);
        this.font.addAsciiGlyphs();
        this.font.addGlyphs(400, 600);
        this.font.getEffects().add(new ColorEffect(java.awt.Color.WHITE));
        this.font.loadGlyphs();
        this.bg0 = new Image("data/bg0.png");
        this.bg1 = new Image("data/bg1.png");
        this.bg2 = new Image("data/bg2.png");
        this.bg3 = new Image("data/bg3.png");
        this.bg4 = new Image("data/bg4.png");
        this.bg5 = new Image("data/bg5.png");
        this.nameframe = new Image("data/name.png");
        this.background = new Image[]{this.bg0, this.bg1, this.bg2, this.bg3, this.bg4, this.bg5};
        this.bgfinal = new Animation(this.background, 500);
        this.text = new TextField(container, this.font, 480, 285, 200, 30, new ComponentListener(){

            @Override
            public void componentActivated(AbstractComponent source) {
                InitScreen.this.text.setFocus(true);
                InitScreen.this.name = InitScreen.this.text.getText();
                InitScreen.this.text.setFocus(false);
            }
        });
        this.text.setFocus(true);
        this.text.setMaxLength(10);
        this.text.setTextColor(Color.white);
        this.text.setBorderColor(Color.black);
        container.setShowFPS(false);
        this.namesaved = false;
        this.path = Test.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        try {
            this.decodedPath = URLDecoder.decode(this.path, "UTF-8");
        }
        catch (IOException error) {
            error.printStackTrace();
        }
        System.out.println(this.decodedPath);
    }

    @Override
    public void render(GameContainer container, StateBasedGame game, Graphics g2) throws SlickException {
        this.bgfinal.draw(0.0f, 0.0f);
        this.text.render(container, g2);
        this.nameframe.draw(0.0f, 0.0f);
        this.font.drawString(449.0f, 250.0f, "ENTER YOUR NAME");
        if (!this.name.equalsIgnoreCase("")) {
            this.font.drawString(510.0f, 325.0f, "SAVED");
        }
    }

    @Override
    public void update(GameContainer container, StateBasedGame game, int delta) throws SlickException {
        if (this.namesaved) {
            try {
                File file = new File(this.decodedPath + "name.dat");
                if (file.exists()) {
                    file.delete();
                    file.createNewFile();
                    this.writeToFile(this.name);
                } else if (!file.exists()) {
                    file.createNewFile();
                    this.writeToFile(this.name);
                }
            }
            catch (IOException error) {
                error.printStackTrace();
            }
            game.enterState(1, this.outTransition, this.inTransition);
            this.namesaved = false;
        }
    }

    @Override
    public void keyPressed(int key, char c2) {
        if (key == 28) {
            this.text.setAcceptingInput(false);
            this.namesaved = true;
        }
    }

    @Override
    public void componentActivated(AbstractComponent source) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void writeToFile(String name) {
        try {
            FileOutputStream fstream = new FileOutputStream(this.decodedPath + "name.dat");
            ObjectOutputStream objstream = new ObjectOutputStream(fstream);
            objstream.writeUTF(name);
            objstream.close();
        }
        catch (IOException error) {
            error.printStackTrace();
        }
    }
}

