/*
 * Decompiled with CFR 0.152.
 */
package com.tinyline.svg;

import com.tinyline.svg.ImageLoader;
import com.tinyline.svg.SVGNode;
import com.tinyline.svg.SVGPathElem;
import com.tinyline.svg.SVGRaster;
import com.tinyline.tiny2d.TinyBitmap;
import com.tinyline.tiny2d.TinyColor;
import com.tinyline.tiny2d.TinyMatrix;
import com.tinyline.tiny2d.TinyNumber;
import com.tinyline.tiny2d.TinyPath;
import com.tinyline.tiny2d.TinyRect;
import com.tinyline.tiny2d.TinyString;
import com.tinyline.tiny2d.TinyUtil;

public class SVGImageElem
extends SVGNode {
    public int x;
    public int y;
    public int width;
    public int height;
    public TinyString xlink_href;
    private SVGPathElem B;
    private TinyBitmap G;
    private TinyString H;
    private static ImageLoader C;
    private static TinyString E;
    private static TinyString D;
    private static final char[] F;
    private static final int[] I;

    SVGImageElem() {
        this.x = 0;
        this.y = 0;
        this.width = 0;
        this.height = 0;
        this.xlink_href = null;
        this.B = null;
        this.G = null;
        this.H = new TinyString("".toCharArray());
    }

    public SVGImageElem(SVGImageElem sVGImageElem) {
        super(sVGImageElem);
        this.x = sVGImageElem.x;
        this.y = sVGImageElem.y;
        this.width = sVGImageElem.width;
        this.height = sVGImageElem.height;
        if (sVGImageElem.xlink_href != null) {
            this.xlink_href = new TinyString(sVGImageElem.xlink_href.data);
        }
        this.B = null;
        this.G = sVGImageElem.G;
        this.H = new TinyString("".toCharArray());
    }

    public SVGNode copyNode() {
        return new SVGImageElem(this);
    }

    public static void setImageLoader(ImageLoader imageLoader) {
        C = imageLoader;
    }

    public int setAttribute(int n, Object object) throws Exception {
        this.outlined = false;
        switch (n) {
            case 109: {
                this.x = ((TinyNumber)object).val;
                break;
            }
            case 123: {
                this.y = ((TinyNumber)object).val;
                break;
            }
            case 107: {
                this.width = ((TinyNumber)object).val;
                break;
            }
            case 41: {
                this.height = ((TinyNumber)object).val;
                break;
            }
            case 115: {
                this.xlink_href = (TinyString)object;
                break;
            }
            default: {
                return super.setAttribute(n, object);
            }
        }
        return 0;
    }

    public Object getAttribute(int n) {
        int n2 = 0;
        TinyString tinyString = null;
        switch (n) {
            case 109: {
                n2 = this.x;
                break;
            }
            case 123: {
                n2 = this.y;
                break;
            }
            case 107: {
                n2 = this.width;
                break;
            }
            case 41: {
                n2 = this.height;
                break;
            }
            case 115: {
                tinyString = this.xlink_href;
                break;
            }
            default: {
                return super.getAttribute(n);
            }
        }
        if (tinyString != null) {
            return tinyString;
        }
        return new TinyNumber(n2);
    }

    public void paint(SVGRaster sVGRaster) {
        if (!this.isDisplay() || !this.isVisible()) {
            return;
        }
        if (!this.outlined) {
            this.createOutline();
        }
        this.B.paint(sVGRaster);
    }

    public TinyRect getBounds() {
        if (this.B == null) {
            return null;
        }
        return this.B.getBounds();
    }

    public TinyRect getDevBounds(SVGRaster sVGRaster) {
        if (this.B == null) {
            return null;
        }
        return this.B.getDevBounds(sVGRaster);
    }

    public int createOutline() {
        if (this.B == null) {
            this.B = (SVGPathElem)this.ownerDocument.createElement(23);
            this.B.path = new TinyPath(6);
            this.B.path.moveTo(0, 0);
            this.B.path.lineTo(25600, 0);
            this.B.path.lineTo(25600, 25600);
            this.B.path.lineTo(0, 25600);
            this.B.path.closePath();
            this.B.bounds = this.B.path.getBBox();
            this.B.outlined = true;
            this.B.fillRule = 22;
            this.B.fill = TinyColor.NONE;
            this.B.stroke = TinyColor.NONE;
        }
        if (this.children.indexOf(this.B, 0) == -1) {
            this.addChild(this.B, -1);
        }
        if (C == null || this.xlink_href == null) {
            return 2;
        }
        if (this.G == null || TinyString.compareTo(this.xlink_href.data, 0, this.xlink_href.count, this.H.data, 0, this.H.count) != 0) {
            this.G = null;
            if (this.xlink_href.startsWith(E, 0) || this.xlink_href.startsWith(D, 0)) {
                TinyString tinyString = new TinyString(this.xlink_href.data, SVGImageElem.D.count, this.xlink_href.count - SVGImageElem.D.count);
                byte[] byArray = SVGImageElem.a(tinyString.data);
                this.G = C.createTinyBitmap(byArray, 0, byArray.length);
                tinyString = null;
            } else {
                this.G = C.createTinyBitmap(this.xlink_href);
            }
            if (this.G == null || this.G.height <= 0 || this.G.width <= 0) {
                return 2;
            }
            this.H = new TinyString(this.xlink_href.data);
        }
        this.B.path.reset();
        this.B.path.moveTo(0, 0);
        this.B.path.lineTo(this.G.width << 8, 0);
        this.B.path.lineTo(this.G.width << 8, this.G.height << 8);
        this.B.path.lineTo(0, this.G.height << 8);
        this.B.path.closePath();
        this.B.bounds = this.B.path.getBBox();
        this.B.outlined = true;
        this.B.fillRule = 22;
        TinyColor tinyColor = new TinyColor(3, new TinyMatrix());
        tinyColor.bitmap = this.G;
        this.B.fill = tinyColor;
        TinyMatrix tinyMatrix = new TinyMatrix();
        int n = TinyUtil.div(this.width, this.G.width << 8);
        int n2 = TinyUtil.div(this.height, this.G.height << 8);
        int n3 = TinyUtil.min(n, n2);
        tinyMatrix.scale(n3, n3);
        TinyMatrix tinyMatrix2 = new TinyMatrix();
        tinyMatrix2.translate(this.x, this.y);
        tinyMatrix.concatenate(tinyMatrix2);
        this.B.transform.setMatrix(tinyMatrix);
        this.outlined = true;
        return 0;
    }

    static final byte[] a(char[] cArray) {
        int n;
        if (cArray == null || cArray.length == 0) {
            return new byte[0];
        }
        int n2 = cArray.length;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            n = cArray[n5];
            if (n == 61) {
                ++n3;
            }
            if (I[n] < 0) {
                ++n4;
            }
            ++n5;
        }
        int n6 = n2 - n4;
        if (n6 % 4 != 0) {
            return null;
        }
        n6 = (n6 * 6 >> 3) - n3;
        byte[] byArray = new byte[n6];
        int n7 = 0;
        int n8 = 0;
        while (n7 < n6) {
            n5 = 0;
            int n9 = 0;
            while (n9 < 4) {
                if ((n = I[cArray[n8++]]) >= 0) {
                    n5 |= n << 18 - n9 * 6;
                } else {
                    --n9;
                }
                ++n9;
            }
            byArray[n7++] = (byte)(n5 >> 16);
            if (n7 >= n6) continue;
            byArray[n7++] = (byte)(n5 >> 8);
            if (n7 >= n6) continue;
            byArray[n7++] = (byte)n5;
        }
        return byArray;
    }

    static {
        E = new TinyString("data:image/jpg;base64,".toCharArray());
        D = new TinyString("data:image/png;base64,".toCharArray());
        F = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
        I = new int[256];
        int n = 0;
        while (n < 256) {
            SVGImageElem.I[n] = -1;
            ++n;
        }
        n = 0;
        while (n < 64) {
            SVGImageElem.I[SVGImageElem.F[n]] = n;
            ++n;
        }
        SVGImageElem.I[61] = 0;
    }
}

