/*
 * Decompiled with CFR 0.152.
 */
package com.tinyline.tiny2d;

import com.tinyline.tiny2d.TinyPoint;
import com.tinyline.tiny2d.TinyRect;
import com.tinyline.tiny2d.TinyUtil;

public class TinyMatrix {
    public int a = 65536;
    public int b;
    public int c;
    public int d = 65536;
    public int tx;
    public int ty;

    public TinyMatrix() {
    }

    public TinyMatrix(TinyMatrix tinyMatrix) {
        this.a = tinyMatrix.a;
        this.b = tinyMatrix.b;
        this.c = tinyMatrix.c;
        this.d = tinyMatrix.d;
        this.tx = tinyMatrix.tx;
        this.ty = tinyMatrix.ty;
    }

    public final void reset() {
        this.a = 65536;
        this.d = 65536;
        this.ty = 0;
        this.tx = 0;
        this.c = 0;
        this.b = 0;
    }

    public final void concatenate(TinyMatrix tinyMatrix) {
        int n = 0;
        int n2 = 0;
        int n3 = TinyUtil.mul(this.a, tinyMatrix.a);
        int n4 = TinyUtil.mul(this.d, tinyMatrix.d);
        int n5 = TinyUtil.mul(this.tx, tinyMatrix.a) + tinyMatrix.tx;
        int n6 = TinyUtil.mul(this.ty, tinyMatrix.d) + tinyMatrix.ty;
        if (this.b != 0 || this.c != 0 || tinyMatrix.b != 0 || tinyMatrix.c != 0) {
            n3 += TinyUtil.mul(this.b, tinyMatrix.c);
            n4 += TinyUtil.mul(this.c, tinyMatrix.b);
            n += TinyUtil.mul(this.a, tinyMatrix.b) + TinyUtil.mul(this.b, tinyMatrix.d);
            n2 += TinyUtil.mul(this.c, tinyMatrix.a) + TinyUtil.mul(this.d, tinyMatrix.c);
            n5 += TinyUtil.mul(this.ty, tinyMatrix.c);
            n6 += TinyUtil.mul(this.tx, tinyMatrix.b);
        }
        this.a = n3;
        this.b = n;
        this.c = n2;
        this.d = n4;
        this.tx = n5;
        this.ty = n6;
    }

    public final void preConcatenate(TinyMatrix tinyMatrix) {
        int n = 0;
        int n2 = 0;
        int n3 = TinyUtil.mul(tinyMatrix.a, this.a);
        int n4 = TinyUtil.mul(tinyMatrix.d, this.d);
        int n5 = TinyUtil.mul(tinyMatrix.tx, this.a) + this.tx;
        int n6 = TinyUtil.mul(tinyMatrix.ty, this.d) + this.ty;
        if (tinyMatrix.b != 0 || tinyMatrix.c != 0 || this.b != 0 || this.c != 0) {
            n3 += TinyUtil.mul(tinyMatrix.b, this.c);
            n4 += TinyUtil.mul(tinyMatrix.c, this.b);
            n += TinyUtil.mul(tinyMatrix.a, this.b) + TinyUtil.mul(tinyMatrix.b, this.d);
            n2 += TinyUtil.mul(tinyMatrix.c, this.a) + TinyUtil.mul(tinyMatrix.d, this.c);
            n5 += TinyUtil.mul(tinyMatrix.ty, this.c);
            n6 += TinyUtil.mul(tinyMatrix.tx, this.b);
        }
        this.a = n3;
        this.b = n;
        this.c = n2;
        this.d = n4;
        this.tx = n5;
        this.ty = n6;
    }

    public final TinyMatrix inverse() {
        TinyMatrix tinyMatrix = new TinyMatrix();
        TinyPoint tinyPoint = new TinyPoint();
        if (this.b == 0 && this.c == 0) {
            tinyMatrix.a = TinyUtil.div(65536, this.a);
            tinyMatrix.d = TinyUtil.div(65536, this.d);
            tinyMatrix.tx = -TinyUtil.mul(tinyMatrix.a, this.tx);
            tinyMatrix.ty = -TinyUtil.mul(tinyMatrix.d, this.ty);
        } else {
            int n = TinyUtil.div(this.a, 65536);
            int n2 = TinyUtil.div(this.b, 65536);
            int n3 = TinyUtil.div(this.c, 65536);
            int n4 = TinyUtil.div(this.d, 65536);
            int n5 = TinyUtil.mul(n, n4) - TinyUtil.mul(n2, n3);
            if (n5 != 0) {
                tinyMatrix.a = TinyUtil.div(this.d, n5);
                tinyMatrix.b = -TinyUtil.div(this.b, n5);
                tinyMatrix.c = -TinyUtil.div(this.c, n5);
                tinyMatrix.d = TinyUtil.div(this.a, n5);
                tinyPoint.x = this.tx;
                tinyPoint.y = this.ty;
                tinyMatrix.a(tinyPoint);
                tinyMatrix.tx = -tinyPoint.x;
                tinyMatrix.ty = -tinyPoint.y;
            }
        }
        return tinyMatrix;
    }

    public final void translate(int n, int n2) {
        this.a = 65536;
        this.d = 65536;
        this.c = 0;
        this.b = 0;
        this.tx = n;
        this.ty = n2;
    }

    public final void scale(int n, int n2) {
        this.a = n;
        this.d = n2;
        this.c = 0;
        this.b = 0;
        this.ty = 0;
        this.tx = 0;
    }

    public final void rotate(int n, int n2, int n3) {
        this.a = TinyUtil.cos(n);
        this.b = TinyUtil.sin(n);
        this.c = -this.b;
        this.d = this.a;
        this.tx = n2 - TinyUtil.mul(this.a, n2) + TinyUtil.mul(this.b, n3);
        this.ty = n3 - TinyUtil.mul(this.b, n2) - TinyUtil.mul(this.a, n3);
    }

    public void skew(int n, int n2) {
        this.a = 65536;
        this.d = 65536;
        this.ty = 0;
        this.tx = 0;
        this.b = TinyUtil.tan(n2);
        this.c = TinyUtil.tan(n);
    }

    private final void a(TinyPoint tinyPoint) {
        int n = TinyUtil.mul(this.a, tinyPoint.x);
        if (this.c != 0) {
            n += TinyUtil.mul(this.c, tinyPoint.y);
        }
        int n2 = TinyUtil.mul(this.d, tinyPoint.y);
        if (this.b != 0) {
            n2 += TinyUtil.mul(this.b, tinyPoint.x);
        }
        tinyPoint.x = n;
        tinyPoint.y = n2;
    }

    public final void transform(TinyPoint tinyPoint) {
        int n = TinyUtil.mul(this.a, tinyPoint.x) + this.tx;
        if (this.c != 0) {
            n += TinyUtil.mul(this.c, tinyPoint.y);
        }
        int n2 = TinyUtil.mul(this.d, tinyPoint.y) + this.ty;
        if (this.b != 0) {
            n2 += TinyUtil.mul(this.b, tinyPoint.x);
        }
        tinyPoint.x = n;
        tinyPoint.y = n2;
    }

    public final void transformToDev(TinyPoint tinyPoint, TinyPoint tinyPoint2) {
        int n = TinyUtil.mul(this.a, tinyPoint.x) + this.tx;
        if (this.c != 0) {
            n += TinyUtil.mul(this.c, tinyPoint.y);
        }
        int n2 = TinyUtil.mul(this.d, tinyPoint.y) + this.ty;
        if (this.b != 0) {
            n2 += TinyUtil.mul(this.b, tinyPoint.x);
        }
        n = n < 0 ? (n -= 128) : (n += 128);
        n2 = n2 < 0 ? (n2 -= 128) : (n2 += 128);
        tinyPoint2.x = n >> 8;
        tinyPoint2.y = n2 >> 8;
    }

    public final TinyRect transformToDev(TinyRect tinyRect) {
        TinyRect tinyRect2 = new TinyRect();
        TinyPoint tinyPoint = new TinyPoint();
        TinyPoint tinyPoint2 = new TinyPoint();
        if (!tinyRect.isEmpty()) {
            tinyPoint.x = tinyRect.xmin;
            tinyPoint.y = tinyRect.ymin;
            tinyPoint2.x = 0;
            tinyPoint2.y = 0;
            this.transformToDev(tinyPoint, tinyPoint2);
            tinyRect2.add(tinyPoint2);
            tinyPoint.x = tinyRect.xmax;
            this.transformToDev(tinyPoint, tinyPoint2);
            tinyRect2.add(tinyPoint2);
            tinyPoint.y = tinyRect.ymax;
            this.transformToDev(tinyPoint, tinyPoint2);
            tinyRect2.add(tinyPoint2);
            tinyPoint.x = tinyRect.xmin;
            this.transformToDev(tinyPoint, tinyPoint2);
            tinyRect2.add(tinyPoint2);
        }
        return tinyRect2;
    }

    int a(int n) {
        TinyPoint tinyPoint = new TinyPoint();
        TinyPoint tinyPoint2 = new TinyPoint();
        TinyPoint tinyPoint3 = new TinyPoint();
        tinyPoint.y = 0;
        tinyPoint.x = 0;
        this.a(tinyPoint);
        tinyPoint2.x = n;
        tinyPoint2.y = 0;
        this.a(tinyPoint2);
        tinyPoint3.x = 0;
        tinyPoint3.y = n;
        this.a(tinyPoint3);
        int n2 = TinyUtil.max(tinyPoint.distance(tinyPoint2), tinyPoint.distance(tinyPoint3));
        return n2;
    }
}

