/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.tools.hiero;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.newdawn.slick.BasicGame;
import org.newdawn.slick.CanvasGameContainer;
import org.newdawn.slick.Color;
import org.newdawn.slick.Game;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Input;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.UnicodeFont;
import org.newdawn.slick.font.GlyphPage;
import org.newdawn.slick.font.HieroSettings;
import org.newdawn.slick.font.effects.ColorEffect;
import org.newdawn.slick.font.effects.ConfigurableEffect;
import org.newdawn.slick.font.effects.EffectUtil;
import org.newdawn.slick.font.effects.GradientEffect;
import org.newdawn.slick.font.effects.OutlineEffect;
import org.newdawn.slick.font.effects.OutlineWobbleEffect;
import org.newdawn.slick.font.effects.OutlineZigzagEffect;
import org.newdawn.slick.font.effects.ShadowEffect;
import org.newdawn.slick.tools.hiero.BMFontUtil;
import org.newdawn.slick.util.Log;

public class Hiero
extends JFrame {
    static final String NEHE = "ABCDEFGHIJKLMNOPQRSTUVWXYZ\nabcdefghijklmnopqrstuvwxyz\n1234567890\n\"!`?'.,;:()[]{}<>|/@\\^$-%+=#_&~*\u007f";
    Game game;
    CanvasGameContainer canvasContainer;
    volatile UnicodeFont newUnicodeFont;
    UnicodeFont unicodeFont;
    Color renderingBackgroundColor = Color.black;
    List effectPanels = new ArrayList();
    Preferences prefs;
    ColorEffect colorEffect;
    JScrollPane appliedEffectsScroll;
    JPanel appliedEffectsPanel;
    JButton addEffectButton;
    JTextPane sampleTextPane;
    JSpinner padAdvanceXSpinner;
    JList effectsList;
    JPanel gamePanel;
    JTextField fontFileText;
    JRadioButton fontFileRadio;
    JRadioButton systemFontRadio;
    JSpinner padBottomSpinner;
    JSpinner padLeftSpinner;
    JSpinner padRightSpinner;
    JSpinner padTopSpinner;
    JList fontList;
    JSpinner fontSizeSpinner;
    DefaultComboBoxModel fontListModel;
    JLabel backgroundColorLabel;
    JButton browseButton;
    JSpinner padAdvanceYSpinner;
    JCheckBox italicCheckBox;
    JCheckBox boldCheckBox;
    JLabel glyphsTotalLabel;
    JLabel glyphPagesTotalLabel;
    JComboBox glyphPageHeightCombo;
    JComboBox glyphPageWidthCombo;
    JComboBox glyphPageCombo;
    JPanel glyphCachePanel;
    JRadioButton glyphCacheRadio;
    JRadioButton sampleTextRadio;
    DefaultComboBoxModel glyphPageComboModel;
    JButton resetCacheButton;
    JButton sampleAsciiButton;
    JButton sampleNeheButton;
    DefaultComboBoxModel effectsListModel;
    JMenuItem openMenuItem;
    JMenuItem saveMenuItem;
    JMenuItem exitMenuItem;
    JMenuItem saveBMFontMenuItem;
    File saveBmFontFile;
    static /* synthetic */ Class class$org$newdawn$slick$tools$hiero$Hiero$Splash;

    public Hiero() throws SlickException {
        super("Hiero v2.0 - Bitmap Font Tool");
        Splash splash = new Splash(this, "splash.jpg", 2000);
        try {
            this.initialize();
        }
        catch (SlickException ex) {
            this.dispose();
            throw ex;
        }
        splash.close();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e2) {
                System.exit(0);
            }

            public void windowClosing(WindowEvent e2) {
                System.exit(0);
            }
        });
        this.prefs = Preferences.userNodeForPackage(Hiero.class);
        java.awt.Color backgroundColor = EffectUtil.fromString(this.prefs.get("background", "000000"));
        this.backgroundColorLabel.setIcon(Hiero.getColorIcon(backgroundColor));
        this.renderingBackgroundColor = new Color(backgroundColor.getRed(), backgroundColor.getGreen(), backgroundColor.getBlue());
        this.fontList.setSelectedValue(this.prefs.get("system.font", "Arial"), true);
        this.fontFileText.setText(this.prefs.get("font.file", ""));
        java.awt.Color foregroundColor = EffectUtil.fromString(this.prefs.get("foreground", "ffffff"));
        this.colorEffect = new ColorEffect();
        this.colorEffect.setColor(foregroundColor);
        this.effectsListModel.addElement(this.colorEffect);
        this.effectsListModel.addElement(new GradientEffect());
        this.effectsListModel.addElement(new OutlineEffect());
        this.effectsListModel.addElement(new OutlineWobbleEffect());
        this.effectsListModel.addElement(new OutlineZigzagEffect());
        this.effectsListModel.addElement(new ShadowEffect());
        new EffectPanel(this.colorEffect);
        this.setVisible(true);
        this.gamePanel.add(this.canvasContainer);
        this.gamePanel.setVisible(false);
        this.canvasContainer.start();
    }

    void initialize() throws SlickException {
        this.initializeComponents();
        this.initializeMenus();
        this.initializeEvents();
        this.setSize(800, 600);
        this.setLocationRelativeTo(null);
        Input.disableControllers();
        this.sampleNeheButton.doClick();
        this.game = new BasicGame("Hiero"){
            String sampleText;

            public void init(GameContainer container) throws SlickException {
                container.setShowFPS(false);
                container.setVerbose(false);
                container.setTargetFrameRate(60);
                container.setClearEachFrame(false);
                container.setAlwaysRender(true);
                Hiero.this.gamePanel.setVisible(true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void update(GameContainer container, int delta) throws SlickException {
                if (Hiero.this.newUnicodeFont != null) {
                    if (Hiero.this.unicodeFont != null) {
                        Hiero.this.unicodeFont.destroy();
                    }
                    Hiero.this.unicodeFont = Hiero.this.newUnicodeFont;
                    Hiero.this.newUnicodeFont = null;
                }
                if (Hiero.this.unicodeFont.loadGlyphs(25)) {
                    Hiero.this.glyphPageComboModel.removeAllElements();
                    int pageCount = Hiero.this.unicodeFont.getGlyphPages().size();
                    int glyphCount = 0;
                    for (int i2 = 0; i2 < pageCount; ++i2) {
                        Hiero.this.glyphPageComboModel.addElement("Page " + (i2 + 1));
                        glyphCount += ((GlyphPage)Hiero.this.unicodeFont.getGlyphPages().get(i2)).getGlyphs().size();
                    }
                    Hiero.this.glyphPagesTotalLabel.setText(String.valueOf(pageCount));
                    Hiero.this.glyphsTotalLabel.setText(String.valueOf(glyphCount));
                }
                if (Hiero.this.saveBmFontFile != null) {
                    try {
                        BMFontUtil bmFont = new BMFontUtil(Hiero.this.unicodeFont);
                        bmFont.save(Hiero.this.saveBmFontFile);
                    }
                    catch (Exception ex) {
                        Log.error("Error saving BMFont files: " + Hiero.this.saveBmFontFile.getAbsolutePath(), ex);
                    }
                    finally {
                        Hiero.this.saveBmFontFile = null;
                    }
                }
            }

            public void render(GameContainer container, Graphics g2) throws SlickException {
                if (Hiero.this.unicodeFont == null) {
                    return;
                }
                try {
                    this.sampleText = Hiero.this.sampleTextPane.getText();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (Hiero.this.sampleTextRadio.isSelected()) {
                    g2.setBackground(Hiero.this.renderingBackgroundColor);
                    g2.clear();
                    int offset = Hiero.this.unicodeFont.getYOffset(this.sampleText);
                    if (offset > 0) {
                        offset = 0;
                    }
                    Hiero.this.unicodeFont.drawString(0.0f, -offset, this.sampleText, Color.white, 0, this.sampleText.length());
                } else {
                    g2.setBackground(Color.white);
                    g2.clear();
                    Hiero.this.unicodeFont.addGlyphs(this.sampleText);
                    g2.setColor(Hiero.this.renderingBackgroundColor);
                    g2.fillRect(0.0f, 0.0f, Hiero.this.unicodeFont.getGlyphPageWidth() + 2, Hiero.this.unicodeFont.getGlyphPageHeight() + 2);
                    int index = Hiero.this.glyphPageCombo.getSelectedIndex();
                    List pages = Hiero.this.unicodeFont.getGlyphPages();
                    if (index >= 0 && index < pages.size()) {
                        ((GlyphPage)pages.get(Hiero.this.glyphPageCombo.getSelectedIndex())).getImage().draw(1.0f, 1.0f);
                    }
                }
            }
        };
        this.canvasContainer = new CanvasGameContainer(this.game){

            public int getWidth() {
                int width = super.getWidth();
                return width <= 0 ? 1 : width;
            }

            public int getHeight() {
                int height = super.getHeight();
                return height <= 0 ? 1 : height;
            }
        };
    }

    private void updateFont() {
        this.updateFont(false);
    }

    private void updateFont(boolean ignoreFileText) {
        UnicodeFont unicodeFont;
        int fontSize = (Integer)this.fontSizeSpinner.getValue();
        File file = new File(this.fontFileText.getText());
        if (!ignoreFileText && file.exists() && file.isFile()) {
            this.fontFileRadio.setSelected(true);
            this.fontList.setEnabled(false);
            this.systemFontRadio.setEnabled(false);
            try {
                unicodeFont = new UnicodeFont(this.fontFileText.getText(), fontSize, this.boldCheckBox.isSelected(), this.italicCheckBox.isSelected());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.updateFont(true);
                return;
            }
        } else {
            this.fontList.setEnabled(true);
            this.systemFontRadio.setEnabled(true);
            this.systemFontRadio.setSelected(true);
            unicodeFont = new UnicodeFont(Font.decode((String)this.fontList.getSelectedValue()), fontSize, this.boldCheckBox.isSelected(), this.italicCheckBox.isSelected());
        }
        unicodeFont.setPaddingTop((Integer)this.padTopSpinner.getValue());
        unicodeFont.setPaddingRight((Integer)this.padRightSpinner.getValue());
        unicodeFont.setPaddingBottom((Integer)this.padBottomSpinner.getValue());
        unicodeFont.setPaddingLeft((Integer)this.padLeftSpinner.getValue());
        unicodeFont.setPaddingAdvanceX((Integer)this.padAdvanceXSpinner.getValue());
        unicodeFont.setPaddingAdvanceY((Integer)this.padAdvanceYSpinner.getValue());
        unicodeFont.setGlyphPageWidth((Integer)this.glyphPageWidthCombo.getSelectedItem());
        unicodeFont.setGlyphPageHeight((Integer)this.glyphPageHeightCombo.getSelectedItem());
        Iterator iter = this.effectPanels.iterator();
        while (iter.hasNext()) {
            EffectPanel panel = (EffectPanel)iter.next();
            unicodeFont.getEffects().add(panel.getEffect());
        }
        int size = this.sampleTextPane.getFont().getSize();
        if (size < 14) {
            size = 14;
        }
        this.sampleTextPane.setFont(unicodeFont.getFont().deriveFont((float)size));
        this.newUnicodeFont = unicodeFont;
    }

    void save(File file) throws IOException {
        HieroSettings settings = new HieroSettings();
        settings.setFontSize((Integer)this.fontSizeSpinner.getValue());
        settings.setBold(this.boldCheckBox.isSelected());
        settings.setItalic(this.italicCheckBox.isSelected());
        settings.setPaddingTop((Integer)this.padTopSpinner.getValue());
        settings.setPaddingRight((Integer)this.padRightSpinner.getValue());
        settings.setPaddingBottom((Integer)this.padBottomSpinner.getValue());
        settings.setPaddingLeft((Integer)this.padLeftSpinner.getValue());
        settings.setPaddingAdvanceX((Integer)this.padAdvanceXSpinner.getValue());
        settings.setPaddingAdvanceY((Integer)this.padAdvanceYSpinner.getValue());
        settings.setGlyphPageWidth((Integer)this.glyphPageWidthCombo.getSelectedItem());
        settings.setGlyphPageHeight((Integer)this.glyphPageHeightCombo.getSelectedItem());
        Iterator iter = this.effectPanels.iterator();
        while (iter.hasNext()) {
            EffectPanel panel = (EffectPanel)iter.next();
            settings.getEffects().add(panel.getEffect());
        }
        settings.save(file);
    }

    void open(File file) throws SlickException {
        EffectPanel[] panels = this.effectPanels.toArray(new EffectPanel[this.effectPanels.size()]);
        for (int i2 = 0; i2 < panels.length; ++i2) {
            panels[i2].remove();
        }
        HieroSettings settings = new HieroSettings(file.getAbsolutePath());
        this.fontSizeSpinner.setValue(new Integer(settings.getFontSize()));
        this.boldCheckBox.setSelected(settings.isBold());
        this.italicCheckBox.setSelected(settings.isItalic());
        this.padTopSpinner.setValue(new Integer(settings.getPaddingTop()));
        this.padRightSpinner.setValue(new Integer(settings.getPaddingRight()));
        this.padBottomSpinner.setValue(new Integer(settings.getPaddingBottom()));
        this.padLeftSpinner.setValue(new Integer(settings.getPaddingLeft()));
        this.padAdvanceXSpinner.setValue(new Integer(settings.getPaddingAdvanceX()));
        this.padAdvanceYSpinner.setValue(new Integer(settings.getPaddingAdvanceY()));
        this.glyphPageWidthCombo.setSelectedItem(new Integer(settings.getGlyphPageWidth()));
        this.glyphPageHeightCombo.setSelectedItem(new Integer(settings.getGlyphPageHeight()));
        Iterator iter = settings.getEffects().iterator();
        block1: while (iter.hasNext()) {
            ConfigurableEffect settingsEffect = (ConfigurableEffect)iter.next();
            int n = this.effectsListModel.getSize();
            for (int i3 = 0; i3 < n; ++i3) {
                ConfigurableEffect effect = (ConfigurableEffect)this.effectsListModel.getElementAt(i3);
                if (effect.getClass() != settingsEffect.getClass()) continue;
                effect.setValues(settingsEffect.getValues());
                new EffectPanel(effect);
                continue block1;
            }
        }
        this.updateFont();
    }

    private void initializeEvents() {
        this.fontList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                if (evt.getValueIsAdjusting()) {
                    return;
                }
                Hiero.this.prefs.put("system.font", (String)Hiero.this.fontList.getSelectedValue());
                Hiero.this.updateFont();
            }
        });
        class FontUpdateListener
        implements ChangeListener,
        ActionListener {
            FontUpdateListener() {
            }

            public void stateChanged(ChangeEvent evt) {
                Hiero.this.updateFont();
            }

            public void actionPerformed(ActionEvent evt) {
                Hiero.this.updateFont();
            }

            public void addSpinners(JSpinner[] spinners) {
                for (int i2 = 0; i2 < spinners.length; ++i2) {
                    final JSpinner spinner = spinners[i2];
                    spinner.addChangeListener(this);
                    ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField().addKeyListener(new KeyAdapter(){
                        String lastText;

                        public void keyReleased(KeyEvent evt) {
                            JFormattedTextField textField = ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField();
                            String text = textField.getText();
                            if (text.length() == 0) {
                                return;
                            }
                            if (text.equals(this.lastText)) {
                                return;
                            }
                            this.lastText = text;
                            int caretPosition = textField.getCaretPosition();
                            try {
                                spinner.setValue(Integer.valueOf(text));
                                textField.setCaretPosition(caretPosition);
                            }
                            catch (Exception ignored) {
                                // empty catch block
                            }
                        }
                    });
                }
            }
        }
        FontUpdateListener listener = new FontUpdateListener();
        listener.addSpinners(new JSpinner[]{this.padTopSpinner, this.padRightSpinner, this.padBottomSpinner, this.padLeftSpinner, this.padAdvanceXSpinner, this.padAdvanceYSpinner});
        this.fontSizeSpinner.addChangeListener(listener);
        this.glyphPageWidthCombo.addActionListener(listener);
        this.glyphPageHeightCombo.addActionListener(listener);
        this.boldCheckBox.addActionListener(listener);
        this.italicCheckBox.addActionListener(listener);
        this.resetCacheButton.addActionListener(listener);
        this.sampleTextRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Hiero.this.glyphCachePanel.setVisible(false);
            }
        });
        this.glyphCacheRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Hiero.this.glyphCachePanel.setVisible(true);
            }
        });
        this.fontFileText.getDocument().addDocumentListener(new DocumentListener(){

            public void removeUpdate(DocumentEvent evt) {
                this.changed();
            }

            public void insertUpdate(DocumentEvent evt) {
                this.changed();
            }

            public void changedUpdate(DocumentEvent evt) {
                this.changed();
            }

            private void changed() {
                File file = new File(Hiero.this.fontFileText.getText());
                if (!(!Hiero.this.fontList.isEnabled() || file.exists() && file.isFile())) {
                    return;
                }
                Hiero.this.prefs.put("font.file", Hiero.this.fontFileText.getText());
                Hiero.this.updateFont();
            }
        });
        this.fontFileRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (Hiero.this.fontList.isEnabled()) {
                    Hiero.this.systemFontRadio.setSelected(true);
                }
            }
        });
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileDialog dialog = new FileDialog((Frame)Hiero.this, "Choose TrueType font file", 0);
                dialog.setLocationRelativeTo(null);
                dialog.setFile("*.ttf");
                dialog.setVisible(true);
                String fileName = dialog.getFile();
                if (fileName == null) {
                    return;
                }
                Hiero.this.fontFileText.setText(new File(dialog.getDirectory(), fileName).getAbsolutePath());
            }
        });
        this.backgroundColorLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                java.awt.Color color = JColorChooser.showDialog(null, "Choose a background color", EffectUtil.fromString(Hiero.this.prefs.get("background", "000000")));
                if (color == null) {
                    return;
                }
                Hiero.this.renderingBackgroundColor = new Color(color.getRed(), color.getGreen(), color.getBlue());
                Hiero.this.backgroundColorLabel.setIcon(Hiero.getColorIcon(color));
                Hiero.this.prefs.put("background", EffectUtil.toString(color));
            }
        });
        this.effectsList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                ConfigurableEffect selectedEffect = (ConfigurableEffect)Hiero.this.effectsList.getSelectedValue();
                boolean enabled = selectedEffect != null;
                Iterator iter = Hiero.this.effectPanels.iterator();
                while (iter.hasNext()) {
                    ConfigurableEffect effect = ((EffectPanel)iter.next()).getEffect();
                    if (effect != selectedEffect) continue;
                    enabled = false;
                    break;
                }
                Hiero.this.addEffectButton.setEnabled(enabled);
            }
        });
        this.effectsList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2 && Hiero.this.addEffectButton.isEnabled()) {
                    Hiero.this.addEffectButton.doClick();
                }
            }
        });
        this.addEffectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                new EffectPanel((ConfigurableEffect)Hiero.this.effectsList.getSelectedValue());
            }
        });
        this.openMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileDialog dialog = new FileDialog((Frame)Hiero.this, "Open Hiero settings file", 0);
                dialog.setLocationRelativeTo(null);
                dialog.setFile("*.hiero");
                dialog.setVisible(true);
                String fileName = dialog.getFile();
                if (fileName == null) {
                    return;
                }
                File file = new File(dialog.getDirectory(), fileName);
                try {
                    Hiero.this.open(file);
                }
                catch (SlickException ex) {
                    throw new RuntimeException("Error opening Hiero settings file: " + file.getAbsolutePath(), ex);
                }
            }
        });
        this.saveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileDialog dialog = new FileDialog((Frame)Hiero.this, "Save Hiero settings file", 1);
                dialog.setLocationRelativeTo(null);
                dialog.setFile("*.hiero");
                dialog.setVisible(true);
                String fileName = dialog.getFile();
                if (fileName == null) {
                    return;
                }
                File file = new File(dialog.getDirectory(), fileName);
                try {
                    Hiero.this.save(file);
                }
                catch (IOException ex) {
                    throw new RuntimeException("Error saving Hiero settings file: " + file.getAbsolutePath(), ex);
                }
            }
        });
        this.saveBMFontMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileDialog dialog = new FileDialog((Frame)Hiero.this, "Save BMFont files", 1);
                dialog.setLocationRelativeTo(null);
                dialog.setFile("*.fnt");
                dialog.setVisible(true);
                String fileName = dialog.getFile();
                if (fileName == null) {
                    return;
                }
                Hiero.this.saveBmFontFile = new File(dialog.getDirectory(), fileName);
            }
        });
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Hiero.this.dispose();
            }
        });
        this.sampleNeheButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Hiero.this.sampleTextPane.setText(Hiero.NEHE);
            }
        });
        this.sampleAsciiButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(Hiero.NEHE);
                buffer.append('\n');
                int count = 0;
                for (int i2 = 33; i2 <= 255; ++i2) {
                    if (buffer.indexOf(Character.toString((char)i2)) != -1) continue;
                    buffer.append((char)i2);
                    if (++count % 30 != 0) continue;
                    buffer.append('\n');
                }
                Hiero.this.sampleTextPane.setText(buffer.toString());
            }
        });
    }

    private void initializeComponents() {
        this.getContentPane().setLayout(new GridBagLayout());
        JPanel leftSidePanel = new JPanel();
        leftSidePanel.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)leftSidePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel fontPanel = new JPanel();
        leftSidePanel.add((Component)fontPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        fontPanel.setLayout(new GridBagLayout());
        fontPanel.setBorder(BorderFactory.createTitledBorder("Font"));
        this.fontSizeSpinner = new JSpinner(new SpinnerNumberModel(32, 0, 256, 1));
        fontPanel.add((Component)this.fontSizeSpinner, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        ((JSpinner.DefaultEditor)this.fontSizeSpinner.getEditor()).getTextField().setColumns(2);
        JScrollPane fontScroll = new JScrollPane();
        fontPanel.add((Component)fontScroll, new GridBagConstraints(1, 1, 4, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.fontListModel = new DefaultComboBoxModel<String>(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        this.fontList = new JList();
        fontScroll.setViewportView(this.fontList);
        this.fontList.setModel(this.fontListModel);
        this.fontList.setVisibleRowCount(6);
        this.fontList.setSelectedIndex(0);
        fontScroll.setMinimumSize(new Dimension(220, this.fontList.getPreferredScrollableViewportSize().height));
        this.systemFontRadio = new JRadioButton("System:", true);
        fontPanel.add((Component)this.systemFontRadio, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.systemFontRadio.setMargin(new Insets(0, 0, 0, 0));
        this.fontFileRadio = new JRadioButton("File:");
        fontPanel.add((Component)this.fontFileRadio, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.fontFileRadio.setMargin(new Insets(0, 0, 0, 0));
        this.fontFileText = new JTextField();
        fontPanel.add((Component)this.fontFileText, new GridBagConstraints(1, 2, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        fontPanel.add((Component)new JLabel("Size:"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.boldCheckBox = new JCheckBox("Bold");
        fontPanel.add((Component)this.boldCheckBox, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.italicCheckBox = new JCheckBox("Italic");
        fontPanel.add((Component)this.italicCheckBox, new GridBagConstraints(3, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.browseButton = new JButton("...");
        fontPanel.add((Component)this.browseButton, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.browseButton.setMargin(new Insets(0, 0, 0, 0));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.systemFontRadio);
        buttonGroup.add(this.fontFileRadio);
        JPanel samplePanel = new JPanel();
        leftSidePanel.add((Component)samplePanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 5, 5), 0, 0));
        samplePanel.setLayout(new GridBagLayout());
        samplePanel.setBorder(BorderFactory.createTitledBorder("Sample Text"));
        JScrollPane textScroll = new JScrollPane();
        samplePanel.add((Component)textScroll, new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.sampleTextPane = new JTextPane();
        textScroll.setViewportView(this.sampleTextPane);
        this.sampleNeheButton = new JButton();
        this.sampleNeheButton.setText("NEHE");
        samplePanel.add((Component)this.sampleNeheButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.sampleAsciiButton = new JButton();
        this.sampleAsciiButton.setText("ASCII");
        samplePanel.add((Component)this.sampleAsciiButton, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
        JPanel renderingPanel = new JPanel();
        leftSidePanel.add((Component)renderingPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        renderingPanel.setBorder(BorderFactory.createTitledBorder("Rendering"));
        renderingPanel.setLayout(new GridBagLayout());
        JPanel wrapperPanel = new JPanel();
        renderingPanel.add((Component)wrapperPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        wrapperPanel.setLayout(new BorderLayout());
        wrapperPanel.setBackground(java.awt.Color.white);
        this.gamePanel = new JPanel();
        wrapperPanel.add(this.gamePanel);
        this.gamePanel.setLayout(new BorderLayout());
        this.gamePanel.setBackground(java.awt.Color.white);
        this.glyphCachePanel = new JPanel(){
            private int maxWidth;

            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                size.width = this.maxWidth = Math.max(this.maxWidth, size.width);
                return size;
            }
        };
        this.glyphCachePanel.setVisible(false);
        renderingPanel.add((Component)this.glyphCachePanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.glyphCachePanel.setLayout(new GridBagLayout());
        this.glyphCachePanel.add((Component)new JLabel("Glyphs:"), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.glyphCachePanel.add((Component)new JLabel("Pages:"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.glyphCachePanel.add((Component)new JLabel("Page width:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.glyphCachePanel.add((Component)new JLabel("Page height:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.glyphPageWidthCombo = new JComboBox<Integer>(new DefaultComboBoxModel<Integer>(new Integer[]{new Integer(32), new Integer(64), new Integer(128), new Integer(256), new Integer(512), new Integer(1024), new Integer(2048)}));
        this.glyphCachePanel.add((Component)this.glyphPageWidthCombo, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.glyphPageWidthCombo.setSelectedIndex(1);
        this.glyphPageHeightCombo = new JComboBox<Integer>(new DefaultComboBoxModel<Integer>(new Integer[]{new Integer(32), new Integer(64), new Integer(128), new Integer(256), new Integer(512), new Integer(1024), new Integer(2048)}));
        this.glyphCachePanel.add((Component)this.glyphPageHeightCombo, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.glyphPageHeightCombo.setSelectedIndex(1);
        this.resetCacheButton = new JButton("Reset Cache");
        this.glyphCachePanel.add((Component)this.resetCacheButton, new GridBagConstraints(0, 6, 2, 1, 1.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.glyphPagesTotalLabel = new JLabel("1");
        this.glyphCachePanel.add((Component)this.glyphPagesTotalLabel, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.glyphsTotalLabel = new JLabel("0");
        this.glyphCachePanel.add((Component)this.glyphsTotalLabel, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.glyphPageComboModel = new DefaultComboBoxModel();
        this.glyphPageCombo = new JComboBox();
        this.glyphCachePanel.add((Component)this.glyphPageCombo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.glyphPageCombo.setModel(this.glyphPageComboModel);
        this.glyphCachePanel.add((Component)new JLabel("View:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        JPanel radioButtonsPanel = new JPanel();
        renderingPanel.add((Component)radioButtonsPanel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        radioButtonsPanel.setLayout(new GridBagLayout());
        this.sampleTextRadio = new JRadioButton("Sample text");
        radioButtonsPanel.add((Component)this.sampleTextRadio, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.sampleTextRadio.setSelected(true);
        this.glyphCacheRadio = new JRadioButton("Glyph cache");
        radioButtonsPanel.add((Component)this.glyphCacheRadio, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 5), 0, 0));
        radioButtonsPanel.add((Component)new JLabel("Background:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.backgroundColorLabel = new JLabel();
        radioButtonsPanel.add((Component)this.backgroundColorLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.glyphCacheRadio);
        buttonGroup2.add(this.sampleTextRadio);
        JPanel rightSidePanel = new JPanel();
        rightSidePanel.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)rightSidePanel, new GridBagConstraints(1, 0, 1, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel paddingPanel = new JPanel();
        paddingPanel.setLayout(new GridBagLayout());
        rightSidePanel.add((Component)paddingPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        paddingPanel.setBorder(BorderFactory.createTitledBorder("Padding"));
        this.padTopSpinner = new JSpinner();
        paddingPanel.add((Component)this.padTopSpinner, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        ((JSpinner.DefaultEditor)this.padTopSpinner.getEditor()).getTextField().setColumns(2);
        this.padRightSpinner = new JSpinner();
        paddingPanel.add((Component)this.padRightSpinner, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        ((JSpinner.DefaultEditor)this.padRightSpinner.getEditor()).getTextField().setColumns(2);
        this.padLeftSpinner = new JSpinner();
        paddingPanel.add((Component)this.padLeftSpinner, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        ((JSpinner.DefaultEditor)this.padLeftSpinner.getEditor()).getTextField().setColumns(2);
        this.padBottomSpinner = new JSpinner();
        paddingPanel.add((Component)this.padBottomSpinner, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        ((JSpinner.DefaultEditor)this.padBottomSpinner.getEditor()).getTextField().setColumns(2);
        JPanel advancePanel = new JPanel();
        FlowLayout advancePanelLayout = new FlowLayout();
        advancePanel.setLayout(advancePanelLayout);
        paddingPanel.add((Component)advancePanel, new GridBagConstraints(0, 4, 3, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        advancePanel.add(new JLabel("X:"));
        this.padAdvanceXSpinner = new JSpinner();
        advancePanel.add(this.padAdvanceXSpinner);
        ((JSpinner.DefaultEditor)this.padAdvanceXSpinner.getEditor()).getTextField().setColumns(2);
        advancePanel.add(new JLabel("Y:"));
        this.padAdvanceYSpinner = new JSpinner();
        advancePanel.add(this.padAdvanceYSpinner);
        ((JSpinner.DefaultEditor)this.padAdvanceYSpinner.getEditor()).getTextField().setColumns(2);
        JPanel effectsPanel = new JPanel();
        effectsPanel.setLayout(new GridBagLayout());
        rightSidePanel.add((Component)effectsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 5, 5), 0, 0));
        effectsPanel.setBorder(BorderFactory.createTitledBorder("Effects"));
        effectsPanel.setMinimumSize(new Dimension(210, 1));
        JScrollPane effectsScroll = new JScrollPane();
        effectsPanel.add((Component)effectsScroll, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.effectsListModel = new DefaultComboBoxModel();
        this.effectsList = new JList();
        effectsScroll.setViewportView(this.effectsList);
        this.effectsList.setModel(this.effectsListModel);
        this.effectsList.setVisibleRowCount(6);
        effectsScroll.setMinimumSize(this.effectsList.getPreferredScrollableViewportSize());
        this.addEffectButton = new JButton("Add");
        effectsPanel.add((Component)this.addEffectButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 6, 5), 0, 0));
        this.addEffectButton.setEnabled(false);
        this.appliedEffectsScroll = new JScrollPane();
        effectsPanel.add((Component)this.appliedEffectsScroll, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.appliedEffectsScroll.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.appliedEffectsScroll.setHorizontalScrollBarPolicy(31);
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        this.appliedEffectsScroll.setViewportView(panel);
        this.appliedEffectsPanel = new JPanel();
        this.appliedEffectsPanel.setLayout(new GridBagLayout());
        panel.add((Component)this.appliedEffectsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.appliedEffectsPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, java.awt.Color.black));
    }

    private void initializeMenus() {
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu fileMenu = new JMenu();
        menuBar.add(fileMenu);
        fileMenu.setText("File");
        fileMenu.setMnemonic(70);
        this.openMenuItem = new JMenuItem("Open Hiero settings file...");
        this.openMenuItem.setMnemonic(79);
        this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        fileMenu.add(this.openMenuItem);
        this.saveMenuItem = new JMenuItem("Save Hiero settings file...");
        this.saveMenuItem.setMnemonic(83);
        this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        fileMenu.add(this.saveMenuItem);
        fileMenu.addSeparator();
        this.saveBMFontMenuItem = new JMenuItem("Save BMFont files (text)...");
        this.saveBMFontMenuItem.setMnemonic(66);
        this.saveBMFontMenuItem.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        fileMenu.add(this.saveBMFontMenuItem);
        fileMenu.addSeparator();
        this.exitMenuItem = new JMenuItem("Exit");
        this.exitMenuItem.setMnemonic(88);
        fileMenu.add(this.exitMenuItem);
    }

    static Icon getColorIcon(java.awt.Color color) {
        BufferedImage image = new BufferedImage(32, 16, 1);
        java.awt.Graphics g2 = image.getGraphics();
        g2.setColor(color);
        g2.fillRect(1, 1, 30, 14);
        g2.setColor(java.awt.Color.black);
        g2.drawRect(0, 0, 31, 15);
        return new ImageIcon(image);
    }

    public static void main(String[] args) throws Exception {
        UIManager.LookAndFeelInfo[] lookAndFeels = UIManager.getInstalledLookAndFeels();
        int n = lookAndFeels.length;
        for (int i2 = 0; i2 < n; ++i2) {
            if (!"Nimbus".equals(lookAndFeels[i2].getName())) continue;
            try {
                UIManager.setLookAndFeel(lookAndFeels[i2].getClassName());
            }
            catch (Exception ignored) {}
            break;
        }
        new Hiero();
    }

    private static class Splash
    extends JWindow {
        private final int minMillis;
        private final long startTime;

        public Splash(Frame frame, String imageFile, int minMillis) {
            super(frame);
            this.minMillis = minMillis;
            this.getContentPane().add((Component)new JLabel(new ImageIcon((class$org$newdawn$slick$tools$hiero$Hiero$Splash == null ? (class$org$newdawn$slick$tools$hiero$Hiero$Splash = Hiero.class$("org.newdawn.slick.tools.hiero.Hiero$Splash")) : class$org$newdawn$slick$tools$hiero$Hiero$Splash).getResource(imageFile))), "Center");
            this.pack();
            this.setLocationRelativeTo(null);
            this.setVisible(true);
            this.startTime = System.currentTimeMillis();
        }

        public void close() {
            final long endTime = System.currentTimeMillis();
            new Thread(new Runnable(){

                public void run() {
                    if (endTime - Splash.this.startTime < (long)Splash.this.minMillis) {
                        Splash.this.addMouseListener(new MouseAdapter(){

                            public void mousePressed(MouseEvent evt) {
                                Splash.this.dispose();
                            }
                        });
                        try {
                            Thread.sleep((long)Splash.this.minMillis - (endTime - Splash.this.startTime));
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            Splash.this.dispose();
                        }
                    });
                }
            }, "Splash").start();
        }
    }

    private class EffectPanel
    extends JPanel {
        private final java.awt.Color selectedColor = new java.awt.Color(11653865);
        private final ConfigurableEffect effect;
        private List values;
        private JButton deleteButton;
        private JPanel valuesPanel;
        private JLabel nameLabel;

        private EffectPanel(ConfigurableEffect effect) {
            this.effect = effect;
            Hiero.this.effectPanels.add(this);
            Hiero.this.effectsList.getListSelectionListeners()[0].valueChanged(null);
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, java.awt.Color.black));
            Hiero.this.appliedEffectsPanel.add((Component)this, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            JPanel titlePanel = new JPanel();
            titlePanel.setLayout(new LayoutManager(){

                public void removeLayoutComponent(Component comp) {
                }

                public Dimension preferredLayoutSize(Container parent) {
                    return null;
                }

                public Dimension minimumLayoutSize(Container parent) {
                    return null;
                }

                public void layoutContainer(Container parent) {
                    Dimension buttonSize = EffectPanel.this.deleteButton.getPreferredSize();
                    EffectPanel.this.deleteButton.setBounds(EffectPanel.this.getWidth() - buttonSize.width - 5, 0, buttonSize.width, buttonSize.height);
                    Dimension labelSize = EffectPanel.this.nameLabel.getPreferredSize();
                    EffectPanel.this.nameLabel.setBounds(5, buttonSize.height / 2 - labelSize.height / 2, EffectPanel.this.getWidth() - buttonSize.width - 5 - 5, labelSize.height);
                }

                public void addLayoutComponent(String name, Component comp) {
                }
            });
            this.deleteButton = new JButton();
            titlePanel.add(this.deleteButton);
            this.deleteButton.setText("X");
            this.deleteButton.setMargin(new Insets(0, 0, 0, 0));
            Font font = this.deleteButton.getFont();
            this.deleteButton.setFont(new Font(font.getName(), font.getStyle(), font.getSize() - 2));
            this.nameLabel = new JLabel(effect.toString());
            titlePanel.add(this.nameLabel);
            font = this.nameLabel.getFont();
            this.nameLabel.setFont(new Font(font.getName(), 1, font.getSize()));
            titlePanel.setPreferredSize(new Dimension(0, Math.max(this.nameLabel.getPreferredSize().height, this.deleteButton.getPreferredSize().height)));
            this.add((Component)titlePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 0, 5), 0, 0));
            titlePanel.setOpaque(false);
            this.valuesPanel = new JPanel();
            this.valuesPanel.setOpaque(false);
            this.valuesPanel.setLayout(new GridBagLayout());
            this.add((Component)this.valuesPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 10, 5, 0), 0, 0));
            this.deleteButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    EffectPanel.this.remove();
                    Hiero.this.updateFont();
                }
            });
            this.updateValues();
            Hiero.this.updateFont();
        }

        public void remove() {
            Hiero.this.effectPanels.remove(this);
            Hiero.this.appliedEffectsPanel.remove(this);
            Hiero.this.getContentPane().validate();
            Hiero.this.effectsList.getListSelectionListeners()[0].valueChanged(null);
        }

        public void updateValues() {
            Hiero.this.prefs.put("foreground", EffectUtil.toString(Hiero.this.colorEffect.getColor()));
            this.valuesPanel.removeAll();
            this.values = this.effect.getValues();
            Iterator iter = this.values.iterator();
            while (iter.hasNext()) {
                this.addValue((ConfigurableEffect.Value)iter.next());
            }
        }

        public void addValue(final ConfigurableEffect.Value value) {
            JLabel valueNameLabel = new JLabel(value.getName() + ":");
            this.valuesPanel.add((Component)valueNameLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            final JLabel valueValueLabel = new JLabel();
            this.valuesPanel.add((Component)valueValueLabel, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 5), 0, 0));
            valueValueLabel.setOpaque(true);
            if (value.getObject() instanceof java.awt.Color) {
                valueValueLabel.setIcon(Hiero.getColorIcon((java.awt.Color)value.getObject()));
            } else {
                valueValueLabel.setText(value.toString());
            }
            valueValueLabel.addMouseListener(new MouseAdapter(){

                public void mouseEntered(MouseEvent evt) {
                    valueValueLabel.setBackground(EffectPanel.this.selectedColor);
                }

                public void mouseExited(MouseEvent evt) {
                    valueValueLabel.setBackground(null);
                }

                public void mouseClicked(MouseEvent evt) {
                    Object oldObject = value.getObject();
                    value.showDialog();
                    if (!value.getObject().equals(oldObject)) {
                        EffectPanel.this.effect.setValues(EffectPanel.this.values);
                        EffectPanel.this.updateValues();
                        Hiero.this.updateFont();
                    }
                }
            });
        }

        public ConfigurableEffect getEffect() {
            return this.effect;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EffectPanel other = (EffectPanel)obj;
            return !(this.effect == null ? other.effect != null : !this.effect.equals(other.effect));
        }
    }
}

