/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import logic.Board;
import org.newdawn.slick.Animation;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.Input;
import org.newdawn.slick.Music;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.Sound;
import org.newdawn.slick.UnicodeFont;
import org.newdawn.slick.font.effects.ColorEffect;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;
import org.newdawn.slick.state.transition.FadeInTransition;
import org.newdawn.slick.state.transition.FadeOutTransition;
import org.newdawn.slick.state.transition.Transition;
import test.Test;

public class Menu
extends BasicGameState {
    private Image bg0 = null;
    private Image bg1 = null;
    private Image bg2 = null;
    private Image bg3 = null;
    private Image bg4 = null;
    private Image bg5 = null;
    private Image[] background = new Image[0];
    private Image normalOption = null;
    private Image timedOption = null;
    private Image highOption = null;
    private Image exitOption = null;
    private Music menumusic = null;
    private Sound button = null;
    private Animation bgfinal = null;
    private float normalScale = 1.0f;
    private float timedScale = 1.0f;
    private float highScale = 1.0f;
    private float quitScale = 1.0f;
    private float scaleStep = 1.0E-4f;
    private Transition inTransition = new FadeInTransition(new Color(0, 0, 0), 1000);
    private Transition outTransition = new FadeOutTransition(new Color(0, 0, 0), 1000);
    private String path = "";
    private String decodedPath = "";
    private String name = "";
    private UnicodeFont font = null;
    private String fontpath = "data/fgh.ttf";
    private int stateID = 1;

    public Menu(int stateID) {
        this.stateID = stateID;
    }

    @Override
    public int getID() {
        return this.stateID;
    }

    @Override
    public void init(GameContainer container, StateBasedGame game) throws SlickException {
        container.setMouseCursor("data/c1.png", 0, 0);
        this.menumusic = new Music("data/menu2.ogg");
        this.button = new Sound("data/buton.wav");
        this.bg0 = new Image("data/bg0.png");
        this.bg1 = new Image("data/bg1.png");
        this.bg2 = new Image("data/bg2.png");
        this.bg3 = new Image("data/bg3.png");
        this.bg4 = new Image("data/bg4.png");
        this.bg5 = new Image("data/bg5.png");
        this.background = new Image[]{this.bg0, this.bg1, this.bg2, this.bg3, this.bg4, this.bg5};
        this.normalOption = new Image("data/normal.png");
        this.timedOption = new Image("data/timed.png");
        this.highOption = new Image("data/high.png");
        this.exitOption = new Image("data/quit.png");
        this.bgfinal = new Animation(this.background, 500);
        this.menumusic.loop(1.0f, 0.1f);
        this.font = new UnicodeFont(this.fontpath, 40, true, false);
        this.font.addAsciiGlyphs();
        this.font.addGlyphs(400, 600);
        this.font.getEffects().add(new ColorEffect(java.awt.Color.WHITE));
        this.font.loadGlyphs();
    }

    @Override
    public void enter(GameContainer container, StateBasedGame game) throws SlickException {
        this.path = Test.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        try {
            this.decodedPath = URLDecoder.decode(this.path, "UTF-8");
        }
        catch (IOException error) {
            error.printStackTrace();
        }
        this.name = this.readFile();
    }

    @Override
    public void render(GameContainer container, StateBasedGame game, Graphics g2) throws SlickException {
        this.bgfinal.draw(0.0f, 0.0f);
        this.normalOption.draw(446.0f, 140.0f, this.normalScale);
        this.timedOption.draw(476.0f, 230.0f, this.timedScale);
        this.highOption.draw(394.0f, 320.0f, this.highScale);
        this.exitOption.draw(490.0f, 410.0f, this.quitScale);
    }

    @Override
    public void update(GameContainer container, StateBasedGame game, int delta) throws SlickException {
        Input input = container.getInput();
        boolean insideNormal = false;
        boolean insideTimed = false;
        boolean insideHigh = false;
        boolean insideExit = false;
        int mouseX = input.getMouseX();
        int mouseY = input.getMouseY();
        if (mouseX >= 446 && mouseX <= 446 + this.normalOption.getWidth() && mouseY >= 140 && mouseY <= 140 + this.normalOption.getHeight()) {
            insideNormal = true;
        } else if (mouseX >= 476 && mouseX <= 476 + this.timedOption.getWidth() && mouseY >= 230 && mouseY <= 230 + this.timedOption.getHeight()) {
            insideTimed = true;
        } else if (mouseX >= 394 && mouseX <= 394 + this.highOption.getWidth() && mouseY >= 320 && mouseY <= 320 + this.highOption.getHeight()) {
            insideHigh = true;
        } else if (mouseX >= 490 && mouseX <= 490 + this.exitOption.getWidth() && mouseY >= 419 && mouseY <= 410 + this.exitOption.getHeight()) {
            insideExit = true;
        }
        if (insideNormal) {
            if (this.normalScale < 1.05f) {
                this.normalScale += this.scaleStep * (float)delta;
            }
            if (input.isMouseButtonDown(0)) {
                this.button.play(1.0f, 0.1f);
                game.enterState(2, this.outTransition, this.inTransition);
            }
        } else if (this.normalScale > 1.0f) {
            this.normalScale -= this.scaleStep * (float)delta;
        }
        if (insideTimed) {
            if (this.timedScale < 1.05f) {
                this.timedScale += this.scaleStep * (float)delta;
            }
            if (input.isMouseButtonDown(0)) {
                this.button.play(1.0f, 0.1f);
                game.enterState(3, this.outTransition, this.inTransition);
            }
        } else if (this.timedScale > 1.0f) {
            this.timedScale -= this.scaleStep * (float)delta;
        }
        if (insideHigh) {
            if (this.highScale < 1.05f) {
                this.highScale += this.scaleStep * (float)delta;
            }
            if (input.isMouseButtonDown(0)) {
                this.button.play(1.0f, 0.1f);
                game.enterState(4, this.outTransition, this.inTransition);
            }
        } else if (this.highScale > 1.0f) {
            this.highScale -= this.scaleStep * (float)delta;
        }
        if (insideExit) {
            if (this.quitScale < 1.05f) {
                this.quitScale += this.scaleStep * (float)delta;
            }
            if (input.isMouseButtonDown(0)) {
                this.button.play(1.0f, 0.1f);
                File file = new File(this.decodedPath + "name.dat");
                if (file.exists()) {
                    file.delete();
                }
                container.exit();
            }
        } else if (this.quitScale > 1.0f) {
            this.quitScale -= this.scaleStep * (float)delta;
        }
    }

    public String readFile() {
        String name = "";
        try {
            FileInputStream fstream = new FileInputStream(this.decodedPath + "name.dat");
            ObjectInputStream objstream = new ObjectInputStream(fstream);
            name = objstream.readUTF();
            objstream.close();
        }
        catch (IOException error) {
            error.printStackTrace();
        }
        return name;
    }

    public void writeBoard() {
        Board board = new Board(11, 8, 8);
        ArrayList<Board> load = new ArrayList<Board>();
        load.add(board);
        try {
            FileOutputStream fstream = new FileOutputStream(this.decodedPath + "board.dat");
            ObjectOutputStream objstream = new ObjectOutputStream(fstream);
            objstream.writeObject(load);
            objstream.close();
        }
        catch (IOException error) {
            error.printStackTrace();
        }
    }
}

