/*
 * Decompiled with CFR 0.152.
 */
package com.tinyline.tiny2d;

import com.tinyline.tiny2d.TinyMatrix;
import com.tinyline.tiny2d.TinyVector;

public class TinyTransform {
    public static final short TRANSFORM_UNKNOWN = 0;
    public static final short TRANSFORM_MATRIX = 1;
    public static final short TRANSFORM_TRANSLATE = 2;
    public static final short TRANSFORM_SCALE = 3;
    public static final short TRANSFORM_ROTATE = 4;
    public static final short TRANSFORM_SKEWX = 5;
    public static final short TRANSFORM_SKEWY = 6;
    public short type;
    public TinyMatrix matrix;
    public int angle;
    public int rotateOriginX;
    public int rotateOriginY;

    public TinyTransform() {
        this.init();
    }

    public TinyTransform(TinyTransform tinyTransform) {
        this.type = tinyTransform.type;
        this.matrix = new TinyMatrix(tinyTransform.matrix);
        this.angle = tinyTransform.angle;
        this.rotateOriginX = tinyTransform.rotateOriginX;
        this.rotateOriginY = tinyTransform.rotateOriginY;
    }

    public void init() {
        this.type = 1;
        this.matrix = new TinyMatrix();
        this.angle = 0;
        this.rotateOriginY = 0;
        this.rotateOriginX = 0;
    }

    public void setMatrix(TinyMatrix tinyMatrix) {
        this.init();
        this.matrix = tinyMatrix;
    }

    public void setTranslate(int n, int n2) {
        this.init();
        this.type = (short)2;
        this.matrix.translate(n, n2);
    }

    public void setScale(int n, int n2) {
        this.init();
        this.type = (short)3;
        this.matrix.scale(n, n2);
    }

    public void setRotate(int n, int n2, int n3) {
        this.init();
        this.type = (short)4;
        this.matrix.rotate(n, n2, n3);
        this.angle = n;
        this.rotateOriginX = n2;
        this.rotateOriginY = n3;
    }

    public void setSkewX(int n) {
        this.init();
        this.type = (short)5;
        this.matrix.skew(n, 0);
        this.angle = n;
    }

    public void setSkewY(int n) {
        this.init();
        this.type = (short)6;
        this.matrix.skew(0, n);
        this.angle = n;
    }

    public static TinyMatrix getTinyMatrix(TinyVector tinyVector) {
        TinyMatrix tinyMatrix = new TinyMatrix();
        int n = tinyVector.count;
        int n2 = 0;
        while (n2 < n) {
            TinyTransform tinyTransform = (TinyTransform)tinyVector.data[n2];
            tinyMatrix.preConcatenate(tinyTransform.matrix);
            ++n2;
        }
        return tinyMatrix;
    }
}

