/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.tools.hiero;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.newdawn.slick.tools.hiero.CharSet;
import org.newdawn.slick.tools.hiero.Hiero;
import org.newdawn.slick.tools.hiero.HieroConfig;

public class CharSetDialog
extends JDialog {
    private CharSet set;
    private String newSetName;

    public CharSetDialog(Hiero parent, CharSet s) {
        super(parent, "Editing " + s.getName(), true);
        this.set = s.copy();
        JMenuBar bar = new JMenuBar();
        JMenu file = new JMenu("File");
        JMenuItem save = new JMenuItem("Save");
        JMenuItem saveAs = new JMenuItem("Save As");
        JMenuItem close = new JMenuItem("Close");
        file.add(save);
        file.add(saveAs);
        file.addSeparator();
        file.add(close);
        bar.add(file);
        this.setJMenuBar(bar);
        this.setDefaultCloseOperation(2);
        save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                try {
                    CharSetDialog.this.set.save(CharSetDialog.this.set.getSource());
                    CharSetDialog.this.dispose();
                }
                catch (IOException x) {
                    x.printStackTrace();
                    JOptionPane.showMessageDialog(CharSetDialog.this, "Failed to resave character set");
                }
            }
        });
        saveAs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                try {
                    String name = JOptionPane.showInputDialog(CharSetDialog.this, (Object)"Enter a name for the new Chararater Set:");
                    CharSetDialog.this.set.setName(name);
                    if (name != null && name.length() != 0) {
                        CharSetDialog.this.set.save(HieroConfig.getConfigFile(name + ".set"));
                    }
                    CharSetDialog.this.newSetName = name;
                    CharSetDialog.this.dispose();
                }
                catch (IOException x) {
                    x.printStackTrace();
                    JOptionPane.showMessageDialog(CharSetDialog.this, "Failed to resave character set");
                }
            }
        });
        close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                CharSetDialog.this.dispose();
            }
        });
        if (!s.isMutable()) {
            save.setEnabled(false);
        }
        this.setContentPane(new CharsPanel());
        this.setSize(600, 600);
        this.setResizable(false);
    }

    public String getNewSet() {
        return this.newSetName;
    }

    public class CharsPanel
    extends JPanel {
        private int lastx = -1;
        private int lasty;

        public CharsPanel() {
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e2) {
                    CharsPanel.this.select(e2.getX(), e2.getY(), true);
                }

                public void mouseReleased(MouseEvent e2) {
                    CharsPanel.this.lastx = -1;
                }
            });
            this.addMouseMotionListener(new MouseMotionListener(){

                public void mouseDragged(MouseEvent e2) {
                    CharsPanel.this.select(e2.getX(), e2.getY(), false);
                }

                public void mouseMoved(MouseEvent e2) {
                }
            });
        }

        private void select(int x, int y, boolean updateIfSame) {
            x -= 35;
            y -= 10;
            if ((x /= 32) >= 0 && x < 16 && (y /= 32) >= 0 && y < 16) {
                if (!updateIfSame && this.lastx == x && this.lasty == y) {
                    return;
                }
                this.lastx = x;
                this.lasty = y;
                int i2 = x + y * 16;
                CharSetDialog.this.set.set(i2, !CharSetDialog.this.set.includes((char)i2));
                this.repaint(0L);
            }
        }

        public void paint(Graphics g2) {
            g2.setColor(Color.black);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2.translate(35, 10);
            g2.setFont(new Font(g2.getFont().getName(), 0, 25));
            for (int i2 = 0; i2 < 256; ++i2) {
                int x = i2 % 16;
                int y = i2 / 16;
                char c2 = (char)i2;
                g2.setColor(Color.white);
                if (CharSetDialog.this.set.includes(c2)) {
                    g2.fillRect(x * 32, y * 32, 32, 32);
                    g2.setColor(Color.black);
                    g2.drawRect(x * 32, y * 32, 32, 32);
                } else {
                    g2.drawRect(x * 32, y * 32, 32, 32);
                }
                g2.drawString("" + c2, x * 32 + 5, y * 32 + 28);
            }
        }
    }
}

