/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.tools.hiero.distancemap;

import java.awt.Color;
import java.awt.image.BufferedImage;
import org.newdawn.slick.tools.hiero.ProgressListener;

public class DistanceFieldFilter {
    private static int progress;

    private static float separation(float x1, float y1, float x2, float y2) {
        float dx = x1 - x2;
        float dy = y1 - y2;
        return (float)Math.sqrt(dx * dx + dy * dy);
    }

    public static BufferedImage process(BufferedImage inImage, int outWidth, int outHeight, int scanSize, ProgressListener listener) {
        float d2;
        int y;
        int x;
        System.out.println("DistanceFieldFilter.process");
        BufferedImage outImage = new BufferedImage(outWidth, outHeight, 6);
        float[][] distances = new float[outImage.getWidth()][outImage.getHeight()];
        int blockWidth = inImage.getWidth() / outImage.getWidth();
        int blockHeight = inImage.getHeight() / outImage.getHeight();
        System.out.println("Block size is " + blockWidth + "," + blockHeight);
        for (int x2 = 0; x2 < outImage.getWidth(); ++x2) {
            listener.reportProgress("Finding signed distance", x2, outImage.getWidth());
            for (int y2 = 0; y2 < outImage.getHeight(); ++y2) {
                distances[x2][y2] = DistanceFieldFilter.findSignedDistance(x2 * blockWidth + blockWidth / 2, y2 * blockHeight + blockHeight / 2, inImage, scanSize, scanSize);
            }
        }
        float max = 0.0f;
        for (int x3 = 0; x3 < distances.length; ++x3) {
            for (int y3 = 0; y3 < distances[0].length; ++y3) {
                float d3 = distances[x3][y3];
                if (d3 == Float.MAX_VALUE || !(d3 > max)) continue;
                max = d3;
            }
        }
        float min = 0.0f;
        for (int x4 = 0; x4 < distances.length; ++x4) {
            for (int y4 = 0; y4 < distances[0].length; ++y4) {
                float d4 = distances[x4][y4];
                if (d4 == Float.MIN_VALUE || !(d4 < min)) continue;
                min = d4;
            }
        }
        float range = max - min;
        float scale = Math.max(Math.abs(min), Math.abs(max));
        System.out.println("Max: " + max + ", Min:" + min + ", Range:" + range);
        for (x = 0; x < distances.length; ++x) {
            for (y = 0; y < distances[0].length; ++y) {
                d2 = distances[x][y];
                if (d2 == Float.MAX_VALUE) {
                    d2 = 1.0f;
                } else if (d2 == Float.MIN_VALUE) {
                    d2 = 0.0f;
                } else {
                    d2 /= scale;
                    d2 /= 2.0f;
                    d2 += 0.5f;
                }
                distances[x][y] = d2;
            }
        }
        for (x = 0; x < distances.length; ++x) {
            listener.reportProgress("Setting Image", x, outImage.getWidth());
            for (y = 0; y < distances[0].length; ++y) {
                d2 = distances[x][y];
                if (d2 == Float.NaN) {
                    d2 = 0.0f;
                }
                outImage.setRGB(x, y, new Color(1.0f, 1.0f, 1.0f, d2).getRGB());
            }
        }
        return outImage;
    }

    public static int progress() {
        return progress;
    }

    private static float findSignedDistance(int pointX, int pointY, BufferedImage inImage, int scanWidth, int scanHeight) {
        Color baseColour = new Color(inImage.getRGB(pointX, pointY));
        boolean baseIsSolid = baseColour.getRed() > 0;
        float closestDistance = Float.MAX_VALUE;
        boolean closestValid = false;
        int startX = pointX - scanWidth / 2;
        int endX = startX + scanWidth;
        int startY = pointY - scanHeight / 2;
        int endY = startY + scanHeight;
        for (int x = startX; x < endX; ++x) {
            if (x < 0 || x >= inImage.getWidth()) continue;
            for (int y = startY; y < endY; ++y) {
                float dist;
                if (y < 0 || y >= inImage.getWidth()) continue;
                Color c2 = new Color(inImage.getRGB(x, y));
                if (baseIsSolid) {
                    if (c2.getRed() != 0 || !((dist = DistanceFieldFilter.separation(pointX, pointY, x, y)) < closestDistance)) continue;
                    closestDistance = dist;
                    closestValid = true;
                    continue;
                }
                if (c2.getRed() <= 0 || !((dist = DistanceFieldFilter.separation(pointX, pointY, x, y)) < closestDistance)) continue;
                closestDistance = dist;
                closestValid = true;
            }
        }
        if (baseIsSolid) {
            if (closestValid) {
                return closestDistance;
            }
            return Float.MAX_VALUE;
        }
        if (closestValid) {
            return -closestDistance;
        }
        return Float.MIN_VALUE;
    }
}

