/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.tools.peditor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.particles.ConfigurableEmitter;
import org.newdawn.slick.tools.peditor.DefaultPanel;

public class GraphEditorWindow
extends JPanel {
    private Hashtable values;
    private JComboBox properties;
    private DefaultPanel top;
    private GraphPanel panel;
    private JLabel valueXLabel;
    private JLabel valueYLabel;
    private JSpinner minSpinner;
    private JSpinner maxSpinner;
    private static Color COLOR_LINE = new Color(0xEEEEEE);
    private static Color COLOR_POINT = new Color(0xFFCC66);
    private static Color COLOR_POINT_OUTLINE = new Color(0x444444);
    private static Color COLOR_SELECTED_POINT = new Color(0xFFFFFF);
    private static Color COLOR_SELECTED_POINT_OUTLINE = new Color(0);
    private static Color COLOR_LEGEND = new Color(0);
    private static Color COLOR_LEGEND_BACKGROUND = new Color(0x555566);
    private static Color COLOR_LEGEND_GRID = new Color(0x333344);
    private static Color COLOR_LEGEND_GRID_CROSS = new Color(0x222233);
    private static Color COLOR_BACKGROUND = new Color(0x444455);
    private static Color COLOR_LABEL = new Color(0);
    private static final String TEXT_CURRENT_X = "Time: ";
    private static final String TEXT_CURRENT_Y = "Value: ";
    static /* synthetic */ Class class$org$newdawn$slick$tools$peditor$ParticleEditor;

    public GraphEditorWindow() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBackground(COLOR_BACKGROUND);
        this.panel = new GraphPanel();
        this.top = this.createTopPanel();
        this.top.setEnabled(false);
        this.add(this.top);
        this.add(this.panel);
        this.values = new Hashtable();
    }

    public void setLinkedEmitter(ConfigurableEmitter emitter) {
        Window w = SwingUtilities.windowForComponent(this);
        if (w instanceof Frame) {
            ((Frame)w).setTitle("Whiskas Gradient Editor (" + emitter.name + ")");
        }
        this.properties.removeAllItems();
        this.values.clear();
        this.panel.setInterpolator(null);
        this.enableControls();
    }

    private DefaultPanel createTopPanel() {
        DefaultPanel top = new DefaultPanel();
        top.setLayout(new BoxLayout(top, 0));
        top.setAlignmentX(0.0f);
        top.setPreferredSize(new Dimension(Short.MAX_VALUE, 40));
        top.add(Box.createRigidArea(new Dimension(5, 0)));
        JLabel propLabel = new JLabel("Property");
        propLabel.setBounds(10, 20, 40, 20);
        propLabel.setForeground(COLOR_LABEL);
        top.add(propLabel);
        top.add(Box.createRigidArea(new Dimension(5, 0)));
        this.properties = new JComboBox();
        this.properties.setMaximumSize(new Dimension(100, 20));
        this.properties.setMinimumSize(new Dimension(100, 20));
        this.properties.setPreferredSize(new Dimension(100, 20));
        this.properties.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent event) {
                String item = (String)event.getItem();
                ConfigurableEmitter.LinearInterpolator currentValue = (ConfigurableEmitter.LinearInterpolator)GraphEditorWindow.this.values.get(item);
                GraphEditorWindow.this.panel.setInterpolator(currentValue);
            }
        });
        top.add(this.properties);
        top.add(Box.createRigidArea(new Dimension(10, 0)));
        JLabel minLabel = new JLabel("Min");
        minLabel.setMaximumSize(new Dimension(100, 20));
        minLabel.setForeground(COLOR_LABEL);
        top.add(minLabel);
        top.add(Box.createRigidArea(new Dimension(5, 0)));
        this.minSpinner = new JSpinner(new SpinnerNumberModel(0, -1000, 1000, 1));
        this.minSpinner.setMaximumSize(new Dimension(100, 20));
        this.minSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e2) {
                GraphEditorWindow.this.fireUpdated(e2.getSource());
            }
        });
        top.add(this.minSpinner);
        top.add(Box.createRigidArea(new Dimension(5, 0)));
        JLabel maxLabel = new JLabel("Max");
        maxLabel.setMaximumSize(new Dimension(100, 20));
        maxLabel.setForeground(COLOR_LABEL);
        top.add(maxLabel);
        top.add(Box.createRigidArea(new Dimension(5, 0)));
        this.maxSpinner = new JSpinner(new SpinnerNumberModel(255, -1000, 1000, 1));
        this.maxSpinner.setMaximumSize(new Dimension(100, 20));
        this.maxSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e2) {
                GraphEditorWindow.this.fireUpdated(e2.getSource());
            }
        });
        top.add(this.maxSpinner);
        top.add(Box.createRigidArea(new Dimension(5, 0)));
        top.add(Box.createHorizontalGlue());
        this.valueXLabel = new JLabel(TEXT_CURRENT_X);
        this.valueXLabel.setMaximumSize(new Dimension(100, 20));
        this.valueXLabel.setForeground(COLOR_LABEL);
        top.add(this.valueXLabel);
        top.add(Box.createRigidArea(new Dimension(10, 0)));
        this.valueYLabel = new JLabel(TEXT_CURRENT_Y);
        this.valueYLabel.setMaximumSize(new Dimension(100, 20));
        this.valueYLabel.setForeground(COLOR_LABEL);
        top.add(this.valueYLabel);
        top.add(Box.createRigidArea(new Dimension(10, 0)));
        return top;
    }

    private void fireUpdated(Object control) {
        if (control.equals(this.minSpinner)) {
            int minY = (Integer)this.minSpinner.getValue();
            if ((float)minY < this.panel.getWorldMaxY()) {
                this.panel.setWorldMinY(minY);
                this.panel.makeSureCurveFits();
                this.panel.repaint();
            } else {
                this.minSpinner.setValue(new Integer((int)this.panel.getWorldMinY()));
            }
        } else if (control.equals(this.maxSpinner)) {
            int maxY = (Integer)this.maxSpinner.getValue();
            if ((float)maxY > this.panel.getWorldMinY()) {
                this.panel.setWorldMaxY(maxY);
                this.panel.makeSureCurveFits();
                this.panel.repaint();
            } else {
                this.maxSpinner.setValue(new Integer((int)this.panel.getWorldMaxY()));
            }
        }
    }

    public void registerValue(ConfigurableEmitter.LinearInterpolator value, String name) {
        this.properties.addItem(name);
        this.values.put(name, value);
        this.panel.setInterpolator(value);
        this.enableControls();
    }

    private void enableControls() {
        if (this.properties.getItemCount() > 0) {
            this.top.setEnabled(true);
        } else {
            this.top.setEnabled(false);
        }
    }

    public void removeValue(String name) {
        this.properties.removeItem(name);
        this.values.remove(name);
        if (this.properties.getItemCount() >= 1) {
            this.properties.setSelectedIndex(0);
        } else {
            this.panel.setInterpolator(null);
        }
        this.enableControls();
    }

    public void setFirstProperty() {
        if (this.properties.getItemCount() > 0) {
            this.properties.setSelectedIndex(0);
            ConfigurableEmitter.LinearInterpolator currentValue = (ConfigurableEmitter.LinearInterpolator)this.values.get(this.properties.getSelectedItem());
            this.panel.setInterpolator(currentValue);
        }
    }

    public static void main(String[] argv) {
        JFrame frame = new JFrame("Whiskas Gradient Editor");
        frame.setDefaultCloseOperation(3);
        JPanel main = new JPanel();
        main.setLayout(new BoxLayout(main, 1));
        main.setBackground(Color.CYAN);
        frame.getContentPane().add(main);
        GraphEditorWindow bottom = new GraphEditorWindow();
        ArrayList<Vector2f> curve = new ArrayList<Vector2f>();
        curve.add(new Vector2f(0.0f, 0.0f));
        curve.add(new Vector2f(1.0f, 255.0f));
        ConfigurableEmitter configurableEmitter = new ConfigurableEmitter("bla");
        configurableEmitter.getClass();
        ConfigurableEmitter.LinearInterpolator test = new ConfigurableEmitter.LinearInterpolator(configurableEmitter, curve, 0, 255);
        bottom.registerValue(test, "Test");
        curve = new ArrayList();
        curve.add(new Vector2f(0.0f, 255.0f));
        curve.add(new Vector2f(1.0f, 0.0f));
        ConfigurableEmitter configurableEmitter2 = new ConfigurableEmitter("bla");
        configurableEmitter2.getClass();
        test = new ConfigurableEmitter.LinearInterpolator(configurableEmitter2, curve, 0, 255);
        bottom.registerValue(test, "Test 2");
        main.add(bottom);
        frame.pack();
        frame.setVisible(true);
        frame.setSize(600, 300);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e2) {
                System.exit(0);
            }
        });
        frame.setVisible(true);
    }

    public class GraphPanel
    extends JPanel {
        private ArrayList curve;
        private ConfigurableEmitter.LinearInterpolator value;
        private float viewportMinX;
        private float viewportMaxX;
        private float viewportMinY;
        private float viewportMaxY;
        private float worldMinX = 0.0f;
        private float worldMaxX = 1.0f;
        private float worldMinY = 0.0f;
        private float worldMaxY = 255.0f;
        private float viewBorderX = 50.0f;
        private float viewBorderY = 25.0f;
        private int colorSelectedPoint;
        private int colorPoint;
        private float mouseX;
        private float mouseY;
        private BufferedImage backgroundImage;

        public GraphPanel() {
            this.setLayout(null);
            this.backgroundImage = this.loadBackgroundImage();
            this.addMouseMotionListener(new MouseMotionListener(){

                public void mouseDragged(MouseEvent e2) {
                    GraphPanel.this.mouseDraggedEvent(e2.getX(), e2.getY(), e2.isShiftDown());
                }

                public void mouseMoved(MouseEvent e2) {
                    GraphPanel.this.mouseMovedEvent(e2.getX(), e2.getY());
                }
            });
            this.addMouseListener(new MouseListener(){

                public void mouseEntered(MouseEvent arg0) {
                }

                public void mouseExited(MouseEvent arg0) {
                }

                public void mousePressed(MouseEvent arg0) {
                }

                public void mouseReleased(MouseEvent arg0) {
                }

                public void mouseClicked(MouseEvent e2) {
                    GraphPanel.this.mousePressedEvent(e2.getX(), e2.getY(), e2.getButton() == 1, e2.getButton() == 3, e2.getButton() == 2);
                }
            });
        }

        private BufferedImage loadBackgroundImage() {
            InputStream in = (class$org$newdawn$slick$tools$peditor$ParticleEditor == null ? (class$org$newdawn$slick$tools$peditor$ParticleEditor = GraphEditorWindow.class$("org.newdawn.slick.tools.peditor.ParticleEditor")) : class$org$newdawn$slick$tools$peditor$ParticleEditor).getClassLoader().getResourceAsStream("org/newdawn/slick/tools/peditor/data/charlie.png");
            BufferedImage backgroundImage = null;
            try {
                backgroundImage = ImageIO.read(in);
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            return backgroundImage;
        }

        public void setInterpolator(ConfigurableEmitter.LinearInterpolator value) {
            if (value == null) {
                this.value = null;
                this.curve = null;
            } else {
                this.value = value;
                this.curve = this.convertToCurvePointCurve(value.getCurve());
                GraphEditorWindow.this.minSpinner.setValue(new Integer(value.getMin()));
                GraphEditorWindow.this.maxSpinner.setValue(new Integer(value.getMax()));
                this.worldMinY = value.getMin();
                this.worldMaxY = value.getMax();
                this.repaint();
            }
        }

        private void makeSureCurveFits() {
            for (int i2 = 0; i2 < this.curve.size(); ++i2) {
                CurvePoint point = (CurvePoint)this.curve.get(i2);
                if (point.y > this.worldMaxY) {
                    point.y = this.worldMaxY;
                }
                if (!(point.y < this.worldMinY)) continue;
                point.y = this.worldMinY;
            }
        }

        private int findSelectedPoint(ArrayList curve) {
            for (int i2 = 0; i2 < curve.size(); ++i2) {
                if (!((CurvePoint)curve.get(i2)).isSelected()) continue;
                return i2;
            }
            return -1;
        }

        private int getPrev(ArrayList curve, int idx) {
            if (idx == -1) {
                return -1;
            }
            if (idx <= 0 || idx >= curve.size() - 1) {
                return -1;
            }
            return idx - 1;
        }

        private int getNext(ArrayList curve, int idx) {
            if (idx == -1) {
                return -1;
            }
            if (idx >= curve.size() - 1) {
                return -1;
            }
            return idx + 1;
        }

        public void mouseDraggedEvent(int x, int y, boolean shiftDown) {
            if (!this.isActive()) {
                return;
            }
            int idx = this.findSelectedPoint(this.curve);
            if (idx != -1) {
                CurvePoint selected = (CurvePoint)this.curve.get(idx);
                CurvePoint world = this.viewToWorld(new CurvePoint(x, y));
                if (selected == this.curve.get(0) || selected == this.curve.get(this.curve.size() - 1)) {
                    selected.y = world.y;
                } else {
                    selected.x = world.x;
                    selected.y = world.y;
                }
                if (selected.x < this.worldMinX) {
                    selected.x = this.worldMinX;
                }
                if (selected.x > this.worldMaxX) {
                    selected.x = this.worldMaxX;
                }
                if (selected.y < this.worldMinY) {
                    selected.y = this.worldMinY;
                }
                if (selected.y > this.worldMaxY) {
                    selected.y = this.worldMaxY;
                }
                if (!shiftDown) {
                    int prev = this.getPrev(this.curve, idx);
                    int next = this.getNext(this.curve, idx);
                    if (prev != -1 && selected.x < ((CurvePoint)this.curve.get((int)prev)).x) {
                        selected.x = ((CurvePoint)this.curve.get((int)prev)).x;
                    }
                    if (next != -1 && selected.x > ((CurvePoint)this.curve.get((int)next)).x) {
                        selected.x = ((CurvePoint)this.curve.get((int)next)).x;
                    }
                }
                this.mouseX = x;
                this.mouseY = y;
                this.sortPoints();
                this.repaint();
            }
        }

        public void mouseMovedEvent(int x, int y) {
            if (!this.isActive()) {
                return;
            }
            CurvePoint posView = new CurvePoint(x, y);
            for (int i2 = 0; i2 < this.curve.size(); ++i2) {
                CurvePoint pWorld = (CurvePoint)this.curve.get(i2);
                CurvePoint pView = this.worldToView((CurvePoint)this.curve.get(i2));
                ((CurvePoint)this.curve.get((int)i2)).selected = posView.x > pView.x - 6.0f && posView.x < pView.x + 6.0f && posView.y > pView.y - 6.0f && posView.y < pView.y + 6.0f;
            }
            this.mouseX = x;
            this.mouseY = y;
            this.repaint();
        }

        public void mousePressedEvent(int x, int y, boolean leftButton, boolean rightButton, boolean middleButton) {
            int idx;
            if (!this.isActive()) {
                return;
            }
            if (rightButton) {
                int idx2 = this.findSelectedPoint(this.curve);
                if (idx2 != -1 && idx2 != 0 && idx2 != this.curve.size() - 1) {
                    this.curve.remove(idx2);
                    this.repaint();
                }
            } else if (leftButton && (idx = this.findSelectedPoint(this.curve)) == -1 && (float)x >= this.viewportMinX && (float)x <= this.viewportMaxX && (float)y >= this.viewportMaxY && (float)y <= this.viewportMinY) {
                CurvePoint p = this.viewToWorld(new CurvePoint(x, y));
                this.curve.add(1, p);
                this.sortPoints();
                this.repaint();
            }
        }

        private CurvePoint worldToView(CurvePoint in) {
            float sx = (this.viewportMaxX - this.viewportMinX) / (this.worldMaxX - this.worldMinX);
            float sy = (this.viewportMaxY - this.viewportMinY) / (this.worldMaxY - this.worldMinY);
            float cx = -sx * this.worldMinX + this.viewportMinX;
            float cy = -sy * this.worldMinY + this.viewportMinY;
            return new CurvePoint(sx * in.x + cx, sy * in.y + cy);
        }

        public CurvePoint viewToWorld(CurvePoint view) {
            float sx = (this.viewportMaxX - this.viewportMinX) / (this.worldMaxX - this.worldMinX);
            float sy = (this.viewportMaxY - this.viewportMinY) / (this.worldMaxY - this.worldMinY);
            float cx = -sx * this.worldMinX + this.viewportMinX;
            float cy = -sy * this.worldMinY + this.viewportMinY;
            return new CurvePoint((view.x - cx) / sx, (view.y - cy) / sy);
        }

        private void drawLegend(Graphics2D g2, float vx0, float vy0, float vx1, float vy1) {
            g2.setColor(COLOR_BACKGROUND);
            g2.fillRect((int)vx0, (int)(vy1 - this.viewBorderY), (int)(vx1 - vx0 + this.viewBorderX), (int)(vy0 - vy1 + this.viewBorderY * 2.0f));
            int legendLineMain = (int)this.viewBorderY;
            int legendLineMin = 8;
            g2.setColor(COLOR_LEGEND_BACKGROUND);
            g2.fillRect((int)vx0, (int)vy0, (int)(vx1 - vx0 + this.viewBorderX), (int)vy0);
            g2.setColor(COLOR_LEGEND);
            g2.drawLine((int)vx0, (int)vy0, (int)(vx1 + this.viewBorderX), (int)vy0);
            g2.drawLine((int)vx0, (int)vy0 + 1, (int)(vx1 + this.viewBorderX), (int)vy0 + 1);
            float space = vx1 - vx0;
            int intervalCountX = (int)space / 50;
            if ((intervalCountX & 1) == 1) {
                --intervalCountX;
            }
            for (int x = 0; x < intervalCountX + 1; ++x) {
                float xi0 = (this.worldMaxX - this.worldMinX) / (float)intervalCountX * (float)x;
                CurvePoint c2 = this.worldToView(new CurvePoint(xi0, 0.0f));
                c2.y = vy0;
                g2.setColor(COLOR_LEGEND);
                g2.drawLine((int)c2.x, (int)c2.y, (int)c2.x, (int)c2.y + legendLineMain);
                g2.setColor(COLOR_LEGEND_GRID);
                g2.drawLine((int)c2.x, (int)(this.viewportMaxY - this.viewBorderY), (int)c2.x, (int)this.viewportMinY);
                String text = this.convertFloat(xi0 * 1.0f);
                g2.setColor(COLOR_LEGEND);
                g2.drawString(text, (int)c2.x + 2, (int)(c2.y + this.viewBorderY - 2.0f));
                if (x > intervalCountX - 1) continue;
                for (int xsub = 0; xsub < 2; ++xsub) {
                    float xi1 = (this.worldMaxX - this.worldMinX) / (float)intervalCountX * (float)(x + 1);
                    CurvePoint ci = this.worldToView(new CurvePoint((xi0 + xi1) / 2.0f * (float)xsub, 0.0f));
                    ci.y = vy0;
                    g2.setColor(COLOR_LEGEND);
                    g2.drawLine((int)ci.x, (int)ci.y, (int)ci.x, (int)ci.y + legendLineMin);
                }
            }
            g2.setColor(COLOR_LEGEND_BACKGROUND);
            g2.fillRect(0, (int)(vy1 - this.viewBorderY), (int)vx0, (int)(vy0 + this.viewBorderY));
            space = vy0 - vy1;
            int intervalCountY = (int)space / 30;
            if ((intervalCountY & 1) == 1) {
                --intervalCountY;
            }
            int legendLineMainY = 50;
            for (int y = 0; y < intervalCountY + 1; ++y) {
                float yi0 = (this.worldMaxY - this.worldMinY) / (float)intervalCountY * (float)y + this.worldMinY;
                CurvePoint c3 = this.worldToView(new CurvePoint(0.0f, yi0));
                g2.setColor(COLOR_LEGEND);
                g2.drawLine((int)c3.x - legendLineMainY, (int)c3.y, (int)c3.x, (int)c3.y);
                g2.setColor(COLOR_LEGEND_GRID);
                g2.drawLine((int)c3.x, (int)c3.y, (int)(c3.x + this.viewportMaxX), (int)c3.y);
                String text = this.convertFloat(yi0);
                g2.setColor(COLOR_LEGEND);
                g2.drawString(text, (int)vx0 - g2.getFontMetrics().stringWidth(text) - 2, (int)(c3.y - 2.0f));
            }
            g2.setColor(COLOR_LEGEND);
            g2.drawLine((int)vx0, (int)vy1, (int)(vx1 + this.viewBorderX), (int)vy1);
            g2.drawLine((int)vx0, (int)vy0, (int)vx0, (int)(vy1 - this.viewBorderY));
            g2.drawLine((int)vx1, (int)vy0, (int)vx1, (int)(vy1 - this.viewBorderY));
        }

        private ArrayList convertToPoint2DCurve(ArrayList curve) {
            ArrayList<Vector2f> bla = new ArrayList<Vector2f>();
            for (int j = 0; j < curve.size(); ++j) {
                CurvePoint c2 = (CurvePoint)curve.get(j);
                bla.add(new Vector2f(c2.getX(), c2.getY()));
            }
            return bla;
        }

        private ArrayList convertToCurvePointCurve(ArrayList point2DCurve) {
            ArrayList<CurvePoint> curvePointCurve = new ArrayList<CurvePoint>();
            for (int j = 0; j < point2DCurve.size(); ++j) {
                Vector2f c2 = (Vector2f)point2DCurve.get(j);
                curvePointCurve.add(new CurvePoint(c2.getX(), c2.getY()));
            }
            return curvePointCurve;
        }

        public void paint(Graphics2D g2, float vx0, float vy0, float vx1, float vy1) {
            if (!this.isActive()) {
                g2.drawImage((Image)this.backgroundImage, 0, (int)vy1 - this.backgroundImage.getHeight(), null);
                return;
            }
            this.viewportMinX = vx0 + this.viewBorderX;
            this.viewportMaxX = vx1 - this.viewBorderX;
            this.viewportMinY = vy1 - this.viewBorderY;
            this.viewportMaxY = vy0 + this.viewBorderY;
            this.drawLegend(g2, this.viewportMinX, this.viewportMinY, this.viewportMaxX, this.viewportMaxY);
            g2.setColor(COLOR_LEGEND_GRID);
            g2.drawLine((int)vx0, (int)vy0, (int)vx1, (int)vy0);
            int[] xPoints = new int[this.curve.size()];
            int[] yPoints = new int[this.curve.size()];
            for (int i2 = 0; i2 < this.curve.size(); ++i2) {
                CurvePoint p = this.worldToView((CurvePoint)this.curve.get(i2));
                xPoints[i2] = (int)p.x;
                yPoints[i2] = (int)p.y;
            }
            g2.setColor(COLOR_LINE);
            g2.drawPolyline(xPoints, yPoints, this.curve.size());
            int width = 6;
            int height = 6;
            for (int i3 = 0; i3 < this.curve.size(); ++i3) {
                int off;
                Color colorOutline;
                Color color;
                if (((CurvePoint)this.curve.get((int)i3)).selected) {
                    color = COLOR_SELECTED_POINT;
                    colorOutline = COLOR_SELECTED_POINT_OUTLINE;
                    off = 1;
                } else {
                    color = COLOR_POINT;
                    colorOutline = COLOR_POINT_OUTLINE;
                    off = 0;
                }
                g2.setColor(colorOutline);
                g2.fillRect(xPoints[i3] - width / 2 - off, yPoints[i3] - height / 2 - off, width + off * 2, height + off * 2);
                g2.setColor(color);
                g2.fillRect(xPoints[i3] - width / 2 - off + 1, yPoints[i3] - height / 2 - off + 1, width + off * 2 - 2, height + off * 2 - 2);
                if (this.value == null || !(this.mouseX >= this.viewportMinX) || !(this.mouseX <= this.viewportMaxX) || !(this.mouseY >= vy0) || !(this.mouseY <= vy1)) continue;
                this.value.setCurve(this.convertToPoint2DCurve(this.curve));
                this.value.setMin((int)this.worldMinY);
                this.value.setMax((int)this.worldMaxY);
                CurvePoint a2 = this.viewToWorld(new CurvePoint(this.mouseX, 0.0f));
                float b2 = this.value.getValue(a2.getX());
                CurvePoint crossPoint = new CurvePoint(a2.getX(), b2);
                CurvePoint p = this.worldToView(crossPoint);
                g2.setColor(COLOR_LEGEND_GRID_CROSS);
                g2.drawLine((int)p.getX(), (int)vy0, (int)p.getX(), (int)vy1);
                GraphEditorWindow.this.valueXLabel.setText(GraphEditorWindow.TEXT_CURRENT_X + this.convertFloat(crossPoint.getX()));
                GraphEditorWindow.this.valueYLabel.setText(GraphEditorWindow.TEXT_CURRENT_Y + this.convertFloat(crossPoint.getY()));
            }
        }

        private void sortPoints() {
            final CurvePoint firstPt = (CurvePoint)this.curve.get(0);
            final CurvePoint lastPt = (CurvePoint)this.curve.get(this.curve.size() - 1);
            Comparator compare = new Comparator(){

                public int compare(Object firstO, Object secondO) {
                    CurvePoint first = (CurvePoint)firstO;
                    CurvePoint second = (CurvePoint)secondO;
                    if (first == firstPt) {
                        return -1;
                    }
                    if (second == lastPt) {
                        return -1;
                    }
                    if (first.x < second.x) {
                        return -1;
                    }
                    if (first.x > second.x) {
                        return 1;
                    }
                    return 0;
                }
            };
            Collections.sort(this.curve, compare);
        }

        public void paintComponent(Graphics g1d) {
            super.paintComponent(g1d);
            Graphics2D g2 = (Graphics2D)g1d;
            g2.setColor(new Color(0x303040));
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.paint(g2, 0.0f, 0.0f, this.getWidth(), this.getHeight());
        }

        private boolean isActive() {
            return this.curve != null;
        }

        private String convertFloat(float f2) {
            NumberFormat format = NumberFormat.getInstance();
            format.setMinimumFractionDigits(2);
            format.setMaximumFractionDigits(2);
            format.setMinimumIntegerDigits(1);
            format.setMaximumIntegerDigits(5);
            return format.format(f2);
        }

        public float getWorldMinY() {
            return this.worldMinY;
        }

        public void setWorldMinY(float worldMinY) {
            this.worldMinY = worldMinY;
        }

        public float getWorldMaxY() {
            return this.worldMaxY;
        }

        public void setWorldMaxY(float worldMaxY) {
            this.worldMaxY = worldMaxY;
        }

        private class CurvePoint {
            public float x;
            public float y;
            public boolean selected;

            public CurvePoint(float x, float y) {
                this.x = x;
                this.y = y;
                this.selected = false;
            }

            public boolean isSelected() {
                return this.selected;
            }

            public float getX() {
                return this.x;
            }

            public float getY() {
                return this.y;
            }
        }
    }
}

