/*
 * Decompiled with CFR 0.152.
 */
package phnxflms.unidye.tileentities;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import phnxflms.unidye.containers.slots.DyeSlot;
import phnxflms.unidye.containers.slots.WoolSlot;
import phnxflms.unidye.recipes.RecipeManager;
import phnxflms.unidye.tileentities.BaseIC2Machine;

public class TileEntityWoolDyer
extends BaseIC2Machine
implements ISidedInventory,
IFluidHandler,
IInventory {
    public int maxCapacity = 1000;
    public ItemStack[] inv;
    public int progress = 0;
    public int tick = 0;
    private int overclock = 0;
    private int transformer = 0;
    private boolean useSteam = false;
    private RecipeManager.WoolDyerRecipe recipe = null;
    public static List<String> networkedFields;
    protected boolean created = false;
    public FluidTank steamTank = new FluidTank(100000);

    public TileEntityWoolDyer() {
        super(32, 1000);
        this.inv = new ItemStack[6];
    }

    private void doWork() {
        boolean canWork = this.canWork();
        this.setWorking(canWork);
        if (!canWork) {
            this.tick = 0;
            this.progress = 0;
            return;
        }
        int tickMax = this.recipe.getTime();
        this.progress = (int)((float)this.tick / (float)tickMax * 100.0f);
        this.tick += 1 + this.overclock;
        if (this.useSteam) {
            if (this.overclock == 0) {
                this.steamTank.drain(this.recipe.getEU() * 2, true);
            } else {
                this.steamTank.drain(this.recipe.getEU() * 2 * 4 * this.overclock, true);
            }
        } else {
            this.energy = this.overclock == 0 ? (this.energy -= (double)this.recipe.getEU()) : (this.energy -= (double)(this.recipe.getEU() * 4 * this.overclock));
        }
        if (this.tick < tickMax) {
            return;
        }
        this.tick = 0;
        this.progress = 0;
        this.inv[0].field_77994_a -= this.recipe.getDye().field_77994_a;
        this.inv[1].field_77994_a -= this.recipe.getWool().field_77994_a;
        if (this.inv[0].field_77994_a == 0) {
            this.inv[0] = null;
        }
        if (this.inv[1].field_77994_a == 0) {
            this.inv[1] = null;
        }
        ItemStack dye = this.recipe.getDye();
        ItemStack wool = this.recipe.getWool();
        if (this.inv[2] == null) {
            this.inv[2] = this.recipe.getOutput();
        } else {
            this.inv[2].field_77994_a += this.recipe.getOutput().field_77994_a;
        }
    }

    private boolean canWork() {
        ItemStack product;
        this.recipe = RecipeManager.getWoolDyerRecipe(this.inv[0], this.inv[1]);
        if (this.recipe == null || this.inv[1].field_77994_a < this.recipe.getWool().field_77994_a) {
            return false;
        }
        if (this.useSteam ? (this.overclock == 0 ? this.steamTank.getFluidAmount() < this.recipe.getEU() * 2 : this.steamTank.getFluidAmount() < this.recipe.getEU() * 4 * this.overclock * 2) : (this.overclock == 0 ? this.energy < (double)this.recipe.getEU() : this.energy < (double)(this.recipe.getEU() * 4 * this.overclock))) {
            return false;
        }
        return !(this.inv[2] != null & (product = this.recipe.getOutput()) != null) || !(!product.func_77969_a(this.inv[2]) | this.inv[2].field_77994_a > this.inv[2].func_77976_d() - product.field_77994_a);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.update();
        }
    }

    private void update() {
        this.overclock = this.inv[3] != null ? this.inv[3].field_77994_a : 0;
        if (this.inv[4] != null) {
            this.transformer = this.inv[4].field_77994_a;
            this.maxInput = voltages[this.transformer > 5 ? 5 : this.transformer];
            this.maxCapacity = 1000 * this.transformer;
        } else {
            this.transformer = 0;
            this.maxInput = voltages[0];
            this.maxCapacity = 1000;
        }
        boolean bl = this.useSteam = this.inv[5] != null;
        if (this.inv[0] != null && this.inv[1] != null) {
            this.doWork();
        } else {
            this.tick = 0;
            this.progress = 0;
            this.setWorking(false);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("overclock", this.overclock);
        nbttagcompound.func_74768_a("transformer", this.transformer);
        nbttagcompound.func_74757_a("useSteam", this.useSteam);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inv.length; ++i) {
            ItemStack stack = this.inv[i];
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        this.steamTank.writeToNBT(nbttagcompound);
        nbttagcompound.func_74782_a("Inventory", (NBTBase)itemList);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.overclock = nbttagcompound.func_74762_e("overclock");
        this.transformer = nbttagcompound.func_74762_e("transformer");
        this.useSteam = nbttagcompound.func_74767_n("useSteam");
        NBTTagList tagList = nbttagcompound.func_150295_c("Inventory", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inv.length) continue;
            this.inv[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        this.steamTank.readFromNBT(nbttagcompound);
    }

    public void func_70305_f() {
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(amount);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return stack;
    }

    public String func_145825_b() {
        return "unidye.tileentitywooldyer";
    }

    public int func_70297_j_() {
        return 64;
    }

    public int func_70302_i_() {
        return this.inv.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inv[slot];
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            this.func_70299_a(slot, null);
        }
        return stack;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) < 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inv[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return null;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int sideMaybe) {
        return slot == 2;
    }

    public boolean func_102007_a(int slot, ItemStack items, int sideMaybe) {
        if (slot == 1) {
            int m = items.func_77960_j();
            int n = items.field_77994_a;
            if (WoolSlot.okay.contains(items.func_77973_b())) {
                if (items.func_77969_a(new ItemStack(items.func_77973_b(), n, m))) {
                    return true;
                }
                return true;
            }
            return false;
        }
        if (slot == 0) {
            int m = items.func_77960_j();
            int n = items.field_77994_a;
            if (DyeSlot.okay.contains(items.func_77973_b())) {
                if (items.func_77969_a(new ItemStack(items.func_77973_b(), n, slot))) {
                    return true;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public int[] func_94128_d(int sideProbably) {
        return new int[]{0, 1, 2};
    }
}

