/*
 * Decompiled with CFR 0.152.
 */
package phnxflms.unidye.tileentities;

import ic2.core.item.armor.ItemArmorQuantumSuit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import phnxflms.unidye.Unidye;
import phnxflms.unidye.containers.slots.ArmourSlot;
import phnxflms.unidye.containers.slots.DyeSlot;
import phnxflms.unidye.recipes.CraftingRecipes;
import phnxflms.unidye.tileentities.TileEntityDyer;

public class TileEntityArmourDyer
extends TileEntityDyer {
    public static final int[] DYE_CODES = new int[]{0x191919, 0x993333, 6717235, 6704179, 3361970, 8339378, 5013401, 0x999999, 0x4C4C4C, 15892389, 8375321, 0xE5E533, 6724056, 11685080, 14188339, 0xFFFFFF};
    private ArmourDyingRecipe recipe = null;

    public TileEntityArmourDyer() {
        super(32, 1000);
    }

    private void doWork() {
        boolean canWork = this.canWork();
        this.setWorking(canWork);
        if (!canWork) {
            this.tick = 0;
            this.progress = 0;
            return;
        }
        int tickMax = this.recipe.getTime();
        this.progress = (int)((float)this.tick / (float)tickMax * 100.0f);
        this.tick += 1 + this.overclock;
        if (this.useSteam) {
            if (this.overclock == 0) {
                this.steamTank.drain(this.recipe.getEU() * 2, true);
            } else {
                this.steamTank.drain(this.recipe.getEU() * 2 * 4 * this.overclock, true);
            }
        } else {
            this.energy = this.overclock == 0 ? (this.energy -= (double)this.recipe.getEU()) : (this.energy -= (double)(this.recipe.getEU() * 4 * this.overclock));
        }
        if (this.tick < tickMax) {
            return;
        }
        this.tick = 0;
        this.progress = 0;
        --this.inv[0].field_77994_a;
        if (this.inv[0].field_77994_a == 0) {
            this.inv[0] = null;
        }
        this.inv[1] = null;
        this.inv[2] = this.recipe.Output.func_77946_l();
    }

    protected boolean canWork() {
        this.recipe = new ArmourDyingRecipe();
        this.recipe.getRecipe(this.inv[0].func_77946_l(), this.inv[1].func_77946_l());
        if (this.recipe == null || this.inv[2] != null) {
            return false;
        }
        return !(this.useSteam ? (this.overclock == 0 ? this.steamTank.getFluidAmount() < this.recipe.getEU() * 2 : this.steamTank.getFluidAmount() < this.recipe.getEU() * 4 * this.overclock * 2) : (this.overclock == 0 ? this.energy < (double)this.recipe.getEU() : this.energy < (double)(this.recipe.getEU() * 4 * this.overclock)));
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.update();
        }
    }

    private void update() {
        this.overclock = this.inv[3] != null ? this.inv[3].field_77994_a : 0;
        if (this.inv[4] != null) {
            this.transformer = this.inv[4].field_77994_a;
            this.maxInput = voltages[this.transformer > 5 ? 5 : this.transformer];
            this.maxCapacity = 1000 * this.transformer;
        } else {
            this.transformer = 0;
            this.maxInput = voltages[0];
            this.maxCapacity = 1000;
        }
        boolean bl = this.useSteam = this.inv[5] != null;
        if (this.inv[0] != null && this.inv[1] != null) {
            this.doWork();
        } else {
            this.tick = 0;
            this.progress = 0;
            this.setWorking(false);
        }
    }

    @Override
    public String func_145825_b() {
        return "unidye.tileentityarmourdyer";
    }

    @Override
    public boolean func_102007_a(int slot, ItemStack items, int sideMaybe) {
        if (slot == 1) {
            return ArmourSlot.okay.contains(items.func_77973_b());
        }
        if (slot == 0) {
            return DyeSlot.okay.contains(items.func_77973_b());
        }
        return false;
    }

    private class ArmourDyingRecipe {
        protected ItemStack Output;
        private final ArrayList<String> CONV = new ArrayList();

        private ArmourDyingRecipe() {
        }

        public ArmourDyingRecipe getRecipe(ItemStack dye, ItemStack armour) {
            if (!DyeSlot.okay.contains(dye.func_77973_b()) || !ArmourSlot.okay.contains(armour.func_77973_b())) {
                return null;
            }
            int dyeID = -1;
            if (dye.func_77973_b() instanceof ItemDye) {
                dyeID = DYE_CODES[dye.func_77960_j()];
            } else {
                int[] IDs;
                for (int ID : IDs = OreDictionary.getOreIDs((ItemStack)dye)) {
                    for (String colour : CraftingRecipes.DYES) {
                        String name = OreDictionary.getOreName((int)ID);
                        if (!name.equals(colour)) continue;
                        this.fillConv();
                        dyeID = DYE_CODES[this.CONV.indexOf(name)];
                    }
                }
            }
            if (dyeID == -1) {
                Unidye.logger.info("Counldn't find the colour of the dye");
                return null;
            }
            this.Output = armour;
            boolean pre = false;
            int colour = 0;
            if (armour.func_77973_b() instanceof ItemArmorQuantumSuit) {
                pre = ((ItemArmorQuantumSuit)armour.func_77973_b()).func_82816_b_(armour);
                if (pre) {
                    colour = ((ItemArmorQuantumSuit)armour.func_77973_b()).func_82814_b(armour);
                }
            } else if (armour.func_77973_b() instanceof ItemArmor) {
                pre = ((ItemArmor)armour.func_77973_b()).func_82816_b_(armour);
                if (pre) {
                    colour = ((ItemArmor)armour.func_77973_b()).func_82814_b(armour);
                }
            } else {
                Unidye.logger.info("A strange happened.");
                return null;
            }
            colour = pre ? this.merge(this.splatter(dyeID), this.splatter(colour)) : this.merge(this.splatter(dyeID), this.splatter(dyeID));
            if (armour.func_77973_b() instanceof ItemArmorQuantumSuit) {
                ((ItemArmorQuantumSuit)armour.func_77973_b()).colorQArmor(armour, colour);
            } else if (armour.func_77973_b() instanceof ItemArmor) {
                ((ItemArmor)armour.func_77973_b()).func_82813_b(armour, colour);
            }
            this.Output = armour;
            return this;
        }

        private void fillConv() {
            for (String colour : (String[])CraftingRecipes.DYES.clone()) {
                this.CONV.add(colour);
            }
            Collections.reverse(this.CONV);
        }

        private int[] splatter(int colour) {
            Matcher m = Pattern.compile("(?i)(?:0x)?([0-F]{2})([0-F]{2})([0-F]{2})").matcher(Integer.toHexString(colour));
            if (m.find()) {
                return new int[]{Integer.parseInt(m.group(1), 16), Integer.parseInt(m.group(2), 16), Integer.parseInt(m.group(3), 16)};
            }
            Unidye.logger.error("Illegal number sent to splatter: " + colour);
            return new int[]{-1};
        }

        private int merge(int[] start, int[] colour) {
            return Integer.parseInt(Integer.toHexString((start[0] + colour[0]) / 2) + "" + Integer.toHexString((start[1] + colour[1]) / 2) + "" + Integer.toHexString((start[2] + colour[2]) / 2), 16);
        }

        public int getEU() {
            return 2;
        }

        public int getTime() {
            return 200;
        }
    }
}

