/*
 * Decompiled with CFR 0.152.
 */
package phnxflms.unidye.tileentities;

import net.minecraft.item.ItemStack;
import phnxflms.unidye.containers.slots.DyeSlot;
import phnxflms.unidye.containers.slots.WoolSlot;
import phnxflms.unidye.recipes.RecipeManager;
import phnxflms.unidye.tileentities.TileEntityDyer;

public class TileEntityWoolDyer
extends TileEntityDyer {
    private RecipeManager.WoolDyerRecipe recipe = null;

    public TileEntityWoolDyer() {
        super(32, 1000);
    }

    private void doWork() {
        boolean canWork = this.canWork();
        this.setWorking(canWork);
        if (!canWork) {
            this.tick = 0;
            this.progress = 0;
            return;
        }
        int tickMax = this.recipe.getTime();
        this.progress = (int)((float)this.tick / (float)tickMax * 100.0f);
        this.tick += 1 + this.overclock;
        if (this.useSteam) {
            if (this.overclock == 0) {
                this.steamTank.drain(this.recipe.getEU() * 2, true);
            } else {
                this.steamTank.drain(this.recipe.getEU() * 2 * 4 * this.overclock, true);
            }
        } else {
            this.energy = this.overclock == 0 ? (this.energy -= (double)this.recipe.getEU()) : (this.energy -= (double)(this.recipe.getEU() * 4 * this.overclock));
        }
        if (this.tick < tickMax) {
            return;
        }
        this.tick = 0;
        this.progress = 0;
        this.inv[0].field_77994_a -= this.recipe.getDye().field_77994_a;
        this.inv[1].field_77994_a -= this.recipe.getWool().field_77994_a;
        if (this.inv[0].field_77994_a == 0) {
            this.inv[0] = null;
        }
        if (this.inv[1].field_77994_a == 0) {
            this.inv[1] = null;
        }
        ItemStack dye = this.recipe.getDye();
        if (this.inv[2] == null) {
            this.inv[2] = this.recipe.getOutput();
        } else {
            this.inv[2].field_77994_a += this.recipe.getOutput().field_77994_a;
        }
    }

    private boolean canWork() {
        ItemStack product;
        this.recipe = RecipeManager.getWoolDyerRecipe(this.inv[0], this.inv[1]);
        if (this.recipe == null || this.inv[1].field_77994_a < this.recipe.getWool().field_77994_a) {
            return false;
        }
        if (this.useSteam ? (this.overclock == 0 ? this.steamTank.getFluidAmount() < this.recipe.getEU() * 2 : this.steamTank.getFluidAmount() < this.recipe.getEU() * 4 * this.overclock * 2) : (this.overclock == 0 ? this.energy < (double)this.recipe.getEU() : this.energy < (double)(this.recipe.getEU() * 4 * this.overclock))) {
            return false;
        }
        return !(this.inv[2] != null & (product = this.recipe.getOutput()) != null) || !(!product.func_77969_a(this.inv[2]) | this.inv[2].field_77994_a > this.inv[2].func_77976_d() - product.field_77994_a);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.update();
        }
    }

    private void update() {
        this.overclock = this.inv[3] != null ? this.inv[3].field_77994_a : 0;
        if (this.inv[4] != null) {
            this.transformer = this.inv[4].field_77994_a;
            this.maxInput = voltages[this.transformer > 5 ? 5 : this.transformer];
            this.maxCapacity = 1000 * this.transformer;
        } else {
            this.transformer = 0;
            this.maxInput = voltages[0];
            this.maxCapacity = 1000;
        }
        boolean bl = this.useSteam = this.inv[5] != null;
        if (this.inv[0] != null && this.inv[1] != null) {
            this.doWork();
        } else {
            this.tick = 0;
            this.progress = 0;
            this.setWorking(false);
        }
    }

    @Override
    public String func_145825_b() {
        return "unidye.tileentitywooldyer";
    }

    @Override
    public boolean func_102007_a(int slot, ItemStack items, int sideMaybe) {
        if (slot == 1) {
            return WoolSlot.okay.contains(items.func_77973_b());
        }
        if (slot == 0) {
            return DyeSlot.okay.contains(items.func_77973_b());
        }
        return false;
    }
}

