/*
 * Decompiled with CFR 0.152.
 */
package phnxflms.unidye.tileentities;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import phnxflms.unidye.Unidye;
import phnxflms.unidye.tileentities.BaseIC2Machine;
import phnxflms.unidye.utils.UnidyeUtils;

public abstract class TileEntityDyer
extends BaseIC2Machine
implements ISidedInventory,
IFluidHandler,
IInventory {
    public int maxCapacity = 1000;
    public ItemStack[] inv;
    public int progress = 0;
    public int tick = 0;
    protected int overclock = 0;
    protected int transformer = 0;
    protected boolean useSteam = false;
    public static List<String> networkedFields;
    protected boolean created = false;
    public FluidTank steamTank = new FluidTank(100000);

    public abstract String func_145825_b();

    public TileEntityDyer(int safeVoltage, int maxStoredEnergy) {
        super(safeVoltage, maxStoredEnergy);
        this.inv = new ItemStack[6];
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("overclock", this.overclock);
        nbttagcompound.func_74768_a("transformer", this.transformer);
        nbttagcompound.func_74757_a("useSteam", this.useSteam);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inv.length; ++i) {
            ItemStack stack = this.inv[i];
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        this.steamTank.writeToNBT(nbttagcompound);
        nbttagcompound.func_74782_a("Inventory", (NBTBase)itemList);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.overclock = nbttagcompound.func_74762_e("overclock");
        this.transformer = nbttagcompound.func_74762_e("transformer");
        this.useSteam = nbttagcompound.func_74767_n("useSteam");
        NBTTagList tagList = nbttagcompound.func_150295_c("Inventory", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inv.length) continue;
            this.inv[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        this.steamTank.readFromNBT(nbttagcompound);
    }

    public void func_70305_f() {
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(amount);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return stack;
    }

    public int func_70297_j_() {
        return 64;
    }

    public int func_70302_i_() {
        return this.inv.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inv[slot];
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            this.func_70299_a(slot, null);
        }
        return stack;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) < 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inv[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (Unidye.isSteamAvailable && this.useSteam && UnidyeUtils.getFluidName(resource.getFluid(), false).matches(".*[steam].*")) {
            return this.steamTank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || resource.isFluidEqual(this.steamTank.getFluid())) {
            return null;
        }
        return this.steamTank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.steamTank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return Unidye.isSteamAvailable && this.useSteam && UnidyeUtils.getFluidName(fluid, false).matches(".*[steam].*");
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.steamTank.getInfo()};
    }

    public boolean func_102008_b(int slot, ItemStack stack, int sideMaybe) {
        return slot == 2;
    }

    public abstract boolean func_102007_a(int var1, ItemStack var2, int var3);

    public int[] func_94128_d(int sideProbably) {
        return new int[]{0, 1, 2};
    }
}

