/*
 * Decompiled with CFR 0.152.
 */
package wlel.tile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import wlel.tile.TileEntityEMFS;
import wlel.tile.TileEntityNode;
import wlel.tile.TileEntityReceiver;
import wlel.tile.TileEntityTransmitter;

public class WNet {
    private ArrayList<TileEntityTransmitter> transmitters = new ArrayList();
    private ArrayList<TileEntityReceiver> receivers = new ArrayList();
    private final long id;
    private TileEntityEMFS emfs;
    private static Map<Long, WNet> wnets = new HashMap<Long, WNet>();

    public WNet(TileEntityEMFS emfs, long id) {
        this.emfs = emfs;
        this.id = id;
        if (wnets.containsKey(id)) {
            WNet wnet = wnets.get(id);
            wnet.destroy();
        }
        wnets.put(id, this);
    }

    public long getID() {
        return this.id;
    }

    public boolean addNode(TileEntityNode te) {
        if (Math.sqrt(te.func_145835_a(this.emfs.field_145851_c, this.emfs.field_145848_d, this.emfs.field_145849_e)) > 32.0) {
            return false;
        }
        if (te instanceof TileEntityTransmitter && !this.transmitters.contains((Object)te)) {
            this.transmitters.add((TileEntityTransmitter)te);
        } else if (te instanceof TileEntityReceiver) {
            this.receivers.add((TileEntityReceiver)te);
        }
        return true;
    }

    public void removeNode(TileEntityNode te) {
        if (te instanceof TileEntityTransmitter) {
            this.transmitters.remove((Object)te);
        } else {
            this.receivers.remove((Object)te);
        }
    }

    public void update() {
        double putratio;
        double requestedEnergy = 0.0;
        for (TileEntityReceiver rec : this.receivers) {
            requestedEnergy += rec.getEnergy();
        }
        double avaliableEnergy = 0.0;
        for (TileEntityTransmitter trans : this.transmitters) {
            avaliableEnergy += trans.getEnergy();
        }
        if (avaliableEnergy == 0.0 || requestedEnergy == 0.0) {
            return;
        }
        double exratio = requestedEnergy / avaliableEnergy;
        if (exratio > 1.0) {
            exratio = 1.0;
        }
        if ((putratio = avaliableEnergy / requestedEnergy) > 1.0) {
            putratio = 1.0;
        }
        for (TileEntityTransmitter trans : this.transmitters) {
            trans.sendEnergy(exratio * trans.getEnergy());
        }
        for (TileEntityReceiver rec : this.receivers) {
            rec.sendEnergy(putratio * rec.getEnergy());
        }
    }

    public void destroy() {
        for (TileEntityNode tileEntityNode : this.transmitters) {
            tileEntityNode.wnetDestroyed();
        }
        for (TileEntityNode tileEntityNode : this.receivers) {
            tileEntityNode.wnetDestroyed();
        }
        while (wnets.containsKey(this.id)) {
            wnets.remove(this.id);
        }
    }

    public static WNet getNet(long id) {
        return wnets.get(id);
    }

    public static boolean netExists(long id) {
        return wnets.containsKey(id);
    }

    public static void clearNets() {
        wnets.clear();
    }
}

