/*
 * Decompiled with CFR 0.152.
 */
package wlel.main;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import wlel.blocks.BlockRegistry;
import wlel.event.WorldUnloadEventHandler;
import wlel.item.ItemRegistry;
import wlel.main.CraftingRegistry;
import wlel.network.CommonProxy;
import wlel.tile.TileEntityEMFS;
import wlel.tile.TileEntityReceiver;
import wlel.tile.TileEntityTransmitter;

@Mod(modid="wlel", name="Wireless Electricity", version="0.2.0", dependencies="required-after:IC2")
public class WirelessElectricity {
    public static final String MODID = "wlel";
    public static final String NAME = "Wireless Electricity";
    public static int maxPackets;
    public static int maxEuPerPacket;
    public static int maxEupt;
    @Mod.Instance
    public static WirelessElectricity instance;
    @SidedProxy(clientSide="wlel.network.ClientProxy", serverSide="wlel.network.ServerProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        Configuration c = new Configuration(e.getSuggestedConfigurationFile());
        c.load();
        String GEN = "general";
        String CLASSIC = "ic2_classic";
        c.setCategoryComment("ic2_classic", "These settings only apply to IC2 Classic");
        maxEupt = c.getInt("maxEupt", "general", 16384, 0, Integer.MAX_VALUE, "max eu/t output per reciver");
        maxPackets = c.getInt("maxPackets", "ic2_classic", 512, 1, 16384, "max # of packets per tick per receiver");
        maxEuPerPacket = c.getInt("maxEuPerPacket", "ic2_classic", 32, 1, 16384, "max eu per packet");
        c.save();
        BlockRegistry.registerBlocks();
        ItemRegistry.registerItems();
        proxy.registerTileEntityRenderers();
        GameRegistry.registerTileEntity(TileEntityReceiver.class, (String)"wlel:receiver");
        GameRegistry.registerTileEntity(TileEntityTransmitter.class, (String)"wlel:transmitter");
        GameRegistry.registerTileEntity(TileEntityEMFS.class, (String)"wlel:emfs");
        MinecraftForge.EVENT_BUS.register((Object)new WorldUnloadEventHandler());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        CraftingRegistry.registerRecipes();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        proxy.registerRenderInformation();
    }
}

