/*
 * Decompiled with CFR 0.152.
 */
package wlel.render;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import net.minecraft.client.renderer.Tessellator;
import wlel.render.Vector3f;

public class NodeBuffer {
    private float[] vertexBuffer = new float[120];
    private static float PIXEL_SIZE = 0.0625f;
    private Vector3f max = new Vector3f();
    private Vector3f min = new Vector3f();
    public static NodeBuffer[] nodeBuffers = new NodeBuffer[12];

    public static void cleanUpServer() {
        for (NodeBuffer nb : nodeBuffers) {
            nb.clear();
        }
    }

    public void clear() {
        this.vertexBuffer = null;
    }

    public Vector3f getMin() {
        return this.min;
    }

    public Vector3f getMax() {
        return this.max;
    }

    public void render() {
        Tessellator t = Tessellator.field_78398_a;
        for (int i = 0; i < this.vertexBuffer.length; i += 5) {
            t.func_78374_a((double)this.vertexBuffer[i], (double)this.vertexBuffer[i + 1], (double)this.vertexBuffer[i + 2], (double)this.vertexBuffer[i + 3], (double)this.vertexBuffer[i + 4]);
        }
    }

    public void loadVertex(InputStream is) {
        byte[] buffer = new byte[480];
        try {
            is.read(buffer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ByteBuffer bb = ByteBuffer.allocate(480);
        bb.put(buffer);
        bb.position(0);
        for (int i = 0; i < 120; ++i) {
            this.vertexBuffer[i] = bb.getFloat();
        }
    }

    public void loadBoundBox(InputStream is) {
        byte[] buffer = new byte[24];
        try {
            is.read(buffer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ByteBuffer bb = ByteBuffer.allocate(24);
        bb.put(buffer);
        bb.position(0);
        this.min.x = bb.getFloat();
        this.min.y = bb.getFloat();
        this.min.z = bb.getFloat();
        this.max.x = bb.getFloat();
        this.max.y = bb.getFloat();
        this.max.z = bb.getFloat();
    }

    static {
        try {
            InputStream nb = NodeBuffer.class.getClassLoader().getResourceAsStream("assets/wlel/nodebuffers.vertexData");
            InputStream bb = NodeBuffer.class.getClassLoader().getResourceAsStream("assets/wlel/boundboxes.vertexData");
            for (int i = 0; i < 12; ++i) {
                NodeBuffer.nodeBuffers[i] = new NodeBuffer();
                nodeBuffers[i].loadVertex(nb);
                nodeBuffers[i].loadBoundBox(bb);
            }
            nb.close();
            bb.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

