/*
 * Decompiled with CFR 0.152.
 */
package wlel.tile;

import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyTile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import wlel.main.WirelessElectricity;
import wlel.tile.TileEntityReceiver;
import wlel.tile.TileEntityTransmitter;
import wlel.tile.WNet;

public abstract class TileEntityNode
extends TileEntity
implements IEnergyTile {
    protected static final double MAX_STORAGE = WirelessElectricity.maxEupt;
    protected double storedEnergy = 0.0;
    protected long tick = 0L;
    private long wNetID = -1L;
    private boolean hasWNetID = false;
    private WNet wnet = null;

    public abstract double getEnergy();

    public abstract void sendEnergy(double var1);

    public void setWNet(long id, EntityPlayer player) {
        if (this.wnet != null && this.wnet.getID() != id) {
            this.wnet.removeNode(this);
        }
        this.wNetID = id;
        this.hasWNetID = true;
        this.wnet = WNet.getNet(this.wNetID);
        if (this.wnet != null) {
            if (!this.wnet.addNode(this)) {
                this.hasWNetID = false;
                if (player != null) {
                    player.func_145747_a((IChatComponent)new ChatComponentText("This node is too far from its Electromagnetic Field Stabilizer!"));
                }
            }
        } else if (player != null) {
            player.func_145747_a((IChatComponent)new ChatComponentText("Electromagnetic Field Stabilizer no longer exists/is not loaded!"));
        }
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.tick == 0L) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
        }
        if (this.tick % 20L == 0L && this.hasWNetID && this.wnet == null) {
            this.wnet = WNet.getNet(this.wNetID);
            if (this.wnet != null && !this.wnet.addNode(this)) {
                this.hasWNetID = false;
            }
        }
        this.handleEnergy();
        ++this.tick;
    }

    public void wnetDestroyed() {
        this.wnet = null;
    }

    public void forgetWNet() {
        this.hasWNetID = false;
        this.wnet = null;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
        this.tick = 0L;
        if (this.wnet != null) {
            this.wnet.removeNode(this);
        }
    }

    public void func_145839_a(NBTTagCompound c) {
        super.func_145839_a(c);
        if (c.func_74764_b("wn")) {
            this.setWNet(c.func_74763_f("wn"), null);
        }
        if (c.func_74764_b("se")) {
            this.storedEnergy = c.func_74769_h("se");
        }
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return from.ordinal() == this.func_145832_p();
    }

    protected abstract void handleEnergy();

    protected TileEntity getEnergyHandler() {
        TileEntity te = null;
        switch (this.func_145832_p()) {
            case 0: {
                te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
                break;
            }
            case 1: {
                te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
                break;
            }
            case 2: {
                te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1);
                break;
            }
            case 3: {
                te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1);
                break;
            }
            case 4: {
                te = this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e);
                break;
            }
            case 5: {
                te = this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e);
            }
        }
        if (this instanceof TileEntityTransmitter && te instanceof IEnergyProvider) {
            return te;
        }
        if (this instanceof TileEntityReceiver && te instanceof IEnergyReceiver) {
            return te;
        }
        return null;
    }

    public void func_145841_b(NBTTagCompound c) {
        super.func_145841_b(c);
        if (this.hasWNetID) {
            c.func_74772_a("wn", this.wNetID);
        }
        c.func_74780_a("se", this.storedEnergy);
    }
}

