/*
 * Decompiled with CFR 0.152.
 */
package wlel.tile;

import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import ic2.api.energy.tile.IMultiEnergySource;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import wlel.main.IC2Classic;
import wlel.main.WirelessElectricity;
import wlel.tile.TileEntityNode;

public class TileEntityReceiver
extends TileEntityNode
implements IEnergyProvider,
IMultiEnergySource {
    private static boolean classic = IC2Classic.isIc2ClassicLoaded();

    @Override
    public double getEnergy() {
        return MAX_STORAGE - this.storedEnergy;
    }

    @Override
    public void sendEnergy(double amount) {
        this.storedEnergy += amount;
    }

    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return direction.ordinal() == this.func_145832_p();
    }

    public double getOfferedEnergy() {
        if (classic) {
            return Math.min((double)WirelessElectricity.maxEuPerPacket, this.storedEnergy);
        }
        return this.storedEnergy;
    }

    public void drawEnergy(double amount) {
        this.storedEnergy -= amount;
    }

    public int getSourceTier() {
        return 1;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        if (!this.canConnectEnergy(from)) {
            return 0;
        }
        this.storedEnergy -= (double)maxExtract / 4.0;
        double cStored = this.storedEnergy;
        if (simulate) {
            this.storedEnergy += (double)maxExtract / 4.0;
        }
        if (cStored < 0.0) {
            double diff = -cStored;
            if (!simulate) {
                this.storedEnergy += diff;
            }
            maxExtract -= (int)(diff * 4.0);
        }
        return maxExtract;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        if (!this.canConnectEnergy(from)) {
            return 0;
        }
        return (int)(this.storedEnergy * 4.0);
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        if (!this.canConnectEnergy(from)) {
            return 0;
        }
        return (int)MAX_STORAGE * 4;
    }

    @Override
    protected void handleEnergy() {
        TileEntity te = this.getEnergyHandler();
        if (te == null) {
            return;
        }
        IEnergyReceiver ep = (IEnergyReceiver)te;
        ForgeDirection opposite = ForgeDirection.getOrientation((int)ForgeDirection.OPPOSITES[this.func_145832_p()]);
        if (!ep.canConnectEnergy(opposite)) {
            return;
        }
        int extracted = ep.receiveEnergy(opposite, (int)(this.storedEnergy * 4.0), false);
        this.storedEnergy -= (double)extracted / 4.0;
    }

    @Override
    public boolean sendMultibleEnergyPackets() {
        return true;
    }

    @Override
    public int getMultibleEnergyPacketAmount() {
        return WirelessElectricity.maxPackets;
    }
}

