/*
 * Decompiled with CFR 0.152.
 */
package wlel.tile;

import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import ic2.api.energy.tile.IEnergySink;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import wlel.tile.TileEntityNode;

public class TileEntityTransmitter
extends TileEntityNode
implements IEnergySink,
IEnergyReceiver {
    @Override
    public double getEnergy() {
        return this.storedEnergy;
    }

    @Override
    public void sendEnergy(double amount) {
        this.storedEnergy -= amount;
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return direction.ordinal() == this.func_145832_p();
    }

    public double getDemandedEnergy() {
        return MAX_STORAGE - this.storedEnergy;
    }

    public int getSinkTier() {
        return 4;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        this.storedEnergy += amount;
        double overflow = this.storedEnergy - MAX_STORAGE;
        if (overflow > 0.0) {
            this.storedEnergy = MAX_STORAGE;
            return overflow;
        }
        return 0.0;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (!this.canConnectEnergy(from)) {
            return 0;
        }
        if (maxReceive < 0) {
            return 0;
        }
        this.storedEnergy += (double)maxReceive / 4.0;
        double cEnergy = this.storedEnergy;
        if (simulate) {
            this.storedEnergy -= (double)maxReceive / 4.0;
        }
        if (cEnergy > MAX_STORAGE) {
            double diff = cEnergy - MAX_STORAGE;
            if (!simulate) {
                this.storedEnergy -= diff;
            }
            maxReceive = (int)((double)maxReceive - diff * 4.0);
        }
        return maxReceive;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        if (!this.canConnectEnergy(from)) {
            return 0;
        }
        return (int)(this.storedEnergy * 4.0);
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        if (!this.canConnectEnergy(from)) {
            return 0;
        }
        return (int)(MAX_STORAGE * 4.0);
    }

    @Override
    protected void handleEnergy() {
        TileEntity te = this.getEnergyHandler();
        if (te == null) {
            return;
        }
        IEnergyProvider ep = (IEnergyProvider)te;
        ForgeDirection opposite = ForgeDirection.getOrientation((int)ForgeDirection.OPPOSITES[this.func_145832_p()]);
        if (!ep.canConnectEnergy(opposite)) {
            return;
        }
        int maxExtract = (int)Math.min((MAX_STORAGE - this.storedEnergy) * 4.0, (double)ep.getEnergyStored(opposite));
        int extracted = ep.extractEnergy(opposite, maxExtract, false);
        this.storedEnergy += (double)extracted / 4.0;
    }
}

