/*
 * Decompiled with CFR 0.152.
 */
package chocohead.patcher.extratrees;

import binnie.extratrees.gen.WorldGenDefault;
import binnie.extratrees.genetics.ExtraTreeSpecies;
import chocohead.patcher.PatcherPlugin;
import com.mojang.authlib.GameProfile;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenerator;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.world.ITreeGenData;
import forestry.arboriculture.blocks.BlockForestryLeaves;
import forestry.arboriculture.genetics.Tree;
import forestry.arboriculture.tiles.TileLeaves;
import forestry.plugins.PluginArboriculture;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.util.ForgeDirection;

public class GeneratorPatcher
implements ITreeGenerator {
    private final Class<? extends WorldGenerator> generator;

    public GeneratorPatcher(Class<? extends WorldGenerator> gen) {
        this.generator = gen == null ? WorldGenDefault.class : gen;
    }

    public WorldGenerator getWorldGenerator(ITreeGenData tree) {
        try {
            if (this.generator.getName().startsWith("forestry.arboriculture")) {
                return this.generator.getConstructor(ITreeGenData.class).newInstance(tree);
            }
            return this.generator.getConstructor(ITree.class).newInstance(tree);
        }
        catch (Exception e) {
            PatcherPlugin.Patcher.logger.warn("Error getting tree generator, it is a danger to have saplings of " + tree.getGenome().getPrimary().getName() + " placed in your world!");
            e.printStackTrace();
            return null;
        }
    }

    public void setLogBlock(ITreeGenome genome, World world, int x, int y, int z, ForgeDirection facing) {
        if (genome.getPrimary() != null && ((ExtraTreeSpecies)genome.getPrimary()).getLog() != null) {
            ((ExtraTreeSpecies)genome.getPrimary()).getLog().placeBlock(world, x, y, z);
        }
    }

    public void setLeaves(ITreeGenome genome, World world, GameProfile owner, int x, int y, int z, boolean decorative) {
        boolean placed = world.func_147465_d(x, y, z, (Block)PluginArboriculture.blocks.leaves, 0, 3);
        if (!placed) {
            return;
        }
        Block block = world.func_147439_a(x, y, z);
        if (PluginArboriculture.blocks.leaves != block) {
            world.func_147468_f(x, y, z);
            return;
        }
        TileLeaves tileLeaves = BlockForestryLeaves.getLeafTile((IBlockAccess)world, (int)x, (int)y, (int)z);
        if (tileLeaves == null) {
            world.func_147468_f(x, y, z);
            return;
        }
        tileLeaves.setOwner(owner);
        if (decorative) {
            tileLeaves.setDecorative();
        }
        tileLeaves.setTree((ITree)new Tree(genome));
        world.func_147471_g(x, y, z);
    }

    @Deprecated
    public void setLogBlock(World world, int x, int y, int z, ForgeDirection facing) {
    }

    @Deprecated
    public void setLeaves(World world, GameProfile owner, int x, int y, int z, boolean decorative) {
    }
}

