/*
 * Decompiled with CFR 0.152.
 */
package chocohead.patcher.extratrees;

import binnie.extratrees.block.IPlankType;
import binnie.extratrees.block.WoodManager;
import chocohead.patcher.PatcherPlugin;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class Root
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformedName.equals("binnie.extratrees.block.PlankType$ForestryPlanks")) {
            return this.fixPlankGetting(basicClass);
        }
        if (transformedName.equals("binnie.extratrees.genetics.ExtraTreeSpecies")) {
            return this.patchTreeSpecies(basicClass);
        }
        if (transformedName.equals("binnie.extratrees.genetics.ExtraTreeFruitGene")) {
            return this.patchFruitGene(basicClass);
        }
        if (transformedName.equals("binnie.extratrees.genetics.ExtraTreeMutation")) {
            return this.patchTreeMutation(basicClass);
        }
        if (transformedName.equals("binnie.craftgui.extratrees.dictionary.PageSpeciesTreeGenome")) {
            return this.patchTreeSpeciesPage(basicClass);
        }
        if (transformedName.equals("binnie.extratrees.machines.MachineRendererForestry")) {
            return this.patchMachineRenderer(basicClass);
        }
        if (transformedName.equals("binnie.extratrees.machines.Lumbermill")) {
            return this.patchLumbermill(basicClass);
        }
        if (transformedName.equals("binnie.craftgui.extratrees.dictionary.WindowArboristDatabase$3")) {
            return this.patchMissingPlanks(basicClass);
        }
        if (transformedName.equals("binnie.extratrees.item.ModuleItems")) {
            return this.hushForge(basicClass);
        }
        if (transformedName.equals("binnie.extratrees.block.ModuleBlocks")) {
            return this.hushForestry(basicClass);
        }
        if (transformedName.equals("binnie.extratrees.block.ILogType$ForestryLog")) {
            return this.fixLogGetting(basicClass);
        }
        if (transformedName.equals("binnie.extratrees.block.ItemETDoor")) {
            return this.fixDoorDrops(basicClass);
        }
        if (transformedName.equals("binnie.extratrees.block.decor.BlockFence")) {
            return this.patchFences(basicClass);
        }
        return basicClass;
    }

    public static Collection getMysteryPlanks() {
        ArrayList<ItemStack> out = new ArrayList<ItemStack>();
        for (IPlankType plank : WoodManager.getAllPlankTypes()) {
            out.add(plank.getStack());
        }
        return out;
    }

    private byte[] fixPlankGetting(byte[] basicClass) {
        ClassNode node = new ClassNode(327680){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                if (name.equals("getStack") || name.equals("getFence")) {
                    return null;
                }
                return super.visitMethod(access, name, desc, signature, exceptions);
            }
        };
        new ClassReader(basicClass).accept((ClassVisitor)node, 0);
        ClassWriter writer = new ClassWriter(0);
        MethodVisitor method = writer.visitMethod(1, "getStack", "()Lnet/minecraft/item/ItemStack;", null, null);
        method.visitCode();
        Label start = new Label();
        method.visitLabel(start);
        method.visitTypeInsn(187, "net/minecraft/item/ItemStack");
        method.visitInsn(89);
        method.visitFieldInsn(178, "binnie/core/Mods", "Forestry", "Lbinnie/core/Mods$Mod;");
        method.visitLdcInsn((Object)"planks");
        method.visitMethodInsn(182, "binnie/core/Mods$Mod", "item", "(Ljava/lang/String;)Lnet/minecraft/item/Item;", false);
        method.visitInsn(4);
        method.visitVarInsn(25, 0);
        method.visitMethodInsn(182, "binnie/extratrees/block/PlankType$ForestryPlanks", "ordinal", "()I", false);
        method.visitMethodInsn(183, "net/minecraft/item/ItemStack", "<init>", "(Lnet/minecraft/item/Item;II)V", false);
        method.visitInsn(176);
        Label end = new Label();
        method.visitLabel(end);
        method.visitLocalVariable("this", "Lbinnie/extratrees/block/PlankType$ForestryPlanks;", null, start, end, 0);
        method.visitMaxs(5, 1);
        method.visitEnd();
        method = writer.visitMethod(1, "getFence", "()Lnet/minecraft/item/ItemStack;", null, null);
        method.visitCode();
        start = new Label();
        method.visitLabel(start);
        method.visitTypeInsn(187, "net/minecraft/item/ItemStack");
        method.visitInsn(89);
        method.visitFieldInsn(178, "binnie/core/Mods", "Forestry", "Lbinnie/core/Mods$Mod;");
        method.visitLdcInsn((Object)"fences");
        method.visitMethodInsn(182, "binnie/core/Mods$Mod", "item", "(Ljava/lang/String;)Lnet/minecraft/item/Item;", false);
        method.visitInsn(4);
        method.visitVarInsn(25, 0);
        method.visitMethodInsn(182, "binnie/extratrees/block/PlankType$ForestryPlanks", "ordinal", "()I", false);
        method.visitMethodInsn(183, "net/minecraft/item/ItemStack", "<init>", "(Lnet/minecraft/item/Item;II)V", false);
        method.visitInsn(176);
        end = new Label();
        method.visitLabel(end);
        method.visitLocalVariable("this", "Lbinnie/extratrees/block/PlankType$ForestryPlanks;", null, start, end, 0);
        method.visitMaxs(5, 1);
        method.visitEnd();
        node.accept((ClassVisitor)writer);
        PatcherPlugin.Patcher.logger.info("Succeeded in transforming binnie.extratrees.block.PlankType$ForestryPlanks");
        return writer.toByteArray();
    }

    private byte[] patchTreeSpecies(byte[] basicClass) {
        ClassNode node = new ClassNode(327680){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                if (name.equals("getGenerator") || name.equals("getGermlingIcon")) {
                    return null;
                }
                return super.visitMethod(access, name, desc, signature, exceptions);
            }
        };
        ClassReader reader = new ClassReader(basicClass);
        reader.accept((ClassVisitor)node, 0);
        node.interfaces.add("forestry/api/arboriculture/ILeafIconProvider");
        node.interfaces.add("forestry/api/arboriculture/IGermlingIconProvider");
        for (MethodNode method : node.methods) {
            AbstractInsnNode n;
            ArrayList<MethodInsnNode> fix;
            if (method.name.equals("init")) {
                fix = new ArrayList<MethodInsnNode>();
                for (n = method.instructions.getFirst(); n != null; n = n.getNext()) {
                    if (n.getType() != 5 || !((MethodInsnNode)n).itf || !((MethodInsnNode)n).name.equals("getGeneratorClasses") || !((MethodInsnNode)n).desc.equals("()[Ljava/lang/Class;")) continue;
                    fix.add((MethodInsnNode)n);
                }
                if (fix.size() == 2) {
                    for (MethodInsnNode n2 : fix) {
                        method.instructions.remove(n2.getNext());
                        method.instructions.remove(n2.getNext());
                        method.instructions.remove(n2.getPrevious());
                        if (((LdcInsnNode)n2.getPrevious().getPrevious().getPrevious().getPrevious().getPrevious().getPrevious().getPrevious()).cst.equals("forestry.treePlum")) {
                            method.instructions.set((AbstractInsnNode)n2, (AbstractInsnNode)new LdcInsnNode((Object)Type.getType((String)"Lforestry/arboriculture/worldgen/WorldGenPlum;")));
                            continue;
                        }
                        method.instructions.set((AbstractInsnNode)n2, (AbstractInsnNode)new LdcInsnNode((Object)Type.getType((String)"Lforestry/arboriculture/worldgen/WorldGenLemon;")));
                    }
                    PatcherPlugin.Patcher.logger.info("Succeeded in transforming binnie.extratrees.genetics.ExtraTreeSpecies");
                    continue;
                }
                System.out.println("Drat, we've been careless. Length was " + fix);
                PatcherPlugin.Patcher.logger.warn("Error in transforming binnie.extratrees.genetics.ExtraTreeSpecies");
                continue;
            }
            if (method.name.equals("getGeneticAdvancement")) {
                fix = new ArrayList();
                for (n = method.instructions.getFirst(); n != null; n = n.getNext()) {
                    if (n.getType() != 5 || !((MethodInsnNode)n).itf || !((MethodInsnNode)n).name.equals("getAllele0") && !((MethodInsnNode)n).name.equals("getAllele1") || !((MethodInsnNode)n).desc.equals("()Lforestry/api/genetics/IAllele;")) continue;
                    fix.add((MethodInsnNode)n);
                }
                if (fix.size() <= 0) break;
                for (MethodInsnNode n2 : fix) {
                    n2.desc = "()Lforestry/api/genetics/IAlleleSpecies;";
                }
                break;
            }
            if (method.name.equals("<init>")) {
                for (AbstractInsnNode n3 = method.instructions.getLast(); n3 != null; n3 = n3.getPrevious()) {
                    if (n3.getType() != 0 || n3.getOpcode() != 177) continue;
                    InsnList l = new InsnList();
                    l.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    l.add((AbstractInsnNode)new VarInsnNode(21, 6));
                    l.add((AbstractInsnNode)new FieldInsnNode(181, "binnie/extratrees/genetics/ExtraTreeSpecies", "polColour", "I"));
                    method.instructions.insertBefore(n3, l);
                }
                continue;
            }
            if (!method.name.equals("registerIcons")) continue;
            InsnList l = new InsnList();
            l.add((AbstractInsnNode)new VarInsnNode(25, 0));
            l.add((AbstractInsnNode)new InsnNode(5));
            l.add((AbstractInsnNode)new TypeInsnNode(189, "net/minecraft/util/IIcon"));
            l.add((AbstractInsnNode)new FieldInsnNode(181, "binnie/extratrees/genetics/ExtraTreeSpecies", "pollenIcons", "[Lnet/minecraft/util/IIcon;"));
            l.add((AbstractInsnNode)new VarInsnNode(25, 0));
            l.add((AbstractInsnNode)new FieldInsnNode(180, "binnie/extratrees/genetics/ExtraTreeSpecies", "pollenIcons", "[Lnet/minecraft/util/IIcon;"));
            l.add((AbstractInsnNode)new InsnNode(3));
            l.add((AbstractInsnNode)new VarInsnNode(25, 1));
            l.add((AbstractInsnNode)new LdcInsnNode((Object)"germlings/pollen.0"));
            l.add((AbstractInsnNode)new MethodInsnNode(184, "forestry/core/render/TextureManager", "registerTex", "(Lnet/minecraft/client/renderer/texture/IIconRegister;Ljava/lang/String;)Lnet/minecraft/util/IIcon;", false));
            l.add((AbstractInsnNode)new InsnNode(83));
            l.add((AbstractInsnNode)new VarInsnNode(25, 0));
            l.add((AbstractInsnNode)new FieldInsnNode(180, "binnie/extratrees/genetics/ExtraTreeSpecies", "pollenIcons", "[Lnet/minecraft/util/IIcon;"));
            l.add((AbstractInsnNode)new InsnNode(4));
            l.add((AbstractInsnNode)new VarInsnNode(25, 1));
            l.add((AbstractInsnNode)new LdcInsnNode((Object)"germlings/pollen.1"));
            l.add((AbstractInsnNode)new MethodInsnNode(184, "forestry/core/render/TextureManager", "registerTex", "(Lnet/minecraft/client/renderer/texture/IIconRegister;Ljava/lang/String;)Lnet/minecraft/util/IIcon;", false));
            l.add((AbstractInsnNode)new InsnNode(83));
            method.instructions.insert(method.instructions.getFirst().getNext(), l);
        }
        ClassWriter writer = new ClassWriter(0);
        writer.visitField(2, "polColour", "I", null, null).visitEnd();
        AnnotationVisitor anon = writer.visitField(2, "pollenIcons", "[Lnet/minecraft/util/IIcon;", null, null).visitAnnotation("Lcpw/mods/fml/relauncher/SideOnly;", true);
        anon.visitEnum("value", "Lcpw/mods/fml/relauncher/Side;", "CLIENT");
        anon.visitEnd();
        MethodVisitor method = writer.visitMethod(1, "getGenerator", "()Lforestry/api/arboriculture/ITreeGenerator;", null, null);
        method.visitCode();
        Label start = new Label();
        method.visitLabel(start);
        method.visitTypeInsn(187, "chocohead/patcher/extratrees/GeneratorPatcher");
        method.visitInsn(89);
        method.visitVarInsn(25, 0);
        method.visitFieldInsn(180, "binnie/extratrees/genetics/ExtraTreeSpecies", "gen", "Ljava/lang/Class;");
        method.visitMethodInsn(183, "chocohead/patcher/extratrees/GeneratorPatcher", "<init>", "(Ljava/lang/Class;)V", false);
        method.visitInsn(176);
        Label end = new Label();
        method.visitLabel(end);
        method.visitLocalVariable("this", "Lbinnie/extratrees/genetics/ExtraTreeSpecies;", null, start, end, 0);
        method.visitMaxs(3, 1);
        method.visitEnd();
        method = writer.visitMethod(1, "getLeafColour", "(Z)I", null, null);
        method.visitCode();
        start = new Label();
        method.visitLabel(start);
        method.visitVarInsn(25, 0);
        method.visitFieldInsn(180, "binnie/extratrees/genetics/ExtraTreeSpecies", "color", "I");
        method.visitInsn(172);
        end = new Label();
        method.visitLabel(end);
        method.visitLocalVariable("this", "Lbinnie/extratrees/genetics/ExtraTreeSpecies;", null, start, end, 0);
        method.visitMaxs(1, 1);
        method.visitEnd();
        method = writer.visitMethod(1, "getLeafIcon", "(ZZ)Lnet/minecraft/util/IIcon;", null, null);
        method.visitCode();
        start = new Label();
        method.visitLabel(start);
        method.visitFieldInsn(178, "forestry/api/arboriculture/TreeManager", "treeFactory", "Lforestry/api/arboriculture/ITreeFactory;");
        method.visitMethodInsn(184, "forestry/api/arboriculture/EnumLeafType", "values", "()[Lforestry/api/arboriculture/EnumLeafType;", false);
        method.visitVarInsn(25, 0);
        method.visitFieldInsn(180, "binnie/extratrees/genetics/ExtraTreeSpecies", "leafType", "Lbinnie/extratrees/genetics/ExtraTreeSpecies$LeafType;");
        method.visitMethodInsn(182, "binnie/extratrees/genetics/ExtraTreeSpecies$LeafType", "ordinal", "()I", false);
        method.visitInsn(50);
        method.visitTypeInsn(187, "java/awt/Color");
        method.visitInsn(89);
        method.visitVarInsn(25, 0);
        method.visitFieldInsn(180, "binnie/extratrees/genetics/ExtraTreeSpecies", "color", "I");
        method.visitMethodInsn(183, "java/awt/Color", "<init>", "(I)V", false);
        method.visitTypeInsn(187, "java/awt/Color");
        method.visitInsn(89);
        method.visitVarInsn(25, 0);
        method.visitFieldInsn(180, "binnie/extratrees/genetics/ExtraTreeSpecies", "polColour", "I");
        method.visitMethodInsn(183, "java/awt/Color", "<init>", "(I)V", false);
        method.visitMethodInsn(185, "forestry/api/arboriculture/ITreeFactory", "getLeafIconProvider", "(Lforestry/api/arboriculture/EnumLeafType;Ljava/awt/Color;Ljava/awt/Color;)Lforestry/api/arboriculture/ILeafIconProvider;", true);
        method.visitVarInsn(21, 1);
        method.visitVarInsn(21, 2);
        method.visitMethodInsn(185, "forestry/api/arboriculture/ILeafIconProvider", "getIcon", "(ZZ)Lnet/minecraft/util/IIcon;", true);
        method.visitInsn(176);
        end = new Label();
        method.visitLabel(end);
        method.visitLocalVariable("this", "Lbinnie/extratrees/genetics/ExtraTreeSpecies;", null, start, end, 0);
        method.visitLocalVariable("pollinated", "Z", null, start, end, 1);
        method.visitLocalVariable("fancy", "Z", null, start, end, 2);
        method.visitMaxs(6, 3);
        method.visitEnd();
        method = writer.visitMethod(1, "getGermlingIcon", "(Lforestry/api/arboriculture/EnumGermlingType;I)Lnet/minecraft/util/IIcon;", null, null);
        anon = method.visitAnnotation("Lcpw/mods/fml/relauncher/SideOnly;", true);
        anon.visitEnum("value", "Lcpw/mods/fml/relauncher/Side;", "CLIENT");
        anon.visitEnd();
        method.visitCode();
        start = new Label();
        method.visitLabel(start);
        method.visitVarInsn(25, 1);
        method.visitFieldInsn(178, "forestry/api/arboriculture/EnumGermlingType", "POLLEN", "Lforestry/api/arboriculture/EnumGermlingType;");
        Label notPollen = new Label();
        method.visitJumpInsn(166, notPollen);
        method.visitVarInsn(25, 0);
        method.visitFieldInsn(180, "binnie/extratrees/genetics/ExtraTreeSpecies", "pollenIcons", "[Lnet/minecraft/util/IIcon;");
        method.visitVarInsn(21, 2);
        method.visitInsn(50);
        method.visitInsn(176);
        method.visitLabel(notPollen);
        method.visitFrame(3, 0, null, 0, null);
        method.visitVarInsn(25, 0);
        method.visitFieldInsn(180, "binnie/extratrees/genetics/ExtraTreeSpecies", "saplingType", "Lbinnie/extratrees/genetics/ExtraTreeSpecies$SaplingType;");
        method.visitFieldInsn(180, "binnie/extratrees/genetics/ExtraTreeSpecies$SaplingType", "icon", "[Lnet/minecraft/util/IIcon;");
        method.visitVarInsn(21, 2);
        method.visitInsn(50);
        method.visitInsn(176);
        end = new Label();
        method.visitLabel(end);
        method.visitLocalVariable("this", "Lbinnie/extratrees/genetics/ExtraTreeSpecies;", null, start, end, 0);
        method.visitLocalVariable("type", "Lforestry/api/arboriculture/EnumGermlingType;", null, start, end, 1);
        method.visitLocalVariable("renderPass", "I", null, start, end, 2);
        method.visitMaxs(2, 3);
        method.visitEnd();
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchTreeGenerator(byte[] basicClass) {
        ClassNode node = new ClassNode(327680){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                if (name.equals("getGenerator")) {
                    return null;
                }
                return super.visitMethod(access, name, desc, signature, exceptions);
            }
        };
        new ClassReader(basicClass).accept((ClassVisitor)node, 0);
        ClassWriter writer = new ClassWriter(0);
        MethodVisitor method = writer.visitMethod(1, "getGenerator", "()Lforestry.api.arboriculture.ITreeGenerator;", null, null);
        method.visitCode();
        Label start = new Label();
        method.visitLabel(start);
        method.visitVarInsn(25, 0);
        method.visitFieldInsn(180, "binnie/extratrees/genetics/ExtraTreeSpecies", "gen", "Ljava/lang/Class;");
        method.visitInsn(176);
        Label end = new Label();
        method.visitLabel(end);
        method.visitLocalVariable("this", "Lbinnie/extratrees/genetics/ExtraTreeSpecies;", null, start, end, 0);
        method.visitMaxs(1, 1);
        method.visitEnd();
        node.accept((ClassVisitor)writer);
        PatcherPlugin.Patcher.logger.info("Succeeded in transforming binnie.extratrees.genetics.ExtraTreeSpecies$ExtraTreeSpecies");
        return writer.toByteArray();
    }

    private byte[] patchFruitGene(byte[] basicClass) {
        ClassNode node = new ClassNode();
        ClassReader reader = new ClassReader(basicClass);
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode method : node.methods) {
            if (!method.name.equals("init")) continue;
            ArrayList<MethodInsnNode> fix = new ArrayList<MethodInsnNode>();
            ArrayList<TypeInsnNode> altfix = new ArrayList<TypeInsnNode>();
            for (AbstractInsnNode n = method.instructions.getFirst(); n != null; n = n.getNext()) {
                if (n.getType() == 5 && ((MethodInsnNode)n).owner.equals("forestry/arboriculture/genetics/AlleleTreeSpecies")) {
                    fix.add((MethodInsnNode)n);
                    continue;
                }
                if (n.getType() != 3 || !((TypeInsnNode)n).desc.equals("forestry/arboriculture/genetics/AlleleTreeSpecies")) continue;
                altfix.add((TypeInsnNode)n);
            }
            if (fix.size() > 0 && altfix.size() > 0) {
                for (MethodInsnNode methodInsnNode : fix) {
                    methodInsnNode.owner = "forestry/arboriculture/genetics/alleles/AlleleTreeSpecies";
                    methodInsnNode.desc = "(Lforestry/api/genetics/IFruitFamily;)Lforestry/arboriculture/genetics/alleles/AlleleTreeSpecies;";
                }
                for (TypeInsnNode typeInsnNode : altfix) {
                    typeInsnNode.desc = "forestry/arboriculture/genetics/alleles/AlleleTreeSpecies";
                }
                PatcherPlugin.Patcher.logger.info("Succeeded in transforming binnie.extratrees.genetics.ModuleGenetics");
                break;
            }
            PatcherPlugin.Patcher.logger.warn("Error in transforming binnie.extratrees.genetics.ModuleGenetics");
            break;
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchTreeMutation(byte[] basicClass) {
        ClassNode node = new ClassNode();
        ClassReader reader = new ClassReader(basicClass);
        reader.accept((ClassVisitor)node, 0);
        boolean fixed = false;
        for (MethodNode method : node.methods) {
            if (method.name.equals("getAllele0") || method.name.equals("getAllele1")) {
                method.desc = "()Lforestry/api/genetics/IAlleleSpecies;";
                fixed = true;
                continue;
            }
            if (!method.name.equals("getChance")) continue;
            method.desc = "(Lnet/minecraft/world/World;IIILforestry/api/arboriculture/IAlleleTreeSpecies;Lforestry/api/arboriculture/IAlleleTreeSpecies;Lforestry/api/arboriculture/ITreeGenome;Lforestry/api/arboriculture/ITreeGenome;)F";
        }
        if (fixed) {
            PatcherPlugin.Patcher.logger.info("Succeeded in transforming binnie.extratrees.genetics.ExtraTreeMutation");
        } else {
            PatcherPlugin.Patcher.logger.warn("Error in transforming binnie.extratrees.genetics.ExtraTreeMutation");
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchTreeSpeciesPage(byte[] basicClass) {
        ClassNode node = new ClassNode();
        ClassReader reader = new ClassReader(basicClass);
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode method : node.methods) {
            if (!method.name.equals("onValueChanged")) continue;
            ArrayList<AbstractInsnNode> flatten = new ArrayList<AbstractInsnNode>();
            ArrayList<AbstractInsnNode> squish = new ArrayList<AbstractInsnNode>();
            MethodInsnNode patchHook = null;
            boolean cat = false;
            boolean dog = false;
            for (AbstractInsnNode n = method.instructions.getFirst(); n != null; n = n.getNext()) {
                if (n.getType() == 15 && ((LineNumberNode)n).line == 76) {
                    cat = true;
                } else if (n.getType() == 15 && ((LineNumberNode)n).line == 78) {
                    cat = false;
                } else if (n.getType() == 5 && ((MethodInsnNode)n).itf && ((MethodInsnNode)n).desc.equals("(Lforestry/api/arboriculture/ITree;)I")) {
                    patchHook = (MethodInsnNode)n;
                } else if (n.getType() == 15 && ((LineNumberNode)n).line == 99) {
                    dog = true;
                } else if (dog) {
                    if (n.getType() == 14 && ((FrameNode)n).type == 4) break;
                }
                if (cat) {
                    flatten.add(n);
                    continue;
                }
                if (!dog) continue;
                squish.add(n);
            }
            if (flatten.size() > 0 && squish.size() > 0 && patchHook != null) {
                method.instructions.set(patchHook.getPrevious(), (AbstractInsnNode)new InsnNode(3));
                patchHook.desc = "(Z)I";
                LineNumberNode start = (LineNumberNode)flatten.get(0);
                flatten.remove(0);
                for (AbstractInsnNode n : flatten) {
                    method.instructions.remove(n);
                }
                InsnList l = new InsnList();
                l.add((AbstractInsnNode)new VarInsnNode(25, 5));
                l.add((AbstractInsnNode)new InsnNode(3));
                l.add((AbstractInsnNode)new InsnNode(3));
                l.add((AbstractInsnNode)new MethodInsnNode(185, "forestry/api/arboriculture/IAlleleTreeSpecies", "getLeafIcon", "(ZZ)Lnet/minecraft/util/IIcon;", true));
                l.add((AbstractInsnNode)new VarInsnNode(58, 17));
                method.instructions.insert((AbstractInsnNode)start, l);
                method.instructions.remove((AbstractInsnNode)start);
                start = (LineNumberNode)squish.get(0);
                squish.remove(0);
                for (AbstractInsnNode n : squish) {
                    method.instructions.remove(n);
                }
                l.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
                l.add((AbstractInsnNode)new VarInsnNode(25, 4));
                l.add((AbstractInsnNode)new MethodInsnNode(184, "chocohead/patcher/binniecore/FakeWorld", "getWoodLog", "(Lforestry/api/arboriculture/ITreeGenome;)Lnet/minecraft/item/ItemStack;", false));
                method.instructions.insert((AbstractInsnNode)start, l);
                method.instructions.remove((AbstractInsnNode)start);
                PatcherPlugin.Patcher.logger.info("Succeeded in transforming binnie.craftgui.extratrees.dictionary.PageSpeciesTreeGenome");
                break;
            }
            PatcherPlugin.Patcher.logger.warn("Error in transforming binnie.craftgui.extratrees.dictionary.PageSpeciesTreeGenome");
            break;
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchMachineRenderer(byte[] basicClass) {
        ClassNode node = new ClassNode();
        ClassReader reader = new ClassReader(basicClass);
        reader.accept((ClassVisitor)node, 0);
        ((FieldNode)node.fields.get((int)0)).signature = "Ljava/lang/String;Ljava/lang/String;Lforestry/core/render/RenderMachine;";
        boolean[] ok = new boolean[]{false, false};
        for (MethodNode method : node.methods) {
            InsnList l;
            ArrayList<Object> fix;
            if (method.name.equals("loadMethod")) {
                fix = new ArrayList<Object>();
                LabelNode newStart = new LabelNode();
                for (LocalVariableNode v : method.localVariables) {
                    if (!v.name.equals("e")) continue;
                    v.start = newStart;
                }
                l = new InsnList();
                l.add((AbstractInsnNode)newStart);
                l.add((AbstractInsnNode)new VarInsnNode(25, 3));
                l.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Exception", "printStackTrace", "()V", false));
                method.instructions.insert(((TryCatchBlockNode)method.tryCatchBlocks.get((int)0)).end.getNext().getNext().getNext().getNext().getNext().getNext(), l);
                for (AbstractInsnNode n = method.instructions.getFirst(); n != null; n = n.getNext()) {
                    if (n.getType() == 4 && ((FieldInsnNode)n).owner.equals("java/lang/Integer") && ((FieldInsnNode)n).name.equals("TYPE")) {
                        fix.add((FieldInsnNode)n);
                        continue;
                    }
                    if (n.getType() != 5 || !((MethodInsnNode)n).name.equals("getMethod")) continue;
                    l = new InsnList();
                    l.add((AbstractInsnNode)new FieldInsnNode(178, "binnie/extratrees/machines/MachineRendererForestry", "renderMethod", "Ljava/lang/reflect/Method;"));
                    l.add((AbstractInsnNode)new InsnNode(4));
                    l.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/reflect/Method", "setAccessible", "(Z)V", false));
                    method.instructions.insert(n.getNext(), l);
                    ((MethodInsnNode)n).name = "getDeclaredMethod";
                    break;
                }
                if (fix.size() <= 0) continue;
                for (FieldInsnNode fieldInsnNode : fix) {
                    method.instructions.set((AbstractInsnNode)fieldInsnNode, (AbstractInsnNode)new LdcInsnNode((Object)Type.getType((String)"Lforestry/core/render/TankRenderInfo;")));
                }
                ok[0] = true;
                continue;
            }
            if (!method.name.equals("renderMachine")) continue;
            fix = new ArrayList();
            IntInsnNode marker = null;
            l = new InsnList();
            LabelNode stacker = ((TryCatchBlockNode)method.tryCatchBlocks.get((int)0)).end;
            LabelNode labelNode = new LabelNode();
            for (LocalVariableNode localVariableNode : method.localVariables) {
                if (!localVariableNode.name.equals("e")) continue;
                localVariableNode.start = labelNode;
            }
            l.add((AbstractInsnNode)labelNode);
            l.add((AbstractInsnNode)new VarInsnNode(25, 8));
            l.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Exception", "printStackTrace", "()V", false));
            method.instructions.insert(stacker.getNext().getNext().getNext().getNext().getNext().getNext(), l);
            for (AbstractInsnNode n = method.instructions.getFirst(); n != null; n = n.getNext()) {
                if (n.getType() == 5 && ((MethodInsnNode)n).owner.equals("java/lang/Integer") && ((MethodInsnNode)n).name.equals("valueOf")) {
                    fix.add((MethodInsnNode)n);
                    continue;
                }
                if (n.getType() != 1 || n.getOpcode() != 16 || ((IntInsnNode)n).operand != 6) continue;
                marker = (IntInsnNode)n;
            }
            if (fix.size() <= 0 || marker == null) break;
            method.instructions.insertBefore(marker, (AbstractInsnNode)new TypeInsnNode(192, "forestry/core/render/RenderMachine"));
            for (MethodInsnNode methodInsnNode : fix) {
                method.instructions.remove(methodInsnNode.getPrevious());
                method.instructions.set((AbstractInsnNode)methodInsnNode, (AbstractInsnNode)new FieldInsnNode(178, "forestry/core/render/TankRenderInfo", "EMPTY", "Lforestry/core/render/TankRenderInfo;"));
            }
            ok[1] = true;
            break;
        }
        if (ok[0] && ok[1]) {
            PatcherPlugin.Patcher.logger.info("Succeeded in transforming binnie.extratrees.machines.MachineRendererForestry");
        } else {
            PatcherPlugin.Patcher.logger.warn("Error in transforming binnie.extratrees.machines.MachineRendererForestry");
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchLumbermill(byte[] basicClass) {
        ClassNode node = new ClassNode();
        ClassReader reader = new ClassReader(basicClass);
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode method : node.methods) {
            if (!method.name.equals("getPlankProduct")) continue;
            boolean flag = false;
            for (AbstractInsnNode n = method.instructions.getFirst(); n != null; n = n.getNext()) {
                if (n.getType() != 1 || ((IntInsnNode)n).operand != 6) continue;
                method.instructions.insert(n.getNext().getNext().getNext(), (AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
                method.instructions.insertBefore(n, (AbstractInsnNode)new JumpInsnNode(198, (LabelNode)n.getNext().getNext()));
                method.instructions.insertBefore(n, (AbstractInsnNode)new VarInsnNode(25, 1));
                flag = true;
                break;
            }
            if (flag) {
                PatcherPlugin.Patcher.logger.info("Succeeded in transforming binnie.extratrees.machines.Lumbermill");
                break;
            }
            PatcherPlugin.Patcher.logger.warn("Error in transforming binnie.extratrees.machines.Lumbermill");
            break;
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchPlankPage(byte[] basicClass) {
        ClassNode node = new ClassNode();
        ClassReader reader = new ClassReader(basicClass);
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode method : node.methods) {
            if (!method.name.equals("onValueChanged")) continue;
            boolean flag = false;
            InsnList l = new InsnList();
            l.add((AbstractInsnNode)new FieldInsnNode(178, "java/lang/System", "out", "Ljava/io/PrintStream;"));
            l.add((AbstractInsnNode)new VarInsnNode(25, 1));
            l.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/item/ItemStack", "getDisplayName", "()Ljava/lang/String;", false));
            l.add((AbstractInsnNode)new MethodInsnNode(182, "java/io/PrintStream", "println", "(Ljava/lang/String;)V", false));
            l.add((AbstractInsnNode)new TypeInsnNode(187, "java/lang/Throwable"));
            l.add((AbstractInsnNode)new InsnNode(89));
            l.add((AbstractInsnNode)new MethodInsnNode(183, "java/lang/Throwable", "<init>", "()V", false));
            l.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Throwable", "printStackTrace", "()V", false));
            method.instructions.insert(method.instructions.getFirst().getNext(), l);
            flag = true;
            if (flag) {
                PatcherPlugin.Patcher.logger.info("Succeeded in transforming binnie.craftgui.extratrees.dictionary.PagePlanksOverview");
                break;
            }
            PatcherPlugin.Patcher.logger.warn("Error in transforming binnie.craftgui.extratrees.dictionary.PagePlanksOverview");
            break;
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchMissingPlanks(byte[] basicClass) {
        ClassNode node = new ClassNode();
        ClassReader reader = new ClassReader(basicClass);
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode method : node.methods) {
            if (!method.name.equals("createListBox")) continue;
            boolean flag = false;
            InsnList l = new InsnList();
            l.add((AbstractInsnNode)new VarInsnNode(25, 0));
            l.add((AbstractInsnNode)new FieldInsnNode(180, "binnie/craftgui/extratrees/dictionary/WindowArboristDatabase$3", "listBox", "Lbinnie/craftgui/controls/listbox/ControlListBox;"));
            l.add((AbstractInsnNode)new MethodInsnNode(184, "chocohead/patcher/extratrees/Root", "getMysteryPlanks", "()Ljava/util/Collection;", false));
            l.add((AbstractInsnNode)new MethodInsnNode(182, "binnie/craftgui/controls/listbox/ControlListBox", "setOptions", "(Ljava/util/Collection;)V", false));
            method.instructions.insertBefore(method.instructions.getLast().getPrevious(), l);
            flag = true;
            if (flag) {
                PatcherPlugin.Patcher.logger.info("Succeeded in transforming binnie.craftgui.extratrees.dictionary.WindowArboristDatabase$3");
                break;
            }
            PatcherPlugin.Patcher.logger.warn("Error in transforming binnie.craftgui.extratrees.dictionary.WindowArboristDatabase$3");
            break;
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] hushForge(byte[] basicClass) {
        ClassNode node = new ClassNode(327680){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                if (name.equals("preInit")) {
                    return null;
                }
                return super.visitMethod(access, name, desc, signature, exceptions);
            }
        };
        new ClassReader(basicClass).accept((ClassVisitor)node, 0);
        ClassWriter writer = new ClassWriter(0);
        MethodVisitor method = writer.visitMethod(1, "preInit", "()V", null, null);
        method.visitCode();
        Label start = new Label();
        method.visitLabel(start);
        method.visitFieldInsn(178, "binnie/Binnie", "Item", "Lbinnie/core/item/ManagerItem;");
        method.visitMethodInsn(184, "binnie/extratrees/item/ExtraTreeItems", "values", "()[Lbinnie/extratrees/item/ExtraTreeItems;", false);
        method.visitFieldInsn(178, "forestry/api/core/Tabs", "tabArboriculture", "Lnet/minecraft/creativetab/CreativeTabs;");
        method.visitMethodInsn(182, "binnie/core/item/ManagerItem", "registerMiscItems", "([Lbinnie/core/item/IItemMisc;Lnet/minecraft/creativetab/CreativeTabs;)Lbinnie/core/item/ItemMisc;", false);
        method.visitFieldInsn(179, "binnie/extratrees/ExtraTrees", "itemMisc", "Lnet/minecraft/item/Item;");
        method.visitTypeInsn(187, "binnie/extratrees/item/ItemDictionary");
        method.visitInsn(89);
        method.visitMethodInsn(183, "binnie/extratrees/item/ItemDictionary", "<init>", "()V", false);
        method.visitFieldInsn(179, "binnie/extratrees/ExtraTrees", "itemDictionary", "Lnet/minecraft/item/Item;");
        method.visitMethodInsn(184, "binnie/core/BinnieCore", "isLepidopteryActive", "()Z", false);
        Label notButterflies = new Label();
        method.visitJumpInsn(153, notButterflies);
        method.visitTypeInsn(187, "binnie/extratrees/item/ItemMothDatabase");
        method.visitInsn(89);
        method.visitMethodInsn(183, "binnie/extratrees/item/ItemMothDatabase", "<init>", "()V", false);
        method.visitFieldInsn(179, "binnie/extratrees/ExtraTrees", "itemDictionaryLepi", "Lnet/minecraft/item/Item;");
        method.visitLabel(notButterflies);
        method.visitFrame(3, 0, null, 0, null);
        method.visitFieldInsn(178, "binnie/Binnie", "Liquid", "Lbinnie/core/liquid/ManagerLiquid;");
        method.visitMethodInsn(184, "binnie/extratrees/item/ExtraTreeLiquid", "values", "()[Lbinnie/extratrees/item/ExtraTreeLiquid;", false);
        method.visitFieldInsn(178, "binnie/core/liquid/ItemFluidContainer", "LiquidExtraTree", "I");
        method.visitMethodInsn(182, "binnie/core/liquid/ManagerLiquid", "createLiquids", "([Lbinnie/core/liquid/IFluidType;I)V", false);
        method.visitTypeInsn(187, "binnie/extratrees/item/ItemFood");
        method.visitInsn(89);
        method.visitMethodInsn(183, "binnie/extratrees/item/ItemFood", "<init>", "()V", false);
        method.visitFieldInsn(179, "binnie/extratrees/ExtraTrees", "itemFood", "Lnet/minecraft/item/Item;");
        method.visitTypeInsn(187, "binnie/extratrees/item/ItemHammer");
        method.visitInsn(89);
        method.visitInsn(3);
        method.visitMethodInsn(183, "binnie/extratrees/item/ItemHammer", "<init>", "(Z)V", false);
        method.visitFieldInsn(179, "binnie/extratrees/ExtraTrees", "itemHammer", "Lnet/minecraft/item/Item;");
        method.visitTypeInsn(187, "binnie/extratrees/item/ItemHammer");
        method.visitInsn(89);
        method.visitInsn(4);
        method.visitMethodInsn(183, "binnie/extratrees/item/ItemHammer", "<init>", "(Z)V", false);
        method.visitFieldInsn(179, "binnie/extratrees/ExtraTrees", "itemDurableHammer", "Lnet/minecraft/item/Item;");
        method.visitInsn(177);
        Label end = new Label();
        method.visitLabel(end);
        method.visitLocalVariable("this", "Lbinnie/extratrees/item/ModuleItems;", null, start, end, 0);
        method.visitMaxs(3, 1);
        method.visitEnd();
        node.accept((ClassVisitor)writer);
        PatcherPlugin.Patcher.logger.info("Succeeded in transforming binnie.extratrees.item.ModuleItems");
        return writer.toByteArray();
    }

    private byte[] hushForestry(byte[] basicClass) {
        ClassNode node = new ClassNode();
        ClassReader reader = new ClassReader(basicClass);
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode method : node.methods) {
            if (!method.name.equals("preInit")) continue;
            ArrayList<AbstractInsnNode> flatten = new ArrayList<AbstractInsnNode>();
            boolean squish = false;
            for (AbstractInsnNode n = method.instructions.getFirst(); n != null; n = n.getNext()) {
                if (n.getType() == 15 && ((LineNumberNode)n).line == 99) {
                    squish = true;
                } else if (n.getType() == 15 && ((LineNumberNode)n).line == 101) break;
                if (!squish) continue;
                flatten.add(n);
            }
            if (flatten.size() > 0) {
                for (AbstractInsnNode n : flatten) {
                    method.instructions.remove(n);
                }
                PatcherPlugin.Patcher.logger.info("Succeeded in transforming binnie.extratrees.block.ModuleBlocks");
                break;
            }
            PatcherPlugin.Patcher.logger.warn("Error in transforming binnie.extratrees.block.ModuleBlocks");
            break;
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] fixLogGetting(byte[] basicClass) {
        ClassNode node = new ClassNode(327680){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                if (name.equals("placeBlock") || name.equals("getItemStack")) {
                    return null;
                }
                return super.visitMethod(access, name, desc, signature, exceptions);
            }
        };
        new ClassReader(basicClass).accept((ClassVisitor)node, 0);
        ClassWriter writer = new ClassWriter(0);
        MethodVisitor method = writer.visitMethod(1, "getItemStack", "()Lnet/minecraft/item/ItemStack;", null, null);
        method.visitCode();
        Label start = new Label();
        method.visitLabel(start);
        method.visitMethodInsn(184, "forestry/api/arboriculture/EnumWoodType", "values", "()[Lforestry/api/arboriculture/EnumWoodType;", false);
        method.visitInsn(89);
        method.visitVarInsn(58, 4);
        method.visitInsn(190);
        method.visitVarInsn(54, 3);
        method.visitInsn(3);
        method.visitVarInsn(54, 2);
        Label loopEnd = new Label();
        method.visitJumpInsn(167, loopEnd);
        Label loopStart = new Label();
        method.visitLabel(loopStart);
        method.visitFrame(0, 5, new Object[]{"binnie/extratrees/block/ILogType$ForestryLog", Opcodes.TOP, Opcodes.INTEGER, Opcodes.INTEGER, "[Lforestry/api/arboriculture/EnumWoodType;"}, 0, new Object[0]);
        method.visitVarInsn(25, 4);
        method.visitVarInsn(21, 2);
        method.visitInsn(50);
        method.visitVarInsn(58, 1);
        Label log = new Label();
        method.visitLabel(log);
        method.visitVarInsn(25, 1);
        method.visitMethodInsn(182, "forestry/api/arboriculture/EnumWoodType", "toString", "()Ljava/lang/String;", false);
        method.visitVarInsn(25, 0);
        method.visitMethodInsn(182, "binnie/extratrees/block/ILogType$ForestryLog", "toString", "()Ljava/lang/String;", false);
        method.visitFieldInsn(178, "java/util/Locale", "ENGLISH", "Ljava/util/Locale;");
        method.visitMethodInsn(182, "java/lang/String", "toLowerCase", "(Ljava/util/Locale;)Ljava/lang/String;", false);
        method.visitMethodInsn(182, "java/lang/String", "equals", "(Ljava/lang/Object;)Z", false);
        Label logFound = new Label();
        method.visitJumpInsn(153, logFound);
        method.visitFieldInsn(178, "forestry/api/arboriculture/TreeManager", "woodItemAccess", "Lforestry/api/arboriculture/IWoodItemAccess;");
        method.visitVarInsn(25, 1);
        method.visitInsn(3);
        method.visitMethodInsn(185, "forestry/api/arboriculture/IWoodItemAccess", "getLog", "(Lforestry/api/arboriculture/EnumWoodType;Z)Lnet/minecraft/item/ItemStack;", true);
        method.visitInsn(176);
        method.visitLabel(logFound);
        method.visitFrame(3, 0, null, 0, null);
        method.visitIincInsn(2, 1);
        method.visitLabel(loopEnd);
        method.visitFrame(3, 0, null, 0, null);
        method.visitVarInsn(21, 2);
        method.visitVarInsn(21, 3);
        method.visitJumpInsn(161, loopStart);
        method.visitInsn(1);
        method.visitInsn(176);
        Label end = new Label();
        method.visitLabel(end);
        method.visitLocalVariable("this", "Lbinnie/extratrees/block/ILogType$ForestryLog;", null, start, end, 0);
        method.visitLocalVariable("wood", "Lforestry/api/arboriculture/EnumWoodType;", null, log, logFound, 1);
        method.visitMaxs(3, 5);
        method.visitEnd();
        method = writer.visitMethod(1, "placeBlock", "(Lnet/minecraft/world/World;III)V", null, null);
        method.visitCode();
        start = new Label();
        method.visitLabel(start);
        method.visitTypeInsn(187, "forestry/arboriculture/worldgen/BlockTypeLog");
        method.visitInsn(89);
        method.visitVarInsn(25, 0);
        method.visitMethodInsn(182, "binnie/extratrees/block/ILogType$ForestryLog", "getItemStack", "()Lnet/minecraft/item/ItemStack;", false);
        method.visitMethodInsn(183, "forestry/arboriculture/worldgen/BlockTypeLog", "<init>", "(Lnet/minecraft/item/ItemStack;)V", false);
        method.visitVarInsn(58, 5);
        Label logBlockDefined = new Label();
        method.visitLabel(logBlockDefined);
        method.visitVarInsn(25, 5);
        method.visitFieldInsn(178, "net/minecraftforge/common/util/ForgeDirection", "UP", "Lnet/minecraftforge/common/util/ForgeDirection;");
        method.visitMethodInsn(182, "forestry/arboriculture/worldgen/BlockTypeLog", "setDirection", "(Lnet/minecraftforge/common/util/ForgeDirection;)V", false);
        method.visitVarInsn(25, 5);
        method.visitVarInsn(25, 1);
        method.visitVarInsn(21, 2);
        method.visitVarInsn(21, 3);
        method.visitVarInsn(21, 4);
        method.visitMethodInsn(182, "forestry/arboriculture/worldgen/BlockTypeLog", "setBlock", "(Lnet/minecraft/world/World;III)V", false);
        method.visitInsn(177);
        end = new Label();
        method.visitLabel(end);
        method.visitLocalVariable("this", "Lbinnie/extratrees/block/ILogType$ForestryLog;", null, start, end, 0);
        method.visitLocalVariable("world", "Lnet/minecraft/world/World;", null, start, end, 1);
        method.visitLocalVariable("x", "I", null, start, end, 2);
        method.visitLocalVariable("y", "I", null, start, end, 3);
        method.visitLocalVariable("z", "I", null, start, end, 4);
        method.visitLocalVariable("logBlock", "Lforestry/arboriculture/worldgen/BlockTypeLog;", null, logBlockDefined, end, 5);
        method.visitMaxs(5, 6);
        method.visitEnd();
        node.accept((ClassVisitor)writer);
        PatcherPlugin.Patcher.logger.info("Succeeded in transforming binnie.extratrees.block.ILogType$ForestryLog");
        return writer.toByteArray();
    }

    private byte[] fixDoorDrops(byte[] basicClass) {
        ClassNode node = new ClassNode();
        new ClassReader(basicClass).accept((ClassVisitor)node, 0);
        for (MethodNode method : node.methods) {
            if (!method.name.equals("placeDoorBlock")) continue;
            boolean flag = false;
            for (AbstractInsnNode n = method.instructions.getFirst(); n != null; n = n.getNext()) {
                if (n.getType() != 14 || ((FrameNode)n).type != 2) continue;
                if (n.getPrevious().getPrevious().getPrevious().getType() != 5) continue;
                InsnList l = new InsnList();
                l.add((AbstractInsnNode)new VarInsnNode(25, 0));
                l.add((AbstractInsnNode)new VarInsnNode(21, 1));
                l.add((AbstractInsnNode)new VarInsnNode(21, 2));
                l.add((AbstractInsnNode)new InsnNode(4));
                l.add((AbstractInsnNode)new InsnNode(96));
                l.add((AbstractInsnNode)new VarInsnNode(21, 3));
                l.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/world/World", PatcherPlugin.obfuscated ? "func_147439_a" : "getBlock", "(III)Lnet/minecraft/block/Block;", false));
                l.add((AbstractInsnNode)new VarInsnNode(25, 5));
                LabelNode endIf = new LabelNode();
                l.add((AbstractInsnNode)new JumpInsnNode(166, endIf));
                l.add((AbstractInsnNode)new VarInsnNode(25, 0));
                l.add((AbstractInsnNode)new VarInsnNode(21, 1));
                l.add((AbstractInsnNode)new VarInsnNode(21, 2));
                l.add((AbstractInsnNode)new InsnNode(4));
                l.add((AbstractInsnNode)new InsnNode(96));
                l.add((AbstractInsnNode)new VarInsnNode(21, 3));
                l.add((AbstractInsnNode)new MethodInsnNode(184, "binnie/core/block/TileEntityMetadata", "getTile", "(Lnet/minecraft/world/IBlockAccess;III)Lbinnie/core/block/TileEntityMetadata;", false));
                l.add((AbstractInsnNode)new VarInsnNode(58, 15));
                LabelNode tileDefined = new LabelNode();
                l.add((AbstractInsnNode)tileDefined);
                l.add((AbstractInsnNode)new VarInsnNode(25, 15));
                LabelNode tileNull = new LabelNode();
                l.add((AbstractInsnNode)new JumpInsnNode(198, tileNull));
                l.add((AbstractInsnNode)new VarInsnNode(25, 15));
                l.add((AbstractInsnNode)new VarInsnNode(25, 6));
                l.add((AbstractInsnNode)new MethodInsnNode(184, "binnie/core/block/TileEntityMetadata", "getItemDamage", "(Lnet/minecraft/item/ItemStack;)I", false));
                l.add((AbstractInsnNode)new InsnNode(3));
                l.add((AbstractInsnNode)new MethodInsnNode(182, "binnie/core/block/TileEntityMetadata", "setTileMetadata", "(IZ)V", false));
                l.add((AbstractInsnNode)tileNull);
                l.add((AbstractInsnNode)new FrameNode(1, 1, new Object[]{"binnie/core/block/TileEntityMetadata"}, 0, null));
                l.add((AbstractInsnNode)new VarInsnNode(25, 5));
                l.add((AbstractInsnNode)new VarInsnNode(25, 0));
                l.add((AbstractInsnNode)new VarInsnNode(21, 1));
                l.add((AbstractInsnNode)new VarInsnNode(21, 2));
                l.add((AbstractInsnNode)new InsnNode(4));
                l.add((AbstractInsnNode)new InsnNode(96));
                l.add((AbstractInsnNode)new VarInsnNode(21, 3));
                l.add((AbstractInsnNode)new VarInsnNode(25, 7));
                l.add((AbstractInsnNode)new VarInsnNode(25, 6));
                l.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/block/Block", PatcherPlugin.obfuscated ? "func_149689_a" : "onBlockPlacedBy", "(Lnet/minecraft/world/World;IIILnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/item/ItemStack;)V", false));
                l.add((AbstractInsnNode)new VarInsnNode(25, 5));
                l.add((AbstractInsnNode)new VarInsnNode(25, 0));
                l.add((AbstractInsnNode)new VarInsnNode(21, 1));
                l.add((AbstractInsnNode)new VarInsnNode(21, 2));
                l.add((AbstractInsnNode)new InsnNode(4));
                l.add((AbstractInsnNode)new InsnNode(96));
                l.add((AbstractInsnNode)new VarInsnNode(21, 3));
                l.add((AbstractInsnNode)new VarInsnNode(21, 4));
                l.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/block/Block", PatcherPlugin.obfuscated ? "func_149714_e" : "onPostBlockPlaced", "(Lnet/minecraft/world/World;IIII)V", false));
                l.add((AbstractInsnNode)endIf);
                l.add((AbstractInsnNode)new FrameNode(2, 1, null, 0, null));
                method.instructions.insert(n, l);
                method.localVariables.add(new LocalVariableNode("tile", "Lbinnie/core/block/TileEntityMetadata;", null, tileDefined, endIf, 15));
                flag = true;
                break;
            }
            if (flag) {
                PatcherPlugin.Patcher.logger.info("Succeeded in transforming binnie.extratrees.block.ItemETDoor");
                break;
            }
            PatcherPlugin.Patcher.logger.warn("Error in transforming binnie.extratrees.block.ItemETDoor");
            break;
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchFences(byte[] basicClass) {
        ClassNode node = new ClassNode(327680){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                if (name.equals("canConnect")) {
                    return null;
                }
                return super.visitMethod(access, name, desc, signature, exceptions);
            }
        };
        new ClassReader(basicClass).accept((ClassVisitor)node, 0);
        ClassWriter writer = new ClassWriter(0);
        MethodVisitor method = writer.visitMethod(9, "canConnect", "(Lnet/minecraft/block/Block;)Z", null, null);
        method.visitCode();
        Label start = new Label();
        method.visitLabel(start);
        method.visitFieldInsn(178, "forestry/plugins/PluginArboriculture", "validFences", "Ljava/util/List;");
        method.visitVarInsn(25, 0);
        method.visitMethodInsn(185, "java/util/List", "contains", "(Ljava/lang/Object;)Z", true);
        method.visitInsn(172);
        Label end = new Label();
        method.visitLabel(end);
        method.visitLocalVariable("block", "Lnet/minecraft/block/Block;", null, start, end, 0);
        method.visitMaxs(2, 1);
        method.visitEnd();
        node.accept((ClassVisitor)writer);
        PatcherPlugin.Patcher.logger.info("Succeeded in transforming binnie.extratrees.block.decor.BlockFence");
        return writer.toByteArray();
    }
}

