/*
 * Decompiled with CFR 0.152.
 */
package com.estebes.industrial_utilities.init;

import com.estebes.industrial_utilities.misc.DropProperties;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;

public class ConfigInit {
    public static int tankCapacity;
    public static Map<Integer, List<DropProperties>> dropsList;
    private static final String[] defaultDropsOverworld;
    private static final String[] defaultDropsNether;
    private static final String[] defaultDropsEnd;

    public static void init(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        tankCapacity = config.getInt("Capacity", "Industrial_Tank", 64, 1, 256, "Capacity of the tank in buckets");
        ConfigInit.dropParser(config.get("Industrial_Mob_Farm", "Overworld", defaultDropsOverworld, "Overworld drops - Chance->Mod Id:Item Id@Metadata#Biome type required").getStringList(), 0);
        ConfigInit.dropParser(config.get("Industrial_Mob_Farm", "Nether", defaultDropsNether, "Nether drops - Chance->Mod Id:Item Id@Metadata#Biome type required").getStringList(), -1);
        ConfigInit.dropParser(config.get("Industrial_Mob_Farm", "End", defaultDropsEnd, "End drops - Chance->Mod Id:Item Id@Metadata#Biome type required").getStringList(), 1);
        config.save();
    }

    public static void dropParser(String[] rawDrops, int dimensionID) {
        ArrayList<DropProperties> list = new ArrayList<DropProperties>();
        for (String drop : rawDrops) {
            String[] stringArray;
            String[] stringArray2;
            String[] stringArray3;
            String[] splitAux = drop.split("->");
            double dropChance = Double.parseDouble(splitAux[0]);
            if (splitAux.length > 1) {
                stringArray3 = splitAux[1].split(":");
            } else {
                String[] stringArray4 = new String[1];
                stringArray3 = stringArray4;
                stringArray4[0] = "";
            }
            splitAux = stringArray3;
            String modID = splitAux[0];
            if (splitAux.length > 1) {
                stringArray2 = splitAux[1].split("@");
            } else {
                String[] stringArray5 = new String[1];
                stringArray2 = stringArray5;
                stringArray5[0] = "";
            }
            splitAux = stringArray2;
            String itemID = splitAux[0];
            if (splitAux.length > 1) {
                stringArray = splitAux[1].split("#");
            } else {
                String[] stringArray6 = new String[1];
                stringArray = stringArray6;
                stringArray6[0] = "";
            }
            splitAux = stringArray;
            int metaData = Integer.parseInt(splitAux[0]);
            ArrayList<String> biomeTypes = new ArrayList();
            if (splitAux.length > 1) {
                biomeTypes = Arrays.asList(splitAux[1].split(","));
            }
            if (GameRegistry.findItem((String)modID, (String)itemID) == null) continue;
            list.add(new DropProperties(new ItemStack(GameRegistry.findItem((String)modID, (String)itemID), 1, metaData), dropChance, biomeTypes));
        }
        dropsList.put(dimensionID, list);
    }

    static {
        dropsList = new HashMap<Integer, List<DropProperties>>();
        defaultDropsOverworld = new String[]{"0.2->minecraft:rotten_flesh@0#", "0.2->minecraft:bone@0#", "0.15->minecraft:spider_eye@0#", "0.15->minecraft:gunpowder@0#", "0.08->minecraft:slime_ball@0#SWAMP", "0.1->minecraft:string@0#", "0.03->minecraft:ender_pearl@0#"};
        defaultDropsNether = new String[]{"0.2->minecraft:rotten_flesh@0#", "0.1->minecraft:blaze_rod@0#", "0.05->minecraft:magma_cream@0#", "0.05->minecraft:ghast_tear@0#"};
        defaultDropsEnd = new String[]{"0.2->minecraft:ender_pearl@0#"};
    }
}

