/*
 * Decompiled with CFR 0.152.
 */
package com.estebes.ic2_skyblock_kit.block.machine.electric.tileentity;

import com.estebes.ic2_skyblock_kit.block.container.ContainerWaterAccumulator;
import com.estebes.ic2_skyblock_kit.block.gui.GuiWaterAccumulator;
import com.estebes.ic2_skyblock_kit.block.machine.electric.TileEntityMachineElectricTank;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.recipe.RecipeOutput;
import ic2.core.ContainerBase;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumableLiquid;
import ic2.core.block.invslot.InvSlotConsumableLiquidByTank;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.block.invslot.InvSlotUpgrade;
import ic2.core.upgrade.IUpgradableBlock;
import ic2.core.upgrade.IUpgradeItem;
import ic2.core.upgrade.UpgradableProperty;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import org.apache.commons.lang3.mutable.MutableObject;

public class TileEntityWaterAccumulator
extends TileEntityMachineElectricTank {
    protected int production;
    public final InvSlotConsumableLiquidByTank inputSlot;
    public final InvSlotOutput outputSlot;
    public final InvSlotUpgrade upgradeSlot;

    public TileEntityWaterAccumulator(int tier, int progressCost, int progressNeeded, int tankSize, int production) {
        super(tier, progressCost, progressNeeded, tankSize);
        this.production = production;
        this.inputSlot = new InvSlotConsumableLiquidByTank((TileEntityInventory)this, "inputSlot", 1, InvSlot.Access.I, 1, InvSlot.InvSide.ANY, InvSlotConsumableLiquid.OpType.Fill, (IFluidTank)this.tank);
        this.outputSlot = new InvSlotOutput((TileEntityInventory)this, "outputSlot", 2, 1);
        this.upgradeSlot = new InvSlotUpgrade((TileEntityInventory)this, "upgrade", 3, 2);
    }

    public void updateEntityServer() {
        RecipeOutput aux;
        super.updateEntityServer();
        boolean needsInvUpdate = false;
        if (this.energy >= (double)this.progressCost && this.tank.getFluidAmount() < this.tank.getCapacity()) {
            this.setActive(true);
            this.energy -= (double)this.progressCost;
            if (this.progress >= this.progressNeeded) {
                this.tank.fill(new FluidStack(FluidRegistry.WATER, this.field_145850_b.func_72912_H().func_76059_o() ? this.production * 5 : this.production), true);
                needsInvUpdate = true;
                this.progress = 0;
            }
        } else {
            this.setActive(false);
        }
        if ((aux = this.processOutputSlot(true)) != null) {
            this.processOutputSlot(false);
            List processResult = aux.items;
            this.outputSlot.add(processResult);
        }
        for (int i = 0; i < this.upgradeSlot.size(); ++i) {
            ItemStack stack = this.upgradeSlot.get(i);
            if (stack == null || !(stack.func_77973_b() instanceof IUpgradeItem) || !((IUpgradeItem)stack.func_77973_b()).onTick(stack, (IUpgradableBlock)this)) continue;
            needsInvUpdate = true;
        }
        if (needsInvUpdate) {
            super.func_70296_d();
        }
    }

    private RecipeOutput processOutputSlot(boolean simulate) {
        MutableObject output;
        if (!this.inputSlot.isEmpty() && this.inputSlot.transferFromTank((IFluidTank)this.tank, output = new MutableObject(), simulate) && (output.getValue() == null || this.outputSlot.canAdd((ItemStack)output.getValue()))) {
            if (output.getValue() == null) {
                return new RecipeOutput(null, new ItemStack[0]);
            }
            return new RecipeOutput(null, new ItemStack[]{(ItemStack)output.getValue()});
        }
        return null;
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.FluidProducing);
    }

    public ContainerBase<TileEntityWaterAccumulator> getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerWaterAccumulator(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiWaterAccumulator(new ContainerWaterAccumulator(entityPlayer, this));
    }

    @Override
    public String func_145825_b() {
        return "";
    }
}

