/*
 * Decompiled with CFR 0.152.
 */
package com.estebes.ic2_skyblock_kit;

import ic2.api.item.IC2Items;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class ResourceList {
    public static final List<Resource> RESOURCE_LIST = new ArrayList<Resource>();
    static final Resource Aluminium = ResourceList.createResource("Aluminium", new Color(128, 200, 240), 300000).addVariantsRawMetal().addOreDictNames("Aluminum", "NaturalAluminum");
    static final Resource Ardite = ResourceList.createResource("Ardite", new Color(255, 255, 0), 80000).setOrigin(ResourceOrigin.NETHER).addVariantsRawMetal();
    static final Resource Cobalt = ResourceList.createResource("Cobalt", new Color(80, 80, 250), 80000).setOrigin(ResourceOrigin.NETHER).addVariantsRawMetal();
    static final Resource Copper = ResourceList.createResource("Copper", new Color(255, 100, 0), 600000).addVariantsRawMetal();
    static final Resource Gold = ResourceList.createResource("Gold", new Color(255, 200, 80), 270000).addVariantsRawMetal().setIngot(new ItemStack(Items.field_151043_k));
    static final Resource Iron = ResourceList.createResource("Iron", new Color(200, 200, 200), 600000).addVariantsRawMetal().setIngot(new ItemStack(Items.field_151042_j));
    static final Resource Lead = ResourceList.createResource("Lead", new Color(140, 100, 140), 240000).addVariantsRawMetal();
    static final Resource Nickel = ResourceList.createResource("Nickel", new Color(200, 200, 250), 200000).addVariantsRawMetal().addOreDictNames("Ferrous");
    static final Resource Osmium = ResourceList.createResource("Osmium", new Color(50, 50, 255), 300000).addVariantsRawMetal();
    static final Resource Platinum = ResourceList.createResource("Platinum", new Color(255, 255, 200), 60000).addVariantsRawMetal();
    static final Resource Silver = ResourceList.createResource("Silver", new Color(220, 220, 255), 270000).addVariantsRawMetal();
    static final Resource Tin = ResourceList.createResource("Tin", new Color(220, 220, 220), 600000).addVariantsRawMetal();
    static final Resource AluminiumBrass = ResourceList.createResource("AluminiumBrass", new Color(220, 220, 130), 0).setOrigin(ResourceOrigin.NONE).addVariantsAlloy().addOreDictNames("AluminumBrass");
    static final Resource Alumite = ResourceList.createResource("Alumite", new Color(230, 100, 230), 0).setOrigin(ResourceOrigin.NONE).addVariantsAlloy();
    static final Resource Bronze = ResourceList.createResource("Bronze", new Color(255, 128, 0), 0).setOrigin(ResourceOrigin.NONE).addVariantsAlloy();
    static final Resource Electrum = ResourceList.createResource("Electrum", new Color(255, 255, 100), 0).setOrigin(ResourceOrigin.NONE).addVariantsAlloy();
    static final Resource Invar = ResourceList.createResource("Invar", new Color(180, 180, 120), 0).setOrigin(ResourceOrigin.NONE).addVariantsAlloy();
    static final Resource Lumium = ResourceList.createResource("Lumium", new Color(255, 255, 80), 0).setOrigin(ResourceOrigin.NONE).addVariantsAlloy();
    static final Resource Manyullyn = ResourceList.createResource("Manyullyn", new Color(175, 100, 175), 0).setOrigin(ResourceOrigin.NONE).addVariantsAlloy();
    static final Resource Signalum = ResourceList.createResource("Signalum", new Color(255, 64, 0), 0).setOrigin(ResourceOrigin.NONE).addVariantsAlloy();
    static final Resource Steel = ResourceList.createResource("Steel", new Color(130, 130, 130), 0).setOrigin(ResourceOrigin.NONE).addVariantsAlloy();
    static final Resource Redstone = ResourceList.createResource("Redstone", new Color(200, 0, 0), 400000).addVariantsDust().setDust(new ItemStack(Items.field_151137_ax));
    static final Resource Salt = ResourceList.createResource("Salt", new Color(250, 250, 250), 100000).addVariantsDust();
    static final Resource Saltpeter = ResourceList.createResource("Saltpeter", new Color(230, 230, 230), 100000).addVariantsDust();
    static final Resource Sulfur = ResourceList.createResource("Sulfur", new Color(200, 200, 0), 100000).addVariantsDust();
    static final Resource Amethyst = ResourceList.createResource("Amethyst", new Color(210, 50, 210), 0).addVariantsGem();
    static final Resource Apatite = ResourceList.createResource("Apatite", new Color(200, 200, 255), 120000).addVariantsGem();
    static final Resource CertusQuartz = ResourceList.createResource("CertusQuartz", new Color(210, 210, 230), 150000).addVariantsGem();
    static final Resource Coal = ResourceList.createResource("Coal", new Color(70, 70, 70), 350000).addVariantsGem().setGem(new ItemStack(Items.field_151044_h));
    static final Resource Diamond = ResourceList.createResource("Diamond", new Color(200, 255, 255), 50000).addVariantsGem().setGem(new ItemStack(Items.field_151045_i));
    static final Resource Emerald = ResourceList.createResource("Emerald", new Color(80, 255, 80), 40000).addVariantsGem().setGem(new ItemStack(Items.field_151166_bC));
    static final Resource Firestone = ResourceList.createResource("Firestone", new Color(200, 20, 0), 0).setOrigin(ResourceOrigin.NETHER).addVariantsGem();
    static final Resource Iridium = ResourceList.createResource("Iridium", new Color(240, 240, 245), 10000).addVariantsGem().setGem(IC2Items.getItem((String)"iridiumOre"));
    static final Resource Lapis = ResourceList.createResource("Lapis", new Color(70, 70, 220), 120000).addVariantsGem().setGem(new ItemStack(Items.field_151100_aR, 1, 4));
    static final Resource Malachite = ResourceList.createResource("Malachite", new Color(5, 95, 5), 0).addVariantsGem();
    static final Resource NetherQuartz = ResourceList.createResource("NetherQuartz", new Color(230, 210, 210), 250000).setOrigin(ResourceOrigin.NETHER).addVariantsGem().addOreDictNames("Quartz").setGem(new ItemStack(Items.field_151128_bU));
    static final Resource Peridot = ResourceList.createResource("Peridot", new Color(150, 255, 150), 0).addVariantsGem().addOreDictNames("Olivine");
    static final Resource Plutonium = ResourceList.createResource("Plutonium", new Color(240, 50, 50), 0).addVariantsGem();
    static final Resource Ruby = ResourceList.createResource("Ruby", new Color(255, 100, 100), 0).addVariantsGem();
    static final Resource Sapphire = ResourceList.createResource("Sapphire", new Color(100, 100, 200), 0).addVariantsGem();
    static final Resource Tanzanite = ResourceList.createResource("Tanzanite", new Color(64, 0, 20), 0).addVariantsGem();
    static final Resource Topaz = ResourceList.createResource("Topaz", new Color(255, 128, 0), 0).addVariantsGem();
    static final Resource Uranium = ResourceList.createResource("Uranium", new Color(50, 240, 50), 100000).addVariantsDust().setTinyDust(IC2Items.getItem((String)"smallUran235")).setDust(IC2Items.getItem((String)"Uran238")).addIgnoredRecipes(IgnoredRecipes.CENTRIFUGE);
    static final Resource Uranium235 = ResourceList.createResource("Uranium235", new Color(70, 250, 70), 0).addVariants(ResourceVariants.GEM);

    public static Resource createResource(String name, Color color, int ppm) {
        Resource resource = new Resource(name, color, ppm);
        RESOURCE_LIST.add(resource);
        return resource;
    }

    public static enum IgnoredRecipes {
        MACERATOR,
        ORE_WASHER,
        CENTRIFUGE;

    }

    public static enum ResourceVariants {
        ORE,
        GRAVEL_ORE,
        TINY_CRUSHED_ORE,
        CRUSHED_ORE,
        TINY_PURIFIED_CRUSHED_ORE,
        PURIFIED_CRUSHED_ORE,
        TINY_DUST,
        DUST,
        INGOT,
        GEM,
        FLUID;

    }

    public static enum ResourceOrigin {
        NONE,
        OVERWORLD,
        NETHER,
        END;

    }

    public static class Resource {
        private String name;
        private Color color;
        private ResourceOrigin origin;
        private Set<String> oreDictNames = new HashSet<String>();
        private int ppm;
        private Set<IgnoredRecipes> ignoredRecipes = new HashSet<IgnoredRecipes>();
        private Set<ResourceVariants> variants = new HashSet<ResourceVariants>();
        private ItemStack ore = null;
        private ItemStack tinyCrushedOre = null;
        private ItemStack crushedOre = null;
        private ItemStack tinyPurifiedCrushedOre = null;
        private ItemStack purifiedCrushedOre = null;
        private ItemStack tinyDust = null;
        private ItemStack dust = null;
        private ItemStack ingot = null;
        private ItemStack gem = null;

        public Resource(String name, Color color, int ppm) {
            this.name = name;
            this.color = color;
            this.ppm = ppm;
            this.origin = ResourceOrigin.OVERWORLD;
            this.addOreDictNames(name);
        }

        public String getName() {
            return this.name;
        }

        public Color getColor() {
            return this.color;
        }

        public int getPPM() {
            return this.ppm;
        }

        public ResourceOrigin getOrigin() {
            return this.origin;
        }

        public Resource setOrigin(ResourceOrigin origin) {
            this.origin = origin;
            return this;
        }

        public Set<ResourceVariants> getVariants() {
            return this.variants;
        }

        public Resource addVariants(ResourceVariants ... variants) {
            this.variants.addAll(Arrays.asList(variants));
            return this;
        }

        public Resource addVariantsRawMetal() {
            this.addVariants(ResourceVariants.TINY_CRUSHED_ORE, ResourceVariants.CRUSHED_ORE, ResourceVariants.TINY_PURIFIED_CRUSHED_ORE, ResourceVariants.PURIFIED_CRUSHED_ORE, ResourceVariants.TINY_DUST, ResourceVariants.DUST, ResourceVariants.INGOT);
            return this;
        }

        public Resource addVariantsAlloy() {
            this.addVariants(ResourceVariants.TINY_DUST, ResourceVariants.DUST, ResourceVariants.INGOT);
            return this;
        }

        public Resource addVariantsDust() {
            this.addVariants(ResourceVariants.TINY_CRUSHED_ORE, ResourceVariants.CRUSHED_ORE, ResourceVariants.TINY_PURIFIED_CRUSHED_ORE, ResourceVariants.PURIFIED_CRUSHED_ORE, ResourceVariants.TINY_DUST, ResourceVariants.DUST);
            return this;
        }

        public Resource addVariantsGem() {
            this.addVariants(ResourceVariants.TINY_CRUSHED_ORE, ResourceVariants.CRUSHED_ORE, ResourceVariants.TINY_PURIFIED_CRUSHED_ORE, ResourceVariants.PURIFIED_CRUSHED_ORE, ResourceVariants.TINY_DUST, ResourceVariants.DUST, ResourceVariants.GEM);
            return this;
        }

        public ItemStack getOre() {
            return this.ore;
        }

        public Resource setOre(ItemStack ore) {
            this.ore = ore;
            return this;
        }

        public boolean hasOre() {
            return this.variants.contains((Object)ResourceVariants.ORE);
        }

        public ItemStack getTinyCrushedOre() {
            return this.tinyCrushedOre;
        }

        public Resource setTinyCrushedOre(ItemStack customTinyCrushedOre) {
            this.tinyCrushedOre = customTinyCrushedOre;
            return this;
        }

        public boolean hasTinyCrushedOre() {
            return this.variants.contains((Object)ResourceVariants.TINY_CRUSHED_ORE);
        }

        public ItemStack getCrushedOre() {
            return this.crushedOre;
        }

        public Resource setCrushedOre(ItemStack crushedOre) {
            this.crushedOre = crushedOre;
            return this;
        }

        public boolean hasCrushedOre() {
            return this.variants.contains((Object)ResourceVariants.CRUSHED_ORE);
        }

        public ItemStack getTinyPurifiedCrushedOre() {
            return this.tinyPurifiedCrushedOre;
        }

        public Resource setTinyPurifiedCrushedOre(ItemStack tinyPurifiedCrushedOre) {
            this.tinyPurifiedCrushedOre = tinyPurifiedCrushedOre;
            return this;
        }

        public boolean hasTinyPurifiedCrushedOre() {
            return this.variants.contains((Object)ResourceVariants.TINY_PURIFIED_CRUSHED_ORE);
        }

        public ItemStack getPurifiedCrushedOre() {
            return this.purifiedCrushedOre;
        }

        public Resource setPurifiedCrushedOre(ItemStack purifiedCrushedOre) {
            this.purifiedCrushedOre = purifiedCrushedOre;
            return this;
        }

        public boolean hasPurifiedCrushedOre() {
            return this.variants.contains((Object)ResourceVariants.PURIFIED_CRUSHED_ORE);
        }

        public ItemStack getTinyDust() {
            return this.tinyDust;
        }

        public Resource setTinyDust(ItemStack tinyDust) {
            this.tinyDust = tinyDust;
            return this;
        }

        public boolean hasTinyDust() {
            return this.variants.contains((Object)ResourceVariants.TINY_DUST);
        }

        public ItemStack getDust() {
            return this.dust;
        }

        public Resource setDust(ItemStack dust) {
            this.dust = dust;
            return this;
        }

        public boolean hasDust() {
            return this.variants.contains((Object)ResourceVariants.DUST);
        }

        public ItemStack getIngot() {
            return this.ingot;
        }

        public Resource setIngot(ItemStack ingot) {
            this.ingot = ingot;
            return this;
        }

        public boolean hasIngot() {
            return this.variants.contains((Object)ResourceVariants.INGOT);
        }

        public ItemStack getGem() {
            return this.gem;
        }

        public Resource setGem(ItemStack customGem) {
            this.gem = customGem;
            return this;
        }

        public boolean hasGem() {
            return this.variants.contains((Object)ResourceVariants.GEM);
        }

        public Set<String> getOreDictNames() {
            return this.oreDictNames;
        }

        public Resource addOreDictNames(String ... oreDictNames) {
            this.oreDictNames.addAll(Arrays.asList(oreDictNames));
            return this;
        }

        public boolean isEntryFor(String name) {
            return this.oreDictNames.contains(name);
        }

        public Resource addIgnoredRecipes(IgnoredRecipes ... ignoredRecipes) {
            this.ignoredRecipes.addAll(Arrays.asList(ignoredRecipes));
            return this;
        }

        public boolean hasSpecialCentrifugeRecipe() {
            return this.ignoredRecipes.contains((Object)IgnoredRecipes.CENTRIFUGE);
        }

        public String toString() {
            return this.name;
        }
    }
}

