/*
 * Decompiled with CFR 0.152.
 */
package com.estebes.ic2_skyblock_kit.block.tileentity;

import com.estebes.ic2_skyblock_kit.block.container.ContainerTank;
import com.estebes.ic2_skyblock_kit.block.gui.GuiTank;
import com.estebes.ic2_skyblock_kit.init.ConfigInit;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.recipe.RecipeOutput;
import ic2.core.ContainerBase;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumableLiquid;
import ic2.core.block.invslot.InvSlotConsumableLiquidByTank;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.block.invslot.InvSlotUpgrade;
import ic2.core.upgrade.IUpgradableBlock;
import ic2.core.upgrade.IUpgradeItem;
import ic2.core.upgrade.UpgradableProperty;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import org.apache.commons.lang3.mutable.MutableObject;

public class TileEntityTank
extends TileEntityInventory
implements IFluidHandler,
IUpgradableBlock,
IHasGui {
    public final InvSlotUpgrade upgradeSlot;
    protected FluidTank tank = new FluidTank(1000 * ConfigInit.tankCapacity);
    public final InvSlotOutput outputSlot;
    public final InvSlotConsumableLiquidByTank inputSlot;

    public TileEntityTank() {
        this.upgradeSlot = new InvSlotUpgrade((TileEntityInventory)this, "upgrade", 0, 2);
        this.inputSlot = new InvSlotConsumableLiquidByTank((TileEntityInventory)this, "inputSlot", 1, InvSlot.Access.I, 1, InvSlot.InvSide.TOP, InvSlotConsumableLiquid.OpType.Drain, (IFluidTank)this.tank);
        this.outputSlot = new InvSlotOutput((TileEntityInventory)this, "outputSlot", 2, 1);
    }

    protected void updateEntityServer() {
        super.updateEntityServer();
        RecipeOutput aux = this.processInputSlot(true);
        if (aux != null) {
            this.processInputSlot(false);
            List processResult = aux.items;
            this.outputSlot.add(processResult);
        }
        for (int i = 0; i < this.upgradeSlot.size(); ++i) {
            ItemStack stack = this.upgradeSlot.get(i);
            if (stack == null || !(stack.func_77973_b() instanceof IUpgradeItem) || !((IUpgradeItem)stack.func_77973_b()).onTick(stack, (IUpgradableBlock)this)) continue;
            super.func_70296_d();
        }
    }

    private RecipeOutput processInputSlot(boolean simulate) {
        MutableObject output;
        if (!this.inputSlot.isEmpty() && this.inputSlot.transferToTank((IFluidTank)this.tank, output = new MutableObject(), simulate) && (output.getValue() == null || this.outputSlot.canAdd((ItemStack)output.getValue()))) {
            if (output.getValue() == null) {
                return new RecipeOutput(null, new ItemStack[0]);
            }
            return new RecipeOutput(null, new ItemStack[]{(ItemStack)output.getValue()});
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagCompound inputTankTag = new NBTTagCompound();
        this.tank.writeToNBT(inputTankTag);
        nbt.func_74782_a("tank", (NBTBase)inputTankTag);
    }

    public String func_145825_b() {
        return "Industrial Tank";
    }

    public ContainerBase<TileEntityTank> getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerTank(entityPlayer, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiTank(new ContainerTank(entityPlayer, this));
    }

    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public int gaugeLiquidScaled(int i) {
        if (this.tank.getFluidAmount() <= 0) {
            return 0;
        }
        if (this.tank.getFluidAmount() >= this.tank.getCapacity()) {
            return i;
        }
        return this.tank.getFluidAmount() * i / this.tank.getCapacity();
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return !this.canFill(from, resource.getFluid()) ? 0 : this.tank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        if (!this.canDrain(from, resource.getFluid())) {
            return null;
        }
        return this.tank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid != null;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        FluidStack fluidStack = this.tank.getFluid();
        if (fluidStack == null) {
            return false;
        }
        return fluidStack.isFluidEqual(new FluidStack(fluid, 1));
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public double getEnergy() {
        return 0.0;
    }

    public boolean useEnergy(double v) {
        return false;
    }

    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.FluidConsuming, UpgradableProperty.FluidProducing);
    }
}

