/*
 * Decompiled with CFR 0.152.
 */
package com.estebes.ic2_skyblock_kit.block.machine.electric.tileentity;

import com.estebes.ic2_skyblock_kit.ResourceList;
import com.estebes.ic2_skyblock_kit.block.container.ContainerGrinder;
import com.estebes.ic2_skyblock_kit.block.gui.GuiGrinder;
import com.estebes.ic2_skyblock_kit.block.machine.electric.TileEntityMachineElectric;
import com.estebes.ic2_skyblock_kit.init.RecipeInit;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlotConsumableItemStack;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.block.invslot.InvSlotUpgrade;
import ic2.core.upgrade.IUpgradableBlock;
import ic2.core.upgrade.IUpgradeItem;
import ic2.core.upgrade.UpgradableProperty;
import ic2.core.util.StackUtil;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class TileEntityGrinder
extends TileEntityMachineElectric {
    public final InvSlotConsumableItemStack inputSlot = new InvSlotConsumableItemStack((TileEntityInventory)this, "input", 1, 3, new ItemStack[]{new ItemStack(Blocks.field_150347_e), new ItemStack(Blocks.field_150424_aL)});
    public final InvSlotOutput outputSlot = new InvSlotOutput((TileEntityInventory)this, "output", 4, 15);
    public final InvSlotUpgrade upgradeSlot = new InvSlotUpgrade((TileEntityInventory)this, "upgrade", 16, 2);

    public TileEntityGrinder(int tier, int progressCost, int progressNeeded) {
        super(tier, progressCost, progressNeeded);
    }

    public void updateEntityServer() {
        super.updateEntityServer();
        boolean needsInvUpdate = false;
        if (this.energy >= (double)this.progressCost && !this.isInvFull() && !this.inputSlot.isEmpty()) {
            this.setActive(true);
            ++this.progress;
            this.energy -= (double)this.progressCost;
            if (this.progress >= this.progressNeeded) {
                this.doThings();
                needsInvUpdate = true;
                this.progress = 0;
            }
        } else {
            this.progress = 0;
            this.setActive(false);
        }
        for (int i = 0; i < this.upgradeSlot.size(); ++i) {
            ItemStack stack = this.upgradeSlot.get(i);
            if (stack == null || !(stack.func_77973_b() instanceof IUpgradeItem) || !((IUpgradeItem)stack.func_77973_b()).onTick(stack, (IUpgradableBlock)this)) continue;
            needsInvUpdate = true;
        }
        if (needsInvUpdate) {
            super.func_70296_d();
        }
    }

    protected void doThings() {
        if (this.inputSlot.consume(1, true, false) != null) {
            int rng;
            ItemStack input = this.inputSlot.consume(1);
            if (StackUtil.isStackEqual((ItemStack)input, (ItemStack)new ItemStack(Blocks.field_150347_e))) {
                for (ResourceList.Resource resource : RecipeInit.grinderCobblestoneOutputs) {
                    rng = IC2.random.nextInt(1000000);
                    if (resource.getPPM() <= rng || !this.outputSlot.canAdd(resource.getTinyCrushedOre())) continue;
                    this.outputSlot.add(resource.getTinyCrushedOre());
                }
            }
            if (StackUtil.isStackEqual((ItemStack)input, (ItemStack)new ItemStack(Blocks.field_150424_aL))) {
                for (ResourceList.Resource resource : RecipeInit.grinderNetherrackOutputs) {
                    rng = IC2.random.nextInt(1000000);
                    if (resource.getPPM() <= rng || !this.outputSlot.canAdd(resource.getTinyCrushedOre())) continue;
                    this.outputSlot.add(resource.getTinyCrushedOre());
                }
            }
        }
    }

    protected boolean isInvFull() {
        for (int i = 0; i < this.outputSlot.size(); ++i) {
            ItemStack stack = this.outputSlot.get(i);
            if (stack != null && stack.field_77994_a >= stack.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.ItemProducing, UpgradableProperty.ItemConsuming);
    }

    public ContainerBase<TileEntityGrinder> getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerGrinder(entityPlayer, this);
    }

    @Override
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean b) {
        return new GuiGrinder(new ContainerGrinder(entityPlayer, this));
    }

    @Override
    public String func_145825_b() {
        return StatCollector.func_74838_a((String)"tile.ElectricGrinder.name");
    }
}

