/*
 * Decompiled with CFR 0.152.
 */
package com.estebes.ic2_skyblock_kit.block.machine.passive.tileentity;

import com.estebes.ic2_skyblock_kit.block.machine.passive.container.ContainerPassiveWA;
import com.estebes.ic2_skyblock_kit.block.machine.passive.gui.GuiPassiveWA;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.recipe.RecipeOutput;
import ic2.core.ContainerBase;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumableLiquid;
import ic2.core.block.invslot.InvSlotConsumableLiquidByTank;
import ic2.core.block.invslot.InvSlotOutput;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import org.apache.commons.lang3.mutable.MutableObject;

public class TileEntityPassiveWA
extends TileEntityInventory
implements IFluidHandler,
IHasGui {
    protected FluidTank tank = new FluidTank(1000);
    protected int production = 0;
    public final InvSlotConsumableLiquidByTank inputSlot = new InvSlotConsumableLiquidByTank((TileEntityInventory)this, "inputSlot", 0, InvSlot.Access.I, 1, InvSlot.InvSide.ANY, InvSlotConsumableLiquid.OpType.Fill, (IFluidTank)this.tank);
    public final InvSlotOutput outputSlot = new InvSlotOutput((TileEntityInventory)this, "outputSlot", 1, 1);

    public void updateEntityServer() {
        super.updateEntityServer();
        boolean needsInvUpdate = false;
        int n = this.production = this.field_145850_b.func_72912_H().func_76059_o() ? 5 : 0;
        if (this.tank.getFluidAmount() < this.tank.getCapacity() && this.production > 0) {
            this.setActive(true);
            this.tank.fill(new FluidStack(FluidRegistry.WATER, this.production), true);
            needsInvUpdate = true;
        } else {
            this.setActive(false);
        }
        RecipeOutput aux = this.processOutputSlot(true);
        if (aux != null) {
            this.processOutputSlot(false);
            List processResult = aux.items;
            this.outputSlot.add(processResult);
        }
        if (needsInvUpdate) {
            super.func_70296_d();
        }
    }

    protected RecipeOutput processOutputSlot(boolean simulate) {
        MutableObject output;
        if (!this.inputSlot.isEmpty() && this.inputSlot.transferFromTank((IFluidTank)this.tank, output = new MutableObject(), simulate) && (output.getValue() == null || this.outputSlot.canAdd((ItemStack)output.getValue()))) {
            if (output.getValue() == null) {
                return new RecipeOutput(null, new ItemStack[0]);
            }
            return new RecipeOutput(null, new ItemStack[]{(ItemStack)output.getValue()});
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagCompound inputTankTag = new NBTTagCompound();
        this.tank.writeToNBT(inputTankTag);
        nbt.func_74782_a("tank", (NBTBase)inputTankTag);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return !this.canFill(from, resource.getFluid()) ? 0 : this.tank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        if (!this.canDrain(from, resource.getFluid())) {
            return null;
        }
        return this.tank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (!this.canDrain(from, null)) {
            return null;
        }
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public ContainerBase<TileEntityPassiveWA> getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerPassiveWA(entityPlayer, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiPassiveWA(new ContainerPassiveWA(entityPlayer, this));
    }

    public String func_145825_b() {
        return StatCollector.func_74838_a((String)"tile.PassiveWA.name");
    }

    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public int gaugeLiquidScaled(int i) {
        if (this.tank.getFluidAmount() <= 0) {
            return 0;
        }
        if (this.tank.getFluidAmount() >= this.tank.getCapacity()) {
            return i;
        }
        return this.tank.getFluidAmount() * i / this.tank.getCapacity();
    }
}

