/*
 * Decompiled with CFR 0.152.
 */
package com.estebes.ic2_skyblock_kit.block.tileentity;

import com.estebes.ic2_skyblock_kit.block.container.ContainerMobFarm;
import com.estebes.ic2_skyblock_kit.block.gui.GuiMobFarm;
import com.estebes.ic2_skyblock_kit.init.ConfigInit;
import com.estebes.ic2_skyblock_kit.misc.DropProperties;
import com.estebes.ic2_skyblock_kit.misc.Util;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.Direction;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotUpgrade;
import ic2.core.block.machine.tileentity.TileEntityElectricMachine;
import ic2.core.network.NetworkManager;
import ic2.core.upgrade.IUpgradableBlock;
import ic2.core.upgrade.IUpgradeItem;
import ic2.core.upgrade.UpgradableProperty;
import ic2.core.util.StackUtil;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class TileEntityMobFarm
extends TileEntityElectricMachine
implements IUpgradableBlock,
IHasGui {
    private int energyPerTick;
    private int operationDuration;
    private int progress = 0;
    private boolean biomeDependent;
    public final InvSlot outputSlot;
    public final InvSlotUpgrade upgradeSlot;

    public TileEntityMobFarm(int tier, int energyPerTick, int operationDuration) {
        super(Util.calcMaxEnergyTier(tier), tier, 0, false);
        this.energyPerTick = energyPerTick;
        this.operationDuration = operationDuration;
        this.biomeDependent = true;
        this.outputSlot = new InvSlot((TileEntityInventory)this, "output", 1, InvSlot.Access.IO, 15);
        this.upgradeSlot = new InvSlotUpgrade((TileEntityInventory)this, "upgrade", 16, 2);
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.progress = nbttagcompound.func_74762_e("progress");
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("progress", this.progress);
    }

    public void updateEntityServer() {
        super.updateEntityServer();
        boolean needsInvUpdate = false;
        if (!ConfigInit.dropsList.isEmpty() && this.energy >= (double)this.energyPerTick && !this.isInvFull()) {
            this.setActive(true);
            if (this.progress == 0) {
                ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, 0, true);
            }
            ++this.progress;
            this.energy -= (double)this.energyPerTick;
            if (this.progress >= this.operationDuration) {
                if (!this.isInvFull()) {
                    this.generateDrops();
                }
                needsInvUpdate = true;
                this.progress = 0;
                ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, 2, true);
            }
        } else {
            if (this.progress != 0 && this.getActive()) {
                ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, 1, true);
            }
            if (ConfigInit.dropsList.isEmpty()) {
                this.progress = 0;
            }
            this.setActive(false);
        }
        for (int i = 0; i < this.upgradeSlot.size(); ++i) {
            ItemStack stack = this.upgradeSlot.get(i);
            if (stack == null || !(stack.func_77973_b() instanceof IUpgradeItem) || !((IUpgradeItem)stack.func_77973_b()).onTick(stack, (IUpgradableBlock)this)) continue;
            needsInvUpdate = true;
        }
        if (needsInvUpdate) {
            super.func_70296_d();
        }
    }

    public void generateDrops() {
        List<DropProperties> list;
        int dimensionID = this.field_145850_b.field_73011_w.field_76574_g;
        BiomeGenBase biome = this.field_145850_b.func_72807_a(this.field_145851_c, this.field_145849_e);
        BiomeDictionary.Type[] types = BiomeDictionary.getTypesForBiome((BiomeGenBase)biome);
        switch (dimensionID) {
            case -1: {
                list = ConfigInit.dropsList.get(-1);
                break;
            }
            case 1: {
                list = ConfigInit.dropsList.get(1);
                break;
            }
            default: {
                list = ConfigInit.dropsList.get(0);
            }
        }
        for (DropProperties dropProperties : list) {
            int aux = IC2.random.nextInt(100);
            if (!(dropProperties.getChance() * 100.0 > (double)aux)) continue;
            if (this.biomeDependent && !dropProperties.getBiomeTypes().isEmpty()) {
                boolean found = false;
                for (BiomeDictionary.Type type : types) {
                    if (!dropProperties.getBiomeTypes().contains(type.toString())) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            if (StackUtil.putInInventory((IInventory)this, (Direction)Direction.XN, (ItemStack)dropProperties.getItemStack(), (boolean)true) == 0) continue;
            StackUtil.putInInventory((IInventory)this, (Direction)Direction.XN, (ItemStack)dropProperties.getItemStack(), (boolean)false);
        }
    }

    private boolean isInvFull() {
        for (int i = 0; i < this.outputSlot.size(); ++i) {
            ItemStack stack = this.outputSlot.get(i);
            if (stack != null && stack.field_77994_a >= stack.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    public double getEnergy() {
        return this.energy;
    }

    public boolean useEnergy(double amount) {
        if (this.energy >= amount) {
            this.energy -= amount;
            return true;
        }
        return false;
    }

    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.ItemProducing);
    }

    public ContainerBase<TileEntityMobFarm> getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerMobFarm(entityPlayer, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiMobFarm(new ContainerMobFarm(entityPlayer, this));
    }

    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public String func_145825_b() {
        return "Industrial Mob Farm";
    }

    public int getEnergyScaled(int i) {
        if (this.energy <= 0.0) {
            return 0;
        }
        if (this.energy >= (double)this.maxEnergy) {
            return i;
        }
        return (int)(this.energy * (double)i) / this.maxEnergy;
    }

    public int getProgressScaled(int i) {
        if (this.progress <= 0) {
            return 0;
        }
        if (this.progress >= this.operationDuration) {
            return i;
        }
        return this.progress * i / this.operationDuration;
    }
}

