/*
 * Decompiled with CFR 0.152.
 */
package com.estebes.ic2_skyblock_kit.init;

import com.estebes.ic2_skyblock_kit.ResourceList;
import com.estebes.ic2_skyblock_kit.init.BlockInit;
import com.estebes.ic2_skyblock_kit.recipe.EAFRecipeManager;
import com.estebes.ic2_skyblock_kit.recipe.RecipeUtil;
import ic2.api.crops.CropCard;
import ic2.api.item.IC2Items;
import ic2.api.recipe.Recipes;
import ic2.core.crop.IC2Crops;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class RecipeInit {
    public static Set<ResourceList.Resource> grinderCobblestoneOutputs = new HashSet<ResourceList.Resource>();
    public static Set<ResourceList.Resource> grinderNetherrackOutputs = new HashSet<ResourceList.Resource>();
    public static Map<CropCard, Double> grassDrops = new HashMap<CropCard, Double>();

    public static void init() {
        for (String entry : OreDictionary.getOreNames()) {
            if (entry.startsWith("oreNether")) {
                entry = entry.replaceFirst("oreNether", "");
            } else {
                if (!entry.startsWith("ore")) continue;
                entry = entry.replaceFirst("ore", "");
            }
            for (ResourceList.Resource resource2 : ResourceList.RESOURCE_LIST) {
                if (resource2.isEntryFor(entry) && resource2.getOrigin() == ResourceList.ResourceOrigin.OVERWORLD) {
                    grinderCobblestoneOutputs.add(resource2);
                }
                if (!resource2.isEntryFor(entry) || resource2.getOrigin() != ResourceList.ResourceOrigin.NETHER) continue;
                grinderNetherrackOutputs.add(resource2);
            }
        }
        ResourceList.RESOURCE_LIST.stream().filter(ResourceList.Resource::hasTinyCrushedOre).filter(ResourceList.Resource::hasCrushedOre).forEach(resource -> RecipeUtil.add9to1("crushedTiny" + resource.getName(), resource.getCrushedOre()));
        ResourceList.RESOURCE_LIST.stream().filter(ResourceList.Resource::hasTinyPurifiedCrushedOre).filter(ResourceList.Resource::hasPurifiedCrushedOre).forEach(resource -> RecipeUtil.add9to1("crushedPurifiedTiny" + resource.getName(), resource.getPurifiedCrushedOre()));
        ResourceList.RESOURCE_LIST.stream().filter(ResourceList.Resource::hasTinyDust).filter(ResourceList.Resource::hasDust).forEach(resource -> RecipeUtil.add9to1("dustTiny" + resource.getName(), resource.getDust()));
        ResourceList.RESOURCE_LIST.stream().filter(ResourceList.Resource::hasCrushedOre).filter(ResourceList.Resource::hasTinyPurifiedCrushedOre).filter(ResourceList.Resource::hasPurifiedCrushedOre).forEach(resource -> RecipeUtil.addWasher("crushed" + resource.getName(), resource.getTinyPurifiedCrushedOre(), resource.getPurifiedCrushedOre()));
        ResourceList.RESOURCE_LIST.stream().filter(ResourceList.Resource::hasCrushedOre).filter(ResourceList.Resource::hasDust).filter(resource -> !resource.hasSpecialCentrifugeRecipe()).forEach(resource -> RecipeUtil.addCentrifuge("crushed" + resource.getName(), resource.getDust()));
        ResourceList.RESOURCE_LIST.stream().filter(ResourceList.Resource::hasPurifiedCrushedOre).filter(ResourceList.Resource::hasTinyDust).filter(ResourceList.Resource::hasDust).filter(resource -> !resource.hasSpecialCentrifugeRecipe()).forEach(resource -> RecipeUtil.addCentrifuge("crushedPurified" + resource.getName(), resource.getTinyDust(), resource.getDust()));
        ResourceList.RESOURCE_LIST.stream().filter(ResourceList.Resource::hasCrushedOre).filter(ResourceList.Resource::hasGem).forEach(resource -> RecipeUtil.addCompressor("crushed" + resource.getName(), resource.getGem()));
        ResourceList.RESOURCE_LIST.stream().filter(ResourceList.Resource::hasPurifiedCrushedOre).filter(ResourceList.Resource::hasGem).forEach(resource -> RecipeUtil.addCompressor("crushedPurified" + resource.getName(), resource.getGem()));
        ResourceList.RESOURCE_LIST.stream().filter(ResourceList.Resource::hasDust).filter(ResourceList.Resource::hasGem).forEach(resource -> RecipeUtil.addCompressor("dust" + resource.getName(), resource.getGem()));
        ResourceList.RESOURCE_LIST.stream().filter(ResourceList.Resource::hasCrushedOre).filter(ResourceList.Resource::hasIngot).forEach(resource -> RecipeUtil.addSmelting(resource.getCrushedOre(), resource.getIngot()));
        ResourceList.RESOURCE_LIST.stream().filter(ResourceList.Resource::hasPurifiedCrushedOre).filter(ResourceList.Resource::hasIngot).forEach(resource -> RecipeUtil.addSmelting(resource.getPurifiedCrushedOre(), resource.getIngot()));
        ResourceList.RESOURCE_LIST.stream().filter(ResourceList.Resource::hasDust).filter(ResourceList.Resource::hasIngot).forEach(resource -> RecipeUtil.addSmelting(resource.getDust(), resource.getIngot()));
        ResourceList.RESOURCE_LIST.stream().filter(ResourceList.Resource::hasCrushedOre).filter(ResourceList.Resource::hasDust).filter(resource -> !resource.hasIngot()).filter(resource -> !resource.hasGem()).filter(resource -> !resource.hasSpecialCentrifugeRecipe()).forEach(resource -> RecipeUtil.addSmelting(resource.getCrushedOre(), resource.getDust()));
        ResourceList.RESOURCE_LIST.stream().filter(ResourceList.Resource::hasPurifiedCrushedOre).filter(ResourceList.Resource::hasDust).filter(resource -> !resource.hasIngot()).filter(resource -> !resource.hasGem()).filter(resource -> !resource.hasSpecialCentrifugeRecipe()).forEach(resource -> RecipeUtil.addSmelting(resource.getPurifiedCrushedOre(), resource.getDust()));
        Recipes.advRecipes.addRecipe(new ItemStack((Block)BlockInit.machine_passive, 1, 0), new Object[]{"scs", "cgc", "scs", Character.valueOf('s'), new ItemStack(Blocks.field_150348_b), Character.valueOf('c'), new ItemStack(Blocks.field_150347_e), Character.valueOf('g'), new ItemStack(Blocks.field_150359_w)});
        Recipes.advRecipes.addRecipe(new ItemStack((Block)BlockInit.machine_manual, 1, 0), new Object[]{"csc", "s s", "csc", Character.valueOf('s'), new ItemStack(Blocks.field_150348_b), Character.valueOf('c'), new ItemStack(Blocks.field_150347_e)});
        Recipes.advRecipes.addRecipe(new ItemStack((Block)BlockInit.machine_manual, 1, 1), new Object[]{"scs", "c c", "scs", Character.valueOf('s'), new ItemStack(Blocks.field_150348_b), Character.valueOf('c'), new ItemStack(Blocks.field_150347_e)});
        Recipes.advRecipes.addRecipe(new ItemStack((Block)BlockInit.machine_electric, 1, 0), new Object[]{" c ", "cbc", " c ", Character.valueOf('c'), IC2Items.getItem((String)"cell"), Character.valueOf('b'), IC2Items.getItem((String)"machine")});
        Recipes.advRecipes.addRecipe(new ItemStack((Block)BlockInit.machine_industrial, 1, 0), new Object[]{"scs", "apa", "scs", Character.valueOf('p'), new ItemStack((Block)BlockInit.machine_electric, 1, 0), Character.valueOf('s'), IC2Items.getItem((String)"plateadviron"), Character.valueOf('c'), IC2Items.getItem((String)"carbonPlate"), Character.valueOf('a'), IC2Items.getItem((String)"advancedAlloy")});
        Recipes.advRecipes.addRecipe(new ItemStack((Block)BlockInit.machine_electric, 1, 1), new Object[]{" m ", "mcm", " m ", Character.valueOf('m'), IC2Items.getItem((String)"elemotor"), Character.valueOf('c'), IC2Items.getItem((String)"macerator")});
        Recipes.advRecipes.addRecipe(new ItemStack((Block)BlockInit.machine_industrial, 1, 1), new Object[]{"scs", "apa", "scs", Character.valueOf('p'), new ItemStack((Block)BlockInit.machine_electric, 1, 1), Character.valueOf('s'), IC2Items.getItem((String)"plateadviron"), Character.valueOf('c'), IC2Items.getItem((String)"carbonPlate"), Character.valueOf('a'), IC2Items.getItem((String)"advancedAlloy")});
        Recipes.advRecipes.addRecipe(new ItemStack((Block)BlockInit.machine_electric, 1, 2), new Object[]{"wlw", "cac", "wlw", Character.valueOf('w'), IC2Items.getItem((String)"waterCell"), Character.valueOf('l'), IC2Items.getItem((String)"lavaCell"), Character.valueOf('c'), IC2Items.getItem((String)"electronicCircuit"), Character.valueOf('a'), IC2Items.getItem((String)"machine")});
        Recipes.advRecipes.addRecipe(new ItemStack((Block)BlockInit.machine_industrial, 1, 2), new Object[]{"scs", "apa", "scs", Character.valueOf('p'), new ItemStack((Block)BlockInit.machine_electric, 1, 2), Character.valueOf('s'), IC2Items.getItem((String)"plateadviron"), Character.valueOf('c'), IC2Items.getItem((String)"carbonPlate"), Character.valueOf('a'), IC2Items.getItem((String)"advancedAlloy")});
        Recipes.advRecipes.addRecipe(new ItemStack((Block)BlockInit.machine_electric, 1, 3), new Object[]{" c ", "cfc", " c ", Character.valueOf('c'), IC2Items.getItem((String)"coil"), Character.valueOf('f'), IC2Items.getItem((String)"electroFurnace")});
        Recipes.advRecipes.addRecipe(new ItemStack((Block)BlockInit.machine_industrial, 1, 3), new Object[]{"scs", "apa", "scs", Character.valueOf('p'), new ItemStack((Block)BlockInit.machine_electric, 1, 3), Character.valueOf('s'), IC2Items.getItem((String)"plateadviron"), Character.valueOf('c'), IC2Items.getItem((String)"carbonPlate"), Character.valueOf('a'), IC2Items.getItem((String)"advancedAlloy")});
        EAFRecipeManager.addRecipe(new ItemStack(Blocks.field_150347_e), new FluidStack(FluidRegistry.LAVA, 100), 2000);
        EAFRecipeManager.addRecipe(new ItemStack(Blocks.field_150424_aL), new FluidStack(FluidRegistry.LAVA, 500), 2000);
        grassDrops.put(IC2Crops.cropReed, 0.05);
        grassDrops.put(IC2Crops.cropStickReed, 0.02);
        grassDrops.put(IC2Crops.cropWheat, 0.05);
        grassDrops.put(IC2Crops.cropCarrots, 0.05);
        grassDrops.put(IC2Crops.cropPotato, 0.05);
        grassDrops.put(IC2Crops.cropPumpkin, 0.02);
        grassDrops.put(IC2Crops.cropMelon, 0.02);
        grassDrops.put(IC2Crops.cropCocoa, 0.02);
        grassDrops.put(IC2Crops.cropNetherWart, 0.02);
    }
}

